/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.function.Consumer;
import java.util.function.Function;
import org.logicng.datastructures.Assignment;
import org.logicng.datastructures.Tristate;
import org.logicng.formulas.CFalse;
import org.logicng.formulas.CTrue;
import org.logicng.formulas.Formula;
import org.logicng.formulas.FormulaFactory;
import org.logicng.formulas.FormulaTransformation;
import org.logicng.formulas.Literal;
import org.logicng.formulas.Variable;
import org.logicng.solvers.MiniSat;
import org.logicng.transformations.cnf.BDDCNFTransformation;
import org.logicng.transformations.dnf.DNFFactorization;
import org.logicng.transformations.simplification.AdvancedSimplifier;
import org.logicng.transformations.simplification.DefaultRatingFunction;
import org.logicng.transformations.simplification.RatingFunction;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.convert.VariablesSet;
import org.matheclipse.core.eval.EvalAttributes;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ASTElementLimitExceeded;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.exception.ValidateException;
import org.matheclipse.core.eval.interfaces.AbstractArg1;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.util.AbstractAssumptions;
import org.matheclipse.core.eval.util.OptionArgs;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.IntervalSym;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.generic.Comparators;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IBooleanFormula;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IComparatorFunction;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.IPredicate;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.interfaces.ITernaryComparator;
import org.matheclipse.core.tensor.qty.IQuantity;
import org.matheclipse.core.tensor.qty.UnitConvert;
import org.matheclipse.parser.client.math.MathException;

public final class BooleanFunctions {
    public static final Equal CONST_EQUAL = new Equal();
    public static final Greater CONST_GREATER = new Greater();
    public static final Less CONST_LESS = new Less();
    public static final GreaterEqual CONST_GREATER_EQUAL = new GreaterEqual();
    public static final LessEqual CONST_LESS_EQUAL = new LessEqual();
    private static final int[] FULL_BITSETS = new int[]{1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE};

    private static IExpr equalNull(IExpr a1, IExpr a2, EvalEngine engine) {
        IExpr arg2;
        if ((a1.isExactNumber() || a1.isString()) && (a2.isExactNumber() || a2.isString())) {
            if (a1.isQuantity() && a2.isQuantity()) {
                return BooleanFunctions.quantityEquals((IQuantity)a1, (IQuantity)a2);
            }
            return a1.equals(a2) ? S.True : S.False;
        }
        IExpr arg1 = F.expandAll(a1, true, true);
        IExpr.COMPARE_TERNARY b = arg1.equalTernary(arg2 = F.expandAll(a2, true, true), engine);
        if (b == IExpr.COMPARE_TERNARY.FALSE) {
            return S.False;
        }
        if (b == IExpr.COMPARE_TERNARY.TRUE) {
            return S.True;
        }
        return Equal.simplifyCompare(S.Equal, a1, a2);
    }

    private static IExpr quantityEquals(IQuantity q1, IQuantity q2) {
        try {
            if (!q1.unit().equals(q2.unit())) {
                UnitConvert unitConvert = UnitConvert.SI();
                q2 = (IQuantity)unitConvert.to(q1.unit()).apply(q2);
            }
            if (q1.unit().equals(q2.unit())) {
                return F.bool(q1.value().equals(q2.value()));
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return F.NIL;
    }

    private static IExpr quantityUnequals(IQuantity q1, IQuantity q2) {
        try {
            if (!q1.unit().equals(q2.unit())) {
                UnitConvert unitConvert = UnitConvert.SI();
                q2 = (IQuantity)unitConvert.to(q1.unit()).apply(q2);
            }
            if (q1.unit().equals(q2.unit())) {
                return F.bool(!q1.value().equals(q2.value()));
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return F.NIL;
    }

    private static int quantityCompareTo(IQuantity q1, IQuantity q2) {
        try {
            if (!q1.unit().equals(q2.unit())) {
                UnitConvert unitConvert = UnitConvert.SI();
                q2 = (IQuantity)unitConvert.to(q1.unit()).apply(q2);
            }
            if (q1.unit().equals(q2.unit())) {
                return q1.value().compareTo(q2.value());
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return Integer.MIN_VALUE;
    }

    public static IExpr unequalNull(IExpr a1, IExpr a2, EvalEngine engine) {
        IExpr arg2;
        if ((a1.isExactNumber() || a1.isString()) && (a2.isExactNumber() || a2.isString())) {
            if (a1.isQuantity() && a2.isQuantity()) {
                return BooleanFunctions.quantityUnequals((IQuantity)a1, (IQuantity)a2);
            }
            return a1.equals(a2) ? S.False : S.True;
        }
        IExpr arg1 = F.expandAll(a1, true, true);
        IExpr.COMPARE_TERNARY b = arg1.equalTernary(arg2 = F.expandAll(a2, true, true), engine);
        if (b == IExpr.COMPARE_TERNARY.FALSE) {
            return S.True;
        }
        if (b == IExpr.COMPARE_TERNARY.TRUE) {
            return S.False;
        }
        return Equal.simplifyCompare(S.Unequal, arg1, arg2);
    }

    public static IAST inequality2And(IAST ast) {
        IASTAppendable result = F.And();
        for (int i = 3; i < ast.size(); i += 2) {
            result.append(F.binaryAST2(ast.get(i - 1), ast.get(i - 2), ast.get(i)));
        }
        return result;
    }

    public static IExpr equals(IAST ast) {
        return BooleanFunctions.equalNull(ast.arg1(), ast.arg2(), EvalEngine.get()).orElse(ast);
    }

    public static IAST satisfiabilityInstances(IExpr booleanExpression, IAST variables, int maxChoices) {
        LogicFormula lf = new LogicFormula();
        Variable[] vars = lf.ast2Variable(variables);
        List<Assignment> assignments = BooleanFunctions.logicNGSatisfiabilityInstances(booleanExpression, vars, lf, maxChoices);
        Object2IntMap<String> map = LogicFormula.name2Position(vars);
        IASTAppendable list = F.ListAlloc(assignments.size());
        for (int i = 0; i < assignments.size() && i < maxChoices; ++i) {
            list.append(lf.literals2BooleanList(assignments.get(i).literals(), map));
        }
        EvalAttributes.sort(list, Comparators.REVERSE_CANONICAL_COMPARATOR);
        return list;
    }

    public static IAST solveInstances(IExpr booleanExpression, IAST variables, int maximumNumberOfResults) {
        LogicFormula lf = new LogicFormula();
        Variable[] vars = lf.ast2Variable(variables);
        List<Assignment> assignments = BooleanFunctions.logicNGSatisfiabilityInstances(booleanExpression, vars, lf, maximumNumberOfResults);
        Object2IntMap<String> map = LogicFormula.name2Position(vars);
        IASTAppendable list = F.ListAlloc(assignments.size());
        for (int i = 0; i < assignments.size() && i < maximumNumberOfResults; ++i) {
            list.append(lf.literals2VariableList(assignments.get(i).literals(), map));
        }
        EvalAttributes.sort(list, Comparators.REVERSE_CANONICAL_COMPARATOR);
        return list;
    }

    private static FormulaTransformation transformation(IAST ast, EvalEngine engine) {
        int size = ast.argSize();
        if (size > 1 && ast.get(size).isString()) {
            IStringX lastArg = (IStringX)ast.get(size);
            String method = lastArg.toString();
            if (method.equals("DNF") || method.equals("SOP")) {
                return new DNFFactorization();
            }
            if (method.equals("CNF") || method.equals("POS")) {
                return new BDDCNFTransformation();
            }
            IOFunctions.printMessage(ast.topHead(), "unsupported", F.list(lastArg, S.Method), engine);
            return null;
        }
        return new DNFFactorization();
    }

    private static IExpr booleanConvert(IAST ast, EvalEngine engine) throws ValidateException {
        FormulaTransformation transformation = BooleanFunctions.transformation(ast, engine);
        if (transformation != null) {
            LogicFormula lf = new LogicFormula();
            Formula formula = lf.expr2BooleanFunction(ast.arg1(), false).transform(transformation);
            return lf.booleanFunction2Expr(formula);
        }
        return F.NIL;
    }

    public static List<Assignment> logicNGSatisfiabilityInstances(IExpr booleanExpression, Variable[] vars, LogicFormula lf, int maxChoices) {
        Formula formula = lf.expr2BooleanFunction(booleanExpression, false);
        MiniSat miniSat = MiniSat.miniSat((FormulaFactory)lf.getFactory());
        miniSat.add(formula);
        return miniSat.enumerateAllModels(vars);
    }

    private static IAST xorToDNF(IAST xorForm) {
        int size = xorForm.argSize();
        if (size > 2) {
            if (size <= 15) {
                int allBits;
                IASTAppendable orAST = F.Or();
                for (int i = allBits = FULL_BITSETS[size - 1]; i >= 0; --i) {
                    int singleBit = 1;
                    int count = 0;
                    for (int j = 0; j < size; ++j) {
                        if ((singleBit & i) != 0) {
                            ++count;
                        }
                        singleBit <<= 1;
                    }
                    if (!(count & true)) continue;
                    IASTMutable andAST = F.astMutable(S.And, size);
                    singleBit = 1;
                    int startPos = 1;
                    int startNotPos = count + 1;
                    for (int j = 0; j < size; ++j) {
                        if ((singleBit & i) == 0) {
                            andAST.set(startNotPos++, F.Not(xorForm.get(j + 1)));
                        } else {
                            andAST.set(startPos++, xorForm.get(j + 1));
                        }
                        singleBit <<= 1;
                    }
                    orAST.append(andAST);
                }
                return orAST;
            }
            throw new ASTElementLimitExceeded(32767L);
        }
        IExpr arg1 = xorForm.arg1();
        IExpr arg2 = xorForm.arg2();
        return F.Or((IExpr)F.And(arg1, (IExpr)F.Not(arg2)), (IExpr)F.And((IExpr)F.Not(arg1), arg2));
    }

    public static void initialize() {
        Initializer.init();
    }

    private BooleanFunctions() {
    }

    private static class Xor
    extends AbstractFunctionEvaluator
    implements IBooleanFormula {
        private Xor() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isEmpty()) {
                return S.False;
            }
            if (ast.size() == 2) {
                return ast.arg1();
            }
            IExpr result = ast.arg1();
            int size = ast.size();
            IASTAppendable xor = F.ast((IExpr)S.Xor, size - 1);
            boolean evaled = false;
            for (int i = 2; i < size; ++i) {
                IExpr arg = ast.get(i);
                if (arg.isTrue()) {
                    result = result.isTrue() ? S.False : (result.isFalse() ? S.True : S.Not.of(engine, result));
                    evaled = true;
                    continue;
                }
                if (arg.isFalse()) {
                    if (result.isTrue()) {
                        result = S.True;
                    } else if (result.isFalse()) {
                        result = S.False;
                    }
                    evaled = true;
                    continue;
                }
                if (arg.equals(result)) {
                    result = S.False;
                    evaled = true;
                    continue;
                }
                if (result.isTrue()) {
                    result = S.Not.of(engine, arg);
                    evaled = true;
                    continue;
                }
                if (result.isFalse()) {
                    result = arg;
                    evaled = true;
                    continue;
                }
                xor.append(arg);
            }
            if (evaled) {
                xor.append(result);
                return xor;
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(13);
        }
    }

    private static final class UnsameQ
    extends AbstractCoreFunctionEvaluator
    implements IPredicate,
    IComparatorFunction {
        private UnsameQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.size() > 2) {
                IAST temp = engine.evalArgs(ast, 0).orElse(ast);
                if (temp.isAST2()) {
                    return temp.arg1().isSame(temp.arg2()) ? S.False : S.True;
                }
                for (int i = 2; i < temp.size(); ++i) {
                    int j = i;
                    while (j < temp.size()) {
                        if (!temp.get(i - 1).isSame(temp.get(j++))) continue;
                        return S.False;
                    }
                }
            }
            return S.True;
        }
    }

    private static final class Unequal
    extends Equal {
        private Unequal() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.exists(x -> x.equals(S.Undefined))) {
                return S.Undefined;
            }
            if (ast.size() > 2) {
                IExpr.COMPARE_TERNARY b = IExpr.COMPARE_TERNARY.UNDECIDABLE;
                if (ast.isAST2()) {
                    return BooleanFunctions.unequalNull(ast.arg1(), ast.arg2(), engine);
                }
                IASTMutable result = ast.copy();
                result.setArgs(result.size(), i -> F.expandAll(result.get(i), true, true));
                for (int i2 = 2; i2 < result.size(); ++i2) {
                    int j = i2;
                    while (j < result.size()) {
                        b = result.get(i2 - 1).equalTernary(result.get(j++), engine);
                        if (b == IExpr.COMPARE_TERNARY.TRUE) {
                            return S.False;
                        }
                        if (b != IExpr.COMPARE_TERNARY.UNDECIDABLE) continue;
                        return F.NIL;
                    }
                }
            }
            return S.True;
        }
    }

    private static class TrueQ
    extends AbstractFunctionEvaluator
    implements IPredicate {
        private TrueQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.bool(ast.equalsAt(1, S.True));
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class TautologyQ
    extends AbstractFunctionEvaluator
    implements IPredicate {
        private TautologyQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            try {
                IASTMutable userDefinedVariables;
                if (ast.isAST2()) {
                    if (ast.arg2().isList()) {
                        userDefinedVariables = ((IAST)ast.arg2()).copy();
                        EvalAttributes.sort(userDefinedVariables);
                    } else {
                        userDefinedVariables = F.ListAlloc(ast.arg2());
                    }
                    VariablesSet vSet = new VariablesSet(arg1);
                    IASTAppendable variables = vSet.getVarList();
                    if (variables.equals(userDefinedVariables)) {
                        return TautologyQ.logicNGTautologyQ(arg1);
                    }
                } else {
                    return TautologyQ.logicNGTautologyQ(arg1);
                }
                return TautologyQ.bruteForceTautologyQ(arg1, userDefinedVariables, 1) ? S.True : S.False;
            }
            catch (MathException mathException) {
                return S.False;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        private static IExpr logicNGTautologyQ(IExpr arg1) {
            IExpr temp = SatisfiableQ.logicNGSatisfiableQ(F.Not(arg1));
            if (temp.isPresent()) {
                return temp.isTrue() ? S.False : S.True;
            }
            return F.NIL;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static boolean bruteForceTautologyQ(IExpr expr, IAST variables, int position) {
            if (variables.size() <= position) {
                return EvalEngine.get().evalTrue(expr);
            }
            IExpr sym = variables.get(position);
            if (sym.isSymbol()) {
                if (sym.isBuiltInSymbol() || !sym.isVariable()) {
                    throw new ArgumentTypeException(IOFunctions.getMessage("setraw", F.list(sym), EvalEngine.get()));
                }
                ISymbol symbol = (ISymbol)sym;
                IExpr value = symbol.assignedValue();
                try {
                    symbol.assignValue(S.True, false);
                    if (!TautologyQ.bruteForceTautologyQ(expr, variables, position + 1)) {
                        boolean bl = false;
                        return bl;
                    }
                }
                finally {
                    symbol.assignValue(value, false);
                }
                try {
                    symbol.assignValue(S.False, false);
                    if (!TautologyQ.bruteForceTautologyQ(expr, variables, position + 1)) {
                        boolean bl = false;
                        return bl;
                    }
                }
                finally {
                    symbol.assignValue(value, false);
                }
            }
            return true;
        }
    }

    private static final class SatisfiableQ
    extends AbstractFunctionEvaluator
    implements IPredicate {
        private SatisfiableQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            try {
                IASTMutable userDefinedVariables;
                String method = "SAT";
                if (ast.size() > 2) {
                    VariablesSet vSet;
                    IASTAppendable variables;
                    OptionArgs options;
                    IExpr optionMethod;
                    if (ast.arg2().isList()) {
                        userDefinedVariables = ((IAST)ast.arg2()).copy();
                        EvalAttributes.sort(userDefinedVariables);
                    } else {
                        userDefinedVariables = F.ListAlloc(ast.arg2());
                    }
                    if (ast.size() > 3 && (optionMethod = (options = new OptionArgs(ast.topHead(), ast, 3, engine)).getOption(S.Method)).isString()) {
                        method = optionMethod.toString();
                    }
                    if ((variables = (vSet = new VariablesSet(arg1)).getVarList()).equals(userDefinedVariables)) {
                        return SatisfiableQ.logicNGSatisfiableQ(arg1);
                    }
                } else {
                    return SatisfiableQ.logicNGSatisfiableQ(arg1);
                }
                return SatisfiableQ.bruteForceSatisfiableQ(arg1, userDefinedVariables, 1) ? S.True : S.False;
            }
            catch (MathException mathException) {
                return S.False;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_3;
        }

        private static IExpr logicNGSatisfiableQ(IExpr arg1) {
            FormulaFactory factory = new FormulaFactory();
            LogicFormula lf = new LogicFormula(factory);
            Formula formula = lf.expr2BooleanFunction(arg1, false);
            MiniSat miniSat = MiniSat.miniSat((FormulaFactory)factory);
            miniSat.add(formula);
            Tristate result = miniSat.sat();
            if (result == Tristate.TRUE) {
                return S.True;
            }
            if (result == Tristate.FALSE) {
                return S.False;
            }
            return F.NIL;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static boolean bruteForceSatisfiableQ(IExpr expr, IAST variables, int position) {
            if (variables.size() <= position) {
                return EvalEngine.get().evalTrue(expr);
            }
            IExpr sym = variables.get(position);
            if (sym.isSymbol()) {
                if (sym.isBuiltInSymbol() || !sym.isVariable()) {
                    throw new ArgumentTypeException(IOFunctions.getMessage("setraw", F.list(sym), EvalEngine.get()));
                }
                ISymbol symbol = (ISymbol)sym;
                IExpr value = symbol.assignedValue();
                try {
                    symbol.assignValue(S.True, false);
                    if (SatisfiableQ.bruteForceSatisfiableQ(expr, variables, position + 1)) {
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    symbol.assignValue(value, false);
                }
                try {
                    symbol.assignValue(S.False, false);
                    if (SatisfiableQ.bruteForceSatisfiableQ(expr, variables, position + 1)) {
                        boolean bl = true;
                        return bl;
                    }
                }
                finally {
                    symbol.assignValue(value, false);
                }
            }
            return false;
        }
    }

    private static final class SatisfiabilityInstances
    extends AbstractFunctionEvaluator {
        private SatisfiabilityInstances() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IAST userDefinedVariables;
            IExpr arg1 = ast.arg1();
            VariablesSet vSet = new VariablesSet(arg1);
            IASTAppendable variablesInFormula = vSet.getVarList();
            String method = "SAT";
            int maxChoices = 1;
            if (ast.size() > 2) {
                IExpr argN;
                OptionArgs options;
                IExpr optionMethod;
                if (ast.arg2().equals(S.All)) {
                    maxChoices = Integer.MAX_VALUE;
                    userDefinedVariables = variablesInFormula;
                } else {
                    userDefinedVariables = ast.arg2().orNewList();
                }
                IExpr complement = S.Complement.of(engine, userDefinedVariables, variablesInFormula);
                if (complement.size() > 1 && complement.isList()) {
                    IASTAppendable or = F.Or();
                    or.append(arg1);
                    arg1 = or;
                    or.appendArgs((IAST)complement);
                }
                if (ast.size() > 3 && (optionMethod = (options = new OptionArgs(ast.topHead(), ast, 3, engine)).getOption(S.Method)).isString()) {
                    method = optionMethod.toString();
                }
                if (!(argN = ast.last()).isRule()) {
                    if (argN.equals(S.All)) {
                        maxChoices = Integer.MAX_VALUE;
                    } else if (argN.isNumber()) {
                        maxChoices = Validate.checkPositiveIntType(ast, ast.argSize());
                    }
                }
            } else {
                userDefinedVariables = variablesInFormula;
            }
            return BooleanFunctions.satisfiabilityInstances(arg1, userDefinedVariables, maxChoices);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_3;
        }
    }

    private static final class SatisfiabilityCount
    extends AbstractFunctionEvaluator {
        private SatisfiabilityCount() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IAST userDefinedVariables;
            IExpr arg1 = ast.arg1();
            String method = "SAT";
            if (ast.size() > 2) {
                OptionArgs options;
                IExpr optionMethod;
                userDefinedVariables = ast.arg2().orNewList();
                if (ast.size() > 3 && (optionMethod = (options = new OptionArgs(ast.topHead(), ast, 3, engine)).getOption(S.Method)).isString()) {
                    method = optionMethod.toString();
                }
            } else {
                VariablesSet vSet = new VariablesSet(arg1);
                userDefinedVariables = vSet.getVarList();
            }
            return SatisfiabilityCount.logicNGSatisfiabilityCount(arg1, userDefinedVariables);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_3;
        }

        private static IInteger logicNGSatisfiabilityCount(IExpr booleanExpression, IAST variables) {
            FormulaFactory factory = new FormulaFactory();
            LogicFormula lf = new LogicFormula(factory);
            Formula formula = lf.expr2BooleanFunction(booleanExpression, false);
            MiniSat miniSat = MiniSat.miniSat((FormulaFactory)factory);
            miniSat.add(formula);
            Variable[] vars = lf.ast2Variable(variables);
            List assignments = miniSat.enumerateAllModels(vars);
            return F.ZZ(assignments.size());
        }
    }

    private static final class SameQ
    extends AbstractCoreFunctionEvaluator
    implements IPredicate,
    IComparatorFunction {
        private SameQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.size() > 2) {
                IAST temp = engine.evalArgs(ast, 0).orElse(ast);
                if (temp.isAST2()) {
                    return temp.arg1().isSame(temp.arg2()) ? S.True : S.False;
                }
                if (temp.existsLeft((x, y) -> !x.isSame((IExpr)y))) {
                    return S.False;
                }
            }
            return S.True;
        }
    }

    private static final class Positive
    extends AbstractEvaluator {
        private Positive() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isPositiveResult()) {
                return S.True;
            }
            if (arg1.isNumber()) {
                return S.False;
            }
            ISignedNumber signedNumber = arg1.evalReal();
            if (signedNumber != null) {
                return F.bool(signedNumber.isPositive());
            }
            if (arg1.isNegativeInfinity()) {
                return S.False;
            }
            if (arg1.isInfinity()) {
                return S.True;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static class Or
    extends AbstractCoreFunctionEvaluator
    implements IBooleanFormula {
        private Or() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int i;
            if (ast.isAST0()) {
                return S.False;
            }
            boolean evaled = false;
            IAST flattenedAST = EvalAttributes.flattenDeep(ast);
            if (flattenedAST.isPresent()) {
                evaled = true;
            } else {
                flattenedAST = ast;
            }
            IASTAppendable result = flattenedAST.copyAppendable();
            int[] symbols = new int[flattenedAST.size()];
            int[] notSymbols = new int[flattenedAST.size()];
            int index = 1;
            for (i = 1; i < flattenedAST.size(); ++i) {
                IExpr sym;
                IExpr arg = flattenedAST.get(i);
                if (arg.isTrue()) {
                    return S.True;
                }
                if (arg.isFalse()) {
                    result.remove(index);
                    evaled = true;
                    continue;
                }
                if ((arg = engine.evaluateNIL(arg)).isPresent()) {
                    if (arg.isTrue()) {
                        return S.True;
                    }
                    if (arg.isFalse()) {
                        result.remove(index);
                        evaled = true;
                        continue;
                    }
                    result.set(index, arg);
                    evaled = true;
                } else {
                    arg = flattenedAST.get(i);
                }
                if (arg.isSymbol()) {
                    symbols[i] = arg.hashCode();
                } else if (arg.isNot() && (sym = arg.first()).isSymbol()) {
                    notSymbols[i] = sym.hashCode();
                }
                ++index;
            }
            for (i = 1; i < symbols.length; ++i) {
                if (symbols[i] == 0) continue;
                for (int j = 1; j < notSymbols.length; ++j) {
                    if (i == j || symbols[i] != notSymbols[j] || !result.equalsAt(i, result.get(j).first())) continue;
                    return S.True;
                }
            }
            if (result.isAST1()) {
                return result.arg1();
            }
            if (evaled) {
                if (result.isAST0()) {
                    return S.False;
                }
                return result;
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(105);
        }
    }

    private static class Not
    extends AbstractArg1
    implements IBooleanFormula {
        private Not() {
        }

        @Override
        public IExpr e1ObjArg(IExpr o) {
            if (o.isTrue()) {
                return S.False;
            }
            if (o.isFalse()) {
                return S.True;
            }
            if (o.isAST()) {
                int functionID;
                IAST temp = (IAST)o;
                if (o.isNot()) {
                    return o.first();
                }
                if (temp.isAST2() && (functionID = temp.headID()) > -1) {
                    switch (functionID) {
                        case 439: {
                            return F.ForAll(temp.first(), F.Not(temp.second()));
                        }
                        case 510: {
                            return F.Exists(temp.first(), F.Not(temp.second()));
                        }
                        case 423: {
                            return temp.apply((IExpr)S.Unequal);
                        }
                        case 1381: {
                            return temp.apply((IExpr)S.Equal);
                        }
                        case 571: {
                            return temp.apply((IExpr)S.LessEqual);
                        }
                        case 572: {
                            return temp.apply((IExpr)S.Less);
                        }
                        case 753: {
                            return temp.apply((IExpr)S.GreaterEqual);
                        }
                        case 754: {
                            return temp.apply((IExpr)S.Greater);
                        }
                    }
                }
            }
            return F.NIL;
        }
    }

    private static class Nor
    extends AbstractCoreFunctionEvaluator
    implements IBooleanFormula {
        private Nor() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST0()) {
                return S.True;
            }
            if (ast.isAST1()) {
                return F.Not(ast.arg1());
            }
            IASTAppendable result = ast.copyHead();
            boolean evaled = false;
            for (int i = 1; i < ast.size(); ++i) {
                IExpr arg = engine.evaluate(ast.get(i));
                if (arg.isTrue()) {
                    return S.False;
                }
                if (arg.isFalse()) {
                    evaled = true;
                    continue;
                }
                result.append(arg);
            }
            if (evaled) {
                if (result.isAST0()) {
                    return S.True;
                }
                if (result.isAST1()) {
                    return F.Not(result.arg1());
                }
                return result;
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class NonPositive
    extends AbstractEvaluator {
        private NonPositive() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isNegativeResult() || arg1.isZero()) {
                return S.True;
            }
            if (arg1.isNumber()) {
                return S.False;
            }
            ISignedNumber signedNumber = arg1.evalReal();
            if (signedNumber != null) {
                return F.bool(signedNumber.isNegative() || signedNumber.isZero());
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static final class NonNegative
    extends AbstractEvaluator {
        private NonNegative() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isNonNegativeResult()) {
                return S.True;
            }
            if (arg1.isNumber()) {
                return S.False;
            }
            ISignedNumber signedNumber = arg1.evalReal();
            if (signedNumber != null) {
                return F.bool(!signedNumber.isNegative());
            }
            if (arg1.isNegativeInfinity()) {
                return S.False;
            }
            if (arg1.isInfinity()) {
                return S.True;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static class NoneTrue
    extends AbstractFunctionEvaluator {
        private NoneTrue() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isAST()) {
                IAST list = (IAST)ast.arg1();
                IExpr head = ast.arg2();
                return this.noneTrue(list, head, engine);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2_1;
        }

        public IExpr noneTrue(IAST list, IExpr head, EvalEngine engine) {
            IASTAppendable logicalNor = F.ast(S.Nor);
            if (list.exists(x -> NoneTrue.noneTrueArgument(x, head, logicalNor, engine))) {
                return S.False;
            }
            return logicalNor.isAST0() ? S.True : logicalNor;
        }

        private static boolean noneTrueArgument(IExpr x, IExpr head, IASTAppendable resultCollector, EvalEngine engine) {
            IExpr temp = engine.evaluate(F.unaryAST1(head, x));
            if (temp.isTrue()) {
                return true;
            }
            if (!temp.isFalse()) {
                resultCollector.append(temp);
            }
            return false;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class Negative
    extends AbstractEvaluator {
        private Negative() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isNegativeResult()) {
                return S.True;
            }
            if (arg1.isNumber()) {
                return S.False;
            }
            ISignedNumber signedNumber = arg1.evalReal();
            if (signedNumber != null) {
                return F.bool(signedNumber.isNegative());
            }
            if (arg1.isNegativeInfinity()) {
                return S.True;
            }
            if (arg1.isInfinity()) {
                return S.False;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static final class Nand
    extends AbstractCoreFunctionEvaluator
    implements IBooleanFormula {
        private Nand() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST0()) {
                return S.False;
            }
            if (ast.isAST1()) {
                return F.Not(ast.arg1());
            }
            IASTAppendable result = ast.copyHead();
            boolean evaled = false;
            for (int i = 1; i < ast.size(); ++i) {
                IExpr arg = engine.evaluate(ast.get(i));
                if (arg.isFalse()) {
                    return S.True;
                }
                if (arg.isTrue()) {
                    evaled = true;
                    continue;
                }
                result.append(arg);
            }
            if (evaled) {
                if (result.isAST0()) {
                    return S.False;
                }
                if (result.isAST1()) {
                    return F.Not(result.arg1());
                }
                return result;
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static class MinMax
    extends AbstractFunctionEvaluator {
        private MinMax() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (ast.isAST1()) {
                if (arg1.isList() || arg1.isAssociation()) {
                    return F.list(F.Min(arg1), F.Max(arg1));
                }
            } else if (ast.isAST2()) {
                IExpr arg2 = ast.arg2();
                if (arg1.isList() || arg1.isAssociation()) {
                    if (arg2.isList()) {
                        if (arg2.size() == 3 && arg2.first().isNumericFunction(true) && arg2.second().isNumericFunction(true)) {
                            return F.list(F.Subtract(F.Min(arg1), arg2.first()), F.Plus((IExpr)F.Max(arg1), arg2.second()));
                        }
                    } else {
                        if (arg2.isNumericFunction(true)) {
                            return F.list(F.Subtract(F.Min(arg1), arg2), F.Plus((IExpr)F.Max(arg1), arg2));
                        }
                        if (arg2.isAST(S.Scaled, 2) && arg2.first().isNumericFunction(true)) {
                            IExpr delta = engine.evaluate(F.Times(arg2.first(), (IExpr)F.Subtract(F.Max(arg1), F.Min(arg1))));
                            return F.list(F.Subtract(F.Min(arg1), delta), F.Plus((IExpr)F.Max(arg1), delta));
                        }
                    }
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class Min
    extends AbstractFunctionEvaluator {
        private Min() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST0()) {
                return F.CInfinity;
            }
            if (ast.arg1().isInterval()) {
                return IntervalSym.min((IAST)ast.arg1());
            }
            int allocSize = F.allocLevel1(ast, x -> x.isList());
            IASTAppendable result = F.ast((IExpr)S.Min, allocSize);
            boolean evaled = this.flattenListRecursive(ast, result);
            return Min.minimum(result, evaled);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_INFINITY;
        }

        protected boolean flattenListRecursive(IAST ast, IASTAppendable result) {
            boolean evaled = false;
            for (int i = 1; i < ast.size(); ++i) {
                IExpr arg = ast.get(i);
                int dim = arg.isVector();
                if (dim >= 0) {
                    IExpr normal = arg.normal(false);
                    if (normal.isList()) {
                        this.flattenListRecursive((IAST)normal, result);
                        evaled = true;
                        continue;
                    }
                } else if (arg.isList()) {
                    this.flattenListRecursive((IAST)arg, result);
                    evaled = true;
                    continue;
                }
                result.append(arg);
            }
            return evaled;
        }

        private static IExpr minimum(IAST list, boolean flattenedList) {
            boolean evaled = false;
            IASTAppendable f = list.remove(x -> x.isInfinity());
            if (f.isPresent()) {
                if (f.isAST0()) {
                    return F.CNInfinity;
                }
                list = f;
                evaled = true;
            }
            if (!evaled) {
                evaled = flattenedList;
            }
            if (list.isEmpty()) {
                return F.CInfinity;
            }
            IExpr min1 = list.arg1();
            f = list.copyHead();
            for (int i = 2; i < list.size(); ++i) {
                IExpr min2 = list.get(i);
                if (min2.isInfinity()) {
                    evaled = true;
                    continue;
                }
                if (min1.equals(min2)) continue;
                IExpr.COMPARE_TERNARY comp = CONST_GREATER.prepareCompare(min1, min2);
                if (comp == IExpr.COMPARE_TERNARY.TRUE) {
                    min1 = min2;
                    evaled = true;
                    continue;
                }
                if (comp == IExpr.COMPARE_TERNARY.FALSE) {
                    evaled = true;
                    continue;
                }
                if (comp != IExpr.COMPARE_TERNARY.UNDECIDABLE) continue;
                if (min1.isRealResult()) {
                    f.append(min2);
                    continue;
                }
                f.append(min1);
                min1 = min2;
            }
            if (f.size() > 1) {
                f.append(1, min1);
                if (!evaled) {
                    return F.NIL;
                }
                return f;
            }
            return min1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1037);
        }
    }

    private static class Max
    extends Min {
        private Max() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST0()) {
                return F.CNInfinity;
            }
            if (ast.arg1().isInterval()) {
                return IntervalSym.max((IAST)ast.arg1());
            }
            int allocSize = F.allocLevel1(ast, x -> x.isList());
            IASTAppendable result = F.ast((IExpr)S.Max, allocSize);
            boolean evaled = this.flattenListRecursive(ast, result);
            return Max.maximum(result, evaled);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_INFINITY;
        }

        private static IExpr maximum(IAST list, boolean flattenedList) {
            boolean evaled = false;
            IASTAppendable f = list.remove(x -> x.isNegativeInfinity());
            if (f.isPresent()) {
                if (f.isAST0()) {
                    return F.CNInfinity;
                }
                list = f;
                evaled = true;
            }
            if (!evaled) {
                evaled = flattenedList;
            }
            if (list.isEmpty()) {
                return F.CNInfinity;
            }
            IExpr max1 = list.arg1();
            f = list.copyHead();
            for (int i = 2; i < list.size(); ++i) {
                IExpr max2 = list.get(i);
                if (max1.equals(max2)) continue;
                IExpr.COMPARE_TERNARY comp = CONST_LESS.prepareCompare(max1, max2);
                if (comp == IExpr.COMPARE_TERNARY.TRUE) {
                    max1 = max2;
                    evaled = true;
                    continue;
                }
                if (comp == IExpr.COMPARE_TERNARY.FALSE) {
                    evaled = true;
                    continue;
                }
                if (comp != IExpr.COMPARE_TERNARY.UNDECIDABLE) continue;
                if (max1.isRealResult()) {
                    f.append(max2);
                    continue;
                }
                f.append(max1);
                max1 = max2;
            }
            if (f.size() > 1) {
                f.append(max1);
                if (!evaled) {
                    return F.NIL;
                }
                return f;
            }
            return max1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1037);
        }
    }

    private static class LogicalExpand
    extends AbstractFunctionEvaluator {
        private LogicalExpand() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr subst;
            IExpr arg1 = ast.arg1();
            if (ast.arg1().isAST() && (subst = ast.arg1().replaceAll(LogicalExpand.logicalExpand(engine))).isPresent()) {
                return subst;
            }
            return arg1;
        }

        private static Function<IExpr, IExpr> logicalExpand(EvalEngine engine) {
            return x -> {
                if (x.isAST()) {
                    IAST formula = (IAST)x;
                    if (x.isNot() && x.first().isOr()) {
                        IAST result = ((IAST)x.first()).apply((IExpr)S.And);
                        result = result.map(arg -> F.Not(arg));
                        return engine.evaluate(result);
                    }
                    if (formula.isSameHeadSizeGE(S.Xor, 3)) {
                        return BooleanFunctions.xorToDNF(formula);
                    }
                    try {
                        return BooleanFunctions.booleanConvert(F.BooleanConvert(formula, F.stringx("DNF")), engine);
                    }
                    catch (ValidateException validateException) {
                        // empty catch block
                    }
                }
                return F.NIL;
            };
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class CompareOperator
    extends AbstractFunctionEvaluator {
        IBuiltInSymbol operatorHead;
        IBuiltInSymbol comparatorHead;

        public CompareOperator(IBuiltInSymbol operatorHead, IBuiltInSymbol comparatorHead) {
            this.operatorHead = operatorHead;
            this.comparatorHead = comparatorHead;
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr head;
            if (ast.isAST1() && (head = ast.head()).isAST(this.operatorHead, 2)) {
                return F.binaryAST2((IExpr)this.comparatorHead, ast.arg1(), head.first());
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_1_0;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    public static final class LessEqual
    extends Greater {
        @Override
        protected IExpr checkAssumptions(IExpr arg1, IExpr arg2) {
            ISignedNumber a2;
            if (arg2.isNegative()) {
                if (arg1.isNonNegativeResult() || arg1.isPositiveResult()) {
                    return S.False;
                }
            } else if (arg2.isZero()) {
                if (arg1.isNegativeResult()) {
                    return S.True;
                }
                if (arg1.isPositiveResult()) {
                    return S.False;
                }
            } else if (arg1.isNegativeResult() || arg1.isZero()) {
                return S.True;
            }
            if ((a2 = arg2.evalReal()) != null && AbstractAssumptions.assumeLessEqual(arg1, a2)) {
                return S.True;
            }
            return F.NIL;
        }

        @Override
        protected IExpr simplifyCompare(IExpr a1, IExpr a2) {
            if (a1.isInfinity() && a2.isInfinity()) {
                return S.True;
            }
            if (a1.isNegativeInfinity() && a2.isNegativeInfinity()) {
                return S.True;
            }
            return this.simplifyCompare(a1, a2, S.LessEqual, S.GreaterEqual, false);
        }

        @Override
        public IExpr.COMPARE_TERNARY compareTernary(IExpr a0, IExpr a1) {
            if (a0.equals(a1) && a0.isRealResult() && a1.isRealResult()) {
                return IExpr.COMPARE_TERNARY.TRUE;
            }
            if (a0.isQuantity() && a1.isQuantity()) {
                int comp = BooleanFunctions.quantityCompareTo((IQuantity)a0, (IQuantity)a1);
                if (comp != Integer.MIN_VALUE) {
                    return comp <= 0 ? IExpr.COMPARE_TERNARY.TRUE : IExpr.COMPARE_TERNARY.FALSE;
                }
                return IExpr.COMPARE_TERNARY.UNDECIDABLE;
            }
            return super.compareTernary(a1, a0);
        }
    }

    public static final class Less
    extends Greater {
        @Override
        protected IExpr checkAssumptions(IExpr arg1, IExpr arg2) {
            ISignedNumber a2;
            if (arg2.isNegative()) {
                if (arg1.isPositiveResult()) {
                    return S.False;
                }
            } else if (arg2.isZero()) {
                if (arg1.isNegativeResult()) {
                    return S.True;
                }
                if (arg1.isPositiveResult()) {
                    return S.False;
                }
            } else if (arg1.isNegativeResult() || arg1.isZero()) {
                return S.True;
            }
            if ((a2 = arg2.evalReal()) != null && AbstractAssumptions.assumeLessThan(arg1, a2)) {
                return S.True;
            }
            return F.NIL;
        }

        @Override
        protected IExpr simplifyCompare(IExpr a1, IExpr a2) {
            if (a1.isInfinity() && a2.isInfinity()) {
                return S.False;
            }
            if (a1.isNegativeInfinity() && a2.isNegativeInfinity()) {
                return S.False;
            }
            return this.simplifyCompare(a1, a2, S.Less, S.Greater, false);
        }

        @Override
        public IExpr.COMPARE_TERNARY compareTernary(IExpr a0, IExpr a1) {
            return super.compareTernary(a1, a0);
        }
    }

    private static final class Inequality
    extends AbstractEvaluator
    implements IComparatorFunction {
        static final IBuiltInSymbol[] COMPARATOR_SYMBOLS = new IBuiltInSymbol[]{F.Equal, F.Greater, F.GreaterEqual, F.Less, F.LessEqual, F.Unequal};
        private static final int UNKNOWN = -3;
        private static final int UNEQUAL = -2;
        private static final int LESS_OR_LESSEQUAL = -1;
        private static final int EQUAL = 2;
        private static final int GREATER_OR_GREATEREQUAL = 1;

        private Inequality() {
        }

        private static int getCompSign(IExpr e) {
            if (e.isSymbol()) {
                if (e.equals(S.Less) || e.equals(S.LessEqual)) {
                    return -1;
                }
                if (e.equals(S.Equal)) {
                    return 2;
                }
                if (e.equals(S.Greater) || e.equals(S.GreaterEqual)) {
                    return 1;
                }
                if (e.equals(S.Unequal)) {
                    return -2;
                }
            }
            return -3;
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.size() == 2) {
                return S.True;
            }
            if (ast.size() < 4) {
                return F.NIL;
            }
            if (ast.size() == 4) {
                for (IBuiltInSymbol sym : COMPARATOR_SYMBOLS) {
                    if (!sym.equals(ast.arg2())) continue;
                    return F.binaryAST2(ast.arg2(), ast.arg1(), ast.arg3());
                }
                return F.NIL;
            }
            if (ast.size() % 2 != 0) {
                return F.NIL;
            }
            int firstSign = Inequality.getCompSign(ast.arg2());
            if (firstSign == -3) {
                return F.NIL;
            }
            for (int i = 4; i < ast.size(); i += 2) {
                int thisSign = Inequality.getCompSign(ast.get(i));
                if (thisSign == -3) {
                    return F.NIL;
                }
                if (thisSign != -firstSign && thisSign != -2 && firstSign != -2) continue;
                IASTAppendable firstIneq = F.ast(S.Inequality);
                IASTAppendable secondIneq = F.ast(S.Inequality);
                for (int j = 1; j < ast.size(); ++j) {
                    IExpr arg = ast.get(j);
                    if (j < i) {
                        firstIneq.append(arg);
                    }
                    if (j <= i - 2) continue;
                    secondIneq.append(arg);
                }
                return F.And((IExpr)firstIneq, (IExpr)secondIneq);
            }
            IASTAppendable res = F.ast(S.Inequality);
            IExpr lastOp = F.NIL;
            for (int i = 0; i < (ast.size() - 1) / 2; ++i) {
                IExpr lhs = ast.get(2 * i + 1);
                IExpr op = ast.get(2 * i + 2);
                IExpr rhs = ast.get(2 * i + 3);
                for (int rhsI = 2 * i + 3; rhsI < ast.size(); rhsI += 2) {
                    IExpr arg = engine.evaluate(F.binaryAST2(op, lhs, ast.get(rhsI)));
                    if (!arg.isFalse()) continue;
                    return S.False;
                }
                IExpr evalRes = engine.evaluate(F.binaryAST2(op, lhs, rhs));
                if (!evalRes.isTrue()) {
                    if (engine.evaluate(F.SameQ(lhs, res.get(res.size() - 1))).isFalse()) {
                        if (lastOp.isPresent() && res.size() > 2) {
                            res.append(lastOp);
                        }
                        res.append(lhs);
                    }
                    res.append(op);
                    res.append(rhs);
                    lastOp = F.NIL;
                    continue;
                }
                lastOp = op;
            }
            if (res.isEmpty()) {
                return S.True;
            }
            if (res.size() == 4) {
                return F.binaryAST2(res.arg2(), res.arg1(), res.arg3());
            }
            if (res.size() == ast.size()) {
                return F.NIL;
            }
            return res;
        }
    }

    private static final class Implies
    extends AbstractCoreFunctionEvaluator
    implements IBooleanFormula {
        private Implies() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            boolean evaled = false;
            IExpr arg1 = engine.evaluateNIL(ast.arg1());
            if (arg1.isPresent()) {
                evaled = true;
            } else {
                arg1 = ast.arg1();
            }
            if (arg1.isTrue()) {
                return ast.arg2();
            }
            if (arg1.isFalse()) {
                return S.True;
            }
            IExpr arg2 = engine.evaluateNIL(ast.arg2());
            if (arg2.isPresent()) {
                evaled = true;
            } else {
                arg2 = ast.arg2();
            }
            if (arg2.isTrue()) {
                return S.True;
            }
            if (arg2.isFalse()) {
                return F.Not(arg1);
            }
            if (arg1.equals(arg2)) {
                return S.True;
            }
            if (evaled) {
                return F.Implies(arg1, arg2);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    public static final class GreaterEqual
    extends Greater {
        public static final GreaterEqual CONST = new GreaterEqual();

        @Override
        protected IExpr checkAssumptions(IExpr arg1, IExpr arg2) {
            ISignedNumber a2;
            if (arg2.isNegative()) {
                if (arg1.isNonNegativeResult() || arg1.isPositiveResult()) {
                    return S.True;
                }
            } else if (arg2.isZero()) {
                if (arg1.isNonNegativeResult() || arg1.isPositiveResult()) {
                    return S.True;
                }
                if (arg1.isNegativeResult()) {
                    return S.False;
                }
            } else if (arg1.isNegativeResult() || arg1.isZero()) {
                return S.False;
            }
            if ((a2 = arg2.evalReal()) != null && AbstractAssumptions.assumeGreaterEqual(arg1, a2)) {
                return S.True;
            }
            return F.NIL;
        }

        @Override
        protected IExpr simplifyCompare(IExpr a1, IExpr a2) {
            if (a1.isInfinity() && a2.isInfinity()) {
                return S.True;
            }
            if (a1.isNegativeInfinity() && a2.isNegativeInfinity()) {
                return S.True;
            }
            return this.simplifyCompare(a1, a2, S.GreaterEqual, S.LessEqual, true);
        }

        @Override
        public IExpr.COMPARE_TERNARY compareTernary(IExpr a0, IExpr a1) {
            if (a0.equals(a1) && a0.isRealResult() && a1.isRealResult()) {
                return IExpr.COMPARE_TERNARY.TRUE;
            }
            if (a0.isQuantity() && a1.isQuantity()) {
                int comp = BooleanFunctions.quantityCompareTo((IQuantity)a0, (IQuantity)a1);
                if (comp != Integer.MIN_VALUE) {
                    return comp >= 0 ? IExpr.COMPARE_TERNARY.TRUE : IExpr.COMPARE_TERNARY.FALSE;
                }
                return IExpr.COMPARE_TERNARY.UNDECIDABLE;
            }
            return super.compareTernary(a0, a1);
        }
    }

    public static class Greater
    extends AbstractCoreFunctionEvaluator
    implements ITernaryComparator,
    IComparatorFunction {
        public static final Greater CONST = new Greater();

        protected IExpr checkAssumptions(IExpr arg1, IExpr arg2) {
            ISignedNumber a2;
            if (arg2.isNegative()) {
                if (arg1.isNonNegativeResult() || arg1.isPositiveResult()) {
                    return S.True;
                }
            } else if (arg2.isZero()) {
                if (arg1.isPositiveResult()) {
                    return S.True;
                }
                if (arg1.isNegativeResult()) {
                    return S.False;
                }
            } else if (arg1.isNegativeResult() || arg1.isZero()) {
                return S.False;
            }
            if ((a2 = arg2.evalReal()) != null && AbstractAssumptions.assumeGreaterThan(arg1, a2)) {
                return S.True;
            }
            return F.NIL;
        }

        private static IExpr.COMPARE_TERNARY compareGreaterIntervalTernary(IExpr lower0, IExpr upper0, IExpr lower1, IExpr upper1) {
            if (lower0.greaterThan(upper1).isTrue()) {
                return IExpr.COMPARE_TERNARY.TRUE;
            }
            if (upper0.lessThan(lower1).isTrue()) {
                return IExpr.COMPARE_TERNARY.FALSE;
            }
            return IExpr.COMPARE_TERNARY.UNDECIDABLE;
        }

        @Override
        public IExpr.COMPARE_TERNARY compareTernary(IExpr a0, IExpr a1) {
            if (a0.isReal()) {
                if (a1.isReal()) {
                    return ((ISignedNumber)a0).isGT((ISignedNumber)a1) ? IExpr.COMPARE_TERNARY.TRUE : IExpr.COMPARE_TERNARY.FALSE;
                }
                if (a1.isInfinity()) {
                    return IExpr.COMPARE_TERNARY.FALSE;
                }
                if (a1.isNegativeInfinity()) {
                    return IExpr.COMPARE_TERNARY.TRUE;
                }
                if (a1.isInterval1()) {
                    return Greater.compareGreaterIntervalTernary(a0.lower(), a0.upper(), a1.lower(), a1.upper());
                }
            } else if (a1.isReal()) {
                if (a0.isInfinity()) {
                    return IExpr.COMPARE_TERNARY.TRUE;
                }
                if (a0.isNegativeInfinity()) {
                    return IExpr.COMPARE_TERNARY.FALSE;
                }
                if (a0.isInterval1()) {
                    return Greater.compareGreaterIntervalTernary(a0.lower(), a0.upper(), a1.lower(), a1.upper());
                }
            } else if (a0.isInfinity()) {
                if (a1.isRealResult() || a1.isNegativeInfinity()) {
                    return IExpr.COMPARE_TERNARY.TRUE;
                }
            } else if (a0.isNegativeInfinity()) {
                if (a1.isRealResult() || a1.isInfinity()) {
                    return IExpr.COMPARE_TERNARY.FALSE;
                }
            } else {
                if (a1.isInfinity() && a0.isRealResult()) {
                    return IExpr.COMPARE_TERNARY.FALSE;
                }
                if (a1.isNegativeInfinity() && a0.isRealResult()) {
                    return IExpr.COMPARE_TERNARY.TRUE;
                }
                if (a0.isInterval1() && a1.isInterval1()) {
                    return Greater.compareGreaterIntervalTernary(a0.lower(), a0.upper(), a1.lower(), a1.upper());
                }
                if (a0.isQuantity() && a1.isQuantity()) {
                    int comp = BooleanFunctions.quantityCompareTo((IQuantity)a0, (IQuantity)a1);
                    if (comp != Integer.MIN_VALUE) {
                        return comp > 0 ? IExpr.COMPARE_TERNARY.TRUE : IExpr.COMPARE_TERNARY.FALSE;
                    }
                    return IExpr.COMPARE_TERNARY.UNDECIDABLE;
                }
            }
            if (a0.equals(a1) && a0.isRealResult() && a1.isRealResult() && !a0.isList()) {
                return IExpr.COMPARE_TERNARY.FALSE;
            }
            return IExpr.COMPARE_TERNARY.UNDECIDABLE;
        }

        private IAST createComparatorResult(IExpr lhs, IExpr rhs, boolean useOppositeHeader, ISymbol originalHead, ISymbol oppositeHead) {
            return F.binaryAST2((IExpr)(useOppositeHeader ? oppositeHead : originalHead), lhs, rhs);
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int i;
            IExpr temp;
            if (ast.size() <= 2) {
                if (ast.isAST1() && ast.arg1().equals(S.Undefined)) {
                    return S.Undefined;
                }
                return S.True;
            }
            IASTAppendable flattened = EvalAttributes.flattenDeep(ast);
            if (flattened.isPresent()) {
                ast = flattened;
            }
            if (ast instanceof IASTMutable && (temp = engine.evalAttributes((ISymbol)ast.head(), (IASTMutable)ast)).isPresent()) {
                return temp;
            }
            IAST astEvaled = ast;
            if (astEvaled.isAST2()) {
                IExpr temp2;
                IExpr arg2;
                IExpr arg1 = astEvaled.arg1();
                IExpr result = this.simplifyCompare(arg1, arg2 = astEvaled.arg2());
                if (result.isPresent()) {
                    return result;
                }
                if (arg2.isNumericFunction(true) && (temp2 = this.checkAssumptions(arg1, arg2)).isPresent()) {
                    return temp2;
                }
            }
            boolean evaled = false;
            IASTAppendable result = astEvaled.copyAppendable();
            IExpr.COMPARE_TERNARY[] cResult = new IExpr.COMPARE_TERNARY[astEvaled.size()];
            cResult[0] = IExpr.COMPARE_TERNARY.TRUE;
            for (i = 1; i < astEvaled.argSize(); ++i) {
                IExpr arg = result.get(i);
                if (arg.equals(S.Undefined)) {
                    return S.Undefined;
                }
                IExpr.COMPARE_TERNARY b = this.prepareCompare(arg, result.get(i + 1), engine);
                if (b == IExpr.COMPARE_TERNARY.FALSE) {
                    return S.False;
                }
                if (b == IExpr.COMPARE_TERNARY.TRUE) {
                    evaled = true;
                }
                cResult[i] = b;
            }
            cResult[astEvaled.argSize()] = IExpr.COMPARE_TERNARY.TRUE;
            if (!evaled) {
                return F.NIL;
            }
            i = 2;
            evaled = false;
            for (int j = 1; j < astEvaled.size(); ++j) {
                if (cResult[j - 1] == IExpr.COMPARE_TERNARY.TRUE && cResult[j] == IExpr.COMPARE_TERNARY.TRUE) {
                    evaled = true;
                    result.remove(i - 1);
                    continue;
                }
                ++i;
            }
            if (evaled) {
                if (result.size() <= 2) {
                    return S.True;
                }
                return result;
            }
            return F.NIL;
        }

        private IExpr.COMPARE_TERNARY prepareCompare(IExpr a0, IExpr a1, EvalEngine engine) {
            if (!a0.isReal() && a0.isNumericFunction(true) || a1.isInexactNumber() && a0.isRational()) {
                a0 = engine.evalN(a0);
            }
            if (!a1.isReal() && a1.isNumericFunction(true) || a0.isInexactNumber() && a1.isRational()) {
                a1 = engine.evalN(a1);
            }
            return this.compareTernary(a0, a1);
        }

        public IExpr.COMPARE_TERNARY prepareCompare(IExpr o0, IExpr o1) {
            return this.prepareCompare(o0, o1, EvalEngine.get());
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_INFINITY;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }

        protected IExpr simplifyCompare(IExpr a1, IExpr a2) {
            return this.simplifyCompare(a1, a2, S.Greater, S.Less, true);
        }

        protected final IExpr simplifyCompare(IExpr a1, IExpr a2, IBuiltInSymbol originalHead, IBuiltInSymbol oppositeHead, boolean setTrue) {
            if (a1.isInfinity() && a2.isInfinity()) {
                return S.False;
            }
            if (a1.isNegativeInfinity() && a2.isNegativeInfinity()) {
                return S.False;
            }
            IExpr lhs = F.NIL;
            IExpr rhs = F.NIL;
            boolean useOppositeHeader = false;
            if (a2.isNumericFunction(true)) {
                lhs = a1;
                rhs = a2;
            } else if (a1.isNumericFunction(true)) {
                lhs = a2;
                rhs = a1;
                useOppositeHeader = true;
            } else if (a1.isRealResult() && a2.isRealResult()) {
                lhs = F.eval(F.Subtract(a1, a2));
                rhs = F.C0;
                if (lhs.isReal()) {
                    return this.createComparatorResult(lhs, rhs, useOppositeHeader, originalHead, oppositeHead);
                }
            }
            if (lhs.isAST()) {
                IAST result;
                IAST lhsAST = (IAST)lhs;
                if (useOppositeHeader) {
                    boolean bl = setTrue = !setTrue;
                }
                if (lhsAST.isInfinity() && rhs.isRealResult()) {
                    return setTrue ? S.True : S.False;
                }
                if (lhsAST.isNegativeInfinity() && rhs.isRealResult()) {
                    return setTrue ? S.False : S.True;
                }
                if (rhs.isInfinity() && lhsAST.isRealResult()) {
                    return setTrue ? S.False : S.True;
                }
                if (rhs.isNegativeInfinity() && lhsAST.isRealResult()) {
                    return setTrue ? S.True : S.False;
                }
                if (lhsAST.isTimes()) {
                    IAST result2 = lhsAST.partitionTimes(x -> x.isNumericFunction(true), F.C0, F.C1, S.List);
                    if (!result2.arg1().isZero()) {
                        if (result2.arg1().hasComplexNumber() || result2.arg2().hasComplexNumber()) {
                            return IOFunctions.printMessage(originalHead, "nord", F.list(result2.arg1()), EvalEngine.get());
                        }
                        if (result2.arg1().isNegative()) {
                            useOppositeHeader = !useOppositeHeader;
                        }
                        rhs = rhs.divide(result2.arg1());
                        return this.createComparatorResult(result2.arg2(), rhs, useOppositeHeader, originalHead, oppositeHead);
                    }
                } else if (lhsAST.isPlus() && !(result = lhsAST.partitionPlus(x -> x.isNumericFunction(true), F.C0, F.C0, S.List)).arg1().isZero()) {
                    if (result.arg1().hasComplexNumber() || result.arg2().hasComplexNumber()) {
                        return IOFunctions.printMessage(originalHead, "nord", F.list(result.arg1()), EvalEngine.get());
                    }
                    rhs = rhs.subtract(result.arg1());
                    return this.createComparatorResult(result.arg2(), rhs, useOppositeHeader, originalHead, oppositeHead);
                }
            }
            return F.NIL;
        }
    }

    private static final class ForAll
    extends AbstractCoreFunctionEvaluator {
        private ForAll() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            boolean evaled = false;
            IExpr x = engine.evaluateNIL(ast.arg1());
            if (x.isPresent()) {
                evaled = true;
            } else {
                x = ast.arg1();
            }
            IExpr expr = engine.evaluateNIL(ast.arg2());
            if (expr.isPresent()) {
                evaled = true;
            } else {
                expr = ast.arg2();
            }
            if (ast.isAST3()) {
                IExpr arg3 = engine.evaluateNIL(ast.arg3());
                if (arg3.isPresent()) {
                    evaled = true;
                } else {
                    arg3 = ast.arg3();
                }
                if (evaled) {
                    return F.ForAll(x, expr, arg3);
                }
                return F.NIL;
            }
            if (expr.isFree(x)) {
                return expr;
            }
            if (evaled) {
                return F.ForAll(x, expr);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class Exists
    extends AbstractCoreFunctionEvaluator {
        private Exists() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            boolean evaled = false;
            IExpr x = engine.evaluateNIL(ast.arg1());
            if (x.isPresent()) {
                evaled = true;
            } else {
                x = ast.arg1();
            }
            IExpr expr = engine.evaluateNIL(ast.arg2());
            if (expr.isPresent()) {
                evaled = true;
            } else {
                expr = ast.arg2();
            }
            if (ast.isAST3()) {
                IExpr arg3 = engine.evaluateNIL(ast.arg3());
                if (arg3.isPresent()) {
                    evaled = true;
                } else {
                    arg3 = ast.arg3();
                }
                if (evaled) {
                    return F.Exists(x, expr, arg3);
                }
                return F.NIL;
            }
            if (expr.isFree(x)) {
                return expr;
            }
            if (evaled) {
                return F.Exists(x, expr);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class Equivalent
    extends AbstractFunctionEvaluator
    implements IBooleanFormula {
        private Equivalent() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST0() || ast.isAST1()) {
                return S.True;
            }
            IASTAppendable result = ast.copyHead();
            IExpr last = F.NIL;
            IExpr boole = F.NIL;
            boolean evaled = false;
            for (int i = 1; i < ast.size(); ++i) {
                IExpr arg = ast.get(i);
                if (arg.isFalse()) {
                    if (!boole.isPresent()) {
                        boole = S.False;
                    } else if (boole.isTrue()) {
                        return S.False;
                    }
                    evaled = true;
                    continue;
                }
                if (arg.isTrue()) {
                    if (!boole.isPresent()) {
                        boole = S.True;
                    } else if (boole.isFalse()) {
                        return S.False;
                    }
                    evaled = true;
                    continue;
                }
                if (!last.equals(arg)) {
                    result.append(arg);
                } else {
                    evaled = true;
                }
                last = arg;
            }
            if (evaled) {
                if (result.isAST0() ? boole.isPresent() : result.isAST1() && !boole.isPresent()) {
                    return S.True;
                }
                if (boole.isPresent()) {
                    result = result.apply((IExpr)S.And);
                    if (boole.isTrue()) {
                        return result;
                    }
                    return result.mapThread(F.Not(F.Slot1), 1);
                }
                return result;
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(4);
        }
    }

    private static class Equal
    extends AbstractFunctionEvaluator
    implements IComparatorFunction {
        private Equal() {
        }

        private static IExpr createComparatorResult(IBuiltInSymbol equalOrUnequalSymbol, IAST lhsAST, IExpr rhs) {
            return F.binaryAST2((IExpr)equalOrUnequalSymbol, lhsAST.rest(), rhs);
        }

        protected static IExpr simplifyCompare(IBuiltInSymbol equalOrUnequalSymbol, IExpr a1, IExpr a2) {
            IExpr rhs;
            IExpr lhs;
            if (a2.isNumber()) {
                lhs = a1;
                rhs = a2;
            } else if (a1.isNumber()) {
                lhs = a2;
                rhs = a1;
            } else {
                return F.NIL;
            }
            if (lhs.isAST()) {
                IAST lhsAST = (IAST)lhs;
                if (lhsAST.isTimes()) {
                    if (lhsAST.arg1().isNumber()) {
                        INumber sn = (INumber)lhsAST.arg1();
                        rhs = F.eval(F.Divide(rhs, sn));
                        return Equal.createComparatorResult(equalOrUnequalSymbol, lhsAST, rhs);
                    }
                } else if (lhsAST.isPlus() && lhsAST.arg1().isNumber()) {
                    INumber sn = (INumber)lhsAST.arg1();
                    rhs = F.eval(F.Subtract(rhs, sn));
                    return Equal.createComparatorResult(equalOrUnequalSymbol, lhsAST, rhs);
                }
            }
            return F.NIL;
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.exists(x -> x.equals(S.Undefined))) {
                return S.Undefined;
            }
            if (ast.size() > 2) {
                IExpr.COMPARE_TERNARY b = IExpr.COMPARE_TERNARY.UNDECIDABLE;
                if (ast.isAST2()) {
                    return BooleanFunctions.equalNull(ast.arg1(), ast.arg2(), engine);
                }
                boolean evaled = false;
                IASTAppendable result = ast.copyAppendable();
                int i = 2;
                IExpr arg1 = F.expandAll(result.arg1(), true, true);
                while (i < result.size()) {
                    IExpr arg2 = F.expandAll(result.get(i), true, true);
                    b = arg1.equalTernary(arg2, engine);
                    if (b == IExpr.COMPARE_TERNARY.FALSE) {
                        return S.False;
                    }
                    if (b == IExpr.COMPARE_TERNARY.TRUE) {
                        evaled = true;
                        result.remove(i - 1);
                        continue;
                    }
                    result.set(i - 1, arg1);
                    ++i;
                    arg1 = arg2;
                }
                if (evaled) {
                    if (result.isAST1()) {
                        return S.True;
                    }
                    return result;
                }
                return F.NIL;
            }
            return S.True;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class BooleanVariables
    extends AbstractFunctionEvaluator {
        private BooleanVariables() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return BooleanVariables.booleanVariables(ast.arg1());
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        private static IAST booleanVariables(IExpr expr) {
            VariablesSet eVar = new VariablesSet();
            eVar.addBooleanVarList(expr);
            return eVar.getVarList();
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static class BooleanTable
    extends AbstractFunctionEvaluator {
        private BooleanTable() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IAST variables = ast.isAST2() ? ast.arg2().orNewList() : BooleanVariables.booleanVariables(ast.arg1());
            BooleanTableParameter btp = new BooleanTableParameter(variables, engine);
            return btp.booleanTable(ast.arg1(), 1);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        private static class BooleanTableParameter {
            public IAST variables;
            public IASTAppendable resultList;
            public EvalEngine engine;

            public BooleanTableParameter(IAST variables, EvalEngine engine) {
                this.variables = variables;
                this.resultList = F.ListAlloc(variables.size());
                this.engine = engine;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IAST booleanTable(IExpr expr, int position) {
                if (this.variables.size() <= position) {
                    if (expr.isList()) {
                        IAST list = (IAST)expr;
                        IASTAppendable newList = F.ListAlloc(list.size());
                        list.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)x -> newList.append(this.engine.evalSymbolTrue((IExpr)x))));
                        this.resultList.append(newList);
                    } else {
                        this.resultList.append(this.engine.evalSymbolTrue(expr));
                    }
                    return this.resultList;
                }
                IExpr sym = this.variables.get(position);
                if (sym.isSymbol()) {
                    if (sym.isBuiltInSymbol() || !sym.isVariable()) {
                        throw new ArgumentTypeException(IOFunctions.getMessage("setraw", F.list(sym), EvalEngine.get()));
                    }
                    ISymbol symbol = (ISymbol)sym;
                    IExpr value = symbol.assignedValue();
                    try {
                        symbol.assignValue(S.True, false);
                        this.booleanTable(expr, position + 1);
                    }
                    finally {
                        symbol.assignValue(value, false);
                    }
                    try {
                        symbol.assignValue(S.False, false);
                        this.booleanTable(expr, position + 1);
                    }
                    finally {
                        symbol.assignValue(value, false);
                    }
                }
                return this.resultList;
            }
        }
    }

    private static class BooleanMinimize
    extends AbstractFunctionEvaluator {
        private BooleanMinimize() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                FormulaFactory factory = new FormulaFactory();
                LogicFormula lf = new LogicFormula(factory);
                Formula formula = lf.expr2BooleanFunction(ast.arg1(), true);
                AdvancedSimplifier simplifier = new AdvancedSimplifier((RatingFunction)new DefaultRatingFunction());
                FormulaTransformation transformation = BooleanFunctions.transformation(ast, engine);
                if (transformation == null) {
                    return F.NIL;
                }
                Formula simplified = formula.transform((FormulaTransformation)simplifier).transform(transformation);
                IExpr result = lf.booleanFunction2Expr(simplified);
                return result;
            }
            catch (ValidateException ve) {
                IOFunctions.printMessage(ast.topHead(), ve, engine);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return ast.arg1();
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static class BooleanConvert
    extends AbstractFunctionEvaluator {
        private BooleanConvert() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return BooleanFunctions.booleanConvert(ast, engine);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static class Boole
    extends AbstractCoreFunctionEvaluator {
        private Boole() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = engine.evaluateNIL(ast.arg1());
            if (arg1.isPresent()) {
                return this.booleValue(arg1, F.Boole(arg1));
            }
            return this.booleValue(ast.arg1(), F.NIL);
        }

        private IExpr booleValue(IExpr arg1, IExpr defaultValue) {
            if (arg1.isTrue()) {
                return F.C1;
            }
            if (arg1.isFalse()) {
                return F.C0;
            }
            if (arg1.isSymbol()) {
                return defaultValue;
            }
            if (arg1.isList()) {
                return ((IAST)arg1).mapThread(x -> F.Boole(x));
            }
            return defaultValue;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static class AnyTrue
    extends AbstractFunctionEvaluator {
        private AnyTrue() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isAST()) {
                IAST list = (IAST)ast.arg1();
                IExpr head = ast.arg2();
                return this.anyTrue(list, head, engine);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2_1;
        }

        public IExpr anyTrue(IAST list, IExpr head, EvalEngine engine) {
            IASTAppendable logicalOr = F.Or();
            if (list.exists(x -> AnyTrue.anyTrueArgument(x, head, logicalOr, engine))) {
                return S.True;
            }
            return logicalOr.isAST0() ? S.False : logicalOr;
        }

        private static boolean anyTrueArgument(IExpr x, IExpr head, IASTAppendable resultCollector, EvalEngine engine) {
            IExpr temp = engine.evaluate(F.unaryAST1(head, x));
            if (temp.isTrue()) {
                return true;
            }
            if (!temp.isFalse()) {
                resultCollector.append(temp);
            }
            return false;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class And
    extends AbstractCoreFunctionEvaluator
    implements IBooleanFormula {
        private And() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int i;
            if (ast.isAST0()) {
                return S.True;
            }
            boolean evaled = false;
            int index = 1;
            IExpr temp = F.NIL;
            IAST flattenedAST = EvalAttributes.flattenDeep(ast);
            if (flattenedAST.isPresent()) {
                evaled = true;
            } else {
                flattenedAST = ast;
            }
            int start = -1;
            for (int i2 = 1; i2 < flattenedAST.size(); ++i2) {
                temp = flattenedAST.get(i2);
                if (temp.isBuiltInSymbol()) {
                    if (temp.isFalse()) {
                        return S.False;
                    }
                    if (temp.isTrue()) continue;
                }
                if ((temp = engine.evaluateNIL(temp)).isPresent()) {
                    if (temp.isFalse()) {
                        return S.False;
                    }
                    if (temp.isTrue()) continue;
                    evaled = true;
                } else {
                    temp = flattenedAST.get(i2);
                }
                start = i2;
                break;
            }
            if (start < 0) {
                return S.True;
            }
            IASTAppendable result = flattenedAST.copyFrom(start);
            result.set(index, temp);
            int[] symbols = new int[flattenedAST.size()];
            int[] notSymbols = new int[flattenedAST.size()];
            for (i = start; i < flattenedAST.size(); ++i) {
                IExpr sym;
                temp = flattenedAST.get(i);
                if (temp.isFalse()) {
                    return S.False;
                }
                if (temp.isTrue()) {
                    result.remove(index);
                    evaled = true;
                    continue;
                }
                if ((temp = engine.evaluateNIL(temp)).isPresent()) {
                    if (temp.isFalse()) {
                        return S.False;
                    }
                    if (temp.isTrue()) {
                        result.remove(index);
                        evaled = true;
                        continue;
                    }
                    result.set(index, temp);
                    evaled = true;
                } else {
                    temp = flattenedAST.get(i);
                }
                if (temp.isSymbol()) {
                    symbols[i] = flattenedAST.get(i).hashCode();
                } else if (temp.isNot() && (sym = temp.first()).isSymbol()) {
                    notSymbols[i] = sym.hashCode();
                }
                ++index;
            }
            for (i = 1; i < symbols.length; ++i) {
                if (symbols[i] == 0) continue;
                for (int j = 1; j < notSymbols.length; ++j) {
                    if (i == j || symbols[i] != notSymbols[j] || !result.equalsAt(i, result.get(j).first())) continue;
                    return S.False;
                }
            }
            if (result.isAST1()) {
                return result.arg1();
            }
            if (evaled) {
                if (result.isAST0()) {
                    return S.True;
                }
                return result;
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(105);
        }
    }

    private static class AllTrue
    extends AbstractFunctionEvaluator {
        private AllTrue() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isAST()) {
                IAST list = (IAST)ast.arg1();
                IExpr head = ast.arg2();
                return this.allTrue(list, head, engine);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2_1;
        }

        public IExpr allTrue(IAST list, IExpr head, EvalEngine engine) {
            IASTAppendable logicalAnd = F.And();
            if (!list.forAll(x -> {
                IExpr temp = engine.evaluate(F.unaryAST1(head, x));
                if (temp.isTrue()) {
                    return true;
                }
                if (temp.isFalse()) {
                    return false;
                }
                logicalAnd.append(temp);
                return true;
            })) {
                return S.False;
            }
            if (logicalAnd.size() > 1) {
                return logicalAnd;
            }
            return S.True;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class LogicFormula {
        final FormulaFactory factory;
        Map<IExpr, Variable> symbol2variableMap = new HashMap<IExpr, Variable>();
        Map<Variable, IExpr> variable2symbolMap = new HashMap<Variable, IExpr>();

        public static Object2IntMap<String> name2Position(Variable[] vars) {
            Object2IntArrayMap map = new Object2IntArrayMap();
            map.defaultReturnValue(-1);
            for (int i = 0; i < vars.length; ++i) {
                map.put((Object)vars[i].name(), i);
            }
            return map;
        }

        public LogicFormula() {
            this(new FormulaFactory());
        }

        public LogicFormula(FormulaFactory factory) {
            this.factory = factory;
        }

        public Variable[] ast2Variable(IAST listOfSymbols) {
            if (listOfSymbols instanceof IAST) {
                Variable[] result = new Variable[listOfSymbols.argSize()];
                for (int i = 1; i < listOfSymbols.size(); ++i) {
                    IExpr arg = listOfSymbols.get(i);
                    if (arg.isSymbol()) {
                        ISymbol symbol = (ISymbol)arg;
                        if (symbol.isFalse() || symbol.isTrue()) {
                            String str = IOFunctions.getMessage("ivar", F.list(symbol), EvalEngine.get());
                            throw new ArgumentTypeException(str);
                        }
                        Variable v = this.symbol2variableMap.get(symbol);
                        if (v == null) {
                            Variable value = this.factory.variable(symbol.getSymbolName());
                            this.symbol2variableMap.put(symbol, value);
                            this.variable2symbolMap.put(value, symbol);
                            result[i - 1] = value;
                            continue;
                        }
                        result[i - 1] = v;
                        continue;
                    }
                    String str = IOFunctions.getMessage("ivar", F.list(arg), EvalEngine.get());
                    throw new ArgumentTypeException(str);
                }
                return result;
            }
            String str = IOFunctions.getMessage("ivar", F.list(listOfSymbols), EvalEngine.get());
            throw new ArgumentTypeException(str);
        }

        public IExpr booleanFunction2Expr(Formula formula) {
            if (formula instanceof org.logicng.formulas.And) {
                org.logicng.formulas.And a = (org.logicng.formulas.And)formula;
                IExpr[] result = new IExpr[a.numberOfOperands()];
                int i = 0;
                for (Formula f : a) {
                    result[i++] = this.booleanFunction2Expr(f);
                }
                Arrays.sort(result, Comparators.CANONICAL_COMPARATOR);
                return F.And(result);
            }
            if (formula instanceof org.logicng.formulas.Or) {
                org.logicng.formulas.Or a = (org.logicng.formulas.Or)formula;
                IExpr[] result = new IExpr[a.numberOfOperands()];
                int i = 0;
                for (Formula f : a) {
                    result[i++] = this.booleanFunction2Expr(f);
                }
                Arrays.sort(result, Comparators.CANONICAL_COMPARATOR);
                return F.Or(result);
            }
            if (formula instanceof org.logicng.formulas.Not) {
                org.logicng.formulas.Not a = (org.logicng.formulas.Not)formula;
                return F.Not(this.booleanFunction2Expr(a.operand()));
            }
            if (formula instanceof CFalse) {
                return S.False;
            }
            if (formula instanceof CTrue) {
                return S.True;
            }
            if (formula instanceof Literal) {
                Literal a = (Literal)formula;
                if (a.phase()) {
                    return this.mapToSymbol(a.variable());
                }
                return F.Not(this.mapToSymbol(a.variable()));
            }
            String str = IOFunctions.getMessage("argillegal", F.list(F.stringx(formula.toString()), F.stringx("LogicFormula")), EvalEngine.get());
            throw new ArgumentTypeException(str);
        }

        private IExpr mapToSymbol(Variable v) {
            IExpr s = this.variable2symbolMap.get(v);
            if (s != null) {
                return s;
            }
            s = F.Dummy(EvalEngine.uniqueName("LF$"));
            this.variable2symbolMap.put(v, s);
            return s;
        }

        private Formula convertEquivalent(IAST ast, boolean substituteExpressions) {
            Formula[] result1 = new Formula[ast.argSize()];
            Formula[] result2 = new Formula[ast.argSize()];
            for (int i = 1; i < ast.size(); ++i) {
                result1[i - 1] = this.factory.not(this.expr2BooleanFunction(ast.get(i), substituteExpressions));
                result2[i - 1] = this.factory.not(result1[i - 1]);
            }
            return this.factory.or(new Formula[]{this.factory.and(result1), this.factory.and(result2)});
        }

        public Formula expr2BooleanFunction(IExpr logicExpr, boolean substituteExpressions) throws ArgumentTypeException {
            if (logicExpr instanceof IAST) {
                IAST ast = (IAST)logicExpr;
                int functionID = ast.headID();
                if (functionID > -1) {
                    switch (functionID) {
                        case 63: {
                            if (!ast.isAnd()) break;
                            return this.convertAnd(ast, substituteExpressions);
                        }
                        case 958: {
                            if (!ast.isOr()) break;
                            return this.convertOr(ast, substituteExpressions);
                        }
                        case 897: {
                            if (!ast.isSameHeadSizeGE(S.Nand, 3)) break;
                            Formula[] result = new Formula[ast.argSize()];
                            ast.forEach((x, i) -> {
                                result[i - 1] = this.factory.not(this.expr2BooleanFunction((IExpr)x, substituteExpressions));
                            });
                            return this.factory.or(result);
                        }
                        case 917: {
                            if (!ast.isSameHeadSizeGE(S.Nor, 3)) break;
                            Formula[] result = new Formula[ast.argSize()];
                            ast.forEach((x, i) -> {
                                result[i - 1] = this.factory.not(this.expr2BooleanFunction((IExpr)x, substituteExpressions));
                            });
                            return this.factory.and(result);
                        }
                        case 425: {
                            if (!ast.isSameHeadSizeGE(S.Equivalent, 3)) break;
                            return this.convertEquivalent(ast, substituteExpressions);
                        }
                        case 1448: {
                            if (!ast.isSameHeadSizeGE(S.Xor, 3)) break;
                            IAST dnf = BooleanFunctions.xorToDNF(ast);
                            if (dnf.isOr()) {
                                return this.convertOr(dnf, substituteExpressions);
                            }
                            if (dnf.isAnd()) {
                                return this.convertAnd(dnf, substituteExpressions);
                            }
                            return this.expr2BooleanFunction(dnf, substituteExpressions);
                        }
                        case 638: {
                            if (!ast.isAST(S.Implies, 3)) break;
                            return this.factory.implication(this.expr2BooleanFunction(ast.arg1(), substituteExpressions), this.expr2BooleanFunction(ast.arg2(), substituteExpressions));
                        }
                        case 922: {
                            if (!ast.isNot()) break;
                            IExpr expr = ast.arg1();
                            return this.factory.not(this.expr2BooleanFunction(expr, substituteExpressions));
                        }
                    }
                }
            } else if (logicExpr instanceof ISymbol) {
                ISymbol symbol = (ISymbol)logicExpr;
                if (symbol.isFalse()) {
                    return this.factory.falsum();
                }
                if (symbol.isTrue()) {
                    return this.factory.verum();
                }
                if (!symbol.isVariable() || symbol.isProtected()) {
                    String message = IOFunctions.getMessage("ivar", F.list(symbol), EvalEngine.get());
                    throw new ArgumentTypeException(message);
                }
                Variable v = this.symbol2variableMap.get(symbol);
                if (v == null) {
                    Variable value = this.factory.variable(symbol.getSymbolName());
                    this.symbol2variableMap.put(symbol, value);
                    this.variable2symbolMap.put(value, symbol);
                    return value;
                }
                return v;
            }
            if (substituteExpressions) {
                Variable v = this.symbol2variableMap.get(logicExpr);
                if (v == null) {
                    Variable value = this.factory.variable(logicExpr.fullFormString());
                    this.symbol2variableMap.put(logicExpr, value);
                    this.variable2symbolMap.put(value, logicExpr);
                    return value;
                }
                return v;
            }
            String str = IOFunctions.getMessage("argillegal", F.list(logicExpr, F.stringx("LogicFormula")), EvalEngine.get());
            throw new ArgumentTypeException(str);
        }

        private Formula convertOr(IAST ast, boolean substituteExpressions) {
            Formula[] result = new Formula[ast.argSize()];
            ast.forEach((x, i) -> {
                result[i - 1] = this.expr2BooleanFunction((IExpr)x, substituteExpressions);
            });
            return this.factory.or(result);
        }

        private Formula convertAnd(IAST ast, boolean substituteExpressions) {
            Formula[] result = new Formula[ast.argSize()];
            ast.forEach((x, i) -> {
                result[i - 1] = this.expr2BooleanFunction((IExpr)x, substituteExpressions);
            });
            return this.factory.and(result);
        }

        public FormulaFactory getFactory() {
            return this.factory;
        }

        private Collection<Variable> list2LiteralCollection(IAST list) {
            ArrayList<Variable> arr = new ArrayList<Variable>(list.argSize());
            for (int i = 1; i < list.size(); ++i) {
                IExpr arg = list.get(i);
                if (!arg.isSymbol()) {
                    String str = IOFunctions.getMessage("argillegal", F.list(arg, list), EvalEngine.get());
                    throw new ArgumentTypeException(str);
                }
                ISymbol symbol = (ISymbol)arg;
                Variable v = this.symbol2variableMap.get(symbol);
                if (v == null) {
                    Variable value = this.factory.variable(symbol.getSymbolName());
                    this.symbol2variableMap.put(symbol, value);
                    this.variable2symbolMap.put(value, symbol);
                }
                arr.add(v);
            }
            return arr;
        }

        public IAST literals2BooleanList(SortedSet<Literal> literals, Object2IntMap<String> map) {
            IASTMutable list = F.astMutable(S.List, map.size());
            for (int i = 0; i < map.size(); ++i) {
                list.set(i + 1, S.Null);
            }
            for (Literal a : literals) {
                int val = map.getInt((Object)a.name());
                if (val == -1) continue;
                if (a.phase()) {
                    list.set(val + 1, S.True);
                    continue;
                }
                list.set(val + 1, S.False);
            }
            return list;
        }

        public IAST literals2VariableList(SortedSet<Literal> literals, Object2IntMap<String> map) {
            IASTMutable list = F.astMutable(S.List, map.size());
            for (int i = 0; i < map.size(); ++i) {
                list.set(i + 1, S.Null);
            }
            for (Literal a : literals) {
                int val = map.getInt((Object)a.name());
                if (val == -1) continue;
                if (a.phase()) {
                    list.set(val + 1, F.Rule(this.variable2symbolMap.get(a.variable()), (IExpr)S.True));
                    continue;
                }
                list.set(val + 1, F.Rule(this.variable2symbolMap.get(a.variable()), (IExpr)S.False));
            }
            return list;
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.AllTrue.setEvaluator(new AllTrue());
            S.And.setEvaluator(new And());
            S.AnyTrue.setEvaluator(new AnyTrue());
            S.Boole.setEvaluator(new Boole());
            S.BooleanConvert.setEvaluator(new BooleanConvert());
            S.BooleanMinimize.setEvaluator(new BooleanMinimize());
            S.BooleanTable.setEvaluator(new BooleanTable());
            S.BooleanVariables.setEvaluator(new BooleanVariables());
            S.Equal.setEvaluator(CONST_EQUAL);
            S.EqualTo.setEvaluator(new CompareOperator(S.EqualTo, S.Equal));
            S.Equivalent.setEvaluator(new Equivalent());
            S.Exists.setEvaluator(new Exists());
            S.ForAll.setEvaluator(new ForAll());
            S.Greater.setEvaluator(CONST_GREATER);
            S.GreaterEqual.setEvaluator(new GreaterEqual());
            S.GreaterEqualThan.setEvaluator(new CompareOperator(S.GreaterEqualThan, S.GreaterEqual));
            S.GreaterThan.setEvaluator(new CompareOperator(S.GreaterThan, S.Greater));
            S.Implies.setEvaluator(new Implies());
            S.Inequality.setEvaluator(new Inequality());
            S.Less.setEvaluator(CONST_LESS);
            S.LessEqual.setEvaluator(new LessEqual());
            S.LessEqualThan.setEvaluator(new CompareOperator(S.LessEqualThan, S.LessEqual));
            S.LessThan.setEvaluator(new CompareOperator(S.LessThan, S.Less));
            S.LogicalExpand.setEvaluator(new LogicalExpand());
            S.Max.setEvaluator(new Max());
            S.Min.setEvaluator(new Min());
            S.MinMax.setEvaluator(new MinMax());
            S.Nand.setEvaluator(new Nand());
            S.Negative.setEvaluator(new Negative());
            S.NoneTrue.setEvaluator(new NoneTrue());
            S.NonNegative.setEvaluator(new NonNegative());
            S.NonPositive.setEvaluator(new NonPositive());
            S.Nor.setEvaluator(new Nor());
            S.Not.setEvaluator(new Not());
            S.Or.setEvaluator(new Or());
            S.Positive.setEvaluator(new Positive());
            S.SameQ.setEvaluator(new SameQ());
            S.SatisfiabilityCount.setEvaluator(new SatisfiabilityCount());
            S.SatisfiabilityInstances.setEvaluator(new SatisfiabilityInstances());
            S.SatisfiableQ.setEvaluator(new SatisfiableQ());
            S.TautologyQ.setEvaluator(new TautologyQ());
            S.TrueQ.setEvaluator(new TrueQ());
            S.Unequal.setEvaluator(new Unequal());
            S.UnequalTo.setEvaluator(new CompareOperator(S.UnequalTo, S.Unequal));
            S.UnsameQ.setEvaluator(new UnsameQ());
            S.Xor.setEvaluator(new Xor());
        }
    }
}

