/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hipparchus.complex.Complex;
import org.hipparchus.exception.MathRuntimeException;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.builtin.functions.BesselJS;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ValidateException;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.reflection.system.FunctionExpand;
import org.matheclipse.core.reflection.system.rules.BesselIRules;
import org.matheclipse.core.reflection.system.rules.BesselKRules;
import org.matheclipse.core.reflection.system.rules.BesselYRules;

public class BesselFunctions {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void initialize() {
        Initializer.init();
    }

    private BesselFunctions() {
    }

    private static final class WeberE
    extends AbstractFunctionEvaluator {
        private WeberE() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr n = ast.arg1();
            IExpr z = ast.arg2();
            if (engine.isNumericMode()) {
                try {
                    Complex nc = n.evalComplex();
                    Complex zc = z.evalComplex();
                    if (ast.isAST3()) {
                        Complex complex = ast.arg3().evalComplex();
                    }
                    return FunctionExpand.callMatcher(F.FunctionExpand(ast), ast, engine);
                }
                catch (ValidateException ve) {
                    return IOFunctions.printMessage(ast.topHead(), ve, engine);
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                    return F.NIL;
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
        }
    }

    private static final class SphericalBesselY
    extends AbstractFunctionEvaluator {
        private SphericalBesselY() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr n = ast.arg1();
            IExpr z = ast.arg2();
            if (engine.isDoubleMode()) {
                try {
                    double nDouble = Double.NaN;
                    double zDouble = Double.NaN;
                    try {
                        nDouble = n.evalDouble();
                        zDouble = z.evalDouble();
                    }
                    catch (ValidateException validateException) {
                        // empty catch block
                    }
                    if (Double.isNaN(nDouble) || Double.isNaN(zDouble) || zDouble < 0.0) {
                        Complex nc = n.evalComplex();
                        Complex zc = z.evalComplex();
                        return F.complexNum(BesselJS.sphericalBesselY(nc, zc));
                    }
                    return F.complexNum(BesselJS.sphericalBesselY(nDouble, zDouble));
                }
                catch (ValidateException ve) {
                    return IOFunctions.printMessage(ast.topHead(), ve, engine);
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
        }
    }

    private static final class SphericalHankelH2
    extends AbstractFunctionEvaluator {
        private SphericalHankelH2() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr n = ast.arg1();
            IExpr z = ast.arg2();
            if (engine.isNumericMode()) {
                try {
                    Complex nc = n.evalComplex();
                    Complex zc = z.evalComplex();
                    return FunctionExpand.callMatcher(F.FunctionExpand(ast), ast, engine);
                }
                catch (ValidateException ve) {
                    ve.printStackTrace();
                    return IOFunctions.printMessage(ast.topHead(), ve, engine);
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                    return F.NIL;
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
        }
    }

    private static final class SphericalHankelH1
    extends AbstractFunctionEvaluator {
        private SphericalHankelH1() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr n = ast.arg1();
            IExpr z = ast.arg2();
            if (engine.isNumericMode()) {
                try {
                    Complex nc = n.evalComplex();
                    Complex zc = z.evalComplex();
                    return FunctionExpand.callMatcher(F.FunctionExpand(ast), ast, engine);
                }
                catch (ValidateException ve) {
                    return IOFunctions.printMessage(ast.topHead(), ve, engine);
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                    return F.NIL;
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
        }
    }

    private static final class SphericalBesselJ
    extends AbstractFunctionEvaluator {
        private SphericalBesselJ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr n = ast.arg1();
            IExpr z = ast.arg2();
            if (engine.isDoubleMode()) {
                try {
                    double nDouble = Double.NaN;
                    double zDouble = Double.NaN;
                    try {
                        nDouble = n.evalDouble();
                        zDouble = z.evalDouble();
                    }
                    catch (ValidateException validateException) {
                        // empty catch block
                    }
                    if (Double.isNaN(nDouble) || Double.isNaN(zDouble)) {
                        Complex nc = n.evalComplex();
                        Complex zc = z.evalComplex();
                        return F.complexNum(BesselJS.sphericalBesselJ(nc, zc));
                    }
                    return F.complexNum(BesselJS.sphericalBesselJ(nDouble, zDouble));
                }
                catch (ValidateException ve) {
                    return IOFunctions.printMessage(ast.topHead(), ve, engine);
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                    return F.NIL;
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
        }
    }

    private static final class HankelH2
    extends AbstractFunctionEvaluator {
        private HankelH2() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr n = ast.arg1();
            IExpr z = ast.arg2();
            if (engine.isDoubleMode()) {
                try {
                    double nDouble = Double.NaN;
                    double zDouble = Double.NaN;
                    try {
                        nDouble = n.evalDouble();
                        zDouble = z.evalDouble();
                    }
                    catch (ValidateException validateException) {
                        // empty catch block
                    }
                    if (Double.isNaN(nDouble) || Double.isNaN(zDouble)) {
                        Complex nc = n.evalComplex();
                        Complex zc = z.evalComplex();
                        return F.complexNum(BesselJS.hankelH2(nc, zc));
                    }
                    return F.complexNum(BesselJS.hankelH2(nDouble, zDouble));
                }
                catch (ValidateException ve) {
                    return IOFunctions.printMessage(ast.topHead(), ve, engine);
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
        }
    }

    private static final class HankelH1
    extends AbstractFunctionEvaluator {
        private HankelH1() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr n = ast.arg1();
            IExpr z = ast.arg2();
            if (engine.isDoubleMode()) {
                try {
                    double nDouble = Double.NaN;
                    double zDouble = Double.NaN;
                    try {
                        nDouble = n.evalDouble();
                        zDouble = z.evalDouble();
                    }
                    catch (ValidateException validateException) {
                        // empty catch block
                    }
                    if (Double.isNaN(nDouble) || Double.isNaN(zDouble)) {
                        Complex nc = n.evalComplex();
                        Complex zc = z.evalComplex();
                        return F.complexNum(BesselJS.hankelH1(nc, zc));
                    }
                    return F.complexNum(BesselJS.hankelH1(nDouble, zDouble));
                }
                catch (ValidateException ve) {
                    return IOFunctions.printMessage(ast.topHead(), ve, engine);
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
        }
    }

    private static final class BesselYZero
    extends AbstractFunctionEvaluator {
        private BesselYZero() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr n = ast.arg1();
            IExpr z = ast.arg2();
            int k = z.toIntDefault();
            if (k > 0 && engine.isDoubleMode()) {
                try {
                    if (n.isReal()) {
                        return F.num(BesselJS.besselYZero(n.evalDouble(), k));
                    }
                }
                catch (MathRuntimeException e) {
                    LOGGER.debug("BesselYZero.evaluate() failed", (Throwable)e);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
        }
    }

    private static final class BesselY
    extends AbstractFunctionEvaluator
    implements BesselYRules {
        private BesselY() {
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr n = ast.arg1();
            IExpr z = ast.arg2();
            if (z.isZero()) {
                if (n.isZero()) {
                    return F.CNInfinity;
                }
                IExpr re = S.Re.of(engine, n);
                if (re.isZero() && n.isNumber() && !n.isZero()) {
                    return S.Indeterminate;
                }
                if (re.isNumber() && !re.isZero()) {
                    return S.ComplexInfinity;
                }
            }
            if (n.isNumber() && (z.isInfinity() || z.isNegativeInfinity())) {
                return F.C0;
            }
            if (engine.isDoubleMode()) {
                try {
                    double nDouble = Double.NaN;
                    double zDouble = Double.NaN;
                    try {
                        nDouble = n.evalDouble();
                        zDouble = z.evalDouble();
                    }
                    catch (ValidateException validateException) {
                        // empty catch block
                    }
                    if (Double.isNaN(nDouble) || Double.isNaN(zDouble) || zDouble < 0.0) {
                        Complex nc = n.evalComplex();
                        Complex zc = z.evalComplex();
                        return F.complexNum(BesselJS.besselY(nc, zc));
                    }
                    return F.num(BesselJS.besselYDouble(nDouble, zDouble));
                }
                catch (ValidateException ve) {
                    return IOFunctions.printMessage(ast.topHead(), ve, engine);
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            super.setUp(newSymbol);
            newSymbol.setAttributes(1536);
        }
    }

    private static final class BesselK
    extends AbstractFunctionEvaluator
    implements BesselKRules {
        private BesselK() {
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr n = ast.arg1();
            IExpr z = ast.arg2();
            if (z.isZero()) {
                if (n.isZero()) {
                    return F.CInfinity;
                }
                IExpr re = n.re();
                if (re.isZero() && n.isNumber() && !n.isZero()) {
                    return S.Indeterminate;
                }
                if (re.isNumber() && !re.isZero()) {
                    return S.ComplexInfinity;
                }
            }
            if (n.isNumber() && (z.isDirectedInfinity(F.CI) || z.isDirectedInfinity(F.CNI))) {
                return F.C0;
            }
            if (engine.isDoubleMode()) {
                try {
                    double nDouble = Double.NaN;
                    double zDouble = Double.NaN;
                    try {
                        nDouble = n.evalDouble();
                        zDouble = z.evalDouble();
                    }
                    catch (ValidateException validateException) {
                        // empty catch block
                    }
                    if (Double.isNaN(nDouble) || Double.isNaN(zDouble) || zDouble < 0.0) {
                        Complex nc = n.evalComplex();
                        Complex zc = z.evalComplex();
                        return F.complexNum(BesselJS.besselK(nc, zc));
                    }
                    return F.num(BesselJS.besselKDouble(nDouble, zDouble));
                }
                catch (ValidateException ve) {
                    return IOFunctions.printMessage(ast.topHead(), ve, engine);
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            super.setUp(newSymbol);
            newSymbol.setAttributes(1536);
        }
    }

    private static final class BesselI
    extends AbstractFunctionEvaluator
    implements BesselIRules {
        private BesselI() {
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr n = ast.arg1();
            IExpr z = ast.arg2();
            if (z.isZero()) {
                if (n.isZero()) {
                    return F.C1;
                }
                if (n.isInteger()) {
                    return F.C0;
                }
                IExpr re = n.re();
                if (re.isPositiveResult()) {
                    return F.C0;
                }
                if (re.isNegativeResult() && n.isNumber() && !n.isInteger()) {
                    return S.ComplexInfinity;
                }
                if (re.isZero() && n.isNumber() && !n.isZero()) {
                    return S.Indeterminate;
                }
            }
            if (n.isNumber() && (z.isDirectedInfinity(F.CI) || z.isDirectedInfinity(F.CNI))) {
                return F.C0;
            }
            if (engine.isDoubleMode()) {
                try {
                    double nDouble = Double.NaN;
                    double zDouble = Double.NaN;
                    try {
                        nDouble = n.evalDouble();
                        zDouble = z.evalDouble();
                    }
                    catch (ValidateException validateException) {
                        // empty catch block
                    }
                    if (Double.isNaN(nDouble) || Double.isNaN(zDouble) || zDouble < 0.0) {
                        Complex nc = n.evalComplex();
                        Complex zc = z.evalComplex();
                        return F.complexNum(BesselJS.besselI(nc, zc));
                    }
                    return F.num(BesselJS.besselIDouble(nDouble, zDouble));
                }
                catch (ValidateException ve) {
                    return IOFunctions.printMessage(ast.topHead(), ve, engine);
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            super.setUp(newSymbol);
            newSymbol.setAttributes(1536);
        }
    }

    private static final class BesselJZero
    extends AbstractFunctionEvaluator {
        private BesselJZero() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr n = ast.arg1();
            IExpr z = ast.arg2();
            int k = z.toIntDefault();
            if (n.isReal() && k > 0 && engine.isDoubleMode()) {
                try {
                    return F.num(BesselJS.besselJZero(n.evalDouble(), k));
                }
                catch (MathRuntimeException e) {
                    LOGGER.debug("BesselJZero.evaluate() failed", (Throwable)e);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
        }
    }

    private static final class BesselJ
    extends AbstractFunctionEvaluator {
        private BesselJ() {
        }

        private IExpr besselJHalf(IExpr n, IExpr z) {
            ISymbol j = F.Dummy("j");
            return F.Times(F.CSqrt2, F.Power((IExpr)S.Pi, F.CN1D2), F.Power(z, F.CN1D2), F.Plus((IExpr)F.Times((IExpr)F.Cos(F.Plus((IExpr)F.Times((IExpr)F.C1D2, (IExpr)F.Plus((IExpr)F.CN1D2, n), (IExpr)S.Pi), F.Negate(z))), (IExpr)F.Sum(F.Times(F.Power((IExpr)F.CN1, j), F.Power((IExpr)F.Times((IExpr)F.C2, z), F.Plus((IExpr)F.CN1, (IExpr)F.Times((IExpr)F.CN2, (IExpr)j))), F.Factorial(F.Plus((IExpr)F.Times((IExpr)F.C2, (IExpr)j), (IExpr)F.Abs(n), (IExpr)F.C1D2)), F.Power((IExpr)F.Times((IExpr)F.Factorial(F.Plus((IExpr)F.Times((IExpr)F.C2, (IExpr)j), (IExpr)F.C1)), (IExpr)F.Factorial(F.Plus((IExpr)F.QQ(-3L, 2L), (IExpr)F.Times((IExpr)F.CN2, (IExpr)j), (IExpr)F.Abs(n)))), -1L)), F.list(j, F.C0, F.Floor(F.Times((IExpr)F.C1D4, (IExpr)F.Plus((IExpr)F.CN3, (IExpr)F.Times((IExpr)F.C2, (IExpr)F.Abs(n)))))))), (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Sin(F.Plus((IExpr)F.Times((IExpr)F.C1D2, (IExpr)F.Plus((IExpr)F.CN1D2, n), (IExpr)S.Pi), F.Negate(z))), (IExpr)F.Sum(F.Times((IExpr)F.Power((IExpr)F.CN1, j), F.Power((IExpr)F.Times((IExpr)F.Factorial(F.Times((IExpr)F.C2, (IExpr)j)), (IExpr)F.Factorial(F.Plus((IExpr)F.CN1D2, (IExpr)F.Times((IExpr)F.CN2, (IExpr)j), (IExpr)F.Abs(n))), (IExpr)F.Power((IExpr)F.Times((IExpr)F.C2, z), F.Times((IExpr)F.C2, (IExpr)j))), -1L), (IExpr)F.Factorial(F.Plus((IExpr)F.CN1D2, (IExpr)F.Times((IExpr)F.C2, (IExpr)j), (IExpr)F.Abs(n)))), F.list(j, F.C0, F.Floor(F.Times((IExpr)F.C1D4, (IExpr)F.Plus((IExpr)F.CN1, (IExpr)F.Times((IExpr)F.C2, (IExpr)F.Abs(n))))))))));
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr in;
            IExpr n = ast.arg1();
            IExpr z = ast.arg2();
            int order = n.toIntDefault();
            if (z.isZero()) {
                if (n.isZero()) {
                    return F.C1;
                }
                if (n.isIntegerResult() || order != Integer.MIN_VALUE) {
                    return F.C0;
                }
                IExpr a = n.re();
                if (a.isPositive()) {
                    return F.C0;
                }
                if (a.isNegative()) {
                    return F.CComplexInfinity;
                }
                if (a.isZero() && !n.isZero()) {
                    return S.Indeterminate;
                }
            }
            if (n.isReal() && (in = engine.evaluate(((ISignedNumber)n).add(F.CN1D2))).isNumIntValue()) {
                if (z.isInfinity() || z.isNegativeInfinity()) {
                    return F.C0;
                }
                return this.besselJHalf(n, z);
            }
            if ((n.isInteger() || order != Integer.MIN_VALUE) && n.isNegative()) {
                return F.Times((IExpr)F.Power((IExpr)F.CN1, n), (IExpr)F.BesselJ(n.negate(), z));
            }
            if (engine.isDoubleMode()) {
                try {
                    double nDouble = Double.NaN;
                    double zDouble = Double.NaN;
                    try {
                        nDouble = n.evalDouble();
                        zDouble = z.evalDouble();
                    }
                    catch (ValidateException validateException) {
                        // empty catch block
                    }
                    if (Double.isNaN(nDouble) || Double.isNaN(zDouble) || zDouble < 0.0) {
                        Complex nc = n.evalComplex();
                        Complex zc = z.evalComplex();
                        return F.complexNum(BesselJS.besselJ(nc, zc));
                    }
                    return F.num(BesselJS.besselJDouble(nDouble, zDouble));
                }
                catch (ValidateException ve) {
                    return IOFunctions.printMessage(ast.topHead(), ve, engine);
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
        }
    }

    private static final class AiryBiPrime
    extends AbstractFunctionEvaluator {
        private AiryBiPrime() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr z = ast.arg1();
            if (engine.isDoubleMode()) {
                if (!z.isComplexNumeric()) {
                    try {
                        return F.complexNum(BesselJS.airyBiPrime(z.evalDouble()));
                    }
                    catch (NegativeArraySizeException nae) {
                        LOGGER.log(engine.getLogLevel(), "AiryBiPrime: {} caused NegativeArraySizeException", (Object)ast, (Object)nae);
                        return F.NIL;
                    }
                    catch (RuntimeException nae) {
                        // empty catch block
                    }
                }
                try {
                    return F.complexNum(BesselJS.airyBiPrime(z.evalComplex()));
                }
                catch (NegativeArraySizeException nae) {
                    LOGGER.log(engine.getLogLevel(), "AiryBiPrime: {} caused NegativeArraySizeException", (Object)ast, (Object)nae);
                    return F.NIL;
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                    return F.NIL;
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
        }
    }

    private static final class AiryBi
    extends AbstractFunctionEvaluator {
        private AiryBi() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr z = ast.arg1();
            if (engine.isDoubleMode()) {
                if (!z.isComplexNumeric()) {
                    try {
                        return F.complexNum(BesselJS.airyBi(z.evalDouble()));
                    }
                    catch (NegativeArraySizeException nae) {
                        LOGGER.log(engine.getLogLevel(), "AiryBi: {} caused NegativeArraySizeException", (Object)ast);
                        return F.NIL;
                    }
                    catch (RuntimeException nae) {
                        // empty catch block
                    }
                }
                try {
                    return F.complexNum(BesselJS.airyBi(z.evalComplex()));
                }
                catch (NegativeArraySizeException nae) {
                    LOGGER.log(engine.getLogLevel(), "AiryBi: {} caused NegativeArraySizeException", (Object)ast);
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
        }
    }

    private static final class AiryAiPrime
    extends AbstractFunctionEvaluator {
        private AiryAiPrime() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr z = ast.arg1();
            if (engine.isDoubleMode()) {
                if (!z.isComplexNumeric()) {
                    try {
                        return F.complexNum(BesselJS.airyAiPrime(z.evalDouble()));
                    }
                    catch (NegativeArraySizeException nae) {
                        LOGGER.log(engine.getLogLevel(), "AiryAiPrime: {} caused NegativeArraySizeException", (Object)ast);
                        return F.NIL;
                    }
                    catch (RuntimeException nae) {
                        // empty catch block
                    }
                }
                try {
                    return F.complexNum(BesselJS.airyAiPrime(z.evalComplex()));
                }
                catch (NegativeArraySizeException nae) {
                    LOGGER.log(engine.getLogLevel(), "AiryAiPrime: {} caused NegativeArraySizeException", (Object)ast);
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                }
                return F.NIL;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
        }
    }

    private static final class AiryAi
    extends AbstractFunctionEvaluator {
        private AiryAi() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr z = ast.arg1();
            if (engine.isDoubleMode()) {
                if (!z.isComplexNumeric()) {
                    try {
                        return F.complexNum(BesselJS.airyAi(z.evalDouble()));
                    }
                    catch (NegativeArraySizeException nae) {
                        LOGGER.log(engine.getLogLevel(), "AiryAi: {} caused NegativeArraySizeException", (Object)ast, (Object)nae);
                        return F.NIL;
                    }
                    catch (RuntimeException nae) {
                        // empty catch block
                    }
                }
                try {
                    return F.complexNum(BesselJS.airyAi(z.evalComplex()));
                }
                catch (NegativeArraySizeException nae) {
                    LOGGER.log(engine.getLogLevel(), "AiryAi: {} caused NegativeArraySizeException", (Object)ast);
                }
                catch (RuntimeException rex) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)rex);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.AiryAi.setEvaluator(new AiryAi());
            S.AiryAiPrime.setEvaluator(new AiryAiPrime());
            S.AiryBi.setEvaluator(new AiryBi());
            S.AiryBiPrime.setEvaluator(new AiryBiPrime());
            S.BesselI.setEvaluator(new BesselI());
            S.BesselJ.setEvaluator(new BesselJ());
            S.BesselJZero.setEvaluator(new BesselJZero());
            S.BesselK.setEvaluator(new BesselK());
            S.BesselY.setEvaluator(new BesselY());
            S.BesselYZero.setEvaluator(new BesselYZero());
            S.HankelH1.setEvaluator(new HankelH1());
            S.HankelH2.setEvaluator(new HankelH2());
            S.SphericalBesselJ.setEvaluator(new SphericalBesselJ());
            S.SphericalBesselY.setEvaluator(new SphericalBesselY());
            S.SphericalHankelH1.setEvaluator(new SphericalHankelH1());
            S.SphericalHankelH2.setEvaluator(new SphericalHankelH2());
            S.WeberE.setEvaluator(new WeberE());
        }
    }
}

