/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.FailedException;
import org.matheclipse.core.eval.exception.RuleCreationError;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.ISetEvaluator;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class AttributeFunctions {
    private static final Logger LOGGER = LogManager.getLogger();

    public static IAST attributesList(IExpr expr, IAST ast, EvalEngine engine) {
        IExpr x = Validate.checkIdentifierHoldPattern(expr, ast, engine);
        if (!x.isPresent()) {
            return F.NIL;
        }
        ISymbol symbol = (ISymbol)x;
        return AttributeFunctions.attributesList(symbol);
    }

    public static IAST attributesList(ISymbol symbol) {
        int attributes = symbol.getAttributes();
        IASTAppendable result = F.ListAlloc(Integer.bitCount(attributes));
        if ((attributes & 2) != 0) {
            result.append(S.Constant);
        }
        if ((attributes & 8) != 0) {
            result.append(S.Flat);
        }
        if ((attributes & 0x401E0) == 262624) {
            result.append(S.HoldAllComplete);
        } else if ((attributes & 0xE0) == 224) {
            result.append(S.HoldComplete);
        } else if ((attributes & 0x60) == 96) {
            result.append(S.HoldAll);
        } else {
            if ((attributes & 0x20) != 0) {
                result.append(S.HoldFirst);
            }
            if ((attributes & 0x40) != 0) {
                result.append(S.HoldRest);
            }
        }
        if ((attributes & 0x200) != 0) {
            result.append(S.Listable);
        }
        if ((attributes & 0x6000) == 24576) {
            result.append(S.NHoldAll);
        } else {
            if ((attributes & 0x2000) != 0) {
                result.append(S.NHoldFirst);
            }
            if ((attributes & 0x4000) != 0) {
                result.append(S.NHoldRest);
            }
        }
        if ((attributes & 0x400) != 0) {
            result.append(S.NumericFunction);
        }
        if ((attributes & 1) != 0) {
            result.append(S.OneIdentity);
        }
        if ((attributes & 4) != 0) {
            result.append(S.Orderless);
        }
        if ((attributes & 0x8000) != 0) {
            result.append(S.Protected);
        }
        if ((attributes & 0x40000) == 262144 && (attributes & 0x401E0) != 262624) {
            result.append(S.SequenceHold);
        }
        return result;
    }

    public static void initialize() {
        Initializer.init();
    }

    private AttributeFunctions() {
    }

    private static final class SetAttributes
    extends AbstractCoreFunctionEvaluator {
        private SetAttributes() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                if (ast.isAST2()) {
                    if (ast.arg1().isList()) {
                        IAST list = (IAST)ast.arg1();
                        return SetAttributes.setSymbolsAttributes(list, ast.arg2(), ast, engine);
                    }
                    IExpr arg1 = ast.arg1();
                    IExpr arg2 = engine.evaluate(ast.arg2());
                    ISymbol sym = (ISymbol)ast.arg1();
                    return SetAttributes.addAttributes(arg1, arg2, ast, engine);
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return F.NIL;
        }

        private static IExpr setSymbolsAttributes(IAST listOfSymbols, IExpr attributes, IAST ast, EvalEngine engine) {
            attributes = engine.evaluate(attributes);
            for (int i = 1; i < listOfSymbols.size(); ++i) {
                IExpr arg = listOfSymbols.get(i);
                if (!arg.isSymbol() || SetAttributes.addAttributes(arg, attributes, ast, engine).isPresent()) continue;
                return F.NIL;
            }
            return S.Null;
        }

        private static IExpr addAttributes(IExpr expr, IExpr attributes, IAST ast, EvalEngine engine) {
            IExpr x = Validate.checkIdentifierHoldPattern(expr, ast, engine);
            if (!x.isPresent()) {
                return F.NIL;
            }
            ISymbol sym = (ISymbol)x;
            if (!engine.isPackageMode() && Config.SERVER_MODE && sym.toString().charAt(0) != '$') {
                throw new RuleCreationError(expr);
            }
            if (attributes.isSymbol()) {
                ISymbol attribute = (ISymbol)attributes;
                SetAttributes.addAttributes(sym, attribute);
            } else if (attributes.isList()) {
                IAST lst = (IAST)attributes;
                for (int i = 1; i < lst.size(); ++i) {
                    ISymbol attribute = (ISymbol)lst.get(i);
                    SetAttributes.addAttributes(sym, attribute);
                }
            }
            return S.Null;
        }

        private static void addAttributes(ISymbol sym, ISymbol attribute) {
            if (sym.isProtected()) {
                IOFunctions.printMessage(S.SetAttributes, "write", F.list(sym), EvalEngine.get());
                throw new FailedException();
            }
            int functionID = attribute.ordinal();
            if (functionID > -1) {
                switch (functionID) {
                    case 273: {
                        sym.addAttributes(2);
                        break;
                    }
                    case 501: {
                        sym.addAttributes(8);
                        break;
                    }
                    case 796: {
                        sym.addAttributes(512);
                        break;
                    }
                    case 947: {
                        sym.addAttributes(1);
                        break;
                    }
                    case 963: {
                        sym.addAttributes(4);
                        break;
                    }
                    case 599: {
                        sym.addAttributes(96);
                        break;
                    }
                    case 600: {
                        sym.addAttributes(262624);
                        break;
                    }
                    case 601: {
                        sym.addAttributes(224);
                        break;
                    }
                    case 602: {
                        sym.addAttributes(32);
                        break;
                    }
                    case 605: {
                        sym.addAttributes(64);
                        break;
                    }
                    case 886: {
                        sym.addAttributes(24576);
                        break;
                    }
                    case 887: {
                        sym.addAttributes(8192);
                        break;
                    }
                    case 888: {
                        sym.addAttributes(16384);
                        break;
                    }
                    case 939: {
                        sym.addAttributes(1024);
                        break;
                    }
                    case 1062: {
                        sym.addAttributes(32768);
                        break;
                    }
                    case 1103: {
                        sym.addAttributes(65536);
                        break;
                    }
                    case 1173: {
                        sym.addAttributes(262144);
                    }
                }
            }
        }
    }

    private static final class Unprotect
    extends AbstractCoreFunctionEvaluator {
        private Unprotect() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (Config.UNPROTECT_ALLOWED) {
                IASTMutable mutable = ast.copyAST();
                for (int i = 1; i < ast.size(); ++i) {
                    IExpr x2 = Validate.checkIdentifierHoldPattern(ast.get(i), ast, engine);
                    if (!x2.isPresent()) {
                        return F.NIL;
                    }
                    mutable.set(i, x2);
                }
                IASTAppendable result = F.ListAlloc(mutable.size());
                mutable.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)x -> Unprotect.unprotect(x, result)));
                return result;
            }
            LOGGER.log(engine.getLogLevel(), "Unprotect: not allowed. Set Config.UNPROTECT_ALLOWED if necessary");
            return F.NIL;
        }

        private static void unprotect(IExpr x, IASTAppendable result) {
            ISymbol symbol = (ISymbol)x;
            if (symbol.isProtected()) {
                symbol.clearAttributes(32768);
                result.append(x);
            }
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class Protect
    extends AbstractCoreFunctionEvaluator {
        private Protect() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IASTMutable mutable = ast.copyAST();
            for (int i = 1; i < ast.size(); ++i) {
                IExpr x2 = Validate.checkIdentifierHoldPattern(ast.get(i), ast, engine);
                if (!x2.isPresent()) {
                    return F.NIL;
                }
                mutable.set(i, x2);
            }
            IASTAppendable result = F.ListAlloc(mutable.size());
            mutable.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)x -> Protect.protect(x, result)));
            return result;
        }

        private static void protect(IExpr x, IASTAppendable result) {
            ISymbol symbol = (ISymbol)x;
            if (!symbol.isProtected()) {
                symbol.addAttributes(32768);
                result.append(x);
            }
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class ClearAttributes
    extends AbstractCoreFunctionEvaluator {
        private ClearAttributes() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                if (ast.isAST2()) {
                    if (ast.arg1().isList()) {
                        IAST list = (IAST)ast.arg1();
                        IExpr arg2 = engine.evaluate(ast.arg2());
                        for (int i = 1; i < list.size(); ++i) {
                            IExpr temp = this.clearAttributes(list.get(i), arg2, ast, engine);
                            if (temp.isPresent()) continue;
                            return F.NIL;
                        }
                        return S.Null;
                    }
                    if (ast.arg1().isSymbol()) {
                        IExpr arg2 = engine.evaluate(ast.arg2());
                        ISymbol sym = (ISymbol)ast.arg1();
                        return this.clearAttributes(sym, arg2, ast, engine);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return F.NIL;
        }

        private IExpr clearAttributes(IExpr expr, IExpr attributes, IAST ast, EvalEngine engine) {
            IExpr x = Validate.checkIdentifierHoldPattern(expr, ast, engine);
            if (!x.isPresent()) {
                return F.NIL;
            }
            ISymbol sym = (ISymbol)x;
            if (!engine.isPackageMode() && Config.SERVER_MODE && sym.toString().charAt(0) != '$') {
                throw new RuleCreationError(sym);
            }
            if (sym.isProtected()) {
                IOFunctions.printMessage(S.ClearAttributes, "write", F.list(sym), EvalEngine.get());
                throw new FailedException();
            }
            if (attributes.isSymbol()) {
                ISymbol attribute = (ISymbol)attributes;
                this.clearAttributes(sym, attribute);
                return S.Null;
            }
            if (attributes.isList()) {
                IAST lst = (IAST)attributes;
                for (int i = 1; i < lst.size(); ++i) {
                    ISymbol attribute = (ISymbol)lst.get(i);
                    this.clearAttributes(sym, attribute);
                }
                return S.Null;
            }
            return S.Null;
        }

        private void clearAttributes(ISymbol sym, ISymbol attribute) {
            int functionID = attribute.ordinal();
            if (functionID > -1) {
                switch (functionID) {
                    case 273: {
                        sym.clearAttributes(2);
                        break;
                    }
                    case 501: {
                        sym.clearAttributes(8);
                        break;
                    }
                    case 796: {
                        sym.clearAttributes(512);
                        break;
                    }
                    case 947: {
                        sym.clearAttributes(1);
                        break;
                    }
                    case 963: {
                        sym.clearAttributes(4);
                        break;
                    }
                    case 599: {
                        sym.clearAttributes(96);
                        break;
                    }
                    case 600: {
                        sym.clearAttributes(262624);
                        break;
                    }
                    case 601: {
                        sym.clearAttributes(224);
                        break;
                    }
                    case 602: {
                        sym.clearAttributes(32);
                        break;
                    }
                    case 605: {
                        sym.clearAttributes(64);
                        break;
                    }
                    case 886: {
                        sym.clearAttributes(24576);
                        break;
                    }
                    case 887: {
                        sym.clearAttributes(8192);
                        break;
                    }
                    case 888: {
                        sym.clearAttributes(16384);
                        break;
                    }
                    case 939: {
                        sym.clearAttributes(1024);
                        break;
                    }
                    case 1173: {
                        sym.clearAttributes(262144);
                    }
                }
            }
        }
    }

    private static final class Attributes
    extends AbstractFunctionEvaluator
    implements ISetEvaluator {
        private Attributes() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST1()) {
                IExpr arg1 = ast.arg1();
                return AttributeFunctions.attributesList(arg1, ast, engine);
            }
            return F.NIL;
        }

        @Override
        public IExpr evaluateSet(IExpr leftHandSide, IExpr rightHandSide, IBuiltInSymbol builtinSymbol, EvalEngine engine) {
            if (leftHandSide.isAST(S.Attributes, 2)) {
                if (!leftHandSide.first().isSymbol()) {
                    IOFunctions.printMessage(builtinSymbol, "setps", F.list(leftHandSide.first()), engine);
                    return rightHandSide;
                }
                IExpr temp = engine.evaluate(F.SetAttributes(leftHandSide.first(), rightHandSide));
                if (temp.equals(S.Null)) {
                    return rightHandSide;
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(608);
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.Attributes.setEvaluator(new Attributes());
            S.ClearAttributes.setEvaluator(new ClearAttributes());
            S.SetAttributes.setEvaluator(new SetAttributes());
            S.Protect.setEvaluator(new Protect());
            S.Unprotect.setEvaluator(new Unprotect());
        }
    }
}

