/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import java.util.function.Consumer;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.eval.util.AbstractAssumptions;
import org.matheclipse.core.eval.util.Assumptions;
import org.matheclipse.core.eval.util.IAssumptions;
import org.matheclipse.core.eval.util.OptionArgs;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.ISymbol;

public class AssumptionFunctions {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IExpr refineAssumptions(IExpr expr, IAssumptions assumptions, EvalEngine engine) {
        if (assumptions != null) {
            IAssumptions oldAssumptions = engine.getAssumptions();
            try {
                engine.setAssumptions(assumptions);
                IExpr iExpr = engine.evalWithoutNumericReset(expr);
                return iExpr;
            }
            finally {
                engine.setAssumptions(oldAssumptions);
            }
        }
        return engine.evalWithoutNumericReset(expr);
    }

    public static void initialize() {
        Initializer.init();
    }

    private AssumptionFunctions() {
    }

    private static class Refine
    extends AbstractCoreFunctionEvaluator {
        private Refine() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr assumptionExpr;
            OptionArgs options = null;
            IAssumptions assumptions = null;
            if (ast.size() > 2) {
                options = new OptionArgs(S.Refine, ast, 2, engine);
            }
            if ((assumptionExpr = OptionArgs.determineAssumptions(ast, 2, options)).isPresent() && assumptionExpr.isAST()) {
                assumptions = Assumptions.getInstance(assumptionExpr);
            }
            return AssumptionFunctions.refineAssumptions(ast.arg1(), assumptions, engine);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
            this.setOptions(newSymbol, F.list(F.Rule((IExpr)S.Assumptions, (IExpr)S.$Assumptions)));
        }
    }

    private static class NotElement
    extends AbstractCoreFunctionEvaluator {
        private NotElement() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg2 = engine.evaluate(ast.arg2());
            if (arg2.isSymbol()) {
                IExpr arg1 = engine.evaluate(ast.arg1());
                if (arg1.isAST(S.Alternatives)) {
                    IAST alternatives = (IAST)arg1;
                    IASTAppendable andList = F.And();
                    alternatives.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)x -> andList.append(F.Not(F.Element(x, arg2)))));
                    return andList;
                }
                return F.Not(F.Element(arg1, arg2));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static class Element
    extends AbstractCoreFunctionEvaluator {
        private Element() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg2 = engine.evaluate(ast.arg2());
            if (arg2.isSymbol()) {
                ISymbol domain = (ISymbol)arg2;
                IExpr arg1 = engine.evaluate(ast.arg1());
                if (arg1.isAST()) {
                    IAST arg1AST = (IAST)arg1;
                    if (arg1.isList() || arg1.isAST(S.Alternatives)) {
                        if (arg1AST.size() == 1) {
                            return S.True;
                        }
                        if (arg1AST.size() == 2) {
                            return F.Element(arg1AST.first(), domain);
                        }
                        IASTAppendable result = F.ast(arg1.head(), arg1AST.size());
                        boolean evaled = false;
                        for (int i = 1; i < arg1AST.size(); ++i) {
                            IExpr arg = arg1AST.get(i);
                            IExpr assumeDomain = this.assumeDomain(arg, domain);
                            if (assumeDomain.isFalse()) {
                                evaled = true;
                                return S.False;
                            }
                            if (assumeDomain.isTrue()) {
                                evaled = true;
                                continue;
                            }
                            result.append(arg);
                        }
                        return evaled ? F.Element(result, domain) : F.NIL;
                    }
                }
                return this.assumeDomain(arg1, domain);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        private IExpr assumeDomain(IExpr arg1, ISymbol domain) {
            if (domain.isBuiltInSymbol()) {
                int symbolID = ((IBuiltInSymbol)domain).ordinal();
                switch (symbolID) {
                    case 55: {
                        ISymbol truthValue = AbstractAssumptions.assumeAlgebraic(arg1);
                        return truthValue != null ? truthValue : F.NIL;
                    }
                    case 102: {
                        ISymbol truthValue = AbstractAssumptions.assumeArray(arg1);
                        return truthValue != null ? truthValue : F.NIL;
                    }
                    case 177: {
                        ISymbol truthValue = AbstractAssumptions.assumeBoolean(arg1);
                        return truthValue != null ? truthValue : F.NIL;
                    }
                    case 261: {
                        ISymbol truthValue = AbstractAssumptions.assumeComplex(arg1);
                        return truthValue != null ? truthValue : F.NIL;
                    }
                    case 668: {
                        ISymbol truthValue = AbstractAssumptions.assumeInteger(arg1);
                        return truthValue != null ? truthValue : F.NIL;
                    }
                    case 1051: {
                        return AbstractAssumptions.assumePrime(arg1);
                    }
                    case 1098: {
                        ISymbol truthValue = AbstractAssumptions.assumeRational(arg1);
                        return truthValue != null ? truthValue : F.NIL;
                    }
                    case 1110: {
                        ISymbol truthValue = AbstractAssumptions.assumeReal(arg1);
                        return truthValue != null ? truthValue : F.NIL;
                    }
                }
            }
            return F.NIL;
        }
    }

    private static final class Assuming
    extends AbstractEvaluator {
        private Assuming() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr oldValue = S.$Assumptions.assignedValue();
            IExpr value = S.True;
            value = oldValue == null ? (ast.arg1().isList() ? ast.arg1() : F.list(ast.arg1())) : ((value = oldValue).isList() ? ((IAST)value).appendClone(ast.arg1()) : F.ListAlloc(value, ast.arg1()));
            try {
                IExpr temp;
                S.$Assumptions.assignValue(value);
                IExpr iExpr = temp = engine.evaluate(ast.arg2());
                return iExpr;
            }
            finally {
                S.$Assumptions.assignValue(oldValue);
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(64);
        }
    }

    private static final class Arrays
    extends AbstractEvaluator {
        private Arrays() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.size() == 2 && ast.arg1().isAST()) {
                return F.Arrays((IAST)ast.arg1());
            }
            if (ast.size() == 3 && ast.arg1().isAST() && ast.arg2().isSymbol()) {
                return F.Arrays((IAST)ast.arg1(), (ISymbol)ast.arg2());
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(24576);
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.Arrays.setEvaluator(new Arrays());
            S.Assuming.setEvaluator(new Assuming());
            S.Element.setEvaluator(new Element());
            S.NotElement.setEvaluator(new NotElement());
            S.Refine.setEvaluator(new Refine());
        }
    }
}

