/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.exception.ArgumentTypeException;
import org.matheclipse.core.eval.exception.ValidateException;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.eval.interfaces.ICoreFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.ISetEvaluator;
import org.matheclipse.core.eval.util.MutableInt;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.generic.Predicates;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTDataset;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IAssociation;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;

public class AssociationFunctions {
    private static final Logger LOGGER = LogManager.getLogger();

    private static IExpr mapHeadIfPresent(IASTMutable list, IExpr head) {
        if (head.isPresent()) {
            return list.mapThread(x -> F.unaryAST1(head, x));
        }
        return list;
    }

    public static void initialize() {
        Initializer.init();
    }

    private AssociationFunctions() {
    }

    private static class Values
    extends AbstractEvaluator {
        private Values() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr head;
            IExpr arg1 = ast.arg1();
            IExpr iExpr = head = ast.isAST2() ? ast.arg2() : F.NIL;
            if (arg1.isAssociation()) {
                IASTMutable list = ((IAssociation)arg1).values();
                return AssociationFunctions.mapHeadIfPresent(list, head);
            }
            if (arg1.isRuleAST()) {
                if (head.isPresent()) {
                    return F.unaryAST1(head, arg1.second());
                }
                return arg1.second();
            }
            if (arg1.isList()) {
                if (arg1.isListOfRules(true)) {
                    IAST listOfRules = (IAST)arg1;
                    IASTAppendable list = F.ast((IExpr)S.List, listOfRules.argSize());
                    for (int i = 1; i < listOfRules.size(); ++i) {
                        IExpr rule = listOfRules.get(i);
                        if (rule.isRuleAST()) {
                            list.append(rule.second());
                            continue;
                        }
                        if (!rule.isEmptyList()) continue;
                        list.append(rule);
                    }
                    return AssociationFunctions.mapHeadIfPresent(list, head);
                }
                return ((IAST)arg1).mapThread(ast.setAtCopy(1, F.Slot1), 1);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static class Summary
    extends AbstractEvaluator {
        private Summary() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isDataset()) {
                return ((IASTDataset)arg1).summary();
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static final class KeyTake
    extends AbstractEvaluator {
        private KeyTake() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                if (ast.arg1().isListOfRulesOrAssociation(true) || ast.arg1().isListOfLists()) {
                    IAST arg1 = (IAST)ast.arg1();
                    if (arg1.forAll(x -> x.isListOfRulesOrAssociation(true))) {
                        return arg1.mapThread(ast, 1);
                    }
                    IExpr arg2 = ast.arg2();
                    if (!arg2.isList()) {
                        arg2 = F.list(arg2);
                    }
                    return KeyTake.keyTake(arg1, (IAST)arg2);
                }
                LOGGER.log(engine.getLogLevel(), "KeyTake: Association or list of rules expected at position 1.");
            }
            catch (ValidateException ve) {
                IOFunctions.printMessage(ast.topHead(), ve, engine);
            }
            catch (RuntimeException rex) {
                LOGGER.debug("KeyTake.evaluate() failed", (Throwable)rex);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2_1;
        }

        private static IAST keyTake(IAST expr, IAST list) {
            int size = list.size();
            IAssociation resultAssoc = F.assoc();
            for (int i = 1; i < size; ++i) {
                IAST rule = expr.getRule(list.get(i));
                if (!rule.isPresent()) continue;
                resultAssoc.appendRule(rule);
            }
            return resultAssoc;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class Structure
    extends AbstractEvaluator {
        private Structure() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isDataset()) {
                return ((IASTDataset)arg1).structure();
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class Lookup
    extends AbstractEvaluator
    implements ICoreFunctionEvaluator {
        private Lookup() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = engine.evaluate(ast.arg1());
            if (arg1.isList()) {
                if (ast.size() > 2 && arg1.isListOfRules(true)) {
                    IExpr key = engine.evaluate(ast.arg2());
                    if (key.isList()) {
                        return ((IAST)key).mapThread(ast, 2);
                    }
                    if (key.isAST(S.Key, 2)) {
                        key = key.first();
                    }
                    IAST listOfRules = (IAST)arg1;
                    for (int i = 1; i < listOfRules.size(); ++i) {
                        IExpr rule = listOfRules.get(i);
                        if (!rule.isRuleAST() || !rule.first().equals(key)) continue;
                        return rule.second();
                    }
                    if (ast.isAST3()) {
                        return engine.evaluate(ast.arg3());
                    }
                    return F.Missing(F.stringx("KeyAbsent"), key);
                }
                return ((IAST)arg1).mapThread(ast, 1);
            }
            if (arg1.isAssociation()) {
                if (ast.isAST2()) {
                    IExpr key = engine.evaluate(ast.arg2());
                    if (key.isList()) {
                        return ((IAST)key).mapThread(ast, 2);
                    }
                    if (key.isAST(S.Key, 2)) {
                        key = key.first();
                    }
                    return ((IAssociation)arg1).getValue(key);
                }
                if (ast.isAST3()) {
                    IExpr key = engine.evaluate(ast.arg2());
                    if (key.isList()) {
                        return ((IAST)key).mapThread(ast, 2);
                    }
                    if (key.isAST(S.Key, 2)) {
                        key = key.first();
                    }
                    IExpr arg3 = ast.arg3();
                    return ((IAssociation)arg1).getValue(key, () -> engine.evaluate(arg3));
                }
            } else {
                return IOFunctions.printMessage(ast.topHead(), "invrl", F.List(), engine);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_3_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(262624);
        }
    }

    private static class LetterCounts
    extends AbstractEvaluator {
        private LetterCounts() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isString()) {
                String str = ((IStringX)arg1).toString();
                HashMap<Character, MutableInt> map = new HashMap<Character, MutableInt>();
                for (int i = 0; i < str.length(); ++i) {
                    map.compute(Character.valueOf(str.charAt(i)), (k, v) -> v == null ? new MutableInt(1) : v.increment());
                }
                IAssociation assoc = F.assoc();
                for (Map.Entry elem : map.entrySet()) {
                    assoc.appendRule(F.Rule((IExpr)F.$str(((Character)elem.getKey()).charValue()), (IExpr)F.ZZ(((MutableInt)elem.getValue()).value())));
                }
                return assoc;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class KeySort
    extends AbstractEvaluator {
        private KeySort() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IAST arg1;
            if (ast.arg1().isASTOrAssociation() && (arg1 = (IAST)ast.arg1()).isAssociation()) {
                if (ast.isAST2()) {
                    return ((IAssociation)arg1).keySort(new Predicates.IsBinaryFalse(ast.arg2()));
                }
                return ((IAssociation)arg1).keySort();
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static final class KeySelect
    extends AbstractEvaluator {
        private KeySelect() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int size = ast.size();
            if (size == 3) {
                IExpr arg1 = ast.arg1();
                if (arg1.isListOfRulesOrAssociation(false)) {
                    IAST list = (IAST)arg1;
                    IExpr predicateHead = ast.arg2();
                    return this.keySelect(list, x -> engine.evalTrue(predicateHead, (IExpr)x));
                }
                return IOFunctions.printMessage(ast.topHead(), "invrl", F.list(arg1), engine);
            }
            return F.NIL;
        }

        private IAST keySelect(IAST assoc, Predicate<? super IExpr> predicate) {
            int[] items = new int[assoc.size()];
            int length = 0;
            for (int i = 1; i < assoc.size(); ++i) {
                IAST rule = (IAST)assoc.getRule(i);
                if (!predicate.test(rule.first())) continue;
                items[length++] = i;
            }
            if (length == assoc.size() - 1) {
                return assoc;
            }
            IAssociation result = F.assoc();
            if (length > 0) {
                for (int i = 0; i < length; ++i) {
                    result.appendRule(assoc.getRule(items[i]));
                }
            }
            return result;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class Keys
    extends AbstractEvaluator {
        private Keys() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr head;
            IExpr arg1 = ast.arg1();
            IExpr iExpr = head = ast.isAST2() ? ast.arg2() : F.NIL;
            if (arg1.isAssociation()) {
                IASTMutable list = ((IAssociation)arg1).keys();
                return AssociationFunctions.mapHeadIfPresent(list, head);
            }
            if (arg1.isDataset()) {
                return ((IASTDataset)arg1).columnNames();
            }
            if (arg1.isRuleAST()) {
                if (head.isPresent()) {
                    return F.unaryAST1(head, arg1.first());
                }
                return arg1.first();
            }
            if (arg1.isList()) {
                if (arg1.isListOfRules(true)) {
                    IAST listOfRules = (IAST)arg1;
                    IASTAppendable list = F.ast((IExpr)S.List, listOfRules.argSize());
                    for (int i = 1; i < listOfRules.size(); ++i) {
                        IExpr rule = listOfRules.get(i);
                        if (rule.isRuleAST()) {
                            list.append(rule.first());
                            continue;
                        }
                        if (rule.isEmptyList()) {
                            list.append(rule);
                            continue;
                        }
                        throw new ArgumentTypeException("invrl", F.list(rule));
                    }
                    return AssociationFunctions.mapHeadIfPresent(list, head);
                }
                return ((IAST)arg1).mapThread(ast.setAtCopy(1, F.Slot1), 1);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static class Key
    extends AbstractEvaluator {
        private Key() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.head().isAST(S.Key, 2) && ast.isAST1() && ast.arg1().isAssociation()) {
                IExpr key = ast.head().first();
                IAssociation arg1 = (IAssociation)ast.arg1();
                IAST rule = arg1.getRule(key);
                if (rule.isPresent()) {
                    return rule.second();
                }
                return F.Missing(S.KeyAbsent, key);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_1_0;
        }
    }

    private static class KeyExistsQ
    extends AbstractEvaluator {
        private KeyExistsQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST2()) {
                IExpr arg1 = ast.arg1();
                IExpr arg2 = ast.arg2();
                if (arg1.isAssociation()) {
                    return ((IAssociation)arg1).isKey(arg2) ? S.True : S.False;
                }
                if (arg1.isListOfRules(true)) {
                    IAST listOfRules = (IAST)arg1;
                    for (int i = 1; i < listOfRules.size(); ++i) {
                        IExpr rule = listOfRules.get(i);
                        if (!rule.isRuleAST() || !arg2.equals(rule.first())) continue;
                        return S.True;
                    }
                }
                return S.False;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2_2;
        }
    }

    private static class Counts
    extends AbstractEvaluator {
        private Counts() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isList()) {
                IAST list = (IAST)arg1;
                Map<IExpr, MutableInt> histogram = MutableInt.createHistogram(list);
                IAssociation assoc = F.assoc();
                for (Map.Entry<IExpr, MutableInt> elem : histogram.entrySet()) {
                    assoc.appendRule(F.Rule(elem.getKey(), (IExpr)F.ZZ(elem.getValue().value())));
                }
                return assoc;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static class AssociationThread
    extends AbstractEvaluator {
        private AssociationThread() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (ast.isAST2()) {
                IExpr arg2 = ast.arg2();
                return AssociationThread.associationThread(S.Rule, arg1, arg2);
            }
            if (arg1.isRuleAST()) {
                IAST rule = (IAST)arg1;
                return AssociationThread.associationThread((ISymbol)rule.head(), rule.arg1(), rule.arg2());
            }
            return F.NIL;
        }

        private static IExpr associationThread(ISymbol symbol, IExpr arg1, IExpr arg2) {
            if (arg1.isList() && arg2.isList() && arg1.size() == arg2.size()) {
                IAST list1 = (IAST)arg1;
                IAST list2 = (IAST)arg2;
                IASTAppendable listOfRules = F.ListAlloc(arg1.size());
                for (int i = 1; i < list1.size(); ++i) {
                    listOfRules.append(F.binaryAST2((IExpr)symbol, list1.get(i), list2.get(i)));
                }
                return F.assoc(listOfRules);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static class AssociationMap
    extends AbstractEvaluator {
        private AssociationMap() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (ast.isAST2()) {
                IExpr arg2 = ast.arg2();
                return AssociationMap.associationMap(S.Rule, arg1, arg2, engine);
            }
            return F.NIL;
        }

        private static IExpr associationMap(ISymbol symbol, IExpr arg1, IExpr arg2, EvalEngine engine) {
            if (arg2.isList()) {
                IAST list2 = (IAST)arg2;
                IAssociation result = F.assoc();
                for (int i = 1; i < list2.size(); ++i) {
                    IExpr function = engine.evaluate(F.unaryAST1(arg1, list2.get(i)));
                    result.append(F.binaryAST2((IExpr)symbol, list2.get(i), function));
                }
                return result;
            }
            if (arg2.isAssociation()) {
                IAssociation list2 = (IAssociation)arg2;
                IASTAppendable result = F.ast((IExpr)S.Association, list2.size());
                for (int i = 1; i < list2.size(); ++i) {
                    IExpr function = engine.evaluate(F.unaryAST1(arg1, list2.getRule(i)));
                    result.appendRule(function);
                }
                return result;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2_2;
        }
    }

    private static class Association
    extends AbstractEvaluator
    implements ISetEvaluator {
        private Association() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAssociation()) {
                return F.NIL;
            }
            if (ast.head() != S.Association) {
                return F.NIL;
            }
            if (ast.isAST0()) {
                return F.assoc(F.List());
            }
            if (ast.size() > 1) {
                IASTMutable assocList = F.NIL;
                boolean evaled = false;
                try {
                    assocList = ast.copy();
                    for (int i = 1; i < ast.size(); ++i) {
                        IExpr temp;
                        IExpr arg = ast.get(i);
                        if (arg.isAssociation() || !(temp = engine.evaluateNIL(arg)).isPresent()) continue;
                        evaled = true;
                        assocList.set(i, temp);
                    }
                    IAssociation assoc = F.assoc();
                    for (int i = 1; i < assocList.size(); ++i) {
                        IExpr arg = assocList.get(i);
                        if (!arg.isASTOrAssociation()) {
                            return evaled ? assocList : F.NIL;
                        }
                        assoc.appendRules((IAST)arg);
                    }
                    return assoc;
                }
                catch (ValidateException ve) {
                    IOFunctions.printMessage((ISymbol)S.Association, ve, engine);
                    return evaled ? assocList : F.NIL;
                }
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(262624);
        }

        @Override
        public IExpr evaluateSet(IExpr leftHandSide, IExpr rightHandSide, IBuiltInSymbol builtinSymbol, EvalEngine engine) {
            if (leftHandSide.head().isSymbol()) {
                ISymbol symbol = (ISymbol)leftHandSide.head();
                IExpr temp = symbol.assignedValue();
                if (temp == null) {
                    return IOFunctions.printMessage(builtinSymbol, "rvalue", F.list(symbol), engine);
                }
                if (symbol.isProtected()) {
                    return IOFunctions.printMessage(builtinSymbol, "wrsym", F.list(symbol), EvalEngine.get());
                }
                try {
                    IExpr lhsHead = engine.evaluate(symbol);
                    if (lhsHead.isAssociation()) {
                        IAssociation assoc = (IAssociation)lhsHead;
                        assoc = assoc.copy();
                        assoc.appendRule(F.Rule(((IAST)leftHandSide).arg1(), rightHandSide));
                        symbol.assignValue(assoc, false);
                        return rightHandSide;
                    }
                }
                catch (ValidateException ve) {
                    return IOFunctions.printMessage((ISymbol)builtinSymbol, ve, engine);
                }
            }
            IOFunctions.printMessage(builtinSymbol, "setps", F.list(leftHandSide.head()), engine);
            return rightHandSide;
        }
    }

    private static final class AssociateTo
    extends AbstractCoreFunctionEvaluator {
        private AssociateTo() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr leftHandSide = ast.arg1();
            if (leftHandSide.isSymbol()) {
                ISymbol sym = (ISymbol)leftHandSide;
                IExpr arg2 = engine.evaluate(ast.arg2());
                AssociateToFunction function = new AssociateToFunction(arg2);
                IExpr[] results = sym.reassignSymbolValue(function, (ISymbol)S.AssociateTo, engine);
                if (results != null) {
                    return results[1];
                }
                return F.NIL;
            }
            if (leftHandSide.isASTSizeGE(S.Part, 3) && leftHandSide.first().isSymbol()) {
                ISymbol sym = (ISymbol)leftHandSide.first();
                return AssociateTo.assignPartTo(sym, (IAST)leftHandSide, ast, engine);
            }
            return IOFunctions.printMessage(ast.topHead(), "rvalue", F.list(leftHandSide), engine);
        }

        private static IExpr assignPartTo(ISymbol symbol, IAST part, IAST ast, EvalEngine engine) {
            if (symbol.hasAssignedSymbolValue()) {
                IExpr value = ast.arg2();
                if (value.isRuleAST() || value.isListOfRules() || value.isAssociation()) {
                    IExpr oldValue = engine.evaluate(part);
                    if (oldValue.isAssociation()) {
                        IAssociation newResult = ((IAssociation)oldValue).copy();
                        newResult.appendRules((IAST)value);
                        engine.evaluate(F.Set(part, newResult));
                        return symbol.assignedValue();
                    }
                    return IOFunctions.printMessage(ast.topHead(), "invak", F.list(oldValue), EvalEngine.get());
                }
                return IOFunctions.printMessage(ast.topHead(), "invdt", F.List(), EvalEngine.get());
            }
            return IOFunctions.printMessage(ast.topHead(), "rvalue", F.list(symbol), engine);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(32);
        }

        private static class AssociateToFunction
        implements Function<IExpr, IExpr> {
            private final IExpr value;

            public AssociateToFunction(IExpr value) {
                this.value = value;
            }

            @Override
            public IExpr apply(IExpr symbolValue) {
                if (symbolValue.isAssociation()) {
                    if (this.value.isRuleAST() || this.value.isListOfRules() || this.value.isAssociation()) {
                        IAssociation result = (IAssociation)symbolValue;
                        result.appendRules((IAST)this.value);
                        return result;
                    }
                    return IOFunctions.printMessage(S.AssociateTo, "invdt", F.List(), EvalEngine.get());
                }
                return IOFunctions.printMessage(S.AssociateTo, "invak", F.list(symbolValue), EvalEngine.get());
            }
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.AssociateTo.setEvaluator(new AssociateTo());
            S.Association.setEvaluator(new Association());
            S.AssociationMap.setEvaluator(new AssociationMap());
            S.AssociationThread.setEvaluator(new AssociationThread());
            S.Counts.setEvaluator(new Counts());
            S.KeyExistsQ.setEvaluator(new KeyExistsQ());
            S.Key.setEvaluator(new Key());
            S.Keys.setEvaluator(new Keys());
            S.KeySelect.setEvaluator(new KeySelect());
            S.KeySort.setEvaluator(new KeySort());
            S.KeyTake.setEvaluator(new KeyTake());
            S.LetterCounts.setEvaluator(new LetterCounts());
            S.Lookup.setEvaluator(new Lookup());
            S.Structure.setEvaluator(new Structure());
            S.Summary.setEvaluator(new Summary());
            S.Values.setEvaluator(new Values());
        }
    }
}

