/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import java.util.function.Consumer;
import java.util.function.DoubleFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apfloat.Apcomplex;
import org.apfloat.ApcomplexMath;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatMath;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.FixedPrecisionApfloatHelper;
import org.apfloat.InfiniteExpansionException;
import org.apfloat.LossOfPrecisionException;
import org.apfloat.OverflowException;
import org.apfloat.internal.BackingStorageException;
import org.hipparchus.fraction.BigFraction;
import org.hipparchus.linear.Array2DRowRealMatrix;
import org.hipparchus.linear.ArrayRealVector;
import org.hipparchus.linear.RealMatrix;
import org.hipparchus.linear.RealVector;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.builtin.NumberTheory;
import org.matheclipse.core.builtin.functions.GammaJS;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.PlusOp;
import org.matheclipse.core.eval.exception.ArgumentTypeStopException;
import org.matheclipse.core.eval.exception.IterationLimitExceeded;
import org.matheclipse.core.eval.exception.PolynomialDegreeLimitExceeded;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.exception.ValidateException;
import org.matheclipse.core.eval.interfaces.AbstractArg1;
import org.matheclipse.core.eval.interfaces.AbstractArg12;
import org.matheclipse.core.eval.interfaces.AbstractArg2;
import org.matheclipse.core.eval.interfaces.AbstractArgMultiple;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractTrigArg1;
import org.matheclipse.core.eval.interfaces.IFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.INumeric;
import org.matheclipse.core.eval.interfaces.ISetEvaluator;
import org.matheclipse.core.eval.util.AbstractAssumptions;
import org.matheclipse.core.eval.util.Assumptions;
import org.matheclipse.core.eval.util.IAssumptions;
import org.matheclipse.core.eval.util.OpenIntToIExprHashMap;
import org.matheclipse.core.expression.ASTRealMatrix;
import org.matheclipse.core.expression.ASTRealVector;
import org.matheclipse.core.expression.ASTSeriesData;
import org.matheclipse.core.expression.ApcomplexNum;
import org.matheclipse.core.expression.ApfloatNum;
import org.matheclipse.core.expression.ComplexNum;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.IntervalSym;
import org.matheclipse.core.expression.Num;
import org.matheclipse.core.expression.NumberUtil;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IAssociation;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IComplexNum;
import org.matheclipse.core.interfaces.IEvaluator;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.INum;
import org.matheclipse.core.interfaces.INumber;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.numbertheory.GaussianInteger;
import org.matheclipse.core.numbertheory.Primality;
import org.matheclipse.core.patternmatching.hash.HashedOrderlessMatcher;
import org.matheclipse.core.patternmatching.hash.HashedOrderlessMatcherPlus;
import org.matheclipse.core.patternmatching.hash.HashedOrderlessMatcherTimes;
import org.matheclipse.core.patternmatching.hash.HashedPatternRulesLog;
import org.matheclipse.core.patternmatching.hash.HashedPatternRulesTimes;
import org.matheclipse.core.patternmatching.hash.HashedPatternRulesTimesPower;
import org.matheclipse.core.reflection.system.rules.AbsRules;
import org.matheclipse.core.reflection.system.rules.ConjugateRules;
import org.matheclipse.core.reflection.system.rules.GammaRules;
import org.matheclipse.core.reflection.system.rules.PowerRules;
import org.matheclipse.core.tensor.qty.IQuantity;
import org.matheclipse.core.visit.VisitorExpr;
import org.matheclipse.parser.client.math.MathException;

public final class Arithmetic {
    private static final Logger LOGGER = LogManager.getLogger();
    private static int g = 7;
    private static org.hipparchus.complex.Complex[] pComplex = new org.hipparchus.complex.Complex[]{new org.hipparchus.complex.Complex(0.9999999999998099), new org.hipparchus.complex.Complex(676.5203681218851), new org.hipparchus.complex.Complex(-1259.1392167224028), new org.hipparchus.complex.Complex(771.3234287776531), new org.hipparchus.complex.Complex(-176.6150291621406), new org.hipparchus.complex.Complex(12.507343278686905), new org.hipparchus.complex.Complex(-0.13857109526572012), new org.hipparchus.complex.Complex(9.984369578019572E-6), new org.hipparchus.complex.Complex(1.5056327351493116E-7)};
    public static final Plus CONST_PLUS = new Plus();
    public static final Times CONST_TIMES = new Times();
    public static final Power CONST_POWER = new Power();
    public static final IFunctionEvaluator CONST_COMPLEX = new Complex();
    public static final IFunctionEvaluator CONST_RATIONAL = new Rational();

    private static IExpr timesPowerPower(IExpr power0Arg1, IExpr power0Arg2, IExpr power1Arg1, IExpr power1Arg2) {
        IExpr temp;
        if (power0Arg2.isNumber() && power1Arg2.isNumber()) {
            IExpr timesBase;
            if (power0Arg1.equals(power1Arg1)) {
                return F.Power(power0Arg1, power0Arg2.plus(power1Arg2));
            }
            if (power0Arg2.equals(power1Arg2) && power0Arg1.isRealResult() && power1Arg1.isRealResult() && (!(timesBase = EvalEngine.get().evaluate(F.Times(power0Arg1, power1Arg1))).isTimes() || !power0Arg2.isInteger())) {
                return F.Power(timesBase, power0Arg2);
            }
            if (power0Arg2.negate().equals(power1Arg2) && power0Arg1.isPositive() && power1Arg1.isPositive() && power0Arg1.isReal() && power1Arg1.isReal()) {
                if (power0Arg2.isNegative()) {
                    return F.Power(power1Arg1.divide(power0Arg1), power1Arg2);
                }
                return F.Power(power0Arg1.divide(power1Arg1), power0Arg2);
            }
        }
        if (power0Arg1.isRational() && power1Arg1.isRational() && (temp = Arithmetic.timesPowerPower(((IRational)power0Arg1).numerator(), ((IRational)power0Arg1).denominator(), power0Arg2, ((IRational)power1Arg1).numerator(), ((IRational)power1Arg1).denominator(), power1Arg2, false)).isPresent()) {
            return temp;
        }
        if (power0Arg1.equals(power1Arg1)) {
            return F.Power(power0Arg1, power0Arg2.plus(power1Arg2));
        }
        return F.NIL;
    }

    private static IExpr timesPowerPower(IInteger p1Numer, IInteger p1Denom, IExpr p1Exp, IInteger p2Numer, IInteger p2Denom, IExpr p2Exp, boolean setEvaled) {
        int base;
        OpenIntToIExprHashMap.Iterator iter;
        boolean[] evaled = new boolean[]{false};
        OpenIntToIExprHashMap<IExpr> fn1Map = new OpenIntToIExprHashMap<IExpr>();
        IInteger fn1Rest = Primality.countPrimes1021(p1Numer, p1Exp, fn1Map, setEvaled, evaled);
        IInteger fd2Rest = Primality.countPrimes1021(p2Denom, p2Exp.negate(), fn1Map, setEvaled, evaled);
        OpenIntToIExprHashMap<IExpr> fn2Map = new OpenIntToIExprHashMap<IExpr>();
        IInteger fn2Rest = Primality.countPrimes1021(p2Numer, p2Exp, fn2Map, setEvaled, evaled);
        IInteger fd1Rest = Primality.countPrimes1021(p1Denom, p1Exp.negate(), fn2Map, setEvaled, evaled);
        if (!evaled[0] && fn2Map.size() > 0) {
            iter = fn2Map.iterator();
            while (iter.hasNext()) {
                iter.advance();
                base = iter.key();
                IExpr exp1 = fn1Map.get(base);
                if (exp1 == null) continue;
                if (exp1.isAST()) {
                    evaled[0] = true;
                    break;
                }
                IExpr exp2 = fn2Map.get(base);
                if (exp2.isAST()) {
                    evaled[0] = true;
                    break;
                }
                if (!exp1.isInteger() || !exp2.isInteger()) continue;
                evaled[0] = true;
                break;
            }
        }
        if (evaled[0]) {
            if (fn2Map.size() > 0) {
                iter = fn2Map.iterator();
                while (iter.hasNext()) {
                    iter.advance();
                    base = iter.key();
                    Object exponent = iter.value();
                    IExpr exp = fn1Map.get(base);
                    if (exp == null) {
                        fn1Map.put(base, (IExpr)exponent);
                        continue;
                    }
                    fn1Map.put(base, exp.add((IExpr)exponent));
                }
            }
            IASTAppendable times1 = F.TimesAlloc(fn1Map.size() + 4);
            if (!fn1Rest.isOne()) {
                times1.append(F.Power((IExpr)fn1Rest, p1Exp));
            }
            if (!fd2Rest.isOne()) {
                times1.append(F.Power((IExpr)fd2Rest, p2Exp.negate()));
            }
            if (!fn2Rest.isOne()) {
                times1.append(F.Power((IExpr)fn2Rest, p2Exp));
            }
            if (!fd1Rest.isOne()) {
                times1.append(F.Power((IExpr)fd1Rest, p1Exp.negate()));
            }
            if (fn1Map.size() > 0) {
                OpenIntToIExprHashMap.Iterator iter2 = fn1Map.iterator();
                while (iter2.hasNext()) {
                    iter2.advance();
                    int base2 = iter2.key();
                    Object exponent = iter2.value();
                    if (base2 == 1) continue;
                    times1.append(F.Power((IExpr)F.ZZ(base2), F.evalExpand(exponent)));
                }
            }
            return times1;
        }
        return F.NIL;
    }

    public static IAST piecewiseExpand(IAST function, IBuiltInSymbol domain) {
        IExpr a1;
        IExpr x2;
        EvalEngine engine = EvalEngine.get();
        if (function.isPlus()) {
            IAST piecewise;
            int[] piecewiseDimension;
            int piecewisePosition = function.indexOf(x -> x.isPiecewise() != null);
            if (piecewisePosition > 0 && (piecewiseDimension = (piecewise = (IAST)function.get(piecewisePosition)).isPiecewise())[0] > 0 && piecewiseDimension[1] == 2) {
                IAST piecewiseList = (IAST)piecewise.arg1();
                IExpr rest = function.removeAtCopy(piecewisePosition).oneIdentity1();
                IASTAppendable result = F.ListAlloc(piecewiseList.size());
                for (int i = 1; i < piecewiseList.size(); ++i) {
                    IAST subList = (IAST)piecewiseList.get(i);
                    result.append(F.list(F.Plus(rest, subList.arg1()), subList.arg2()));
                }
                if (piecewise.argSize() == 2) {
                    return F.Piecewise(result, S.Plus.of(engine, rest, piecewise.arg2()));
                }
                return F.Piecewise(result);
            }
            return F.NIL;
        }
        if (function.isTimes()) {
            IAST piecewise;
            int[] piecewiseDimension;
            int piecewisePosition = function.indexOf(x -> x.isPiecewise() != null);
            if (piecewisePosition > 0 && (piecewiseDimension = (piecewise = (IAST)function.get(piecewisePosition)).isPiecewise())[0] > 0 && piecewiseDimension[1] == 2) {
                IAST piecewiseList = (IAST)piecewise.arg1();
                IExpr rest = function.removeAtCopy(piecewisePosition).oneIdentity1();
                IASTAppendable result = F.ListAlloc(piecewiseList.size());
                for (int i = 1; i < piecewiseList.size(); ++i) {
                    IAST subList = (IAST)piecewiseList.get(i);
                    result.append(F.list(F.Times(rest, subList.arg1()), subList.arg2()));
                }
                if (piecewise.argSize() == 2) {
                    return F.Piecewise(result, S.Times.of(engine, rest, piecewise.arg2()));
                }
                return F.Piecewise(result);
            }
            return F.NIL;
        }
        if (function.argSize() == 1) {
            x2 = function.arg1();
            if (domain.equals(S.Reals) || function.arg1().isRealResult()) {
                if (function.isAST(S.Abs) || function.isAST(S.RealAbs)) {
                    return F.Piecewise(F.list(F.list(F.Negate(x2), F.Less(x2, F.C0))), x2);
                }
                if (function.isAST(S.Arg)) {
                    return F.Piecewise(F.list(F.list(S.Pi, F.Less(x2, F.C0))), F.C0);
                }
                if (function.isAST(S.Sign) || function.isAST(S.RealSign)) {
                    return F.Piecewise(F.list(F.list(F.CN1, F.Less(x2, F.C0)), F.list(F.C1, F.Greater(x2, F.C0))), F.C0);
                }
            }
            if (function.isAST(S.Boole)) {
                return F.Piecewise(F.list(F.list(F.C1, x2)), F.C0);
            }
        }
        if (function.isAST(S.BernsteinBasis, 4)) {
            IExpr d = function.arg1();
            IExpr n = function.arg2();
            IExpr x3 = function.arg3();
            return F.Piecewise(F.list(F.list(F.C1, F.Or((IExpr)F.And((IExpr)F.Equal(d, (IExpr)F.C0), (IExpr)F.Equal(n, (IExpr)F.C0)), (IExpr)F.And((IExpr)F.GreaterEqual(d, F.C0), (IExpr)F.Equal(n, (IExpr)F.C0), (IExpr)F.Equal(x3, (IExpr)F.C0)), (IExpr)F.And((IExpr)F.Greater(d, F.C0), (IExpr)F.Equal(x3, (IExpr)F.C1), (IExpr)F.Equal((IExpr)F.Subtract(d, n), (IExpr)F.C0)))), F.list(F.Times((IExpr)F.Power((IExpr)F.Subtract(F.C1, x3), F.Subtract(d, n)), (IExpr)F.Power(x3, n), (IExpr)F.Binomial(d, n)), F.And(F.Greater(d, F.C0), F.GreaterEqual(n, F.C0), F.GreaterEqual((IExpr)F.Subtract(d, n), F.C0), F.Less(F.C0, x3, F.C1)))), F.C0);
        }
        if (function.isAST(S.RealAbs, 2)) {
            return F.Piecewise(F.list(F.list(F.Negate(S.x), F.Less((IExpr)S.x, F.C0))), S.x);
        }
        if (function.isAST(S.RealSign, 2)) {
            return F.Piecewise(F.list(F.list(F.CN1, F.Less((IExpr)S.x, F.C0)), F.list(F.C1, F.Greater((IExpr)S.x, F.C0))), F.C0);
        }
        if (function.isAST(S.Clip, 2)) {
            x2 = function.arg1();
            return F.Piecewise(F.list(F.list(F.CN1, F.Less(x2, F.CN1)), F.list(F.C1, F.Greater(x2, F.C1))), x2);
        }
        if (function.isAST(S.Clip, 3) && function.second().isList2()) {
            x2 = function.arg1();
            IExpr low = function.second().first();
            IExpr high = function.second().second();
            return F.Piecewise(F.list(F.list(low, F.Less(x2, low)), F.list(high, F.Greater(x2, high))), x2);
        }
        if (function.isAST(S.If, 3)) {
            a1 = function.arg1();
            IExpr a2 = function.arg2();
            return F.Piecewise(F.list(F.list(a2, a1), F.C0));
        }
        if (function.isAST(S.If, 4)) {
            a1 = function.arg1();
            IExpr a2 = function.arg2();
            IExpr a3 = function.arg3();
            return F.Piecewise(F.list(F.list(a2, a1)), a3);
        }
        if (function.isAST(S.Ramp, 2)) {
            x2 = function.arg1();
            return F.Piecewise(F.list(F.list(x2, F.GreaterEqual(x2, F.C0))), F.C0);
        }
        if (function.isAST(S.UnitStep) && function.size() > 1) {
            int size = function.size();
            IASTAppendable andAST = F.ast((IExpr)S.And, size);
            for (int i = 1; i < size; ++i) {
                andAST.append(F.GreaterEqual(function.get(i), F.C0));
            }
            return F.Piecewise(F.list(F.list(F.C1, andAST)), F.C0);
        }
        if (function.size() > 1) {
            IASTAppendable andAST;
            if (function.isAST(S.DiscreteDelta)) {
                if (function.size() == 2) {
                    return F.Piecewise(F.list(F.list(F.C1, F.Equal(function.arg1(), (IExpr)F.C0))), F.C0);
                }
                andAST = F.ast((IExpr)S.And, function.argSize());
                function.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)x -> andAST.append(F.Equal(x, (IExpr)F.C0))));
                return F.Piecewise(F.list(F.list(F.C1, andAST)), F.C0);
            }
            if (function.isAST(S.KroneckerDelta)) {
                if (function.size() == 2) {
                    return F.Piecewise(F.list(F.list(F.C1, F.Equal(function.arg1(), (IExpr)F.C0))), F.C0);
                }
                andAST = F.ast((IExpr)S.And, function.argSize() - 1);
                IExpr last = function.arg1();
                for (int i = 2; i < function.size(); ++i) {
                    IExpr arg = function.get(i);
                    andAST.append(F.Equal((IExpr)F.Subtract(last, arg), (IExpr)F.C0));
                    last = arg;
                }
                return F.Piecewise(F.list(F.list(F.C1, andAST)), F.C0);
            }
        }
        return F.NIL;
    }

    public static IExpr rationalPower(IInteger p1Numer, IInteger p1Denom, IRational p1Exp) {
        boolean[] evaled = new boolean[]{false};
        OpenIntToIExprHashMap<IExpr> fn1Map = new OpenIntToIExprHashMap<IExpr>();
        IInteger fn1Rest = Primality.countPrimes1021(p1Numer, (IExpr)p1Exp, fn1Map, true, evaled);
        IInteger fd1Rest = Primality.countPrimes1021(p1Denom, (IExpr)p1Exp.negate(), fn1Map, true, evaled);
        if (evaled[0]) {
            IASTAppendable times1 = F.TimesAlloc(fn1Map.size() + 4);
            if (!fn1Rest.isOne()) {
                times1.append(F.Power((IExpr)fn1Rest, p1Exp));
            }
            if (!fd1Rest.isOne()) {
                times1.append(F.Power((IExpr)fd1Rest, p1Exp.negate()));
            }
            OpenIntToIExprHashMap.Iterator iter = fn1Map.iterator();
            while (iter.hasNext()) {
                iter.advance();
                int base = iter.key();
                Object exponent = iter.value();
                if (base == 1) continue;
                times1.append(F.Power((IExpr)F.ZZ(base), exponent));
            }
            return times1;
        }
        return F.NIL;
    }

    public static org.hipparchus.complex.Complex lanczosApproxGamma(org.hipparchus.complex.Complex z) {
        if (z.getReal() < 0.5) {
            return Arithmetic.lanczosApproxGamma(z.negate().add(1.0)).multiply(z.multiply(Math.PI).sin()).reciprocal().multiply(Math.PI);
        }
        z = z.subtract(1.0);
        org.hipparchus.complex.Complex x = pComplex[0];
        for (int i = 1; i < g + 2; ++i) {
            x = x.add(pComplex[i].divide(z.add((double)i)));
        }
        org.hipparchus.complex.Complex t = z.add((double)g).add(0.5);
        return t.pow(z.add(0.5)).multiply(t.negate().exp()).multiply(x).multiply(Math.sqrt(Math.PI * 2));
    }

    public static void initialize() {
        Initializer.init();
    }

    private Arithmetic() {
    }

    private static class TimesBy
    extends AddTo {
        private TimesBy() {
        }

        @Override
        protected IASTMutable getAST(IExpr value) {
            return F.Times(null, value);
        }

        @Override
        protected ISymbol getFunctionSymbol() {
            return S.TimesBy;
        }

        @Override
        protected ISymbol getArithmeticSymbol() {
            return S.Times;
        }
    }

    public static class Times
    extends AbstractArgMultiple
    implements INumeric {
        public static final Times CONST = new Times();
        private static HashedOrderlessMatcherTimes TIMES_ORDERLESS_MATCHER;

        @Override
        public HashedOrderlessMatcher getHashRuleMap() {
            return TIMES_ORDERLESS_MATCHER;
        }

        private static IExpr eInfinity(IAST inf, IExpr o1) {
            if (inf.isComplexInfinity()) {
                if (o1.isZero()) {
                    return S.Indeterminate;
                }
                return F.CComplexInfinity;
            }
            if (inf.isInfinity()) {
                if (o1.isInfinity()) {
                    return F.CInfinity;
                }
                if (o1.isNegativeInfinity()) {
                    return F.CNInfinity;
                }
                if (o1.isComplexInfinity()) {
                    return F.CComplexInfinity;
                }
                if (!o1.isZero()) {
                    if (o1.isNegativeResult()) {
                        return F.CNInfinity;
                    }
                    if (o1.isPositiveResult()) {
                        return F.CInfinity;
                    }
                }
            }
            if (inf.isNegativeInfinity()) {
                if (o1.isInfinity()) {
                    return F.CNInfinity;
                }
                if (o1.isNegativeInfinity()) {
                    return F.CInfinity;
                }
                if (o1.isComplexInfinity()) {
                    return F.CComplexInfinity;
                }
                if (!o1.isZero()) {
                    if (o1.isNegativeResult()) {
                        return F.CInfinity;
                    }
                    if (o1.isPositiveResult()) {
                        return F.CNInfinity;
                    }
                }
            }
            if (inf.isAST1()) {
                if (o1.isNumber() && inf.isAST1()) {
                    return DirectedInfinity.timesInf(inf, o1);
                }
                if (o1.isDirectedInfinity() && o1.isAST1()) {
                    return F.eval(F.DirectedInfinity(F.Times(inf.first(), o1.first())));
                }
            }
            return F.NIL;
        }

        private static IExpr distributeLeadingFactor(IExpr noEvalExpression, IAST originalExpr) {
            IExpr expr = noEvalExpression;
            if (!expr.isPresent()) {
                expr = originalExpr;
            }
            if (expr.isTimes() && expr.first().isInteger()) {
                IAST times = (IAST)expr;
                IInteger leadingFactor = (IInteger)times.arg1();
                if (leadingFactor.isMinusOne()) {
                    return Times.distributeLeadingFactorCN1(noEvalExpression, times);
                }
                return Times.distributeLeadingFactorModulus(noEvalExpression, times, leadingFactor);
            }
            return noEvalExpression;
        }

        private static IExpr distributeLeadingFactorModulus(IExpr noEvalExpression, IAST times, IInteger leadingFactor) {
            boolean negative = false;
            if (leadingFactor.isNegative()) {
                leadingFactor = leadingFactor.negate();
                negative = true;
            }
            IASTAppendable result = F.NIL;
            for (int i = 2; i < times.size(); ++i) {
                IInteger powArg1;
                IExpr arg = times.get(i);
                if (!arg.isPower() || !arg.base().isInteger() || arg.exponent().isNumber() || !(powArg1 = (IInteger)arg.base()).isPositive()) continue;
                IInteger mod = F.C0;
                int count = 0;
                while (!leadingFactor.isZero() && (mod = leadingFactor.mod(powArg1)).isZero()) {
                    ++count;
                    leadingFactor = leadingFactor.div(powArg1);
                }
                if (count <= 0) continue;
                if (!result.isPresent()) {
                    result = times.copyAppendable();
                }
                result.set(i, F.Power(arg.base(), F.Plus((IExpr)F.ZZ(count), arg.exponent())));
            }
            if (result.isPresent()) {
                if (negative) {
                    leadingFactor = leadingFactor.negate();
                }
                result.set(1, leadingFactor);
                if (leadingFactor.isMinusOne()) {
                    return Times.distributeLeadingFactorCN1(result, result);
                }
                return result;
            }
            return noEvalExpression;
        }

        private static IExpr distributeLeadingFactorCN1(IExpr noEvalExpr, IAST times) {
            IASTAppendable result = F.NIL;
            for (int i = 2; i < times.size(); ++i) {
                IAST plus;
                IExpr arg = times.get(i);
                if (!arg.isPlus() || !AbstractFunctionEvaluator.isNegativeWeighted(plus = (IAST)arg, true)) continue;
                IExpr temp = EvalEngine.get().evaluate(plus.mapThread(F.binaryAST2((IExpr)F.Times, F.CN1, (IExpr)F.Slot1), 2));
                result = times.copyAppendable();
                result.set(i, temp);
                result.remove(1);
                return result;
            }
            return noEvalExpr;
        }

        @Override
        public IExpr e2ComArg(IComplex c0, IComplex c1) {
            return c0.multiply(c1);
        }

        @Override
        public IExpr e2DblArg(INum d0, INum d1) {
            return d0.multiply(d1);
        }

        @Override
        public IExpr e2DblComArg(IComplexNum d0, IComplexNum d1) {
            return d0.multiply(d1);
        }

        @Override
        public IExpr e2FraArg(IFraction f0, IFraction f1) {
            return f0.mul(f1);
        }

        @Override
        public IExpr e2IntArg(IInteger i0, IInteger i1) {
            return i0.multiply(i1);
        }

        @Override
        public IExpr e2ObjArg(IAST ast, IExpr arg1, IExpr arg2) {
            if (arg1.isReal() || arg2.isReal()) {
                if (arg1.isZero()) {
                    if (arg2.isQuantity()) {
                        return ((IQuantity)arg2).ofUnit(F.C0);
                    }
                    if (arg2.isDirectedInfinity()) {
                        IOFunctions.printMessage(S.Infinity, "indet", F.list(F.Times(arg1, arg2)), EvalEngine.get());
                        return S.Indeterminate;
                    }
                    return F.C0;
                }
                if (arg2.isZero()) {
                    if (arg1.isQuantity()) {
                        return ((IQuantity)arg1).ofUnit(F.C0);
                    }
                    if (arg1.isDirectedInfinity()) {
                        IOFunctions.printMessage(S.Infinity, "indet", F.list(F.Times(arg1, arg2)), EvalEngine.get());
                        return S.Indeterminate;
                    }
                    return F.C0;
                }
                if (arg1.isOne()) {
                    return arg2;
                }
                if (arg2.isOne()) {
                    return arg1;
                }
            }
            if (arg1.isNumber() && arg2.isNumber()) {
                return F.NIL;
            }
            if (arg1.isSymbol() || arg2.isSymbol()) {
                if (arg1 == arg2) {
                    return F.Power(arg1, F.C2);
                }
                if (arg1.isSymbol() ? arg2.isAtom() : arg2.isSymbol() && arg1.isAtom()) {
                    return F.NIL;
                }
            }
            if (arg1.isInterval()) {
                if (arg2.isInterval()) {
                    return IntervalSym.times((IAST)arg1, (IAST)arg2);
                }
                if (arg2.isRealResult()) {
                    return IntervalSym.times(arg2, (IAST)arg1);
                }
                return F.NIL;
            }
            if (arg2.isInterval()) {
                if (arg1.isRealResult()) {
                    return IntervalSym.times(arg1, (IAST)arg2);
                }
                return F.NIL;
            }
            if (arg1.equals(arg2)) {
                return F.Power(arg1, F.C2);
            }
            if (arg1.isQuantity()) {
                IQuantity q = (IQuantity)arg1;
                return q.times(arg2, true);
            }
            if (arg2.isQuantity()) {
                IQuantity q = (IQuantity)arg2;
                return q.times(arg1, true);
            }
            if (arg1.isAST() || arg2.isAST()) {
                IExpr temp;
                int arg1Ordinal = arg1.headID();
                int arg2Ordinal = arg2.headID();
                if (arg1Ordinal < 0 && arg2Ordinal < 0) {
                    return F.NIL;
                }
                if (arg1Ordinal == 355 && arg1.isDirectedInfinity() ? (temp = Times.eInfinity((IAST)arg1, arg2)).isPresent() : arg2Ordinal == 355 && arg2.isDirectedInfinity() && (temp = Times.eInfinity((IAST)arg2, arg1)).isPresent()) {
                    return temp;
                }
                switch (arg1Ordinal) {
                    case 1036: {
                        IExpr power1Exponent;
                        IExpr power1Base;
                        IExpr temp2;
                        if (arg1.size() != 3) break;
                        IExpr power0Base = arg1.base();
                        IExpr power0Exponent = arg1.exponent();
                        if (arg1.equalsAt(1, arg2) && (power0Exponent.isNumber() && !arg2.isRational() || !power0Exponent.isNumber())) {
                            return F.Power(arg2, power0Exponent.inc());
                        }
                        if (!arg2.isPower() || !(temp2 = Arithmetic.timesPowerPower(power0Base, power0Exponent, power1Base = arg2.base(), power1Exponent = arg2.exponent())).isPresent()) break;
                        return temp2;
                    }
                }
                switch (arg2Ordinal) {
                    case 1014: {
                        if (!arg1.isFraction() || !arg1.isNegative() || !arg2.isPlus()) break;
                        return F.Times(arg1.negate(), arg2.negate());
                    }
                    case 1036: {
                        IExpr power1Exponent;
                        IExpr power1Base;
                        IExpr temp3;
                        if (arg2.size() != 3 || !(temp3 = this.timesArgPower(arg1, power1Base = arg2.base(), power1Exponent = arg2.exponent())).isPresent()) break;
                        return temp3;
                    }
                    case 799: {
                        IFraction f;
                        if (!arg1.isNegative() || !arg2.isLog() || !arg2.first().isFraction() || !arg1.isReal() || !(f = (IFraction)arg2.first()).isPositive() || !f.isLT(F.C1)) break;
                        return arg1.negate().times(F.Log(f.inverse()));
                    }
                    case 677: {
                        if (!arg2.isInterval()) break;
                        if (arg1.isInterval()) {
                            return IntervalSym.times((IAST)arg1, (IAST)arg2);
                        }
                        return IntervalSym.times(arg1, (IAST)arg2);
                    }
                    case 1176: {
                        if (!(arg2 instanceof ASTSeriesData)) break;
                        return ((ASTSeriesData)arg2).times(arg1);
                    }
                }
            }
            return F.NIL;
        }

        @Override
        public IExpr eComIntArg(IComplex c0, IInteger i1) {
            return c0.multiply(F.complex(i1, F.C0));
        }

        private IExpr evalNumericMode(IAST ast) {
            INum number = F.CD1;
            int start = -1;
            for (int i = 1; i < ast.size(); ++i) {
                IExpr arg = ast.get(i);
                if (arg instanceof INum) {
                    if (arg instanceof ApfloatNum) {
                        number = number.multiply((INum)arg);
                        continue;
                    }
                    if (number instanceof ApfloatNum) {
                        number = number.multiply(((INum)arg).apfloatNumValue());
                        continue;
                    }
                    number = number.multiply((INum)arg);
                    continue;
                }
                if (arg instanceof IComplexNum) {
                    start = i;
                    break;
                }
                return F.NIL;
            }
            if (start < 0) {
                return number;
            }
            IComplexNum complexNumber = number instanceof Num ? F.complexNum(((Num)number).doubleValue()) : F.complexNum(number.apfloatValue());
            for (int i = start; i < ast.size(); ++i) {
                IExpr arg = ast.get(i);
                if (arg instanceof INum) {
                    number = (INum)arg;
                    if (number instanceof Num) {
                        complexNumber = complexNumber.multiply(F.complexNum(((Num)number).doubleValue()));
                        continue;
                    }
                    complexNumber = complexNumber.multiply(F.complexNum(number.apfloatValue()));
                    continue;
                }
                if (arg instanceof IComplexNum) {
                    if (complexNumber instanceof ApcomplexNum) {
                        complexNumber = complexNumber.multiply(((IComplexNum)arg).apcomplexNumValue());
                        continue;
                    }
                    complexNumber = complexNumber.multiply((IComplexNum)arg);
                    continue;
                }
                return F.NIL;
            }
            return complexNumber;
        }

        @Override
        public double evalReal(double[] stack, int top, int size) {
            double result = 1.0;
            for (int i = top - size + 1; i < top + 1; ++i) {
                result *= stack[i];
            }
            return result;
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IAST temp;
            int size = ast.size();
            if (size == 1) {
                if (ast.head() == S.Times) {
                    return F.C1;
                }
                return F.NIL;
            }
            IExpr arg1 = ast.arg1();
            if (size == 2) {
                if (ast.head() == S.Times) {
                    return arg1;
                }
                return F.NIL;
            }
            if (size > 2 && (temp = this.evaluateHashsRepeated(ast, engine)).isPresent()) {
                return temp.oneIdentity1();
            }
            if (ast.isEvalFlagOn(65536) && (temp = engine.evalArgsOrderlessN(ast)).isPresent()) {
                ast = temp;
            }
            if (size == 3) {
                IExpr arg2;
                if ((arg1.isOne() || arg1.isMinusOne()) && ast.arg2().isPlus()) {
                    if (arg1.isOne()) {
                        return ast.arg2();
                    }
                    arg2 = (IAST)ast.arg2();
                    return arg2.mapThread(F.Times(arg1, (IExpr)F.Slot1), 2);
                }
                arg2 = ast.arg2();
                IExpr temp2 = Times.distributeLeadingFactor(this.binaryOperator(ast, arg1, arg2, engine), ast);
                if (temp2.isPresent()) {
                    return temp2;
                }
                return this.binaryOperator(ast, arg1, arg2, engine);
            }
            if (size > 3) {
                ISymbol sym = ast.topHead();
                IASTAppendable result = F.NIL;
                IExpr tempArg1 = arg1;
                boolean evaled = false;
                int i = 2;
                boolean isIASTAppendable = false;
                IAST astTimes = ast;
                while (i < astTimes.size()) {
                    IExpr binaryResult = this.binaryOperator(astTimes, tempArg1, astTimes.get(i), engine);
                    if (!binaryResult.isPresent()) {
                        for (int j = i + 1; j < astTimes.size(); ++j) {
                            binaryResult = this.binaryOperator(astTimes, tempArg1, astTimes.get(j), engine);
                            if (!binaryResult.isPresent()) continue;
                            evaled = true;
                            tempArg1 = binaryResult;
                            if (isIASTAppendable) {
                                ((IASTAppendable)astTimes).remove(j);
                                break;
                            }
                            astTimes = astTimes.splice(j);
                            isIASTAppendable = true;
                            break;
                        }
                        if (binaryResult.isPresent()) continue;
                        if (!result.isPresent()) {
                            result = F.ast((IExpr)sym, astTimes.size() - i + 1);
                        }
                        result.append(tempArg1);
                        if (i == astTimes.argSize()) {
                            result.append(astTimes.get(i));
                        } else {
                            tempArg1 = astTimes.get(i);
                        }
                        ++i;
                        continue;
                    }
                    evaled = true;
                    tempArg1 = binaryResult;
                    if (i == astTimes.argSize()) {
                        if (!result.isPresent()) {
                            result = F.ast((IExpr)sym, astTimes.size() - i + 1);
                        }
                        result.append(tempArg1);
                    }
                    ++i;
                }
                if (evaled && result.isPresent()) {
                    if (sym.hasOneIdentityAttribute() && result.size() > 1) {
                        return result.oneIdentity0();
                    }
                    return Times.distributeLeadingFactor(result, F.NIL);
                }
                return Times.distributeLeadingFactor(F.NIL, astTimes);
            }
            if (engine.isSymbolicMode(S.Times.getAttributes())) {
                ast.addEvalFlags(262144);
            }
            return F.NIL;
        }

        @Override
        public IExpr numericEval(IAST ast, EvalEngine engine) {
            IExpr temp = this.evalNumericMode(ast);
            if (temp.isPresent()) {
                return temp;
            }
            return this.evaluate(ast, engine);
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1549);
            TIMES_ORDERLESS_MATCHER = Times.initTimesHashMatcher();
            super.setUp(newSymbol);
        }

        private static HashedOrderlessMatcherTimes initTimesHashMatcher() {
            HashedOrderlessMatcherTimes timesMatcher = new HashedOrderlessMatcherTimes();
            timesMatcher.defineHashRule(new HashedPatternRulesLog(F.Log(F.x_), F.Log(F.y_)));
            timesMatcher.defineHashRule(new HashedPatternRulesTimes((IExpr)F.Sin(F.x_), (IExpr)F.Cot(F.x_), F.Cos(S.x)));
            timesMatcher.defineHashRule(new HashedPatternRulesTimes((IExpr)F.Sin(F.x_), (IExpr)F.Csc(F.x_), F.C1));
            timesMatcher.defineHashRule(new HashedPatternRulesTimes((IExpr)F.Tan(F.x_), (IExpr)F.Cot(F.x_), F.C1));
            timesMatcher.defineHashRule(new HashedPatternRulesTimes((IExpr)F.Cos(F.x_), (IExpr)F.Sec(F.x_), F.C1));
            timesMatcher.defineHashRule(new HashedPatternRulesTimes((IExpr)F.Cos(F.x_), (IExpr)F.Tan(F.x_), F.Sin(S.x)));
            timesMatcher.defineHashRule(new HashedPatternRulesTimes((IExpr)F.Csc(F.x_), (IExpr)F.Tan(F.x_), F.Sec(S.x)));
            timesMatcher.defineHashRule(new HashedPatternRulesTimesPower((IExpr)F.Power((IExpr)F.Csc(F.x_), F.m_), (IExpr)F.Power((IExpr)F.Cot(F.x_), F.n_DEFAULT), F.Condition(F.Times((IExpr)F.Power((IExpr)F.Csc(S.x), F.Plus((IExpr)S.m, (IExpr)S.n)), (IExpr)F.Power((IExpr)F.Cos(S.x), S.n)), F.And((IExpr)F.Not(F.NumberQ(S.m)), (IExpr)F.IntegerQ(S.n), (IExpr)F.Greater((IExpr)S.n, F.C0)))));
            timesMatcher.defineHashRule(new HashedPatternRulesTimesPower((IExpr)F.Power((IExpr)F.Sec(F.x_), F.m_), (IExpr)F.Power((IExpr)F.Tan(F.x_), F.n_DEFAULT), F.Condition(F.Times((IExpr)F.Power((IExpr)F.Sec(S.x), F.Plus((IExpr)S.m, (IExpr)S.n)), (IExpr)F.Power((IExpr)F.Sin(S.x), S.n)), F.And((IExpr)F.Not(F.NumberQ(S.m)), (IExpr)F.IntegerQ(S.n), (IExpr)F.Greater((IExpr)S.n, F.C0)))));
            timesMatcher.defineHashRule(new HashedPatternRulesTimesPower((IExpr)F.Power((IExpr)F.Csch(F.x_), F.m_), (IExpr)F.Power((IExpr)F.Coth(F.x_), F.n_DEFAULT), F.Condition(F.Times((IExpr)F.Power((IExpr)F.Csch(S.x), F.Plus((IExpr)S.m, (IExpr)S.n)), (IExpr)F.Power((IExpr)F.Cosh(S.x), S.n)), F.And((IExpr)F.Not(F.NumberQ(S.m)), (IExpr)F.IntegerQ(S.n), (IExpr)F.Greater((IExpr)S.n, F.C0)))));
            timesMatcher.defineHashRule(new HashedPatternRulesTimesPower((IExpr)F.Power((IExpr)F.Sech(F.x_), F.m_), (IExpr)F.Power((IExpr)F.Tanh(F.x_), F.n_DEFAULT), F.Condition(F.Times((IExpr)F.Power((IExpr)F.Sech(S.x), F.Plus((IExpr)S.m, (IExpr)S.n)), (IExpr)F.Power((IExpr)F.Sinh(S.x), S.n)), F.And((IExpr)F.Not(F.NumberQ(S.m)), (IExpr)F.IntegerQ(S.n), (IExpr)F.Greater((IExpr)S.n, F.C0)))));
            timesMatcher.defineHashRule(new HashedPatternRulesTimesPower((IExpr)F.ProductLog(F.x_), (IExpr)F.Power((IExpr)S.E, F.ProductLog(F.x_)), S.x));
            timesMatcher.defineHashRule(new HashedPatternRulesTimes((IExpr)F.Gamma(F.x_), (IExpr)F.Gamma(F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.x_))), F.Times((IExpr)S.Pi, (IExpr)F.Csc(F.Times((IExpr)S.x, (IExpr)S.Pi)))));
            timesMatcher.defineHashRule(new HashedPatternRulesTimesPower((IExpr)F.Power((IExpr)F.Sin(F.x_), F.C2), (IExpr)F.Power((IExpr)F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Power((IExpr)F.Cos(F.x_), F.C2))), F.CN1), F.C1));
            timesMatcher.defineHashRule(new HashedPatternRulesTimesPower((IExpr)F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Power((IExpr)F.Cos(F.x_), F.C2))), (IExpr)F.Power((IExpr)F.Sin(F.x_), F.CN2), F.C1));
            timesMatcher.defineHashRule(new HashedPatternRulesTimesPower((IExpr)F.Power((IExpr)F.Cos(F.x_), F.C2), (IExpr)F.Power((IExpr)F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Power((IExpr)F.Sin(F.x_), F.C2))), F.CN1), F.C1));
            timesMatcher.defineHashRule(new HashedPatternRulesTimesPower((IExpr)F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Power((IExpr)F.Sin(F.x_), F.C2))), (IExpr)F.Power((IExpr)F.Cos(F.x_), F.CN2), F.C1));
            timesMatcher.defineHashRule(new HashedPatternRulesTimesPower((IExpr)F.Power((IExpr)F.Sech(F.x_), F.C2), (IExpr)F.Power((IExpr)F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Power((IExpr)F.Tanh(F.x_), F.C2))), F.CN1), F.C1));
            timesMatcher.defineHashRule(new HashedPatternRulesTimesPower((IExpr)F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Power((IExpr)F.Tanh(F.x_), F.C2))), (IExpr)F.Power((IExpr)F.Sech(F.x_), F.CN2), F.C1));
            timesMatcher.defineHashRule(new HashedPatternRulesTimesPower((IExpr)F.Power((IExpr)F.Tanh(F.x_), F.C2), (IExpr)F.Power((IExpr)F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Power((IExpr)F.Sech(F.x_), F.C2))), F.CN1), F.C1));
            timesMatcher.defineHashRule(new HashedPatternRulesTimesPower((IExpr)F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.CN1, (IExpr)F.Power((IExpr)F.Sech(F.x_), F.C2))), (IExpr)F.Power((IExpr)F.Tanh(F.x_), F.CN2), F.C1));
            timesMatcher.defineHashRule(new HashedPatternRulesTimesPower((IExpr)F.Cos(F.Times((IExpr)F.C2, (IExpr)F.x_)), (IExpr)F.Power((IExpr)F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.CN2, (IExpr)F.Power((IExpr)F.Sin(F.x_), F.C2))), F.CN1), F.C1));
            timesMatcher.defineHashRule(new HashedPatternRulesTimesPower((IExpr)F.Plus((IExpr)F.C1, (IExpr)F.Times((IExpr)F.CN2, (IExpr)F.Power((IExpr)F.Sin(F.x_), F.C2))), (IExpr)F.Power((IExpr)F.Cos(F.Times((IExpr)F.C2, (IExpr)F.x_)), F.CN1), F.C1));
            timesMatcher.defineHashRule(new HashedPatternRulesTimesPower((IExpr)F.Cos(F.Times((IExpr)F.C2, (IExpr)F.x_)), (IExpr)F.Power((IExpr)F.Plus((IExpr)F.CN1, (IExpr)F.Times((IExpr)F.C2, (IExpr)F.Power((IExpr)F.Cos(F.x_), F.C2))), F.CN1), F.C1));
            timesMatcher.defineHashRule(new HashedPatternRulesTimesPower((IExpr)F.Plus((IExpr)F.CN1, (IExpr)F.Times((IExpr)F.C2, (IExpr)F.Power((IExpr)F.Cos(F.x_), F.C2))), (IExpr)F.Power((IExpr)F.Cos(F.Times((IExpr)F.C2, (IExpr)F.x_)), F.CN1), F.C1));
            timesMatcher.defineHashRule(new HashedPatternRulesTimesPower((IExpr)F.Power((IExpr)F.Sec(F.x_), F.C2), (IExpr)F.Power((IExpr)F.Plus((IExpr)F.C1, (IExpr)F.Power((IExpr)F.Tan(F.x_), F.C2)), F.CN1), F.C1));
            timesMatcher.defineHashRule(new HashedPatternRulesTimesPower((IExpr)F.Plus((IExpr)F.C1, (IExpr)F.Power((IExpr)F.Tan(F.x_), F.C2)), (IExpr)F.Power((IExpr)F.Sec(F.x_), F.CN2), F.C1));
            timesMatcher.defineHashRule(new HashedPatternRulesTimesPower((IExpr)F.Power((IExpr)F.Csc(F.x_), F.C2), (IExpr)F.Power((IExpr)F.Plus((IExpr)F.C1, (IExpr)F.Power((IExpr)F.Cot(F.x_), F.C2)), F.CN1), F.C1));
            timesMatcher.defineHashRule(new HashedPatternRulesTimesPower((IExpr)F.Plus((IExpr)F.C1, (IExpr)F.Power((IExpr)F.Cot(F.x_), F.C2)), (IExpr)F.Power((IExpr)F.Csc(F.x_), F.CN2), F.C1));
            timesMatcher.defineHashRule(new HashedPatternRulesTimes((IExpr)F.Sin(F.x_), (IExpr)F.Sec(F.x_), F.Tan(S.x)));
            timesMatcher.defineHashRule(new HashedPatternRulesTimes((IExpr)F.Cos(F.x_), (IExpr)F.Csc(F.x_), F.Cot(S.x)));
            timesMatcher.defineHashRule(new HashedPatternRulesTimes((IExpr)F.Cosh(F.x_), (IExpr)F.Tanh(F.x_), F.Sinh(S.x)));
            timesMatcher.defineHashRule(new HashedPatternRulesTimes((IExpr)F.Coth(F.x_), (IExpr)F.Sinh(F.x_), F.Cosh(S.x)));
            timesMatcher.defineHashRule(new HashedPatternRulesTimes((IExpr)F.Csch(F.x_), (IExpr)F.Tanh(F.x_), F.Sech(S.x)));
            timesMatcher.defineHashRule(new HashedPatternRulesTimes((IExpr)F.Coth(F.x_), (IExpr)F.Sech(F.x_), F.Csch(S.x)));
            timesMatcher.defineHashRule(new HashedPatternRulesTimes((IExpr)F.Sech(F.x_), (IExpr)F.Sinh(F.x_), F.Tanh(S.x)));
            timesMatcher.defineHashRule(new HashedPatternRulesTimes((IExpr)F.Sech(F.x_), (IExpr)F.Cosh(F.x_), F.C1));
            timesMatcher.defineHashRule(new HashedPatternRulesTimes((IExpr)F.Csch(F.x_), (IExpr)F.Sinh(F.x_), F.C1));
            timesMatcher.defineHashRule(new HashedPatternRulesTimes((IExpr)F.Cosh(F.x_), (IExpr)F.Csch(F.x_), F.Coth(S.x)));
            timesMatcher.defineHashRule(new HashedPatternRulesTimes((IExpr)F.Coth(F.x_), (IExpr)F.Tanh(F.x_), F.C1));
            return timesMatcher;
        }

        private IExpr timesArgPower(IExpr arg1, IExpr base2, IExpr exponent2) {
            if (arg1.isNumber() && base2.isRational() && exponent2.isFraction()) {
                IExpr temp;
                IComplex complex1;
                IRational complex1Im;
                IRational rat;
                if (arg1.isExactNumber() && exponent2.isNegative() && (rat = ((INumber)arg1).rationalFactor()) != null && base2.equals(rat.numerator())) {
                    if (rat.isNegative()) {
                        rat = rat.negate();
                    }
                    IExpr factor = ((INumber)arg1).divide(rat.numerator());
                    return F.Times(factor, (IExpr)F.Power((IExpr)rat.numerator(), F.C1.add((IRational)exponent2)));
                }
                if (base2.isMinusOne()) {
                    if (arg1.isImaginaryUnit()) {
                        return F.Power((IExpr)F.CN1, exponent2.plus(F.C1D2));
                    }
                    if (arg1.isNegativeImaginaryUnit()) {
                        return F.Times((IExpr)F.CN1, (IExpr)F.Power((IExpr)F.CN1, exponent2.plus(F.C1D2)));
                    }
                }
                if (arg1.isRational()) {
                    IExpr temp2 = this.timesRationalPower((IRational)arg1, base2, exponent2);
                    if (temp2.isPresent()) {
                        return temp2;
                    }
                } else if (arg1.isComplex() && ((IComplex)arg1).getRealPart().isZero() && !(complex1Im = (complex1 = (IComplex)arg1).getImaginaryPart()).isOne() && !complex1Im.isMinusOne() && (temp = this.timesRationalPower(complex1Im, base2, exponent2)).isPresent()) {
                    return F.Times((IExpr)F.CI, temp);
                }
            }
            if (arg1.equals(base2)) {
                if (exponent2.isNumber() && !arg1.isRational()) {
                    return F.Power(arg1, exponent2.inc());
                }
                if (!exponent2.isNumber()) {
                    return F.Power(arg1, exponent2.inc());
                }
            } else if (arg1.negate().equals(base2) && base2.isPositive()) {
                if (exponent2.isNumber() && !arg1.isRational()) {
                    return F.Negate(F.Power(base2, exponent2.inc()));
                }
                if (!exponent2.isNumber()) {
                    return F.Negate(F.Power(base2, exponent2.inc()));
                }
            } else if (arg1.isFraction() && base2.isFraction() && base2.isPositive()) {
                IExpr inverse = base2.inverse();
                IExpr o1negExpr = AbstractFunctionEvaluator.getPowerNegativeExpression(exponent2, true);
                if (o1negExpr.isPresent()) {
                    if (arg1.equals(inverse)) {
                        return F.Power(base2, F.Plus((IExpr)F.CN1, exponent2));
                    }
                    if (arg1.negate().equals(inverse)) {
                        return F.Negate(F.Power(base2, F.Plus((IExpr)F.CN1, exponent2)));
                    }
                } else {
                    if (arg1.equals(inverse)) {
                        return F.Power(inverse, F.Subtract(F.C1, exponent2));
                    }
                    if (arg1.negate().equals(inverse)) {
                        return F.Negate(F.Power(inverse, F.Subtract(F.C1, exponent2)));
                    }
                }
            }
            if (arg1.isRational() && !exponent2.isNumber()) {
                return Arithmetic.timesPowerPower(arg1, F.C1, base2, exponent2);
            }
            return F.NIL;
        }

        private IExpr timesRationalPower(IRational rationalArg1, IExpr base2, IExpr exponent2) {
            EvalEngine engine = EvalEngine.get();
            if (engine.isTogetherMode()) {
                return F.NIL;
            }
            if (exponent2.isNegative()) {
                IExpr temp = Arithmetic.timesPowerPower(rationalArg1.numerator(), rationalArg1.denominator(), F.C1, ((IRational)base2).denominator(), ((IRational)base2).numerator(), exponent2.negate(), false);
                if (temp.isPresent()) {
                    return temp;
                }
            } else {
                IExpr temp = Arithmetic.timesPowerPower(rationalArg1.numerator(), rationalArg1.denominator(), F.C1, ((IRational)base2).numerator(), ((IRational)base2).denominator(), exponent2, false);
                if (temp.isPresent()) {
                    return temp;
                }
            }
            return F.NIL;
        }
    }

    private static class Subtract
    extends AbstractFunctionEvaluator {
        private Subtract() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.Subtract(ast.arg1(), ast.arg2());
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1632);
        }
    }

    private static class SubtractFrom
    extends AddTo {
        private SubtractFrom() {
        }

        @Override
        protected IASTMutable getAST(IExpr value) {
            return (IASTMutable)F.Plus(null, F.Negate(value));
        }

        @Override
        protected ISymbol getFunctionSymbol() {
            return S.SubtractFrom;
        }

        @Override
        protected ISymbol getArithmeticSymbol() {
            return S.Subtract;
        }
    }

    private static class Surd
    extends AbstractArg2
    implements INumeric {
        private Surd() {
        }

        @Override
        public IExpr e2ApfloatArg(ApfloatNum af0, ApfloatNum af1) {
            if (af1.isZero()) {
                EvalEngine ee = EvalEngine.get();
                LOGGER.log(ee.getLogLevel(), "Surd(a,b) division by zero");
                return S.Indeterminate;
            }
            if (af0.isNegative()) {
                return af0.abs().pow(af1.inverse()).negate();
            }
            return af0.pow(af1.inverse());
        }

        @Override
        public IExpr e2DblArg(INum d0, INum d1) {
            double r;
            double val = d0.doubleValue();
            double result = Surd.doubleSurd(val, r = d1.doubleValue());
            if (Double.isNaN(result)) {
                return S.Indeterminate;
            }
            return F.num(result);
        }

        @Override
        public IExpr e2ObjArg(IAST ast, IExpr base, IExpr root) {
            if (base.isNumber() && root.isInteger()) {
                EvalEngine engine = EvalEngine.get();
                if (base.isComplex() || base.isComplexNumeric()) {
                    LOGGER.log(engine.getLogLevel(), "Surd(a,b) - \"a\" should be a real value.");
                    return F.NIL;
                }
                if (root.isZero()) {
                    LOGGER.log(engine.getLogLevel(), "Surd(a,b) division by zero");
                    return S.Indeterminate;
                }
                if (base.isNegative()) {
                    if (((IInteger)root).isEven()) {
                        IOFunctions.printMessage(ast.topHead(), "nonegs", F.CEmptyList, engine);
                        return S.Indeterminate;
                    }
                    return F.Times((IExpr)F.CN1, (IExpr)F.Power(base.negate(), ((IInteger)root).inverse()));
                }
                if (base.isMinusOne()) {
                    return F.CN1;
                }
                return F.Power(base, ((IInteger)root).inverse());
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(17920);
            super.setUp(newSymbol);
        }

        @Override
        public double evalReal(double[] stack, int top, int size) {
            if (size != 2) {
                throw new UnsupportedOperationException();
            }
            return Surd.doubleSurd(stack[top - 1], stack[top]);
        }

        private static double doubleSurd(double val, double r) {
            if (r == 0.0) {
                EvalEngine ee = EvalEngine.get();
                LOGGER.log(ee.getLogLevel(), "Surd(a,b) division by zero");
                return Double.NaN;
            }
            if (val < 0.0) {
                double root = Math.floor(r);
                if (Double.isFinite(r) && Double.compare(r, root) == 0) {
                    int iRoot = (int)root;
                    if ((iRoot & 1) == 0) {
                        Level level = EvalEngine.get().getLogLevel();
                        LOGGER.log(level, "Surd(a,b) - undefined for negative \"a\" and even \"b\" values");
                        return Double.NaN;
                    }
                    return -Math.pow(Math.abs(val), 1.0 / r);
                }
                return Double.NaN;
            }
            return Math.pow(val, 1.0 / r);
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr base = ast.arg1();
            if (base.isComplex() || base.isComplexNumeric()) {
                return IOFunctions.printMessage(ast.topHead(), "preal", F.list(base), engine);
            }
            IExpr arg2 = engine.evaluateNonNumeric(ast.arg2());
            if (arg2.isZero()) {
                IOFunctions.printMessage(ast.topHead(), "indet", F.list(ast), engine);
                return S.Indeterminate;
            }
            if (arg2.isNumber()) {
                if (arg2.isInteger()) {
                    IInteger root = (IInteger)arg2;
                    if (base.isNegative() && root.isEven()) {
                        IOFunctions.printMessage(ast.topHead(), "nonegs", F.CEmptyList, engine);
                        return S.Indeterminate;
                    }
                    if (base.isInfinity()) {
                        if (root.isNegative()) {
                            return F.C0;
                        }
                        return F.CInfinity;
                    }
                    if (base.isNegativeInfinity()) {
                        if (root.isNegative()) {
                            return F.C0;
                        }
                        return F.CNInfinity;
                    }
                    if (root.isNegative()) {
                        if (root.isMinusOne()) {
                            return F.Power(base, F.CN1);
                        }
                        return F.Power((IExpr)F.Surd(base, root.negative()), F.CN1);
                    }
                } else {
                    return IOFunctions.printMessage(ast.topHead(), "int", F.list(ast, F.C2), EvalEngine.get());
                }
            }
            return this.binaryOperator(ast, ast.arg1(), ast.arg2(), engine);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }
    }

    private static class Sqrt
    extends AbstractArg1
    implements INumeric {
        private Sqrt() {
        }

        @Override
        public IExpr e1ObjArg(IExpr o) {
            return F.Power(o, F.C1D2);
        }

        @Override
        public double evalReal(double[] stack, int top, int size) {
            if (size != 1) {
                throw new UnsupportedOperationException();
            }
            return Math.sqrt(stack[top]);
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
        }
    }

    private static final class SignCmp
    extends AbstractEvaluator {
        private SignCmp() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            INumber number = arg1.evalNumber();
            if (number != null) {
                int signum = number.complexSign();
                return F.ZZ(signum);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
        }
    }

    private static final class Sign
    extends AbstractCoreFunctionEvaluator {
        private Sign() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr x;
            IExpr temp;
            IAST result = F.NIL;
            IExpr arg1 = engine.evaluateNIL(ast.arg1());
            if (arg1.isPresent()) {
                result = F.Sign(arg1);
            } else {
                arg1 = ast.arg1();
            }
            if (arg1.isList()) {
                return ((IAST)arg1).mapThread(F.Sign(F.Slot1), 1);
            }
            if (arg1.isNumber()) {
                if (arg1.isComplexNumeric()) {
                    IComplexNum c = (IComplexNum)arg1;
                    return c.divide(F.num(c.dabs()));
                }
                return Sign.numberSign((INumber)arg1);
            }
            if (arg1.isIndeterminate()) {
                return S.Indeterminate;
            }
            if (arg1.isDirectedInfinity()) {
                IAST directedInfininty = (IAST)arg1;
                if (directedInfininty.isComplexInfinity()) {
                    return S.Indeterminate;
                }
                if (directedInfininty.isAST1()) {
                    return F.Sign(directedInfininty.arg1());
                }
            } else if (arg1.isTimes()) {
                IASTAppendable[] res = ((IAST)arg1).filterNIL(new SignTimesFunction());
                if (res[0].size() > 1) {
                    if (res[1].size() > 1) {
                        res[0].append(F.Sign(res[1]));
                    }
                    return res[0];
                }
            } else if (arg1.isPower()) {
                if (arg1.exponent().isReal()) {
                    return F.Power((IExpr)F.Sign(arg1.base()), arg1.exponent());
                }
                if (arg1.base().isE()) {
                    return F.Power((IExpr)S.E, F.Times((IExpr)F.CI, F.Im(arg1.exponent())));
                }
            } else if (arg1.isAST(S.Sign, 2)) {
                return arg1;
            }
            if (AbstractAssumptions.assumeNegative(arg1)) {
                return F.CN1;
            }
            if (AbstractAssumptions.assumePositive(arg1)) {
                return F.C1;
            }
            IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
            if (negExpr.isPresent()) {
                return F.Times((IExpr)F.CN1, (IExpr)F.Sign(negExpr));
            }
            INumber number = arg1.evalNumber();
            if (number != null && (temp = Sign.numberSign(number)).isPresent()) {
                return temp;
            }
            if (arg1.isRealResult() && !arg1.isZero()) {
                return F.Divide(arg1, F.Abs(arg1));
            }
            IExpr y = AbstractFunctionEvaluator.imaginaryPart(arg1, true);
            if (y.isPresent() && y.isRealResult() && (x = AbstractFunctionEvaluator.realPart(arg1, false)).isPresent() && x.isRealResult()) {
                return F.Times((IExpr)F.Plus(x, (IExpr)F.Times((IExpr)F.CI, y)), (IExpr)F.Power((IExpr)F.Plus((IExpr)F.Sqr(x), (IExpr)F.Sqr(y)), F.CN1D2));
            }
            if (arg1.isInterval()) {
                if (arg1.size() == 2) {
                    IAST list = (IAST)arg1.first();
                    if (list.first().isNegativeResult() && list.second().isNegativeResult()) {
                        return F.CN1;
                    }
                    if (list.first().isPositiveResult() && list.second().isPositiveResult()) {
                        return F.C1;
                    }
                    if (list.first().isZero() && list.second().isZero()) {
                        return F.C0;
                    }
                }
                return IntervalSym.mapSymbol(S.Sign, (IAST)arg1);
            }
            return result;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        public static IExpr numberSign(INumber arg1) {
            if (arg1.isReal()) {
                int signum = ((ISignedNumber)arg1).complexSign();
                return F.ZZ(signum);
            }
            if (arg1.isComplex()) {
                IComplex c = (IComplex)arg1;
                return F.Times((IExpr)c, (IExpr)F.Power(c.abs(), F.CN1));
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
        }

        private static final class SignTimesFunction
        implements Function<IExpr, IExpr> {
            private SignTimesFunction() {
            }

            @Override
            public IExpr apply(IExpr expr) {
                if (expr.isNumber()) {
                    return Sign.numberSign((INumber)expr);
                }
                IExpr temp = F.eval(F.Sign(expr));
                if (!temp.topHead().equals(S.Sign)) {
                    return temp;
                }
                return F.NIL;
            }
        }
    }

    private static final class RealSign
    extends AbstractEvaluator {
        private RealSign() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isReal()) {
                return arg1.sign();
            }
            if (arg1.isNumericFunction(true)) {
                IExpr temp = engine.evalN(arg1);
                if (temp.isReal()) {
                    return temp.sign();
                }
                if (temp.isNumber()) {
                    return F.NIL;
                }
            }
            if (arg1.isInfinity()) {
                return F.C1;
            }
            if (arg1.isNegativeInfinity()) {
                return F.CN1;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
        }
    }

    private static final class RealAbs
    extends AbstractEvaluator {
        private RealAbs() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isInfinity() || arg1.isNegativeInfinity()) {
                return F.CInfinity;
            }
            if (arg1.isNumber()) {
                if (arg1.isReal()) {
                    return arg1.abs();
                }
                return F.NIL;
            }
            if (arg1.isNumericFunction(true)) {
                IExpr temp = engine.evalN(arg1);
                if (temp.isReal()) {
                    return temp.abs();
                }
                if (temp.isNumber()) {
                    return F.NIL;
                }
            }
            if (arg1.isNegativeResult()) {
                return F.Negate(arg1);
            }
            if (arg1.isNonNegativeResult()) {
                return arg1;
            }
            if (arg1.isSymbol()) {
                ISymbol sym = (ISymbol)arg1;
                return sym.mapConstantDouble(new AbsNumericFunction(sym));
            }
            if (arg1.isInterval()) {
                return IntervalSym.abs((IAST)arg1);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }

        private static final class AbsNumericFunction
        implements DoubleFunction<IExpr> {
            final ISymbol symbol;

            public AbsNumericFunction(ISymbol symbol) {
                this.symbol = symbol;
            }

            @Override
            public IExpr apply(double value) {
                double result;
                if (value < 2.147483647E9 && value > -2.147483648E9 && (result = Math.abs(value)) > 0.0) {
                    return this.symbol;
                }
                return F.NIL;
            }
        }
    }

    private static final class Re
    extends AbstractEvaluator {
        private Re() {
        }

        public static IExpr evalRe(IExpr expr, EvalEngine engine) {
            IExpr base;
            if (expr.isDirectedInfinity()) {
                IAST directedInfininty = (IAST)expr;
                if (directedInfininty.isComplexInfinity()) {
                    return S.Indeterminate;
                }
                if (directedInfininty.isAST1()) {
                    if (directedInfininty.isInfinity()) {
                        return F.CInfinity;
                    }
                    IExpr re = directedInfininty.arg1().re();
                    if (re.isNumber()) {
                        if (re.isZero()) {
                            return F.C0;
                        }
                        return F.Times((IExpr)F.Sign(re), (IExpr)F.CInfinity);
                    }
                }
            }
            if (expr.isNumber() || expr.isQuantity()) {
                return expr.re();
            }
            if (expr.isRealResult() || expr.isRealVector() || expr.isRealMatrix()) {
                return expr;
            }
            IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(expr);
            if (negExpr.isPresent()) {
                return F.Negate(F.Re(negExpr));
            }
            if (expr.isTimes()) {
                IAST timesAST = (IAST)expr;
                int position = timesAST.indexOf(x -> x.isRealResult());
                if (position > 0) {
                    return F.Times(timesAST.get(position), F.Re(timesAST.splice(position)));
                }
                IExpr first = timesAST.arg1();
                if (first.isNumber()) {
                    IExpr rest = timesAST.rest().oneIdentity1();
                    if (first.isReal()) {
                        return F.Times(first, F.Re(expr.rest()));
                    }
                    return F.Subtract(F.Times(first.re(), F.Re(rest)), F.Times(first.im(), F.Im(rest)));
                }
            }
            if (expr.isPlus()) {
                return ((IAST)expr).mapThread((IAST)F.Re(F.Slot1), 1);
            }
            if (expr.isPower() && (base = expr.base()).isRealResult()) {
                IExpr exponent = expr.exponent();
                return Re.rePowerComplex(base, exponent.re(), exponent.im());
            }
            if (expr.isInterval()) {
                return IntervalSym.mapSymbol(S.Re, (IAST)expr);
            }
            return F.NIL;
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            return Re.evalRe(arg1, engine);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        private static IExpr rePowerComplex(IExpr x, IExpr a, IExpr b) {
            if ((a.isNumber() || a.isRealResult()) && (b.isNumber() || b.isRealResult())) {
                if (x.isE()) {
                    return F.Times((IExpr)F.Power((IExpr)S.E, a), (IExpr)F.Cos(b));
                }
                return F.Times((IExpr)F.Times((IExpr)F.Power((IExpr)F.Power(x, F.C2), F.Times((IExpr)F.C1D2, a)), (IExpr)F.Power((IExpr)S.E, F.Times(F.Negate(b), (IExpr)F.Arg(x)))), (IExpr)F.Cos(F.Plus((IExpr)F.Times(a, (IExpr)F.Arg(x)), (IExpr)F.Times((IExpr)F.Times((IExpr)F.C1D2, b), (IExpr)F.Log(F.Power(x, F.C2))))));
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
        }
    }

    private static final class Rational
    extends AbstractCoreFunctionEvaluator {
        private Rational() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.head().equals(S.Rational)) {
                if (!ast.isAST2()) {
                    return IOFunctions.printArgMessage(ast, ARGS_2_2, engine);
                }
                try {
                    IExpr numeratorExpr = ast.arg1();
                    IExpr denominatorExpr = ast.arg2();
                    if (!numeratorExpr.isInteger() || !denominatorExpr.isInteger()) {
                        numeratorExpr = engine.evaluate(numeratorExpr);
                        denominatorExpr = engine.evaluate(denominatorExpr);
                        if (!numeratorExpr.isInteger() || !denominatorExpr.isInteger()) {
                            return F.NIL;
                        }
                    }
                    IInteger numerator = (IInteger)numeratorExpr;
                    IInteger denominator = (IInteger)denominatorExpr;
                    if (denominator.isZero()) {
                        LOGGER.log(engine.getLogLevel(), "Division by zero expression: {}/{}", (Object)numerator, (Object)denominator);
                        if (numerator.isZero()) {
                            return S.Indeterminate;
                        }
                        return F.CComplexInfinity;
                    }
                    if (numerator.isZero()) {
                        return F.C0;
                    }
                    return F.fraction(numerator, denominator);
                }
                catch (Exception e) {
                    LOGGER.debug("Rational.evaluate() failed", (Throwable)e);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static class PreIncrement
    extends PreDecrement {
        private PreIncrement() {
        }

        @Override
        protected IASTMutable getAST() {
            return (IASTMutable)F.Plus(null, (IExpr)F.C1);
        }

        @Override
        protected ISymbol getFunctionSymbol() {
            return S.PreIncrement;
        }
    }

    private static class PreDecrement
    extends Decrement {
        private PreDecrement() {
        }

        @Override
        protected IASTMutable getAST() {
            return (IASTMutable)F.Plus(null, (IExpr)F.CN1);
        }

        @Override
        protected IExpr getResult(IExpr symbolValue, IExpr calculatedResult) {
            return calculatedResult;
        }

        @Override
        protected ISymbol getFunctionSymbol() {
            return S.PreDecrement;
        }
    }

    private static final class Precision
    extends AbstractCoreFunctionEvaluator {
        private Precision() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = engine.evaluate(ast.arg1());
            if (arg1 instanceof INum) {
                return F.ZZ(((INum)arg1).precision());
            }
            if (arg1 instanceof IComplexNum) {
                return F.ZZ(((IComplexNum)arg1).precision());
            }
            LOGGER.log(engine.getLogLevel(), "Precision: Numeric expression expected");
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    public static class Power
    extends AbstractFunctionEvaluator
    implements INumeric,
    PowerRules {
        public static IExpr binaryOperator(IAST ast, IExpr base, IExpr exponent, EvalEngine engine) {
            try {
                IExpr temp;
                IExpr result;
                if (base.isInexactNumber() && exponent.isInexactNumber() && (result = Power.e2NumericArg(ast, base, exponent)).isPresent()) {
                    return result;
                }
                if (exponent.isDirectedInfinity() && (temp = Power.evalDirectedInfinityArg2(base, (IAST)exponent)).isPresent()) {
                    return temp;
                }
                if (base.isDirectedInfinity() && (temp = Power.evalDirectedInfinityArg1((IAST)base, exponent)).isPresent()) {
                    return temp;
                }
                if (base.isZero()) {
                    if (exponent.isInterval()) {
                        return IntervalSym.power(base, (IAST)exponent);
                    }
                    return Power.powerZeroArg1(exponent);
                }
                if (base.isQuantity()) {
                    try {
                        IQuantity q = (IQuantity)base;
                        return q.power(exponent);
                    }
                    catch (MathException mex) {
                        return F.NIL;
                    }
                }
                if (base.isAST()) {
                    if (base.isInterval()) {
                        if (exponent.isInteger()) {
                            return IntervalSym.power((IAST)base, (IInteger)exponent);
                        }
                        if (exponent.isReal()) {
                            return IntervalSym.power((IAST)base, (ISignedNumber)exponent);
                        }
                    } else if (base instanceof ASTSeriesData) {
                        int exp = exponent.toIntDefault();
                        if (exp != Integer.MIN_VALUE) {
                            return ((ASTSeriesData)base).powerSeries(exp);
                        }
                        return F.NIL;
                    }
                }
                if (exponent.isInterval() && base.isRealResult()) {
                    return IntervalSym.power(base, (IAST)exponent);
                }
                if (exponent.isReal()) {
                    if (exponent.isZero()) {
                        return base.isInfinity() || base.isNegativeInfinity() ? S.Indeterminate : F.C1;
                    }
                    if (exponent.isOne()) {
                        return base;
                    }
                    if (exponent.isInteger()) {
                        if (base.isInteger()) {
                            return Power.integerInteger((IInteger)base, (IInteger)exponent);
                        }
                        if (base instanceof IFraction) {
                            return Power.fractionInteger((IFraction)base, (IInteger)exponent);
                        }
                        if (base instanceof IComplex) {
                            return Power.complexInteger((IComplex)base, (IInteger)exponent);
                        }
                        if (base.isAtom()) {
                            return F.NIL;
                        }
                    }
                }
                if (base.isOne()) {
                    return F.C1;
                }
                if (base.isMinusOne()) {
                    if (exponent.isEvenResult()) {
                        return F.C1;
                    }
                    if (exponent.isIntegerResult()) {
                        if (exponent.isPlus() && exponent.first().isInteger()) {
                            IInteger arg1Plus = (IInteger)exponent.first();
                            if (!arg1Plus.isOne()) {
                                IInteger factor;
                                IInteger iInteger = factor = ((IInteger)exponent.first()).isEven() ? F.C1 : F.CN1;
                                if (factor.isMinusOne()) {
                                    return F.Power((IExpr)F.CN1, F.Plus(1L, exponent.rest().oneIdentity1()));
                                }
                                return F.Times((IExpr)factor, (IExpr)F.Power((IExpr)F.CN1, exponent.rest().oneIdentity1()));
                            }
                        } else if (exponent.isTimes() && exponent.first().isInteger()) {
                            IInteger arg1Times = (IInteger)exponent.first();
                            return F.Power((IExpr)F.Power((IExpr)F.CN1, arg1Times), exponent.rest().oneIdentity1());
                        }
                    }
                }
                if ((result = Power.e2ObjArg(ast, base, exponent)).isPresent()) {
                    return result;
                }
                if (base instanceof IInteger) {
                    if (exponent instanceof IFraction) {
                        return Power.fractionFraction(F.fraction((IInteger)base, F.C1), (IFraction)exponent);
                    }
                    if (exponent instanceof IComplex) {
                        return Power.complexComplex(F.complex((IInteger)base, F.C0), (IComplex)exponent);
                    }
                    return F.NIL;
                }
                if (base instanceof IFraction) {
                    if (exponent instanceof IFraction) {
                        return Power.fractionFraction((IFraction)base, (IFraction)exponent);
                    }
                    if (exponent instanceof IComplex) {
                        return Power.complexComplex(F.complex((IFraction)base), (IComplex)exponent);
                    }
                    return F.NIL;
                }
                if (base instanceof IComplex) {
                    if (exponent instanceof IFraction) {
                        return Power.complexFraction((IComplex)base, (IFraction)exponent);
                    }
                    if (exponent instanceof IComplex) {
                        return Power.complexComplex((IComplex)base, (IComplex)exponent);
                    }
                }
            }
            catch (LossOfPrecisionException | BackingStorageException lpe) {
                return IOFunctions.printMessage(S.General, "zzapfloatcld", F.List(), EvalEngine.get());
            }
            catch (ArithmeticException | InfiniteExpansionException | OverflowException aex) {
                return IOFunctions.printMessage(S.General, "ovfl", F.List(), EvalEngine.get());
            }
            if (engine.isSymbolicMode(S.Power.getAttributes())) {
                ast.addEvalFlags(262144);
            }
            return F.NIL;
        }

        public static IExpr powerSurd(IExpr surdAST, IExpr exponent) {
            IExpr surdArg1 = surdAST.first();
            IExpr surdArg2 = surdAST.second();
            if (surdArg2.isInteger() && exponent.isInteger()) {
                IInteger surdExponent = (IInteger)surdArg2;
                IInteger powExponent = (IInteger)exponent;
                boolean negativeExponent = false;
                if (surdExponent.isPositive() && surdExponent.isOdd()) {
                    if (powExponent.isNegative()) {
                        powExponent = powExponent.negate();
                        negativeExponent = true;
                    }
                    if (powExponent.isGT(surdExponent)) {
                        IInteger iquo = powExponent.iquo(surdExponent);
                        IInteger irem = powExponent.irem(surdExponent);
                        if (negativeExponent) {
                            return F.Times((IExpr)F.Power(surdArg1, iquo.negate()), (IExpr)F.Power(surdAST, irem.negate()));
                        }
                        return F.Times((IExpr)F.Power(surdArg1, iquo), (IExpr)F.Power(surdAST, irem));
                    }
                }
            }
            return F.NIL;
        }

        private static IExpr e2NumericArg(IAST ast, IExpr o0, IExpr o1) {
            IExpr result = F.NIL;
            if (o0 instanceof ApcomplexNum) {
                if (o1.isNumber()) {
                    result = Power.e2ApcomplexArg((ApcomplexNum)o0, ((INumber)o1).apcomplexNumValue());
                }
            } else if (o1 instanceof ApcomplexNum) {
                if (o0.isNumber()) {
                    result = Power.e2ApcomplexArg(((INumber)o0).apcomplexNumValue(), (ApcomplexNum)o1);
                }
            } else if (o0 instanceof ComplexNum) {
                if (o1.isNumber()) {
                    result = Power.e2DblComArg((ComplexNum)o0, ((INumber)o1).complexNumValue());
                }
            } else if (o1 instanceof ComplexNum && o0.isNumber()) {
                result = Power.e2DblComArg(((INumber)o0).complexNumValue(), (ComplexNum)o1);
            }
            if (o0 instanceof ApfloatNum) {
                if (o1.isReal()) {
                    result = Power.e2ApfloatArg((ApfloatNum)o0, ((ISignedNumber)o1).apfloatNumValue());
                }
            } else if (o1 instanceof ApfloatNum) {
                if (o0.isReal()) {
                    result = Power.e2ApfloatArg(((ISignedNumber)o0).apfloatNumValue(), (ApfloatNum)o1);
                }
            } else if (o0 instanceof Num) {
                if (o1.isReal()) {
                    result = Power.e2DblArg((Num)o0, ((ISignedNumber)o1).numValue());
                }
            } else if (o1 instanceof Num && o0.isReal()) {
                result = Power.e2DblArg(((ISignedNumber)o0).numValue(), (Num)o1);
            }
            if (result.isPresent()) {
                return result;
            }
            return Power.e2ObjArg(ast, o0, o1);
        }

        private static IExpr e2ApcomplexArg(ApcomplexNum base, ApcomplexNum exponent) {
            return base.pow(exponent);
        }

        private static IExpr e2ApfloatArg(ApfloatNum base, ApfloatNum exponent) {
            if (base.isZero()) {
                if (exponent.isNegative()) {
                    IOFunctions.printMessage(S.Power, "infy", F.list(F.Power((IExpr)F.C0, exponent)), EvalEngine.get());
                    return F.CComplexInfinity;
                }
                if (exponent.isZero()) {
                    IOFunctions.printMessage(S.Power, "indet", F.list(F.Power((IExpr)F.C0, F.C0)), EvalEngine.get());
                    return S.Indeterminate;
                }
            }
            if (exponent.isMinusOne()) {
                return base.inverse();
            }
            if (exponent.isNumIntValue()) {
                return base.pow(exponent);
            }
            if (base.isNegative()) {
                ApcomplexNum b = base.apcomplexNumValue();
                ApcomplexNum e = exponent.apcomplexNumValue();
                return b.pow(e);
            }
            return base.pow(exponent);
        }

        private static IExpr complexComplex(IComplex base, IComplex exponent) {
            if (base.getImaginaryPart().isZero()) {
                IRational a = base.getRealPart();
                IRational b = exponent.getRealPart();
                IRational c = exponent.getImaginaryPart();
                IAST temp = F.Plus((IExpr)F.Times((IExpr)b, (IExpr)F.Arg(a)), (IExpr)F.Times((IExpr)F.C1D2, (IExpr)c, (IExpr)F.Log(F.Sqr(a))));
                return F.Times((IExpr)F.Power((IExpr)F.Sqr(a), F.Times((IExpr)F.C1D2, (IExpr)b)), (IExpr)F.Exp(F.Times((IExpr)F.CN1, (IExpr)c, (IExpr)F.Arg(a))), (IExpr)F.Plus((IExpr)F.Cos(temp), (IExpr)F.Times((IExpr)F.CI, (IExpr)F.Sin(temp))));
            }
            return F.NIL;
        }

        private static IExpr e2DblArg(INum base, INum exponent) {
            if (base.isZero()) {
                if (exponent.isNegative()) {
                    IOFunctions.printMessage(S.Power, "infy", F.list(F.Power((IExpr)F.C0, exponent)), EvalEngine.get());
                    return F.CComplexInfinity;
                }
                if (exponent.isZero()) {
                    IOFunctions.printMessage(S.Power, "indet", F.list(F.Power((IExpr)F.C0, F.C0)), EvalEngine.get());
                    return S.Indeterminate;
                }
            }
            if (exponent.isMinusOne()) {
                return base.inverse();
            }
            if (exponent.isNumIntValue()) {
                return base.pow(exponent);
            }
            if (base.isNegative()) {
                return F.complexNum(base.doubleValue()).pow(F.complexNum(exponent.doubleValue()));
            }
            return base.pow(exponent);
        }

        private static IExpr e2DblComArg(IComplexNum base, IComplexNum exponent) {
            return base.pow(exponent);
        }

        private static IExpr fractionInteger(IFraction base, IInteger exponent) {
            if (base.numerator().isZero()) {
                return F.C0;
            }
            if (exponent.isZero()) {
                return F.C1;
            }
            IInteger exp = exponent.numerator();
            int expInt = exp.toIntDefault();
            if (expInt != Integer.MIN_VALUE) {
                return base.powerRational(expInt);
            }
            if (exp.isNegative()) {
                IInteger negExponent = exp.negate();
                return F.Rational(base.denominator().power(negExponent), base.numerator().power(negExponent));
            }
            return F.Rational(base.numerator().power(exp), base.denominator().power(exp));
        }

        private static IExpr fractionFraction(IFraction base, IFraction exponent) {
            IInteger baseNumerator = base.numerator();
            if (baseNumerator.isZero()) {
                return F.C0;
            }
            if (exponent.numerator().isZero()) {
                return F.C1;
            }
            IInteger baseDenominator = base.denominator();
            if (baseNumerator.isOne() && !baseDenominator.isOne()) {
                return F.Power((IExpr)baseDenominator, exponent.negate());
            }
            if (exponent.equals(F.CN1D2) && base.isNegative()) {
                return F.Times((IExpr)F.CNI, (IExpr)F.Power((IExpr)base.negate().inverse(), exponent.negate()));
            }
            IInteger exponentDenominator = exponent.denominator();
            if (exponent.isNegative() && !baseDenominator.isOne()) {
                return F.Power((IExpr)base.inverse(), exponent.negate());
            }
            if (exponentDenominator.isOne()) {
                return Power.fractionInteger(base, exponent.numerator());
            }
            IExpr temp = Arithmetic.rationalPower(baseNumerator, baseDenominator, exponent);
            if (temp.isPresent()) {
                return temp;
            }
            return F.NIL;
        }

        private static IExpr integerInteger(IInteger base, IInteger exponent) throws ArithmeticException {
            if (base.isMinusOne()) {
                return exponent.isEven() ? F.C1 : F.CN1;
            }
            if (base.isZero()) {
                return F.NIL;
            }
            long n = exponent.toLong();
            return base.power(n);
        }

        private static IExpr e2NumberDirectedInfinity(INumber arg1, IAST arg2) {
            int comp = arg1.compareAbsValueToOne();
            switch (comp) {
                case 1: {
                    if (arg2.isInfinity()) {
                        if (arg1.isReal() && arg1.isPositive()) {
                            return F.CInfinity;
                        }
                        return F.CComplexInfinity;
                    }
                    if (!arg2.isNegativeInfinity()) break;
                    return F.C0;
                }
                case -1: {
                    if (arg2.isInfinity()) {
                        return F.C0;
                    }
                    if (!arg2.isNegativeInfinity()) break;
                    if (arg1.isReal() && arg1.isPositive()) {
                        return F.CInfinity;
                    }
                    return F.CComplexInfinity;
                }
            }
            return F.NIL;
        }

        private static IExpr e2ObjArg(IAST ast, IExpr base, IExpr exponent) {
            if (base.isAST(S.Surd, 3)) {
                return Power.powerSurd(base, exponent);
            }
            if (base.isReal() || exponent.isReal()) {
                IExpr o1negExpr;
                if (exponent.isReal()) {
                    ISignedNumber realExponent = (ISignedNumber)exponent;
                    if (base.isPower() && Power.powerPowerRealExponent((IAST)base, realExponent)) {
                        return F.Power(base.base(), base.exponent().times(realExponent));
                    }
                    if (base.isInfinity()) {
                        if (realExponent.isNegative()) {
                            return F.C0;
                        }
                        return F.CInfinity;
                    }
                    if (base.isNegativeInfinity()) {
                        if (realExponent.isNegative()) {
                            return F.C0;
                        }
                        if (realExponent.isInteger()) {
                            IInteger ii = (IInteger)realExponent;
                            if (ii.isOdd()) {
                                return F.CNInfinity;
                            }
                            return F.CInfinity;
                        }
                        int exp = realExponent.toIntDefault();
                        if (exp != Integer.MIN_VALUE) {
                            if ((exp & 1) == 1) {
                                return F.CNInfinity;
                            }
                            return F.CInfinity;
                        }
                    }
                    if (exponent.isMinusOne() || exponent.isInteger()) {
                        if (base.isNumber()) {
                            if (exponent.isMinusOne()) {
                                return ((INumber)base).inverse();
                            }
                            try {
                                long n = ((IInteger)exponent).toLong();
                                return ((INumber)base).power(n);
                            }
                            catch (ArithmeticException n) {}
                        } else {
                            IExpr temp;
                            IExpr o1negExpr2 = F.NIL;
                            o1negExpr2 = exponent.isInteger() && ((IInteger)exponent).isEven() ? AbstractFunctionEvaluator.getPowerNegativeExpression(base, true) : AbstractFunctionEvaluator.getPowerNegativeExpression(base, false);
                            if (o1negExpr2.isPresent()) {
                                if (exponent.isMinusOne()) {
                                    return F.Times((IExpr)F.CN1, (IExpr)F.Power(o1negExpr2, F.CN1));
                                }
                                IInteger ii = (IInteger)exponent;
                                if (ii.isEven()) {
                                    return F.Power(o1negExpr2, exponent);
                                }
                            }
                            if (exponent.isMinusOne() && base.isTimes() && (temp = Power.powerTimesInverse((IAST)base, (ISignedNumber)exponent)).isPresent()) {
                                return temp;
                            }
                        }
                    }
                } else if (base.isFraction() && base.isPositive() && ((IFraction)base).isLT(F.C1) && (o1negExpr = AbstractFunctionEvaluator.getPowerNegativeExpression(exponent, true)).isPresent()) {
                    return F.Power(base.inverse(), o1negExpr);
                }
                if (base.isReal() && base.isNegative() && exponent.isNumEqualRational(F.C1D2)) {
                    return F.Times((IExpr)F.CI, (IExpr)F.Power(F.Negate(base), exponent));
                }
            }
            if (base.isDirectedInfinity() && !exponent.isReal()) {
                if (base.isInfinity()) {
                    if (exponent.isNegativeResult()) {
                        return F.C0;
                    }
                    if (exponent.isPositiveResult()) {
                        return F.CInfinity;
                    }
                }
                if (base.isNegativeInfinity() && exponent.isNegativeResult()) {
                    return F.C0;
                }
            }
            if (base.isE() && exponent.isPlusTimesPower()) {
                IAST times;
                IExpr i;
                IExpr expandedFunction = F.evalExpand(exponent);
                if (expandedFunction.isPlus()) {
                    return Power.powerEPlus((IAST)expandedFunction);
                }
                if (expandedFunction.isTimes() && (i = F.Times.of(times = (IAST)expandedFunction, F.CNI, F.Power((IExpr)S.Pi, F.CN1))).isRational()) {
                    IRational rat = (IRational)i;
                    if (rat.isGT(F.C1) || rat.isLE(F.CN1)) {
                        IInteger t = rat.trunc();
                        t = t.add(t.irem(F.C2));
                        return S.Exp.of(F.Times((IExpr)F.CI, (IExpr)S.Pi, (IExpr)F.Subtract(i, t)));
                    }
                    IRational t1 = rat.multiply(F.C6).normalize();
                    IRational t2 = rat.multiply(F.C4).normalize();
                    if (t1.isInteger() || t2.isInteger()) {
                        return S.Plus.of(F.Cos(F.Times((IExpr)F.CNI, (IExpr)times)), F.Times((IExpr)F.CI, (IExpr)F.Sin(F.Times((IExpr)F.CNI, (IExpr)times))));
                    }
                }
            }
            if (base.isAST()) {
                IAST powBase = (IAST)base;
                if (powBase.isTimes()) {
                    if (exponent.isInteger() || exponent.isMinusOne()) {
                        return powBase.mapThread(F.Power((IExpr)F.Slot1, exponent), 1);
                    }
                    if (base.first().isMinusOne() && exponent.isReal() && base.isRealResult()) {
                        return F.Times((IExpr)F.Power(base.first(), exponent), (IExpr)F.Power((IExpr)base.rest(), exponent));
                    }
                    if (base.size() > 2) {
                        IASTAppendable filterAST = powBase.copyHead();
                        IASTAppendable restAST = powBase.copyHead();
                        IASTAppendable simplifiedTimesArgs = powBase.copyHead();
                        powBase.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)x -> {
                            if (x.isRealResult()) {
                                if (x.isMinusOne()) {
                                    restAST.append((IExpr)x);
                                } else if (x.isNegativeResult()) {
                                    filterAST.append(x.negate());
                                    restAST.append(F.CN1);
                                } else {
                                    if (exponent.isReal() && x.isPower() && x.base().isNumber() && Power.powerPowerRealExponent((IAST)x, (ISignedNumber)exponent)) {
                                        simplifiedTimesArgs.append(F.Power(x.base(), x.exponent().times(exponent)));
                                        return;
                                    }
                                    filterAST.append((IExpr)x);
                                }
                            } else {
                                restAST.append((IExpr)x);
                            }
                        }));
                        IExpr temp = restAST.oneIdentity1();
                        if (simplifiedTimesArgs.size() > 1 || filterAST.size() > 1 && !temp.isNumber()) {
                            if (filterAST.size() > 1) {
                                simplifiedTimesArgs.append(F.Power((IExpr)filterAST, exponent));
                            }
                            if (restAST.size() > 1) {
                                simplifiedTimesArgs.append(F.Power(temp, exponent));
                            }
                            return simplifiedTimesArgs;
                        }
                    }
                } else if (base.isPower()) {
                    IExpr temp;
                    if (base.exponent().isReal() && exponent.isReal() && (temp = base.exponent().times(exponent)).isOne()) {
                        if (base.base().isNonNegativeResult()) {
                            return base.base();
                        }
                        if (base.base().isRealResult() && base.exponent().isEvenResult()) {
                            return F.Abs(base.base());
                        }
                    }
                    if (exponent.isInteger()) {
                        if (base.exponent().isNumber()) {
                            return F.Power(base.base(), exponent.times(base.exponent()));
                        }
                        return F.Power(base.base(), F.Times(exponent, base.exponent()));
                    }
                }
            }
            if (exponent.isFraction() && base.isRational()) {
                IInteger expMod;
                IInteger expDiv;
                IInteger expNumerator;
                if (((IFraction)exponent).isGT(F.C1)) {
                    expNumerator = ((IFraction)exponent).numerator();
                    IInteger expDenominator = ((IFraction)exponent).denominator();
                    expDiv = expNumerator.div(expDenominator);
                    expMod = expNumerator.mod(expDenominator);
                    return F.Times(base.power(expDiv), base.power(F.QQ(expMod, expDenominator)));
                }
                if (((IFraction)exponent).isLT(F.CN1)) {
                    expNumerator = ((IFraction)exponent).numerator().negate();
                    IInteger expDenominator = ((IFraction)exponent).denominator();
                    expDiv = expNumerator.div(expDenominator);
                    expMod = expNumerator.mod(expDenominator);
                    return F.Times((IExpr)F.Power(base.power(expDiv), F.CN1), (IExpr)F.Power(base.power(F.QQ(expMod, expDenominator)), F.CN1));
                }
                if (base.isNegative() && ((IFraction)exponent).isNegative()) {
                    return F.Times((IExpr)F.CN1, (IExpr)F.Power((IExpr)F.CN1, F.C1.add(exponent)), (IExpr)F.Power(base.negate(), exponent));
                }
                if (base.isRational() && !ast.isAllExpanded()) {
                    IRational num = (IRational)base;
                    IInteger expNumerator2 = ((IFraction)exponent).numerator();
                    IInteger expDenominator = ((IFraction)exponent).denominator();
                    int denominator = expDenominator.toIntDefault();
                    if (denominator > 1) {
                        IAST temp;
                        int numerator = 1;
                        if (!expNumerator2.isOne()) {
                            numerator = expNumerator2.toIntDefault();
                        }
                        if (numerator > 0 && (temp = num.factorSmallPrimes(numerator, denominator)).isPresent()) {
                            return temp;
                        }
                    }
                    if (ast.isPresent()) {
                        ast.addEvalFlags(8192);
                    }
                }
            }
            return F.NIL;
        }

        private static boolean powerPowerRealExponent(IAST powerAST, ISignedNumber exponent) {
            IExpr baseArg1 = powerAST.base();
            IExpr exponentArg1 = powerAST.exponent();
            if (exponentArg1.isReal() && baseArg1.isNonNegativeResult()) {
                return true;
            }
            if (exponent.isRational() && exponentArg1.isFraction() && exponentArg1.isRational()) {
                return true;
            }
            return exponent.isNumIntValue() && exponent.isPositive() && exponentArg1.isNumIntValue() && exponentArg1.isPositive();
        }

        private static IExpr evalDirectedInfinityArg1(IAST directedInfinity, IExpr exponent) {
            if (exponent.isZero()) {
                return S.Indeterminate;
            }
            if (directedInfinity.isComplexInfinity()) {
                if (exponent.isReal()) {
                    if (exponent.isNegative()) {
                        return F.C0;
                    }
                    return F.CComplexInfinity;
                }
                return S.Indeterminate;
            }
            if (exponent.isOne()) {
                return directedInfinity;
            }
            if (exponent.isMinusOne()) {
                return F.C0;
            }
            return F.NIL;
        }

        private static IExpr evalDirectedInfinityArg2(IExpr base, IAST directedInfinity) {
            if (directedInfinity.isComplexInfinity()) {
                return S.Indeterminate;
            }
            if (base.isOne() || base.isMinusOne() || base.isImaginaryUnit() || base.isNegativeImaginaryUnit()) {
                return S.Indeterminate;
            }
            if (base.isZero()) {
                if (directedInfinity.isInfinity()) {
                    return F.C0;
                }
                if (directedInfinity.isNegativeInfinity()) {
                    return F.CComplexInfinity;
                }
                return S.Indeterminate;
            }
            if (base.isInfinity()) {
                if (directedInfinity.isInfinity()) {
                    return F.CComplexInfinity;
                }
                if (directedInfinity.isNegativeInfinity()) {
                    return F.C0;
                }
                return S.Indeterminate;
            }
            if (base.isNegativeInfinity()) {
                if (directedInfinity.isInfinity()) {
                    return F.CComplexInfinity;
                }
                if (directedInfinity.isNegativeInfinity()) {
                    return F.C0;
                }
                return S.Indeterminate;
            }
            if (base.isComplexInfinity()) {
                if (directedInfinity.isInfinity()) {
                    return F.CComplexInfinity;
                }
                if (directedInfinity.isNegativeInfinity()) {
                    return F.C0;
                }
                return S.Indeterminate;
            }
            if (base.isDirectedInfinity()) {
                if (directedInfinity.isInfinity()) {
                    return F.CComplexInfinity;
                }
                if (directedInfinity.isNegativeInfinity()) {
                    return F.C0;
                }
                return S.Indeterminate;
            }
            if (base.isNumber()) {
                IExpr temp = Power.e2NumberDirectedInfinity((INumber)base, directedInfinity);
                if (temp.isPresent()) {
                    return temp;
                }
            } else {
                IExpr temp;
                IExpr a1 = F.evaln(base);
                if (a1.isNumber() && (temp = Power.e2NumberDirectedInfinity((INumber)a1, directedInfinity)).isPresent()) {
                    return temp;
                }
            }
            return F.NIL;
        }

        private static IExpr powerTimesInverse(IAST timesAST, ISignedNumber arg2) {
            IASTAppendable resultAST = F.NIL;
            for (int i = 1; i < timesAST.size(); ++i) {
                IExpr arg = timesAST.get(i);
                if (!arg.isPower() || !arg.exponent().isReal()) continue;
                if (!resultAST.isPresent()) {
                    resultAST = timesAST.copyAppendable();
                    resultAST.map((IASTMutable)resultAST, x -> F.Power(x, arg2));
                }
                if (arg.exponent().isMinusOne()) {
                    resultAST.set(i, arg.base());
                    continue;
                }
                resultAST.set(i, F.Power(arg.base(), arg.exponent().times(arg2)));
            }
            return resultAST;
        }

        private static IExpr powerZeroArg1(IExpr exponent) {
            EvalEngine engine = EvalEngine.get();
            if (exponent.isZeroResult()) {
                IOFunctions.printMessage(S.Power, "indet", F.list(F.Power((IExpr)F.C0, F.C0)), EvalEngine.get());
                return S.Indeterminate;
            }
            if (exponent.isPositiveResult()) {
                return F.C0;
            }
            if (exponent.isNegativeResult()) {
                IOFunctions.printMessage(S.Power, "infy", F.list(F.Power((IExpr)F.C0, exponent)), EvalEngine.get());
                return F.CComplexInfinity;
            }
            IExpr a = exponent.re();
            if (a.isReal()) {
                if (a.isNegative()) {
                    IOFunctions.printMessage(S.Power, "infy", F.list(F.Power((IExpr)F.C0, exponent)), EvalEngine.get());
                    return F.CComplexInfinity;
                }
                if (a.isZero()) {
                    IOFunctions.printMessage(S.Power, "indet", F.list(F.Power((IExpr)F.C0, F.C0)), EvalEngine.get());
                    return S.Indeterminate;
                }
                return F.C0;
            }
            if (a.isNumericFunction(true)) {
                IExpr temp = engine.evalN(a);
                if (temp.isReal()) {
                    if (temp.isNegative()) {
                        IOFunctions.printMessage(S.Power, "infy", F.list(F.Power((IExpr)F.C0, temp)), EvalEngine.get());
                        return F.CComplexInfinity;
                    }
                    if (temp.isZero()) {
                        IOFunctions.printMessage(S.Power, "indet", F.list(F.Power((IExpr)F.C0, F.C0)), EvalEngine.get());
                        return S.Indeterminate;
                    }
                    return F.C0;
                }
                if (temp.isComplex() || temp.isComplexNumeric()) {
                    IOFunctions.printMessage(S.Power, "indet", F.list(F.Power((IExpr)F.C0, temp)), EvalEngine.get());
                    return S.Indeterminate;
                }
            }
            return F.NIL;
        }

        private static IAST powerEPlus(IAST plus) {
            IASTAppendable multiplicationFactors = F.NIL;
            IASTAppendable plusClone = F.NIL;
            for (int i = plus.argSize(); i > 0; --i) {
                IExpr arg = plus.get(i);
                if (arg.isLog()) {
                    if (!multiplicationFactors.isPresent()) {
                        multiplicationFactors = F.TimesAlloc(8);
                        plusClone = plus.copyAppendable();
                    }
                    multiplicationFactors.append(arg.first());
                    plusClone.remove(i);
                    continue;
                }
                if (!arg.isTimes() || arg.size() != 3 || !arg.second().isLog() || !arg.first().isReal()) continue;
                IAST times = (IAST)arg;
                IExpr logArgument = times.arg2().first();
                if (!multiplicationFactors.isPresent()) {
                    multiplicationFactors = F.TimesAlloc(8);
                    plusClone = plus.copyAppendable();
                }
                multiplicationFactors.append(F.Power(logArgument, times.arg1()));
                plusClone.remove(i);
            }
            if (multiplicationFactors.isPresent()) {
                multiplicationFactors.append(F.Exp(plusClone));
                return multiplicationFactors;
            }
            return F.NIL;
        }

        private static IExpr complexFraction(IComplex base, IFraction exponent) {
            if (base.getRealPart().isZero()) {
                if (exponent.isNumEqualRational(F.C1D2)) {
                    IRational im = base.getImaginaryPart();
                    boolean negative = false;
                    if ((im = im.divideBy(F.C2)).isNegative()) {
                        im = im.negate();
                        negative = true;
                    }
                    if (NumberUtil.isPerfectSquare(im)) {
                        IAST temp = F.Sqrt(im);
                        if (negative) {
                            return F.Plus((IExpr)temp, (IExpr)F.Times((IExpr)F.CNI, (IExpr)temp));
                        }
                        return F.Plus((IExpr)temp, (IExpr)F.Times((IExpr)F.CI, (IExpr)temp));
                    }
                } else if (exponent.isNumEqualRational(F.CN1D2)) {
                    return F.Times((IExpr)F.CN1, (IExpr)F.Power((IExpr)F.CN1, F.C3D4));
                }
            }
            if (exponent.isPositive()) {
                IComplex sqrt;
                if (base.isImaginaryUnit()) {
                    return F.Power((IExpr)F.CN1, F.C1D2.times(exponent));
                }
                if (base.isNegativeImaginaryUnit()) {
                    IInteger denominator;
                    IInteger numerator = exponent.numerator();
                    IInteger div = numerator.div(denominator = exponent.denominator());
                    if (div.isOdd()) {
                        div = div.subtract(F.C1);
                    }
                    IRational rat = exponent.subtract(div);
                    numerator = rat.numerator();
                    denominator = rat.denominator().multiply(F.C2);
                    return F.Times((IExpr)F.CN1, (IExpr)F.Power((IExpr)F.CNI, div), (IExpr)F.Power((IExpr)F.CN1, F.fraction(denominator.subtract(numerator), denominator)));
                }
                if (exponent.equals(F.C1D2) && (sqrt = base.sqrtCC()) != null) {
                    return sqrt;
                }
            }
            return F.NIL;
        }

        private static IExpr complexInteger(IComplex base, IInteger exponent) {
            if (base.isZero()) {
                return F.C0;
            }
            if (exponent.isZero()) {
                return F.C1;
            }
            return base.pow(exponent.toBigNumerator().intValue());
        }

        @Override
        public double evalReal(double[] stack, int top, int size) {
            if (size != 2) {
                throw new UnsupportedOperationException();
            }
            return Math.pow(stack[top - 1], stack[top]);
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int size = ast.size();
            if (ast.head() == S.Power) {
                switch (size) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        return F.C1;
                    }
                    case 2: {
                        return ast.arg1();
                    }
                    case 3: {
                        return Power.binaryOperator(ast, ast.arg1(), ast.arg2(), engine);
                    }
                    default: {
                        return Power.powerFoldRight(ast, engine);
                    }
                }
            }
            return F.NIL;
        }

        private static IExpr powerFoldRight(IAST ast, EvalEngine engine) {
            IExpr last = ast.last();
            for (int i = ast.size() - 2; i >= 0; --i) {
                IExpr arg = ast.get(i);
                IExpr temp = F.Power.ofNIL(engine, arg, last);
                if (!temp.isPresent()) {
                    if (i <= 1) {
                        return F.Power(arg, last);
                    }
                    IASTAppendable result = ast.copyUntil(i);
                    result.append(F.Power(arg, last));
                    return result;
                }
                last = temp;
            }
            return last;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1537);
            super.setUp(newSymbol);
        }
    }

    private static final class Pochhammer
    extends AbstractArg2 {
        private Pochhammer() {
        }

        @Override
        public IExpr e2ObjArg(IAST ast, IExpr a, IExpr n) {
            IExpr temp;
            if (n.isZero()) {
                return F.C1;
            }
            if (n.isOne()) {
                return a;
            }
            int ni = n.toIntDefault();
            if (a.isRational() && ni > Integer.MIN_VALUE) {
                BigFraction bf = ((IRational)a).toBigFraction();
                return Pochhammer.pochhammer(bf, ni, ast);
            }
            if (a.isInteger() && a.isPositive() && (temp = EvalEngine.get().evaluate(F.Plus((IExpr)((IInteger)a).subtract(F.C1), n))).isSymbol()) {
                return F.Divide(F.Factorial(temp), F.Gamma(a));
            }
            if (n.isInteger() && ni > Integer.MIN_VALUE) {
                if (ni > Config.MAX_POLYNOMIAL_DEGREE) {
                    PolynomialDegreeLimitExceeded.throwIt(ni);
                }
                EvalEngine engine = EvalEngine.get();
                if (ni > 0) {
                    IAST product = F.product(k -> F.Plus(a, k), 0, ni - 1);
                    return engine.evaluate(product);
                }
                if (ni < 0) {
                    IExpr temp2 = F.Power((IExpr)F.product(k -> F.Plus(a, k.negate()), 1, -ni), -1L);
                    IExpr result = engine.evaluate(temp2);
                    return result;
                }
            }
            if (a.isNumber() && n.isNumber()) {
                return F.Divide(F.Gamma(F.Plus(a, n)), F.Gamma(a));
            }
            return F.NIL;
        }

        private static IExpr pochhammer(BigFraction that, int n, IAST ast) {
            if (n < 0) {
                int positiveN = -n;
                int iterationLimit = EvalEngine.get().getIterationLimit();
                if (iterationLimit >= 0 && iterationLimit <= positiveN) {
                    IterationLimitExceeded.throwIt(positiveN, ast);
                }
                BigFraction res = BigFraction.ONE;
                for (int i = -1; i >= n; --i) {
                    res = res.multiply(that.add(i));
                }
                if (res.equals((Object)BigFraction.ZERO)) {
                    return F.CComplexInfinity;
                }
                return F.fraction(res.reciprocal());
            }
            if (n == 0) {
                return F.C1;
            }
            if (that.equals((Object)BigFraction.ZERO)) {
                return F.C0;
            }
            int iterationLimit = EvalEngine.get().getIterationLimit();
            if (iterationLimit >= 0 && iterationLimit <= n) {
                IterationLimitExceeded.throwIt(n, ast);
            }
            BigFraction res = that;
            for (int i = 1; i < n; ++i) {
                res = res.multiply(that.add(i));
            }
            return F.fraction(res);
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
        }
    }

    public static class Plus
    extends AbstractArgMultiple
    implements INumeric {
        private static HashedOrderlessMatcherPlus PLUS_ORDERLESS_MATCHER;

        @Override
        public IExpr e2ComArg(IComplex c0, IComplex c1) {
            return c0.add(c1);
        }

        @Override
        public IExpr e2DblArg(INum d0, INum d1) {
            return d0.add(d1);
        }

        @Override
        public IExpr e2DblComArg(IComplexNum d0, IComplexNum d1) {
            return d0.add(d1);
        }

        @Override
        public IExpr e2FraArg(IFraction f0, IFraction f1) {
            return f0.add(f1);
        }

        @Override
        public IExpr e2IntArg(IInteger i0, IInteger i1) {
            return i0.add(i1);
        }

        @Override
        public IExpr eComIntArg(IComplex c0, IInteger i1) {
            return c0.add(F.complex(i1, F.C0));
        }

        private IExpr evalNumericMode(IAST ast) {
            INum number = F.CD0;
            int start = -1;
            for (int i = 1; i < ast.size(); ++i) {
                IExpr arg = ast.get(i);
                if (arg instanceof INum) {
                    if (arg instanceof ApfloatNum) {
                        number = number.add((INum)arg);
                        continue;
                    }
                    if (number instanceof ApfloatNum) {
                        number = number.add(((INum)arg).apfloatNumValue());
                        continue;
                    }
                    number = number.add((INum)arg);
                    continue;
                }
                if (arg instanceof IComplexNum) {
                    start = i;
                    break;
                }
                return F.NIL;
            }
            if (start < 0) {
                return number;
            }
            IComplexNum complexNumber = number instanceof Num ? F.complexNum(number.doubleValue()) : F.complexNum(number.apfloatValue());
            for (int i = start; i < ast.size(); ++i) {
                IExpr arg = ast.get(i);
                if (arg instanceof INum) {
                    number = (INum)arg;
                    if (number instanceof Num) {
                        complexNumber = complexNumber.add(F.complexNum(((Num)number).doubleValue()));
                        continue;
                    }
                    complexNumber = complexNumber.add(F.complexNum(number.apfloatValue()));
                    continue;
                }
                if (arg instanceof IComplexNum) {
                    if (complexNumber instanceof ApcomplexNum) {
                        complexNumber = complexNumber.add(((IComplexNum)arg).apcomplexNumValue());
                        continue;
                    }
                    complexNumber = complexNumber.add((IComplexNum)arg);
                    continue;
                }
                return F.NIL;
            }
            return complexNumber;
        }

        @Override
        public double evalReal(double[] stack, int top, int size) {
            double result = 0.0;
            for (int i = top - size + 1; i < top + 1; ++i) {
                result += stack[i];
            }
            return result;
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int size = ast.size();
            if (size > 2) {
                PlusOp plusOp;
                IExpr temp;
                IAST temp2;
                if (ast.head() != S.Plus) {
                    return F.NIL;
                }
                if (ast.isEvalFlagOn(65536) && (temp2 = engine.evalArgsOrderlessN(ast)).isPresent()) {
                    ast = temp2;
                }
                if ((temp = ast.findFirst(arg_0 -> Plus.lambda$evaluate$0(plusOp = new PlusOp(size), arg_0))).isPresent()) {
                    return temp;
                }
                if (plusOp.isEvaled()) {
                    return plusOp.getSum();
                }
                temp = this.evaluateHashsRepeated(ast, engine);
                if (temp.isAST(S.Plus, 2)) {
                    return temp.first();
                }
                return temp;
            }
            if (size == 1) {
                if (ast.head() == S.Plus) {
                    return F.C0;
                }
                return F.NIL;
            }
            if (size == 2) {
                if (ast.head() == S.Plus) {
                    return ast.arg1();
                }
                return F.NIL;
            }
            if (engine.isSymbolicMode(S.Plus.getAttributes())) {
                ast.addEvalFlags(262144);
            }
            return F.NIL;
        }

        @Override
        public HashedOrderlessMatcher getHashRuleMap() {
            return PLUS_ORDERLESS_MATCHER;
        }

        @Override
        public IExpr numericEval(IAST ast, EvalEngine engine) {
            IExpr temp = this.evalNumericMode(ast);
            if (temp.isPresent()) {
                return temp;
            }
            return this.evaluate(ast, engine);
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1549);
            PLUS_ORDERLESS_MATCHER = Plus.initPlusHashMatcher();
            super.setUp(newSymbol);
        }

        private static HashedOrderlessMatcherPlus initPlusHashMatcher() {
            HashedOrderlessMatcherPlus plusMatcher = new HashedOrderlessMatcherPlus();
            plusMatcher.definePatternHashRule(F.Power((IExpr)F.Sin(F.x_), F.C2), F.Power((IExpr)F.Cos(F.x_), F.C2), F.C1);
            plusMatcher.definePatternHashRule(F.Power((IExpr)F.Sech(F.x_), F.C2), F.Power((IExpr)F.Tanh(F.x_), F.C2), F.C1);
            plusMatcher.definePatternHashRule((IExpr)F.Power((IExpr)F.Cosh(F.x_), F.C2), (IExpr)F.Power((IExpr)F.Sinh(F.x_), F.C2), (IExpr)F.C1, true);
            plusMatcher.definePatternHashRule((IExpr)F.Power((IExpr)F.Csc(F.x_), F.C2), (IExpr)F.Power((IExpr)F.Cot(F.x_), F.C2), (IExpr)F.C1, true);
            plusMatcher.defineHashRule(F.ArcSin(F.x_), F.ArcCos(F.x_), F.CPiHalf);
            plusMatcher.defineHashRule(F.ArcTan(F.x_), F.ArcCot(F.x_), F.CPiHalf);
            plusMatcher.defineHashRule(F.ArcTan(F.x_), F.ArcTan(F.y_), F.Times((IExpr)F.C1D2, (IExpr)S.Pi), F.And((IExpr)F.Positive(S.x), (IExpr)F.Equal((IExpr)S.y, (IExpr)F.Power((IExpr)S.x, F.CN1))));
            plusMatcher.defineHashRule(F.ArcTan(F.C1D3), F.ArcTan(F.C1D2), F.Times((IExpr)F.C1D4, (IExpr)S.Pi));
            plusMatcher.defineHashRule(F.ArcTan(F.C1D3), F.ArcTan(F.QQ(1L, 7L)), F.ArcTan(F.C1D2));
            return plusMatcher;
        }

        private static /* synthetic */ IExpr lambda$evaluate$0(PlusOp plusOp, IExpr x) {
            return plusOp.plus(x);
        }
    }

    private static final class PiecewiseExpand
    extends AbstractFunctionEvaluator {
        private PiecewiseExpand() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (arg1.isAST()) {
                IExpr arg2;
                IBuiltInSymbol domain = S.Complexes;
                IAssumptions assumptions = null;
                if (ast.isAST2()) {
                    arg2 = ast.arg2();
                    if (arg2.equals(S.Reals) || arg2.equals(S.Complexes)) {
                        domain = (IBuiltInSymbol)arg2;
                    } else {
                        assumptions = Assumptions.getInstance(arg2);
                    }
                } else if (ast.isAST3()) {
                    arg2 = ast.arg2();
                    IExpr arg3 = ast.arg3();
                    if (arg3.equals(S.Reals) || arg3.equals(S.Complexes)) {
                        domain = (IBuiltInSymbol)arg3;
                    }
                    assumptions = Assumptions.getInstance(arg2);
                }
                PiecewiseExpandVisitor visitor = new PiecewiseExpandVisitor(domain);
                IAssumptions oldAssumptions = engine.getAssumptions();
                try {
                    if (assumptions != null) {
                        engine.setAssumptions(assumptions);
                    }
                    IExpr iExpr = arg1.accept(visitor).orElse(arg1);
                    return iExpr;
                }
                finally {
                    engine.setAssumptions(oldAssumptions);
                }
            }
            return arg1;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_3;
        }

        static class PiecewiseExpandVisitor
        extends VisitorExpr {
            private final IBuiltInSymbol domain;

            public PiecewiseExpandVisitor(IBuiltInSymbol domain) {
                this.domain = domain;
            }

            @Override
            public IExpr visit(IASTMutable ast) {
                IExpr expr = this.visitAST(ast).orElse(ast);
                if (expr.isAST()) {
                    return Arithmetic.piecewiseExpand((IAST)expr, this.domain).orElseGet(() -> this.visitAST((IAST)expr));
                }
                return F.NIL;
            }
        }
    }

    private static final class Piecewise
    extends AbstractFunctionEvaluator {
        private Piecewise() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            int[] dim = arg1.isMatrix(false);
            if (dim == null || dim[0] <= 0 || dim[1] != 2 || !arg1.isAST()) {
                if (arg1.isEmptyList()) {
                    if (ast.isAST2()) {
                        return ast.arg2();
                    }
                    return F.C0;
                }
                return IOFunctions.printMessage(ast.topHead(), "pairs", F.list(arg1, ast.topHead()), engine);
            }
            IAST matrix = (IAST)arg1;
            IExpr defaultValue = F.C0;
            if (ast.isAST1()) {
                return ast.appendClone(F.C0);
            }
            if (ast.isAST2()) {
                defaultValue = ast.arg2();
            }
            int matrixSize = matrix.size();
            IASTAppendable result = F.NIL;
            IASTAppendable piecewiseAST = F.NIL;
            boolean evaluated = false;
            boolean noBoolean = false;
            for (int i = 1; i < matrixSize; ++i) {
                IExpr rowArg1;
                IAST row = matrix.getAST(i);
                IExpr condition = row.arg2();
                if (condition.isTrue()) {
                    if (!evaluated && i == matrixSize - 1) {
                        if (!row.arg1().isSymbol()) {
                            return row.arg1();
                        }
                        return F.NIL;
                    }
                    if (noBoolean) {
                        piecewiseAST = Piecewise.createPiecewise(piecewiseAST, result);
                        piecewiseAST.append(row.arg1());
                        return piecewiseAST;
                    }
                    return row.arg1();
                }
                if (condition.isFalse()) {
                    evaluated = true;
                    continue;
                }
                if ((condition = engine.evaluateNIL(condition)).isPresent()) {
                    evaluated = true;
                    if (condition.isTrue()) {
                        if (noBoolean) {
                            result = Piecewise.appendPiecewise(result, row.arg1(), S.True, matrixSize);
                            return Piecewise.createPiecewise(piecewiseAST, result);
                        }
                        return row.arg1();
                    }
                    if (condition.isFalse()) continue;
                }
                if ((rowArg1 = engine.evaluateNIL(row.arg1())).isPresent()) {
                    evaluated = true;
                } else {
                    rowArg1 = row.arg1();
                }
                if (i == matrixSize - 1 && rowArg1.equals(defaultValue)) {
                    evaluated = true;
                    continue;
                }
                result = Piecewise.appendPiecewise(result, rowArg1, condition.orElse(row.arg2()), matrixSize);
                piecewiseAST = Piecewise.createPiecewise(piecewiseAST, result);
                noBoolean = true;
            }
            if (!noBoolean) {
                return defaultValue;
            }
            if (evaluated) {
                piecewiseAST = Piecewise.createPiecewise(piecewiseAST, F.List());
                piecewiseAST.append(engine.evaluate(defaultValue));
                return piecewiseAST;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        private static IASTAppendable createPiecewise(IASTAppendable piecewiseAST, IAST resultList) {
            if (!piecewiseAST.isPresent()) {
                piecewiseAST = F.ast(S.Piecewise);
                piecewiseAST.append(resultList);
            }
            return piecewiseAST;
        }

        private static IASTAppendable appendPiecewise(IASTAppendable list, IExpr function, IExpr predicate, int matrixSize) {
            if (!list.isPresent()) {
                list = F.ListAlloc(matrixSize);
            }
            list.append(F.list(function, predicate));
            return list;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static class N
    extends AbstractCoreFunctionEvaluator {
        private N() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return this.numericEval(ast, engine);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IExpr numericEval(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (ast.isAST1()) {
                return N.numericEvalAST1(arg1, engine);
            }
            IExpr arg2 = ast.arg2();
            boolean oldNumericMode = engine.isNumericMode();
            long oldDigitPrecision = engine.getNumericPrecision();
            try {
                long nDigitPrecision = oldDigitPrecision;
                arg2 = engine.evaluateNonNumeric(arg2);
                nDigitPrecision = arg2.toIntDefault();
                if (nDigitPrecision <= 0L) {
                    IAST iAST = IOFunctions.printMessage(S.N, "precsm", F.list(arg2, F.C1), engine);
                    return iAST;
                }
                if (nDigitPrecision > Config.MAX_PRECISION_APFLOAT) {
                    IAST iAST = IOFunctions.printMessage(S.N, "precgt", F.list(arg2, F.ZZ(Config.MAX_PRECISION_APFLOAT)), engine);
                    return iAST;
                }
                IExpr iExpr = N.numericEvalAST2(arg1, nDigitPrecision, engine);
                return iExpr;
            }
            finally {
                engine.setNumericMode(oldNumericMode);
                engine.setNumericPrecision(oldDigitPrecision);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static IExpr numericEvalAST1(IExpr expr, EvalEngine engine) {
            boolean oldNumericMode = engine.isNumericMode();
            long oldDigitPrecision = engine.getNumericPrecision();
            int oldSignificantFigures = engine.getSignificantFigures();
            try {
                long numericPrecision = oldDigitPrecision;
                if (expr.isNumericFunction(true)) {
                    engine.setNumericMode(true, numericPrecision, oldSignificantFigures);
                    IExpr iExpr = engine.evalWithoutNumericReset(expr);
                    return iExpr;
                }
                if ((expr = engine.evaluate(expr)).isInexactNumber()) {
                    IExpr iExpr = expr;
                    return iExpr;
                }
                engine.setNumericMode(true, numericPrecision, oldSignificantFigures);
                IExpr iExpr = engine.evalWithoutNumericReset(expr);
                return iExpr;
            }
            finally {
                engine.setNumericMode(oldNumericMode);
                engine.setNumericPrecision(oldDigitPrecision);
            }
        }

        private static IExpr numericEvalAST2(IExpr expr, long nDigitPrecision, EvalEngine engine) {
            int significantFigures;
            if ((expr = engine.evaluate(expr)).isInexactNumber()) {
                return expr;
            }
            int maxSize = Config.MAX_OUTPUT_SIZE > Short.MAX_VALUE ? Short.MAX_VALUE : Config.MAX_OUTPUT_SIZE;
            int n = significantFigures = nDigitPrecision > (long)maxSize ? maxSize : (int)nDigitPrecision;
            if (nDigitPrecision < 16L) {
                nDigitPrecision = 16L;
            }
            engine.setNumericMode(true, nDigitPrecision, significantFigures);
            return engine.evalWithoutNumericReset(expr);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class Minus
    extends AbstractFunctionEvaluator {
        private Minus() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.Times((IExpr)F.CN1, ast.arg1());
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }
    }

    private static final class MantissaExponent
    extends AbstractCoreFunctionEvaluator {
        private MantissaExponent() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1;
            if (ast.size() == 2 && (arg1 = engine.evaluate(ast.arg1())).isReal()) {
                Apfloat x = arg1 instanceof ApfloatNum ? ((ApfloatNum)arg1).apfloatValue() : ((ISignedNumber)arg1).apfloatValue();
                Apfloat mantissa = ApfloatMath.scale((Apfloat)x, (long)(-x.scale()));
                long exponent = x.scale();
                return F.list(F.num(mantissa), F.ZZ(exponent));
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static final class LCM
    extends AbstractArgMultiple {
        private LCM() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST1() && ast.arg1().isExactNumber()) {
                return ast.arg1().abs();
            }
            return super.evaluate(ast, engine);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_INFINITY;
        }

        @Override
        public IExpr e2IntArg(IInteger i0, IInteger i1) {
            return i0.lcm(i1);
        }

        @Override
        public IExpr e2ObjArg(IAST ast, IExpr arg1, IExpr arg2) {
            if (arg1.isZero()) {
                return arg1;
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(524);
        }
    }

    private static class Increment
    extends Decrement {
        private Increment() {
        }

        @Override
        protected IASTMutable getAST() {
            return (IASTMutable)F.Plus(null, (IExpr)F.C1);
        }

        @Override
        protected ISymbol getFunctionSymbol() {
            return S.Increment;
        }
    }

    private static final class Im
    extends AbstractEvaluator {
        private Im() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr base;
            IExpr arg1 = ast.arg1();
            if (arg1.isDirectedInfinity()) {
                IAST directedInfininty = (IAST)arg1;
                if (directedInfininty.isComplexInfinity()) {
                    return S.Indeterminate;
                }
                if (directedInfininty.isAST1()) {
                    if (directedInfininty.isInfinity()) {
                        return F.C0;
                    }
                    IExpr im = S.Im.of(engine, directedInfininty.arg1());
                    if (im.isNumber()) {
                        if (im.isZero()) {
                            return F.C0;
                        }
                        return F.Times((IExpr)F.Sign(im), (IExpr)F.CInfinity);
                    }
                }
            }
            if (arg1.isNumber() || arg1.isQuantity()) {
                return arg1.im();
            }
            if (arg1.isRealResult()) {
                return F.C0;
            }
            if (arg1.isRealVector()) {
                return new ASTRealVector((RealVector)new ArrayRealVector(arg1.size() - 1, 0.0), false);
            }
            if (arg1.isRealMatrix()) {
                ASTRealMatrix matrix = (ASTRealMatrix)arg1;
                return new ASTRealMatrix((RealMatrix)new Array2DRowRealMatrix(matrix.getRowDimension(), matrix.getColumnDimension()), false);
            }
            IExpr negExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(arg1);
            if (negExpr.isPresent()) {
                return F.Negate(F.Im(negExpr));
            }
            if (arg1.isTimes()) {
                IAST timesAST = (IAST)arg1;
                int position = timesAST.indexOf(x -> x.isRealResult());
                if (position > 0) {
                    return F.Times(timesAST.get(position), F.Im(timesAST.splice(position)));
                }
                IExpr first = timesAST.arg1();
                if (first.isNumber()) {
                    IExpr rest = timesAST.rest().oneIdentity1();
                    if (first.isReal()) {
                        return F.Times(first, F.Im(rest));
                    }
                    return F.Plus((IExpr)F.Times(first.re(), F.Im(rest)), (IExpr)F.Times(first.im(), F.Re(rest)));
                }
            }
            if (arg1.isPlus()) {
                return ((IAST)arg1).mapThread((IAST)F.Im(F.Slot1), 1);
            }
            if (arg1.isPower() && (base = arg1.base()).isRealResult()) {
                IExpr a;
                IExpr exponent = arg1.exponent();
                if (exponent.isNumber()) {
                    a = exponent.re();
                    IExpr b = exponent.im();
                    return this.imPowerComplex(base, a, b);
                }
                if (exponent.isNumericFunction(true)) {
                    a = engine.evaluate(F.Re(exponent));
                    IExpr b = engine.evaluate(F.Im(exponent));
                    return this.imPowerComplex(base, a, b);
                }
            }
            if (arg1.isInterval()) {
                IAST list;
                if (arg1.size() == 2 && (list = (IAST)arg1.first()).first().isRealResult() && list.second().isRealResult()) {
                    return F.C0;
                }
                return IntervalSym.mapSymbol(S.Im, (IAST)arg1);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        private IExpr imPowerComplex(IExpr x, IExpr a, IExpr b) {
            if (x.isE()) {
                return F.Times((IExpr)F.Power((IExpr)S.E, a), (IExpr)F.Sin(b));
            }
            return F.Times((IExpr)F.Times((IExpr)F.Power((IExpr)F.Power(x, F.C2), F.Times((IExpr)F.C1D2, a)), (IExpr)F.Power((IExpr)S.E, F.Times(F.Negate(b), (IExpr)F.Arg(x)))), (IExpr)F.Sin(F.Plus((IExpr)F.Times(a, (IExpr)F.Arg(x)), (IExpr)F.Times((IExpr)F.Times((IExpr)F.C1D2, b), (IExpr)F.Log(F.Power(x, F.C2))))));
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
        }
    }

    private static final class HarmonicNumber
    extends AbstractEvaluator {
        private HarmonicNumber() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            try {
                if (ast.isAST2()) {
                    IExpr arg2 = ast.arg2();
                    return HarmonicNumber.harmonic(arg1, arg2, ast, engine);
                }
                return HarmonicNumber.harmonic(arg1, ast, engine);
            }
            catch (ValidateException ve) {
                LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)((Object)ve));
                return F.NIL;
            }
        }

        private static IExpr harmonic(IExpr arg1, IAST ast, EvalEngine engine) {
            if (arg1.isInteger()) {
                if (arg1.isNegative()) {
                    return F.CComplexInfinity;
                }
                int n = Validate.checkIntType(ast, 1, Integer.MIN_VALUE);
                if (n < 0) {
                    return F.NIL;
                }
                if (n == 0) {
                    return F.C0;
                }
                if (n == 1) {
                    return F.C1;
                }
                return F.QQ(HarmonicNumber.harmonicNumber(n));
            }
            if (arg1.isInfinity()) {
                return arg1;
            }
            if (arg1.isNegativeInfinity()) {
                return F.CComplexInfinity;
            }
            return F.NIL;
        }

        private static IExpr harmonic(IExpr arg1, IExpr arg2, IAST ast, EvalEngine engine) {
            if (arg2.isOne()) {
                return F.HarmonicNumber(arg1);
            }
            if (arg2.isInteger() && arg1.isInfinity()) {
                if (arg2.isPositive() && ((IInteger)arg2).isEven()) {
                    IASTMutable v = F.Times((IExpr)F.C1D2, arg2);
                    return F.Times(F.Power((IExpr)F.Times((IExpr)F.C2, (IExpr)S.Pi), F.Times((IExpr)F.C2, (IExpr)v)), F.Power((IExpr)F.CN1, F.Plus((IExpr)v, (IExpr)F.C1)), F.BernoulliB(F.Times((IExpr)F.C2, (IExpr)v)), F.Power((IExpr)F.Times((IExpr)F.C2, (IExpr)F.Factorial(F.Times((IExpr)F.C2, (IExpr)v))), F.CN1));
                }
                return F.NIL;
            }
            if (arg2.isInteger() && !arg2.isPositive()) {
                IExpr z = arg1;
                IInteger n = ((IInteger)arg2).negate();
                IInteger m = n.inc();
                return F.Expand(F.Times((IExpr)F.Power((IExpr)m, F.CN1), (IExpr)F.Plus((IExpr)F.BernoulliB(m, F.Plus(z, (IExpr)F.C1)), (IExpr)F.Times((IExpr)F.Power((IExpr)F.CN1, n), (IExpr)F.BernoulliB(m)))));
            }
            if (arg1.isInteger()) {
                int intArg2;
                if (arg1.isNegative() && arg2.isNumber() && arg2.isPositive()) {
                    return F.CComplexInfinity;
                }
                int n = Validate.checkIntType(ast, 1, Integer.MIN_VALUE);
                if (n < 0) {
                    return F.NIL;
                }
                if (n == 0) {
                    return F.C0;
                }
                int iterationLimit = EvalEngine.get().getIterationLimit();
                if (iterationLimit >= 0 && iterationLimit <= n) {
                    IterationLimitExceeded.throwIt(n, ast);
                }
                if ((intArg2 = arg2.toIntDefault()) != Integer.MIN_VALUE) {
                    int exponent = intArg2;
                    if (intArg2 < 0) {
                        exponent *= -1;
                    }
                    IRational result = F.C0;
                    for (int i2 = 1; i2 <= n; ++i2) {
                        IInteger pow = F.ZZ(i2).powerRational(exponent);
                        result = result.add(intArg2 < 0 ? pow : pow.inverse());
                        result.checkBitLength();
                    }
                    return result;
                }
                IExpr arg2Negate = arg2.negate();
                return F.sum(i -> F.Power(i, arg2Negate), 1, n);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        public static BigFraction harmonicNumber(int n) {
            if (n < 1) {
                return BigFraction.ZERO;
            }
            int iterationLimit = EvalEngine.get().getIterationLimit();
            if (iterationLimit >= 0 && iterationLimit <= n) {
                IterationLimitExceeded.throwIt(n, F.HarmonicNumber(F.ZZ(n)));
            }
            BigFraction a = new BigFraction(1, 1);
            for (int i = 2; i <= n; ++i) {
                a = a.add(new BigFraction(1, i));
            }
            return a;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
        }
    }

    private static final class GCD
    extends AbstractArgMultiple {
        private GCD() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST0()) {
                return F.C0;
            }
            if (ast.isAST1() && ast.arg1().isExactNumber()) {
                return ast.arg1().abs();
            }
            return super.evaluate(ast, engine);
        }

        @Override
        public IExpr eComIntArg(IComplex c0, IInteger i1) {
            return this.e2ComArg(c0, F.complex(i1, F.C0));
        }

        @Override
        public IExpr e2ComArg(IComplex c0, IComplex c1) {
            IInteger[] result;
            IInteger[] gi0 = c0.gaussianIntegers();
            IInteger[] gi1 = c1.gaussianIntegers();
            if (gi0 != null && gi1 != null && (result = GaussianInteger.gcd(gi0, gi1)) != null) {
                return F.complex(result[0], result[1]);
            }
            return F.NIL;
        }

        @Override
        public IExpr e2FraArg(IFraction f0, IFraction f1) {
            return f0.gcd(f1);
        }

        @Override
        public IExpr e2IntArg(IInteger i0, IInteger i1) {
            return i0.gcd(i1);
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(525);
        }
    }

    private static final class Gamma
    extends AbstractArg12
    implements GammaRules {
        private Gamma() {
        }

        @Override
        public IExpr e1ApcomplexArg(Apcomplex arg1) {
            if (arg1.isInteger() && arg1.real().compareTo((Apfloat)Apfloat.ZERO) < 0) {
                return F.CComplexInfinity;
            }
            return F.complexNum(ApcomplexMath.gamma((Apcomplex)arg1));
        }

        @Override
        public IExpr e1ApfloatArg(Apfloat arg1) {
            FixedPrecisionApfloatHelper h = EvalEngine.getApfloat();
            try {
                if (arg1.isInteger() && arg1.compareTo((Apfloat)Apfloat.ZERO) < 0) {
                    return F.CComplexInfinity;
                }
                return F.num(h.gamma(arg1));
            }
            catch (ArithmeticException aex1) {
                try {
                    return F.complexNum(h.gamma(new Apcomplex(arg1, (Apfloat)Apcomplex.ZERO)));
                }
                catch (ArithmeticException aex2) {
                    return F.NIL;
                }
            }
        }

        @Override
        public IExpr e1DblComArg(IComplexNum c) {
            if (c.isNumIntValue() && c.getRealPart() < 0.0) {
                return F.CComplexInfinity;
            }
            return F.complexNum(Arithmetic.lanczosApproxGamma(c.evalComplex()));
        }

        @Override
        public IExpr e1DblArg(INum arg1) {
            if (arg1.isNumIntValue() && arg1.doubleValue() < 0.0) {
                return F.CComplexInfinity;
            }
            double gamma = org.hipparchus.special.Gamma.gamma((double)arg1.doubleValue());
            return F.num(gamma);
        }

        @Override
        public IExpr e2DblComArg(IComplexNum d0, IComplexNum d1) {
            if (d0.isZero() && d1.isZero()) {
                return F.CInfinity;
            }
            return F.complexNum(GammaJS.gamma(d0.evalComplex(), d1.evalComplex()));
        }

        @Override
        public IExpr e2ApcomplexArg(ApcomplexNum arg1, ApcomplexNum arg2) {
            try {
                return F.complexNum(ApcomplexMath.gamma((Apcomplex)arg1.apcomplexValue(), (Apcomplex)arg2.apcomplexValue()));
            }
            catch (ArithmeticException arithmeticException) {
                return F.NIL;
            }
        }

        @Override
        public IExpr e2ApfloatArg(ApfloatNum arg1, ApfloatNum arg2) {
            try {
                return F.num(ApfloatMath.gamma((Apfloat)arg1.apfloatValue(), (Apfloat)arg2.apfloatValue()));
            }
            catch (ArithmeticException aex1) {
                try {
                    return this.e2ApcomplexArg(ApcomplexNum.valueOf(arg1.apfloatValue()), ApcomplexNum.valueOf(arg2.apfloatValue()));
                }
                catch (ArithmeticException arithmeticException) {
                    return F.NIL;
                }
            }
        }

        @Override
        public IExpr e2DblArg(INum d0, INum d1) {
            if (d0.isZero() && d1.isZero()) {
                return F.CInfinity;
            }
            if (d0.isZero() || d0.isNegative() || d1.isNegative()) {
                return F.complexNum(GammaJS.gamma(d0.evalComplex(), d1.evalComplex()));
            }
            double c = GammaJS.gamma(d0.doubleValue(), d1.doubleValue());
            return F.num(c);
        }

        @Override
        public IExpr e2ObjArg(IExpr o0, IExpr z) {
            int n;
            if (z.isZero()) {
                if (o0.isZero()) {
                    return F.CInfinity;
                }
                if (o0.isNegativeResult()) {
                    return F.CComplexInfinity;
                }
                if (o0.isPositiveResult()) {
                    return F.Gamma(o0);
                }
                IExpr re = o0.re();
                if (re.isNegative()) {
                    return F.CComplexInfinity;
                }
                if (re.isPositive()) {
                    return F.Gamma(o0);
                }
            }
            if ((n = o0.toIntDefault()) > 0 && z.isNumericFunction(true)) {
                int iterationLimit = EvalEngine.get().getIterationLimit();
                if (iterationLimit >= 0 && iterationLimit <= n + 1) {
                    IterationLimitExceeded.throwIt(n, F.Gamma(o0, z));
                }
                IASTAppendable sum = F.PlusAlloc(n);
                for (int k = 0; k < n; ++k) {
                    sum.append(F.Divide(F.Power(z, k), F.Factorial(F.ZZ(k))));
                }
                return F.Times((IExpr)F.Factorial(F.ZZ(n - 1)), (IExpr)sum, (IExpr)F.Power((IExpr)S.E, z.negate()));
            }
            return F.NIL;
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                IExpr a = ast.arg1();
                if (ast.isAST3()) {
                    return F.NIL;
                }
                if (ast.size() != 3) {
                    return this.unaryOperator(a);
                }
                return this.binaryOperator(ast, a, ast.arg2());
            }
            catch (ApfloatRuntimeException | ValidateException e) {
                LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)e);
                return F.NIL;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_3;
        }

        @Override
        public IExpr e1ObjArg(IExpr arg1) {
            IAST z;
            if (arg1.isZero()) {
                return F.CComplexInfinity;
            }
            if (arg1.isIntegerResult()) {
                if (arg1.isNegative()) {
                    return F.CComplexInfinity;
                }
                if (arg1.isNonNegativeResult()) {
                    if (arg1.isInteger()) {
                        return NumberTheory.factorial(((IInteger)arg1).subtract(F.C1));
                    }
                    return F.Factorial(arg1.subtract(F.C1));
                }
                return F.NIL;
            }
            if (arg1.isFraction()) {
                IFraction frac = (IFraction)arg1;
                if (frac.denominator().equals(F.C2)) {
                    IInteger n = frac.numerator();
                    if (arg1.isNegative()) {
                        n = n.negate();
                        return F.Times(F.Power((IExpr)F.CN1, F.Times((IExpr)F.C1D2, (IExpr)F.Plus((IExpr)F.C1, (IExpr)n))), F.Power((IExpr)F.C2, n), F.Sqrt(S.Pi), F.Power((IExpr)F.Factorial(n), -1L), F.Factorial(F.Times((IExpr)F.C1D2, (IExpr)F.Plus((IExpr)F.CN1, (IExpr)n))));
                    }
                    return F.Times((IExpr)F.Sqrt(S.Pi), (IExpr)F.Factorial2(n.subtract(F.C2)), (IExpr)F.Power((IExpr)F.C2, F.Times((IExpr)F.C1D2, (IExpr)F.Subtract(F.C1, n))));
                }
            } else if (arg1.isAST() && (z = (IAST)arg1).isAST(F.Conjugate, 2)) {
                return F.Conjugate(F.Gamma(z.arg1()));
            }
            return F.NIL;
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static final class DirectedInfinity
    extends AbstractCoreFunctionEvaluator {
        private DirectedInfinity() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST1()) {
                boolean numericMode = engine.isNumericMode();
                boolean evaled = false;
                try {
                    IExpr a1;
                    engine.setNumericMode(false);
                    IExpr arg1 = ast.arg1();
                    IExpr temp = engine.evaluateNIL(arg1);
                    if (temp.isPresent()) {
                        arg1 = temp;
                        evaled = true;
                    }
                    if (arg1.isIndeterminate() || arg1.isZero()) {
                        IAST iAST = F.CComplexInfinity;
                        return iAST;
                    }
                    if (arg1.isReal()) {
                        if (arg1.isOne() || arg1.isMinusOne()) {
                            if (evaled) {
                                IAST iAST = F.DirectedInfinity(arg1);
                                return iAST;
                            }
                            IAssociation iAssociation = F.NIL;
                            return iAssociation;
                        }
                        if (arg1.isNegative()) {
                            IAST iAST = F.DirectedInfinity(F.CN1);
                            return iAST;
                        }
                        IAST iAST = F.DirectedInfinity(F.C1);
                        return iAST;
                    }
                    if (arg1.isNumber()) {
                        IExpr arg1Abs = engine.evaluate(F.Divide(arg1, F.Abs(arg1)));
                        if (arg1.equals(arg1Abs)) {
                            if (evaled) {
                                IAST iAST = F.DirectedInfinity(arg1);
                                return iAST;
                            }
                            IAssociation iAssociation = F.NIL;
                            return iAssociation;
                        }
                        IAST iAST = F.DirectedInfinity(arg1Abs);
                        return iAST;
                    }
                    if (arg1.isNumericFunction(true) && (a1 = engine.evalN(arg1)).isReal()) {
                        if (a1.isZero()) {
                            IAST iAST = F.CComplexInfinity;
                            return iAST;
                        }
                        if (a1.isNegative()) {
                            IAST iAST = F.DirectedInfinity(F.CN1);
                            return iAST;
                        }
                        IAST iAST = F.DirectedInfinity(F.C1);
                        return iAST;
                    }
                    if (evaled) {
                        IAST iAST = F.DirectedInfinity(arg1);
                        return iAST;
                    }
                }
                finally {
                    engine.setNumericMode(numericMode);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_0_1;
        }

        public static IExpr timesInf(IAST inf, IExpr a2) {
            if (inf.isAST1()) {
                IExpr result;
                IExpr a1 = inf.arg1();
                if (a1.isNumber()) {
                    if (a2.isNumber()) {
                        result = a1.times(a2);
                        if (result.isReal()) {
                            if (result.isNegative()) {
                                return F.CNInfinity;
                            }
                            return F.CInfinity;
                        }
                        if (result.isImaginaryUnit()) {
                            return F.DirectedInfinity(F.CI);
                        }
                        if (result.isNegativeImaginaryUnit()) {
                            return F.DirectedInfinity(F.CNI);
                        }
                    } else if (a2.isSymbol()) {
                        if (a1.isOne()) {
                            return F.DirectedInfinity(a2);
                        }
                        if (a1.isMinusOne() || a1.equals(F.CI) || a1.equals(F.CNI)) {
                            return F.DirectedInfinity(F.Times(a1, a2));
                        }
                    }
                } else if (a1.isSymbol()) {
                    if (a2.isReal()) {
                        if (a2.isNegative()) {
                            return F.DirectedInfinity(F.Times((IExpr)F.CN1, (IExpr)F.Sign(a1)));
                        }
                        return F.DirectedInfinity(a1);
                    }
                    if (a2.equals(F.CI)) {
                        return F.DirectedInfinity(F.Times((IExpr)F.CI, a1));
                    }
                    if (a2.equals(F.CNI)) {
                        return F.DirectedInfinity(F.Times((IExpr)F.CNI, (IExpr)F.Sign(a1)));
                    }
                }
                result = F.Divide(F.Times(a1, a2), F.Abs(F.Times(a1, a2)));
                return F.DirectedInfinity(result);
            }
            return inf;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(608);
        }
    }

    private static class DivideBy
    extends AddTo {
        private DivideBy() {
        }

        @Override
        protected IASTMutable getAST(IExpr value) {
            return F.Times(null, (IExpr)F.Power(value, F.CN1));
        }

        @Override
        protected ISymbol getFunctionSymbol() {
            return S.DivideBy;
        }

        @Override
        protected ISymbol getArithmeticSymbol() {
            return S.Divide;
        }
    }

    private static class Divide
    extends AbstractFunctionEvaluator {
        private Divide() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return F.Divide(ast.arg1(), ast.arg2());
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1632);
        }
    }

    private static class Differences
    extends AbstractFunctionEvaluator {
        private Differences() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            int c = 1;
            if (ast.isAST2()) {
                int n = ast.arg2().toIntDefault();
                if (n == Integer.MIN_VALUE) {
                    return F.NIL;
                }
                if (n < 0) {
                    return IOFunctions.printMessage(ast.topHead(), "ilsmn", F.list(F.C2, ast), engine);
                }
                c = n;
            }
            if (ast.isAST1()) {
                if (arg1.isSparseArray()) {
                    arg1 = arg1.normal(false);
                }
                if (arg1.isList()) {
                    if (arg1.size() <= 2) {
                        return F.CEmptyList;
                    }
                    return F.ListConvolve(F.list(F.ZZ(c), F.ZZ(-c)), arg1);
                }
                if (arg1.isNumber()) {
                    return IOFunctions.printMessage(ast.topHead(), "listrp", F.list(F.C1, ast), engine);
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_3;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class Decrement
    extends AbstractFunctionEvaluator {
        protected IASTMutable getAST() {
            return (IASTMutable)F.Plus(null, (IExpr)F.CN1);
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            block6: {
                IExpr arg1 = ast.arg1();
                try {
                    if (arg1.isASTSizeGE(S.Part, 3) && arg1.first().isSymbol()) {
                        ISymbol sym = (ISymbol)arg1.first();
                        if (sym.hasAssignedSymbolValue()) {
                            return this.assignPart(arg1, F.CN1, engine);
                        }
                        return IOFunctions.printMessage(ast.topHead(), "rvalue", F.list(sym), engine);
                    }
                    if (!arg1.isSymbol()) break block6;
                    ISymbol sym = (ISymbol)arg1;
                    if (sym.hasAssignedSymbolValue()) {
                        IExpr[] results = ((ISymbol)arg1).reassignSymbolValue(this.getAST(), this.getFunctionSymbol(), engine);
                        if (results != null) {
                            return this.getResult(results[0], results[1]);
                        }
                        break block6;
                    }
                    return IOFunctions.printMessage(ast.topHead(), "rvalue", F.list(sym), engine);
                }
                catch (ValidateException ve) {
                    LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)((Object)ve));
                }
            }
            return F.NIL;
        }

        private IExpr assignPart(IExpr part, IExpr value, EvalEngine engine) {
            IExpr oldResult = engine.evaluate(part);
            IASTMutable operator = this.getAST();
            operator.set(1, oldResult);
            IExpr newResult = engine.evaluate(operator);
            engine.evaluate(F.Set(part, newResult));
            return this.getResult(oldResult, newResult);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        protected ISymbol getFunctionSymbol() {
            return S.Decrement;
        }

        protected IExpr getResult(IExpr symbolValue, IExpr calculatedResult) {
            return symbolValue;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static class CubeRoot
    extends AbstractFunctionEvaluator {
        private CubeRoot() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr base = ast.arg1();
            if (base.isNumericFunction(true)) {
                if (base.isComplex() || base.isComplexNumeric()) {
                    return IOFunctions.printMessage(ast.topHead(), "preal", F.list(base), engine);
                }
                if (base.isPositiveResult()) {
                    return F.Power(base, F.C1D3);
                }
                return F.Times((IExpr)F.CN1, (IExpr)F.Power(F.Negate(base), F.C1D3));
            }
            return F.Surd(base, F.C3);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
        }
    }

    private static final class Conjugate
    extends AbstractTrigArg1
    implements INumeric,
    ConjugateRules {
        private Conjugate() {
        }

        private IExpr conjugate(IExpr arg1) {
            if (arg1.isNumber()) {
                return ((INumber)arg1).conjugate();
            }
            if (arg1.isRealResult() || arg1.isRealVector() || arg1.isRealMatrix()) {
                return arg1;
            }
            if (arg1.isQuantity()) {
                return arg1.conjugate();
            }
            if (arg1.isDirectedInfinity()) {
                IAST directedInfininty = (IAST)arg1;
                if (directedInfininty.isComplexInfinity()) {
                    return F.CComplexInfinity;
                }
                if (directedInfininty.isAST1()) {
                    if (directedInfininty.isInfinity()) {
                        return F.CInfinity;
                    }
                    IExpr conjug = F.eval(F.Conjugate(directedInfininty.arg1()));
                    return F.Times(conjug, (IExpr)F.CInfinity);
                }
            }
            return F.NIL;
        }

        @Override
        public double evalReal(double[] stack, int top, int size) {
            if (size != 1) {
                throw new UnsupportedOperationException();
            }
            return stack[top];
        }

        @Override
        public IExpr numericEval(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            return this.evaluateArg1(arg1, engine);
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            IExpr im;
            IExpr base;
            IExpr temp = this.conjugate(arg1);
            if (temp.isPresent()) {
                return temp;
            }
            if (arg1.isPower() && (base = arg1.base()).isPositiveResult()) {
                return F.Power(base, F.Conjugate(arg1.exponent()));
            }
            if (arg1.isPlus()) {
                return ((IAST)arg1).mapThread(F.Conjugate(F.Slot1), 1);
            }
            if (arg1.isTimes()) {
                IASTAppendable result = F.NIL;
                IASTAppendable clone = ((IAST)arg1).copyAppendable();
                int i = 1;
                while (i < clone.size()) {
                    temp = this.conjugate(clone.get(i));
                    if (temp.isPresent()) {
                        clone.remove(i);
                        if (!result.isPresent()) {
                            result = ((IAST)arg1).copyHead();
                        }
                        result.append(temp);
                        continue;
                    }
                    ++i;
                }
                if (result.isPresent()) {
                    if (clone.isAST0()) {
                        return result;
                    }
                    if (clone.isAST0()) {
                        result.append(F.Conjugate(clone.arg1()));
                        return result;
                    }
                    result.append(F.Conjugate(clone));
                    return result;
                }
            } else {
                if (arg1.isConjugate()) {
                    return arg1.first();
                }
                if (arg1.isAST(S.Zeta, 2)) {
                    return F.Zeta(F.Conjugate(arg1.first()));
                }
                if (arg1.isAST(S.Zeta, 3) && arg1.first().isReal() && arg1.second().isReal()) {
                    return F.Zeta(F.Conjugate(arg1.first()), F.Conjugate(arg1.second()));
                }
            }
            if (arg1.isNumericFunction(true) && (im = arg1.im()).isFree(S.Re) && im.isFree(S.Im)) {
                return F.Subtract(arg1, F.Times((IExpr)F.C2, (IExpr)F.CI, im));
            }
            if (arg1.isInterval()) {
                return IntervalSym.mapSymbol(S.Conjugate, (IAST)arg1);
            }
            return F.NIL;
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static final class ConditionalExpression
    extends AbstractFunctionEvaluator {
        private ConditionalExpression() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg2 = ast.arg2();
            if (arg2.isTrue()) {
                return ast.arg1();
            }
            if (arg2.isFalse()) {
                return S.Undefined;
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static final class Complex
    extends AbstractCoreFunctionEvaluator {
        private Complex() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            try {
                if (ast.head().equals(S.Complex)) {
                    if (!ast.isAST2()) {
                        return IOFunctions.printArgMessage(ast, ARGS_2_2, engine);
                    }
                    IExpr realExpr = ast.arg1();
                    IExpr imaginaryExpr = ast.arg2();
                    if (!(realExpr.isRational() && imaginaryExpr.isRational() || realExpr instanceof INum && imaginaryExpr instanceof INum)) {
                        realExpr = engine.evaluate(realExpr);
                        imaginaryExpr = engine.evaluate(imaginaryExpr);
                        if (!realExpr.isNumber() || !imaginaryExpr.isNumber()) {
                            return F.NIL;
                        }
                    }
                    if (realExpr.isRational() && imaginaryExpr.isRational()) {
                        IRational re = realExpr.isInteger() ? (IInteger)realExpr : (IFraction)realExpr;
                        IRational im = imaginaryExpr.isInteger() ? (IInteger)imaginaryExpr : (IFraction)imaginaryExpr;
                        return F.complex(re, im);
                    }
                    if (realExpr instanceof INum && imaginaryExpr instanceof INum) {
                        return F.complexNum(((INum)realExpr).doubleValue(), ((INum)imaginaryExpr).doubleValue());
                    }
                    if (realExpr.isNumber() && imaginaryExpr.isNumber()) {
                        return F.Plus(realExpr, (IExpr)F.Times((IExpr)F.CI, imaginaryExpr));
                    }
                }
            }
            catch (Exception e) {
                LOGGER.debug("Complex.evaluate() failed", (Throwable)e);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1120);
        }
    }

    private static final class Clip
    extends AbstractFunctionEvaluator {
        private Clip() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg2;
            IExpr x = ast.first();
            if (ast.size() == 2) {
                try {
                    return this.clip(x);
                }
                catch (ArgumentTypeStopException atsex) {
                    return F.NIL;
                }
            }
            IExpr vMin = null;
            IExpr vMax = null;
            if (ast.size() == 4) {
                IExpr arg3 = ast.arg3();
                if (arg3.isAST(S.List, 3)) {
                    vMin = arg3.first();
                    vMax = arg3.second();
                } else {
                    return F.NIL;
                }
            }
            if (ast.size() >= 3 && (arg2 = ast.arg2()).isAST(S.List, 3)) {
                IExpr min = arg2.first();
                IExpr max = arg2.second();
                if (ast.size() == 3) {
                    vMin = min;
                    vMax = max;
                }
                try {
                    ISignedNumber maxEvaled;
                    if (min.isReal() && max.isReal()) {
                        return this.clip(x, (ISignedNumber)min, (ISignedNumber)max, vMin, vMax);
                    }
                    ISignedNumber minEvaled = min.evalReal();
                    if (minEvaled != null && (maxEvaled = max.evalReal()) != null) {
                        return this.clip(x, minEvaled, maxEvaled, vMin, vMax);
                    }
                }
                catch (ArgumentTypeStopException atsex) {
                    return F.NIL;
                }
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_3;
        }

        private IExpr clip(IExpr x) {
            if (x.isSparseArray()) {
                x = x.normal(false);
            }
            if (x.isList()) {
                IAST list = (IAST)x;
                IAST result = list.map(a -> {
                    IExpr temp = this.clip((IExpr)a);
                    if (temp.isPresent()) {
                        return temp;
                    }
                    ArgumentTypeStopException.throwNIL();
                    return F.NIL;
                });
                return result;
            }
            if (x.isReal()) {
                ISignedNumber real = (ISignedNumber)x;
                if (real.isGT(F.C1)) {
                    return F.C1;
                }
                if (real.isLT(F.CN1)) {
                    return F.CN1;
                }
                return x;
            }
            ISignedNumber real = x.evalReal();
            if (real != null) {
                if (real.isGT(F.C1)) {
                    return F.C1;
                }
                if (real.isLT(F.CN1)) {
                    return F.CN1;
                }
                return x;
            }
            if (x.isInfinity()) {
                return F.C1;
            }
            if (x.isNegativeInfinity()) {
                return F.CN1;
            }
            return F.NIL;
        }

        private IExpr clip(IExpr x, ISignedNumber min, ISignedNumber max, IExpr vMin, IExpr vMax) {
            if (x.isSparseArray()) {
                x = x.normal(false);
            }
            if (x.isList()) {
                IAST list = (IAST)x;
                IAST result = list.map(a -> {
                    IExpr temp = this.clip((IExpr)a, min, max, vMin, vMax);
                    if (temp.isPresent()) {
                        return temp;
                    }
                    ArgumentTypeStopException.throwNIL();
                    return F.NIL;
                });
                return result;
            }
            if (x.isReal()) {
                ISignedNumber real = (ISignedNumber)x;
                if (real.isGT(max)) {
                    return vMax;
                }
                if (real.isLT(min)) {
                    return vMin;
                }
                return x;
            }
            ISignedNumber real = x.evalReal();
            if (real != null) {
                if (real.isGT(max)) {
                    return vMax;
                }
                if (real.isLT(min)) {
                    return vMin;
                }
                return x;
            }
            if (x.isInfinity() && S.Greater.ofQ(x, max)) {
                return vMax;
            }
            if (x.isNegativeInfinity() && S.Less.ofQ(x, min)) {
                return vMin;
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1024);
        }
    }

    private static class Chop
    extends AbstractFunctionEvaluator {
        private Chop() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            double delta = 1.0E-10;
            if (ast.isAST2() && ast.arg2() instanceof INum) {
                delta = ((INum)ast.arg2()).getRealPart();
            }
            try {
                if (arg1.isAST()) {
                    IAST list = (IAST)arg1;
                    return list.mapThread(F.Chop(F.Slot1), 1);
                }
                if (arg1.isNumber()) {
                    return F.chopNumber((INumber)arg1, delta);
                }
            }
            catch (Exception e) {
                LOGGER.debug("Chop.evaluate() failed", (Throwable)e);
            }
            return arg1;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }
    }

    private static class Arg
    extends AbstractCoreFunctionEvaluator
    implements INumeric,
    DoubleUnaryOperator {
        private Arg() {
        }

        @Override
        public double applyAsDouble(double operand) {
            if (operand < 0.0) {
                return Math.PI;
            }
            return 0.0;
        }

        @Override
        public double evalReal(double[] stack, int top, int size) {
            if (size != 1) {
                throw new UnsupportedOperationException();
            }
            if (stack[top] < 0.0) {
                return Math.PI;
            }
            if (stack[top] >= 0.0) {
                return 0.0;
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IAST result = F.NIL;
            IExpr arg1 = engine.evaluateNIL(ast.arg1());
            if (arg1.isPresent()) {
                result = F.Arg(arg1);
            } else {
                arg1 = ast.arg1();
            }
            if (arg1.isList()) {
                return ((IAST)arg1).mapThread(F.Arg(F.Slot1), 1);
            }
            if (arg1.isIndeterminate()) {
                return S.Indeterminate;
            }
            if (arg1.isDirectedInfinity()) {
                IAST directedInfininty = (IAST)arg1;
                if (directedInfininty.isAST1()) {
                    if (directedInfininty.isInfinity()) {
                        return F.C0;
                    }
                    return F.Arg(directedInfininty.arg1());
                }
                if (arg1.isComplexInfinity()) {
                    IOFunctions.printMessage(ast.topHead(), "indet", F.list(ast), engine);
                    return F.Interval(F.list(S.Pi.negate(), S.Pi));
                }
            } else {
                if (arg1.isNumber()) {
                    return ((INumber)arg1).complexArg();
                }
                if (arg1.isTimes() && arg1.first().isRealResult()) {
                    IExpr first = arg1.first();
                    if (first.isPositive()) {
                        return F.Arg(arg1.rest());
                    }
                    if (first.isNegative() && !first.isMinusOne()) {
                        return F.Arg(F.Times((IExpr)F.CN1, (IExpr)arg1.rest()));
                    }
                } else if (arg1.isPower()) {
                    IExpr imPart;
                    IInteger n;
                    IExpr exponent;
                    if (arg1.exponent().isFraction() && (exponent = (IFraction)arg1.exponent()).numerator().isOne() && !(n = exponent.denominator()).isMinusOne() && !n.isZero()) {
                        return F.Divide(F.Arg(arg1.base()), n);
                    }
                    if (arg1.base().isE() && (imPart = AbstractFunctionEvaluator.imaginaryPart(exponent = arg1.exponent(), false)).isPresent()) {
                        IExpr rePart = AbstractFunctionEvaluator.realPart(exponent, false);
                        if (rePart.isZero() && !imPart.isZero()) {
                            return F.Plus((IExpr)F.Times((IExpr)F.C2, (IExpr)S.Pi, (IExpr)F.Floor(F.Times((IExpr)F.C1D2, F.Power((IExpr)S.Pi, -1L), (IExpr)F.Plus((IExpr)S.Pi, F.Negate(F.Re(imPart)))))), F.Re(imPart));
                        }
                        return F.Plus((IExpr)F.Times((IExpr)F.C2, (IExpr)S.Pi, (IExpr)F.Floor(F.Times((IExpr)F.C1D2, F.Power((IExpr)S.Pi, -1L), (IExpr)F.Plus((IExpr)S.Pi, F.Negate(imPart))))), imPart);
                    }
                }
            }
            if (arg1.isNumericFunction(true)) {
                IExpr temp = engine.evalN(arg1);
                if (temp.isRealResult()) {
                    if (temp.isNegative()) {
                        return S.Pi;
                    }
                    return F.C0;
                }
                if (temp.isNumber() && engine.isNumericMode()) {
                    return ((INumber)temp).complexArg();
                }
            }
            if (AbstractAssumptions.assumeNegative(arg1)) {
                return S.Pi;
            }
            if (AbstractAssumptions.assumePositive(arg1)) {
                return F.C0;
            }
            IExpr imPart = AbstractFunctionEvaluator.imaginaryPart(arg1, true);
            if (imPart.isPresent()) {
                return F.ArcTan(F.Re(arg1), imPart);
            }
            return result;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }
    }

    private static class AddTo
    extends AbstractFunctionEvaluator {
        private AddTo() {
        }

        protected IASTMutable getAST(IExpr value) {
            return (IASTMutable)F.Plus(null, value);
        }

        protected ISymbol getFunctionSymbol() {
            return S.AddTo;
        }

        protected ISymbol getArithmeticSymbol() {
            return S.Plus;
        }

        private IExpr assignPart(IExpr part, IExpr value, EvalEngine engine) {
            IExpr oldValue = engine.evaluate(part);
            IASTMutable operator = this.getAST(value);
            operator.set(1, oldValue);
            IExpr newResult = engine.evaluate(operator);
            engine.evaluate(F.Set(part, newResult));
            return newResult;
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr leftHandSide = ast.arg1();
            IExpr head = leftHandSide.head();
            try {
                ISymbol sym;
                IEvaluator eval;
                if (head.isBuiltInSymbol() && leftHandSide.isAST() && (eval = ((IBuiltInSymbol)head).getEvaluator()) instanceof ISetEvaluator) {
                    IExpr temp = engine.evaluateNIL(leftHandSide);
                    if (!temp.isPresent()) {
                        return F.NIL;
                    }
                    IExpr rhs = engine.evaluate(F.binaryAST2((IExpr)this.getArithmeticSymbol(), temp, ast.arg2()));
                    return ((ISetEvaluator)eval).evaluateSet(leftHandSide, rhs, S.Set, engine);
                }
                if (leftHandSide.isASTSizeGE(S.Part, 3) && leftHandSide.first().isSymbol()) {
                    sym = (ISymbol)leftHandSide.first();
                    if (sym.hasAssignedSymbolValue()) {
                        return this.assignPart(leftHandSide, ast.arg2(), engine);
                    }
                    return IOFunctions.printMessage(ast.topHead(), "rvalue", F.list(sym), engine);
                }
                if (leftHandSide.isSymbol()) {
                    sym = (ISymbol)leftHandSide;
                    if (!sym.hasAssignedSymbolValue()) {
                        return IOFunctions.printMessage(this.getFunctionSymbol(), "rvalue", F.list(sym), engine);
                    }
                    IExpr arg2 = engine.evaluate(ast.arg2());
                    IExpr[] results = sym.reassignSymbolValue(this.getAST(arg2), this.getFunctionSymbol(), engine);
                    if (results != null) {
                        return results[1];
                    }
                    return F.NIL;
                }
            }
            catch (ValidateException ve) {
                LOGGER.log(engine.getLogLevel(), (Object)ast.topHead(), (Throwable)((Object)ve));
                return F.NIL;
            }
            return IOFunctions.printMessage(this.getFunctionSymbol(), "rvalue", F.list(leftHandSide), engine);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_2_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
        }
    }

    private static final class AbsArg
    extends AbstractEvaluator {
        private AbsArg() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            int size = ast.size();
            if (size == 2) {
                IExpr z = ast.arg1();
                return F.list(F.Abs(z), F.Arg(z));
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static final class Abs
    extends AbstractTrigArg1
    implements INumeric,
    AbsRules,
    DoubleUnaryOperator {
        private Abs() {
        }

        @Override
        public double applyAsDouble(double operand) {
            return Math.abs(operand);
        }

        @Override
        public IExpr e1ApcomplexArg(Apcomplex arg1) {
            return F.num(ApcomplexMath.abs((Apcomplex)arg1));
        }

        @Override
        public IExpr e1ApfloatArg(Apfloat arg1) {
            return F.num(ApfloatMath.abs((Apfloat)arg1));
        }

        @Override
        public IExpr e1ComplexArg(org.hipparchus.complex.Complex arg1) {
            return F.num(ComplexNum.dabs(arg1));
        }

        @Override
        public IExpr e1DblArg(double arg1) {
            return F.num(Math.abs(arg1));
        }

        @Override
        public double evalReal(double[] stack, int top, int size) {
            if (size != 1) {
                throw new UnsupportedOperationException();
            }
            return Math.abs(stack[top]);
        }

        @Override
        public IExpr evaluateArg1(IExpr arg1, EvalEngine engine) {
            IExpr im;
            IExpr re;
            IASTAppendable[] result;
            IExpr temp;
            if (arg1.isDirectedInfinity()) {
                return F.CInfinity;
            }
            if (arg1.isNumber()) {
                return ((INumber)arg1).abs();
            }
            if (arg1.isNumericFunction(true) && (temp = engine.evalN(arg1)).isReal()) {
                return arg1.copySign((ISignedNumber)temp);
            }
            if (arg1.isNegativeResult()) {
                return F.Negate(arg1);
            }
            if (arg1.isNonNegativeResult()) {
                return arg1;
            }
            if (arg1.isSymbol()) {
                ISymbol sym = (ISymbol)arg1;
                return sym.mapConstantDouble(new AbsNumericFunction(sym));
            }
            if (arg1.isTimes() && (result = ((IAST)arg1).filterNIL(new AbsTimesFunction()))[0].size() > 1) {
                if (result[1].size() > 1) {
                    result[0].append(F.Abs(result[1]));
                }
                return result[0];
            }
            if (arg1.isPower() && arg1.exponent().isRealResult()) {
                return F.Power((IExpr)F.Abs(arg1.base()), arg1.exponent());
            }
            if (arg1.isNumericFunction(true) && (re = arg1.re()).isFree(S.Re) && re.isFree(S.Im) && (im = arg1.im()).isFree(S.Re) && im.isFree(S.Im)) {
                return F.Sqrt(F.Plus((IExpr)F.Sqr(re), (IExpr)F.Sqr(im)));
            }
            if (arg1.isInterval()) {
                return IntervalSym.abs((IAST)arg1);
            }
            return F.NIL;
        }

        @Override
        public IAST getRuleAST() {
            return RULES;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(1536);
            super.setUp(newSymbol);
        }

        private static final class AbsTimesFunction
        implements Function<IExpr, IExpr> {
            private AbsTimesFunction() {
            }

            @Override
            public IExpr apply(IExpr expr) {
                if (expr.isNumber()) {
                    return ((INumber)expr).abs();
                }
                IExpr temp = F.eval(F.Abs(expr));
                if (!temp.isAbs()) {
                    return temp;
                }
                return F.NIL;
            }
        }

        private static final class AbsNumericFunction
        implements DoubleFunction<IExpr> {
            final ISymbol symbol;

            public AbsNumericFunction(ISymbol symbol) {
                this.symbol = symbol;
            }

            @Override
            public IExpr apply(double value) {
                double result;
                if (value < 2.147483647E9 && value > -2.147483648E9 && (result = Math.abs(value)) > 0.0) {
                    return this.symbol;
                }
                return F.NIL;
            }
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.Plus.setDefaultValue(F.C0);
            S.Plus.setEvaluator(CONST_PLUS);
            S.Times.setDefaultValue(F.C1);
            S.Times.setEvaluator(CONST_TIMES);
            S.Power.setDefaultValue(2, F.C1);
            S.Power.setEvaluator(CONST_POWER);
            S.Sqrt.setEvaluator(new Sqrt());
            S.Surd.setEvaluator(new Surd());
            S.Minus.setEvaluator(new Minus());
            S.Abs.setEvaluator(new Abs());
            S.AbsArg.setEvaluator(new AbsArg());
            S.AddTo.setEvaluator(new AddTo());
            S.Arg.setEvaluator(new Arg());
            S.Chop.setEvaluator(new Chop());
            S.Clip.setEvaluator(new Clip());
            S.Complex.setEvaluator(CONST_COMPLEX);
            S.ConditionalExpression.setEvaluator(new ConditionalExpression());
            S.Conjugate.setEvaluator(new Conjugate());
            S.CubeRoot.setEvaluator(new CubeRoot());
            S.Decrement.setEvaluator(new Decrement());
            S.Differences.setEvaluator(new Differences());
            S.DirectedInfinity.setEvaluator(new DirectedInfinity());
            S.Divide.setEvaluator(new Divide());
            S.DivideBy.setEvaluator(new DivideBy());
            S.Gamma.setEvaluator(new Gamma());
            S.GCD.setEvaluator(new GCD());
            S.HarmonicNumber.setEvaluator(new HarmonicNumber());
            S.Im.setEvaluator(new Im());
            S.Increment.setEvaluator(new Increment());
            S.LCM.setEvaluator(new LCM());
            S.MantissaExponent.setEvaluator(new MantissaExponent());
            S.N.setEvaluator(new N());
            S.Piecewise.setEvaluator(new Piecewise());
            S.PiecewiseExpand.setEvaluator(new PiecewiseExpand());
            S.Pochhammer.setEvaluator(new Pochhammer());
            S.Precision.setEvaluator(new Precision());
            S.PreDecrement.setEvaluator(new PreDecrement());
            S.PreIncrement.setEvaluator(new PreIncrement());
            S.Rational.setEvaluator(CONST_RATIONAL);
            S.Re.setEvaluator(new Re());
            S.RealAbs.setEvaluator(new RealAbs());
            S.RealSign.setEvaluator(new RealSign());
            S.Sign.setEvaluator(new Sign());
            S.SignCmp.setEvaluator(new SignCmp());
            S.Subtract.setEvaluator(new Subtract());
            S.SubtractFrom.setEvaluator(new SubtractFrom());
            S.TimesBy.setEvaluator(new TimesBy());
        }
    }
}

