/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.builtin;

import com.google.common.math.LongMath;
import edu.jas.arith.BigRational;
import edu.jas.arith.ModLong;
import edu.jas.arith.ModLongRing;
import edu.jas.poly.Complex;
import edu.jas.poly.ComplexRing;
import edu.jas.poly.GenPolynomial;
import edu.jas.poly.Monomial;
import edu.jas.poly.TermOrderByName;
import edu.jas.structure.RingElem;
import edu.jas.structure.RingFactory;
import edu.jas.ufd.FactorAbstract;
import edu.jas.ufd.FactorComplex;
import edu.jas.ufd.FactorFactory;
import edu.jas.ufd.GCDFactory;
import edu.jas.ufd.GreatestCommonDivisorAbstract;
import edu.jas.ufd.SquarefreeAbstract;
import edu.jas.ufd.SquarefreeFactory;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.basic.Config;
import org.matheclipse.core.builtin.Combinatoric;
import org.matheclipse.core.builtin.IOFunctions;
import org.matheclipse.core.builtin.NumberTheory;
import org.matheclipse.core.builtin.StructureFunctions;
import org.matheclipse.core.convert.JASConvert;
import org.matheclipse.core.convert.JASIExpr;
import org.matheclipse.core.convert.JASModInteger;
import org.matheclipse.core.convert.VariablesSet;
import org.matheclipse.core.eval.EvalAttributes;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.eval.PlusOp;
import org.matheclipse.core.eval.exception.ASTElementLimitExceeded;
import org.matheclipse.core.eval.exception.JASConversionException;
import org.matheclipse.core.eval.exception.LimitException;
import org.matheclipse.core.eval.exception.Validate;
import org.matheclipse.core.eval.interfaces.AbstractCoreFunctionEvaluator;
import org.matheclipse.core.eval.interfaces.AbstractFunctionEvaluator;
import org.matheclipse.core.eval.util.OptionArgs;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.expression.S;
import org.matheclipse.core.generic.Predicates;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IASTMutable;
import org.matheclipse.core.interfaces.IAssociation;
import org.matheclipse.core.interfaces.IBuiltInSymbol;
import org.matheclipse.core.interfaces.IComplex;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IFraction;
import org.matheclipse.core.interfaces.IInteger;
import org.matheclipse.core.interfaces.IPatternSequence;
import org.matheclipse.core.interfaces.IRational;
import org.matheclipse.core.interfaces.ISignedNumber;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.patternmatching.IPatternMatcher;
import org.matheclipse.core.polynomials.IPartialFractionGenerator;
import org.matheclipse.core.polynomials.PartialFractionGenerator;
import org.matheclipse.core.polynomials.PolynomialHomogenization;
import org.matheclipse.core.polynomials.longexponent.ExprMonomial;
import org.matheclipse.core.polynomials.longexponent.ExprPolynomial;
import org.matheclipse.core.polynomials.longexponent.ExprPolynomialRing;
import org.matheclipse.core.polynomials.longexponent.ExprRingFactory;
import org.matheclipse.core.visit.VisitorExpr;

public class Algebra {
    private static final Logger LOGGER = LogManager.getLogger();

    private static boolean appendPlus(IASTAppendable ast, IExpr expr) {
        if (ast.head().equals(S.Plus) && expr.head().equals(S.Plus)) {
            return ast.appendArgs((IAST)expr);
        }
        return ast.append(expr);
    }

    private static boolean checkPolyStruct(IAST ast, EvalEngine engine) {
        for (int i = 1; i < ast.size(); ++i) {
            IExpr arg = ast.get(i);
            if (i == ast.size() - 1 && arg.isRuleAST() || arg.isPolynomialStruct()) continue;
            IOFunctions.printMessage(ast.topHead(), "poly", F.list(arg), engine);
            return false;
        }
        return true;
    }

    public static IExpr[] cancelGCD(IExpr numerator, IExpr denominator) throws JASConversionException {
        IExpr[] result;
        if (denominator.isInteger() && numerator.isPlus() && (result = Cancel.cancelPlusIntegerGCD((IAST)numerator, (IInteger)denominator)) != null) {
            return result;
        }
        VariablesSet eVar = new VariablesSet(numerator);
        eVar.addVarList(denominator);
        if (eVar.size() == 0) {
            return null;
        }
        IASTAppendable vars = eVar.getVarList();
        PolynomialHomogenization substitutions = new PolynomialHomogenization(vars, EvalEngine.get());
        IExpr[] subst = substitutions.replaceForward(numerator, denominator);
        IExpr numeratorPolynomial = subst[0];
        IExpr denominatorPolynomial = subst[1];
        if (substitutions.size() > 0) {
            eVar.clear();
            eVar.addAll(substitutions.substitutedVariablesSet());
            vars = eVar.getVarList();
        }
        try {
            ExprPolynomialRing ring = new ExprPolynomialRing(vars);
            ExprPolynomial pol1 = ring.create(numeratorPolynomial);
            ExprPolynomial pol2 = ring.create(denominatorPolynomial);
            List<IExpr> varList = eVar.getVarList().copyTo();
            JASIExpr jas = new JASIExpr(varList, true);
            GenPolynomial<IExpr> p1 = jas.expr2IExprJAS(pol1);
            GenPolynomial<IExpr> p2 = jas.expr2IExprJAS(pol2);
            GreatestCommonDivisorAbstract engine = GCDFactory.getImplementation((RingFactory)ExprRingFactory.CONST);
            GenPolynomial gcd = engine.gcd(p1, p2);
            IExpr[] result2 = new IExpr[3];
            if (gcd.isONE()) {
                return null;
            }
            result2[0] = F.C1;
            result2[1] = F.eval(jas.exprPoly2Expr((GenPolynomial<IExpr>)p1.divide(gcd)));
            result2[2] = F.eval(jas.exprPoly2Expr((GenPolynomial<IExpr>)p2.divide(gcd)));
            result2[0] = substitutions.replaceBackward(result2[0]);
            result2[1] = substitutions.replaceBackward(result2[1]);
            result2[2] = substitutions.replaceBackward(result2[2]);
            return result2;
        }
        catch (RuntimeException ring) {
            try {
                List<IExpr> varList = eVar.getVarList().copyTo();
                ComplexRing cfac = new ComplexRing((RingFactory)BigRational.ZERO);
                JASConvert jas = new JASConvert((List<? extends IExpr>)varList, cfac);
                GenPolynomial p1 = jas.expr2JAS(numeratorPolynomial, false);
                GenPolynomial p2 = jas.expr2JAS(denominatorPolynomial, false);
                GreatestCommonDivisorAbstract engine = GCDFactory.getImplementation((RingFactory)cfac);
                GenPolynomial gcd = engine.gcd(p1, p2);
                IExpr[] result3 = new IExpr[3];
                if (gcd.isONE()) {
                    return null;
                }
                result3[0] = F.C1;
                result3[1] = F.eval(jas.complexPoly2Expr((GenPolynomial<Complex<BigRational>>)p1.divide(gcd)));
                result3[2] = F.eval(jas.complexPoly2Expr((GenPolynomial<Complex<BigRational>>)p2.divide(gcd)));
                result3[0] = substitutions.replaceBackward(result3[0]);
                result3[1] = substitutions.replaceBackward(result3[1]);
                result3[2] = substitutions.replaceBackward(result3[2]);
                return result3;
            }
            catch (RuntimeException e) {
                LOGGER.debug("Algebra.cancelGCD() failed", (Throwable)e);
                return null;
            }
        }
    }

    public static IExpr expand(IAST ast, Predicate<IExpr> patt, boolean expandNegativePowers, boolean distributePlus, boolean evalParts) {
        return Algebra.expand(ast, patt, expandNegativePowers, distributePlus, evalParts, false);
    }

    public static IExpr expand(IAST ast, Predicate<IExpr> patt, boolean expandNegativePowers, boolean distributePlus, boolean evalParts, boolean factorTerms) {
        Expand.Expander expander = new Expand.Expander(patt, expandNegativePowers, distributePlus, evalParts, factorTerms);
        return expander.expandAST(ast);
    }

    public static IExpr expandAll(IAST ast, Predicate<IExpr> patt, boolean expandNegativePowers, boolean distributePlus, boolean factorTerms, EvalEngine engine) {
        if (patt != null && ast.isFree(patt, true)) {
            return F.NIL;
        }
        IAST localAST = ast;
        IAST tempAST = F.NIL;
        if (localAST.isEvalFlagOff(512) && (tempAST = engine.evalFlatOrderlessAttributesRecursive(localAST)).isPresent()) {
            localAST = tempAST;
        }
        if (localAST.isAllExpanded() && expandNegativePowers && !distributePlus) {
            if (localAST != ast) {
                return localAST;
            }
            return F.NIL;
        }
        IASTAppendable[] result = new IASTAppendable[]{F.NIL};
        IExpr temp = F.NIL;
        int localASTSize = localAST.size();
        IExpr head = localAST.head();
        if (head.isAST()) {
            temp = Algebra.expandAll((IAST)head, patt, expandNegativePowers, distributePlus, factorTerms, engine);
            temp.ifPresent(x -> {
                result[0] = F.ast(x, localASTSize);
                return result[0];
            });
        }
        IAST localASTFinal = localAST;
        localAST.forEach((x, i) -> {
            IExpr t;
            if (x.isAST() && (t = Algebra.expandAll((IAST)x, patt, expandNegativePowers, distributePlus, factorTerms, engine)).isPresent()) {
                if (!result[0].isPresent()) {
                    int size = localASTSize;
                    if (t.isAST()) {
                        size += ((IAST)t).size();
                    }
                    result[0] = F.ast(head, size);
                    result[0].appendArgs(localASTFinal, i);
                }
                Algebra.appendPlus(result[0], t);
                return;
            }
            result[0].ifAppendable(r -> r.append((IExpr)x));
        });
        if (!result[0].isPresent()) {
            temp = Algebra.expand(localAST, patt, expandNegativePowers, distributePlus, true, factorTerms);
            if (temp.isPresent()) {
                ExpandAll.setAllExpanded(temp, expandNegativePowers, distributePlus);
                return temp;
            }
            if (localAST != ast) {
                ExpandAll.setAllExpanded(localAST, expandNegativePowers, distributePlus);
                return localAST;
            }
            ExpandAll.setAllExpanded(ast, expandNegativePowers, distributePlus);
            return F.NIL;
        }
        temp = Algebra.expand(result[0], patt, expandNegativePowers, distributePlus, true, factorTerms);
        if (temp.isPresent()) {
            return ExpandAll.setAllExpanded(temp, expandNegativePowers, distributePlus);
        }
        return ExpandAll.setAllExpanded(result[0], expandNegativePowers, distributePlus);
    }

    public static IExpr factorComplex(IExpr expr, List<IExpr> varList, ISymbol head, boolean gaussianIntegers, EvalEngine engine) {
        return Algebra.factorComplex(expr, varList, head, false, gaussianIntegers, engine);
    }

    private static IExpr factorComplex(IExpr expr, List<IExpr> varList, ISymbol head, boolean numeric2Rational, boolean gaussianIntegers, EvalEngine engine) {
        try {
            if (gaussianIntegers) {
                ComplexRing cfac = new ComplexRing((RingFactory)BigRational.ZERO);
                JASConvert jas = new JASConvert((List<? extends IExpr>)varList, cfac);
                GenPolynomial polyRat = jas.expr2JAS(expr, numeric2Rational);
                return engine.evaluate(Algebra.factorComplex(expr, polyRat, jas, head, (ComplexRing<BigRational>)cfac));
            }
            JASConvert<BigRational> jas = new JASConvert<BigRational>(varList, (RingFactory<BigRational>)BigRational.ZERO);
            GenPolynomial polyRat = jas.expr2JAS(expr, numeric2Rational);
            return Algebra.factorRational(polyRat, jas, head);
        }
        catch (RuntimeException rex) {
            LOGGER.debug("Algebra.factorComplex() failed", (Throwable)rex);
            return expr;
        }
    }

    private static IExpr factorComplex(IExpr expr, GenPolynomial<Complex<BigRational>> polynomial, JASConvert<? extends RingElem<?>> jas, ISymbol head, ComplexRing<BigRational> cfac) {
        FactorComplex factorAbstract = new FactorComplex(cfac);
        SortedMap map = factorAbstract.factors(polynomial);
        IASTAppendable result = F.ast((IExpr)head, map.size());
        for (Map.Entry entry : map.entrySet()) {
            if (((GenPolynomial)entry.getKey()).isONE() && ((Long)entry.getValue()).equals(1L)) continue;
            IExpr key = jas.complexPoly2Expr((GenPolynomial<Complex<BigRational>>)((GenPolynomial)entry.getKey()));
            if (((Long)entry.getValue()).equals(1L) && map.size() <= 2 && (key.equals(F.CNI) || key.equals(F.CI))) {
                return expr;
            }
            result.append(F.Power(jas.complexPoly2Expr((GenPolynomial<Complex<BigRational>>)((GenPolynomial)entry.getKey())), F.ZZ((Long)entry.getValue())));
        }
        return result;
    }

    private static IAST factorModulus(IExpr expr, List<IExpr> varList, boolean factorSquareFree, IExpr option) throws JASConversionException {
        try {
            ModLongRing modIntegerRing = JASModInteger.option2ModLongRing((ISignedNumber)option);
            JASModInteger jas = new JASModInteger(varList, modIntegerRing);
            GenPolynomial<ModLong> poly = jas.expr2JAS(expr);
            return Algebra.factorModulus(jas, modIntegerRing, poly, factorSquareFree);
        }
        catch (ArithmeticException ae) {
            LOGGER.debug("Algebra.factorModulus() failed", (Throwable)ae);
            return F.NIL;
        }
    }

    public static IAST factorModulus(JASModInteger jas, ModLongRing modIntegerRing, GenPolynomial<ModLong> poly, boolean factorSquareFree) {
        SortedMap map;
        try {
            FactorAbstract factorAbstract = FactorFactory.getImplementation((ModLongRing)modIntegerRing);
            map = factorSquareFree ? factorAbstract.squarefreeFactors(poly) : factorAbstract.factors(poly);
        }
        catch (RuntimeException rex) {
            return F.NIL;
        }
        IASTAppendable result = F.TimesAlloc(map.size());
        for (Map.Entry entry : map.entrySet()) {
            GenPolynomial singleFactor = (GenPolynomial)entry.getKey();
            Long val = (Long)entry.getValue();
            result.append(F.Power(jas.modLongPoly2Expr((GenPolynomial<ModLong>)singleFactor), F.ZZ(val)));
        }
        return result;
    }

    public static IAST factorRational(GenPolynomial<BigRational> polyRat, JASConvert<BigRational> jas, ISymbol head) {
        Object[] objects = jas.factorTerms(polyRat);
        GenPolynomial poly = (GenPolynomial)objects[2];
        FactorAbstract factorAbstract = FactorFactory.getImplementation((edu.jas.arith.BigInteger)edu.jas.arith.BigInteger.ONE);
        SortedMap map = factorAbstract.factors(poly);
        IASTAppendable result = F.ast((IExpr)head, map.size() + 1);
        BigInteger gcd = (BigInteger)objects[0];
        BigInteger lcm = (BigInteger)objects[1];
        if (!gcd.equals(BigInteger.ONE) || !lcm.equals(BigInteger.ONE)) {
            result.append(F.fraction(gcd, lcm));
        }
        for (Map.Entry entry : map.entrySet()) {
            GenPolynomial key = (GenPolynomial)entry.getKey();
            Long value = (Long)entry.getValue();
            if (key.isONE() && value.equals(1L)) continue;
            if (value == 1L) {
                result.append(jas.integerPoly2Expr((GenPolynomial<edu.jas.arith.BigInteger>)key));
                continue;
            }
            result.append(F.Power(jas.integerPoly2Expr((GenPolynomial<edu.jas.arith.BigInteger>)key), F.ZZ(value)));
        }
        return result;
    }

    static IExpr factorTermsPlus(IAST plusAST, EvalEngine engine) {
        IRational gcd1 = null;
        if (plusAST.arg1().isRational()) {
            gcd1 = (IRational)plusAST.arg1();
        } else if (plusAST.arg1().isTimes() && plusAST.arg1().first().isRational()) {
            gcd1 = (IRational)plusAST.arg1().first();
        }
        if (gcd1 == null) {
            return F.NIL;
        }
        for (int i = 2; i < plusAST.size(); ++i) {
            IRational gcd2 = null;
            if (plusAST.get(i).isRational()) {
                gcd2 = (IRational)plusAST.get(i);
            } else if (plusAST.get(i).isTimes() && plusAST.get(i).first().isRational()) {
                gcd2 = (IRational)plusAST.get(i).first();
            }
            if (gcd2 == null) {
                return F.NIL;
            }
            IExpr gcd12 = engine.evaluate(F.GCD(gcd1, gcd2));
            if (!gcd12.isRational() || gcd12.isOne()) {
                return F.NIL;
            }
            gcd1 = (IRational)gcd12;
        }
        if (gcd1.isMinusOne()) {
            return F.NIL;
        }
        return engine.evaluate(F.Times((IExpr)gcd1, (IExpr)F.Expand(F.Times((IExpr)gcd1.inverse(), (IExpr)plusAST))));
    }

    public static IExpr[] getNumeratorDenominator(IAST ast, EvalEngine engine) {
        IExpr[] result = new IExpr[3];
        result[2] = Algebra.together(ast, engine);
        result[1] = engine.evaluate(F.Denominator(result[2]));
        result[0] = !result[1].isOne() ? engine.evaluate(F.Numerator(result[2])) : ast;
        return result;
    }

    public static IExpr[] fractionalPartsTimesPower(IAST timesPower, boolean splitNumeratorOne, boolean splitFractionalNumbers, boolean trig, boolean evalParts, boolean negateNumerDenom, boolean splitPowerPlusExponents) {
        if (timesPower.isPower()) {
            IExpr[] parts = Apart.fractionalPartsPower(timesPower, trig, splitPowerPlusExponents);
            if (parts != null) {
                return parts;
            }
            return null;
        }
        IAST timesAST = timesPower;
        IExpr[] result = new IExpr[3];
        result[2] = null;
        IASTAppendable numerator = F.TimesAlloc(timesAST.size());
        IASTAppendable denominator = F.TimesAlloc(timesAST.size());
        boolean evaled = false;
        boolean splitFractionEvaled = false;
        for (int i = 1; i < timesAST.size(); ++i) {
            IExpr arg = timesAST.get(i);
            if (arg.isAST()) {
                IExpr[] parts;
                IAST argAST = (IAST)arg;
                if (trig && argAST.isAST1()) {
                    IExpr denomForm;
                    IExpr numerForm = Numerator.getTrigForm(argAST, trig);
                    if (numerForm.isPresent() && (denomForm = Denominator.getTrigForm(argAST, trig)).isPresent()) {
                        if (!numerForm.isOne()) {
                            numerator.append(numerForm);
                        }
                        if (!denomForm.isOne()) {
                            denominator.append(denomForm);
                        }
                        evaled = true;
                        continue;
                    }
                } else if (arg.isPower() && (parts = Apart.fractionalPartsPower((IAST)arg, trig, splitPowerPlusExponents)) != null) {
                    if (!parts[0].isOne()) {
                        numerator.append(parts[0]);
                    }
                    if (!parts[1].isOne()) {
                        denominator.append(parts[1]);
                    }
                    evaled = true;
                    continue;
                }
            } else if (i == 1 && arg.isFraction()) {
                IFraction fr;
                if (splitNumeratorOne) {
                    fr = (IFraction)arg;
                    if (fr.numerator().isOne()) {
                        denominator.append(fr.denominator());
                        splitFractionEvaled = true;
                        continue;
                    }
                    if (fr.numerator().isMinusOne()) {
                        numerator.append(fr.numerator());
                        denominator.append(fr.denominator());
                        splitFractionEvaled = true;
                        continue;
                    }
                    result[2] = fr;
                    continue;
                }
                if (splitFractionalNumbers) {
                    fr = (IFraction)arg;
                    if (!fr.numerator().isOne()) {
                        numerator.append(fr.numerator());
                    }
                    denominator.append(fr.denominator());
                    evaled = true;
                    continue;
                }
            }
            numerator.append(arg);
        }
        if (evaled) {
            if (evalParts) {
                result[0] = F.eval(numerator);
                result[1] = F.eval(denominator);
            } else {
                result[0] = numerator.oneIdentity1();
                result[1] = denominator.oneIdentity1();
            }
            if (negateNumerDenom && result[0].isNegative() && result[1].isPlus() && ((IAST)result[1]).isAST2()) {
                result[0] = result[0].negate();
                result[1] = result[1].negate();
            }
            return result;
        }
        if (splitFractionEvaled) {
            result[0] = numerator.oneIdentity1();
            if (!result[0].isTimes() && !result[0].isPlus()) {
                result[1] = denominator.oneIdentity1();
                return result;
            }
            if (result[0].isTimes() && ((IAST)result[0]).isAST2() && ((IAST)result[0]).arg1().isMinusOne()) {
                result[1] = denominator.oneIdentity1();
                return result;
            }
        }
        return null;
    }

    public static IExpr[] fractionalParts(IExpr arg, boolean trig) {
        IExpr[] parts = null;
        if (arg.isAST()) {
            IAST ast = (IAST)arg;
            if (arg.isTimes()) {
                parts = Algebra.fractionalPartsTimesPower(ast, false, true, trig, true, true, true);
            } else if (arg.isPower()) {
                parts = Apart.fractionalPartsPower(ast, trig, true);
            } else {
                IExpr denomForm;
                IExpr numerForm = Numerator.getTrigForm(ast, trig);
                if (numerForm.isPresent() && (denomForm = Denominator.getTrigForm(ast, trig)).isPresent()) {
                    parts = new IExpr[]{numerForm, denomForm};
                    return parts;
                }
            }
        }
        return parts;
    }

    public static IExpr partsApart(IExpr[] parts, IExpr variable, EvalEngine engine) {
        IExpr temp = Algebra.partialFractionDecompositionRational((IPartialFractionGenerator)new PartialFractionGenerator(), parts, variable);
        if (temp.isPresent()) {
            return temp;
        }
        temp = S.Factor.of(parts[1]);
        if (temp.isTimes()) {
            return Algebra.partialFractionDecomposition(parts[0], temp, variable, 0, engine);
        }
        return F.NIL;
    }

    public static IExpr partialFractionDecompositionRational(IPartialFractionGenerator pf, IExpr[] parts, IExpr variable) {
        return Algebra.partialFractionDecompositionRational(pf, parts, F.list(variable));
    }

    public static IExpr partialFractionDecomposition(IExpr numerator, IExpr denominatorTimes, IExpr variable, int count, EvalEngine engine) {
        IExpr v2;
        if (!denominatorTimes.isTimes()) {
            return S.Times.of(engine, numerator, F.Power(denominatorTimes, -1L));
        }
        IExpr first = denominatorTimes.first();
        IExpr rest = denominatorTimes.rest().oneIdentity1();
        if (first.isFree(variable)) {
            return S.Times.of(engine, F.Power(first, -1L), Algebra.partialFractionDecomposition(numerator, rest, variable, count + 1, engine));
        }
        IExpr v1 = S.Expand.of(engine, first);
        IExpr peGCD = S.PolynomialExtendedGCD.of(engine, v1, v2 = S.Expand.of(engine, rest), variable);
        if (peGCD.isList() && peGCD.second().isList()) {
            IExpr u2;
            IAST s = (IAST)peGCD.second();
            IExpr A = s.arg1();
            IExpr B = s.arg2();
            IExpr u1 = S.PolynomialRemainder.ofNIL(engine, F.Expand(F.Times(B, numerator)), v1, variable);
            if (u1.isPresent() && (u2 = S.PolynomialRemainder.ofNIL(engine, F.Expand(F.Times(A, numerator)), v2, variable)).isPresent()) {
                return S.Plus.of(engine, F.Times(u1, F.Power(first, -1L)), Algebra.partialFractionDecomposition(u2, rest, variable, count + 1, engine));
            }
            if (count == 0) {
                return F.NIL;
            }
            return S.Times.of(engine, numerator, F.Power(denominatorTimes, -1L));
        }
        if (count == 0) {
            return F.NIL;
        }
        return S.Times.of(engine, numerator, F.Power(denominatorTimes, -1L));
    }

    public static IExpr partialFractionDecompositionRational(IPartialFractionGenerator pf, IExpr[] parts, IAST variableList) {
        try {
            IExpr exprNumerator = F.evalExpandAll(parts[0]);
            IExpr exprDenominator = F.evalExpandAll(parts[1]);
            List<IExpr> varList = variableList.copyTo();
            String[] varListStr = new String[]{variableList.arg1().toString()};
            JASConvert<BigRational> jas = new JASConvert<BigRational>(varList, (RingFactory<BigRational>)BigRational.ZERO);
            GenPolynomial numerator = jas.expr2JAS(exprNumerator, false);
            GenPolynomial denominator = jas.expr2JAS(exprDenominator, false);
            FactorAbstract factorAbstract = FactorFactory.getImplementation((BigRational)BigRational.ZERO);
            SortedMap sfactors = factorAbstract.baseFactors(denominator);
            ArrayList D2 = new ArrayList(sfactors.keySet());
            SquarefreeAbstract sqf = SquarefreeFactory.getImplementation((BigRational)BigRational.ZERO);
            List Ai = sqf.basePartialFraction(numerator, sfactors);
            if (Ai.size() > 0) {
                pf.allocPlus(Ai.size() * 2);
                pf.setJAS(jas);
                if (!((GenPolynomial)((List)Ai.get(0)).get(0)).isZERO()) {
                    pf.addNonFractionalPart((GenPolynomial<BigRational>)((GenPolynomial)((List)Ai.get(0)).get(0)));
                }
                for (int i = 1; i < Ai.size(); ++i) {
                    List list = (List)Ai.get(i);
                    int j = 0;
                    for (GenPolynomial genPolynomial : list) {
                        if (!genPolynomial.isZERO()) {
                            GenPolynomial Di_1 = (GenPolynomial)D2.get(i - 1);
                            pf.addSinglePartialFraction((GenPolynomial<BigRational>)genPolynomial, (GenPolynomial<BigRational>)Di_1, j);
                        }
                        ++j;
                    }
                }
                return pf.getResult();
            }
        }
        catch (RuntimeException e) {
            LOGGER.debug("Algebra.partialFractionDecompositionRational() failed", (Throwable)e);
        }
        return F.NIL;
    }

    public static IExpr[] fractionalPartsRational(IExpr arg) {
        if (arg.isFraction()) {
            IFraction fr = (IFraction)arg;
            IExpr[] parts = new IExpr[]{fr.numerator(), fr.denominator()};
            return parts;
        }
        if (arg.isComplex()) {
            IRational re = ((IComplex)arg).getRealPart();
            IRational im = ((IComplex)arg).getImaginaryPart();
            if (re.isFraction() || im.isFraction()) {
                IExpr[] parts = new IExpr[]{re.numerator().times(im.denominator()).add(im.numerator().times(re.denominator()).times(F.CI)), re.denominator().times(im.denominator())};
                return parts;
            }
            return null;
        }
        return Algebra.fractionalParts(arg, false);
    }

    public static IExpr together(IAST ast, EvalEngine engine) {
        IExpr result = Together.togetherExpr(ast, engine);
        if (result.isPresent()) {
            return engine.evaluate(result);
        }
        return ast;
    }

    public static IAST substituteVariablesInPolynomial(IExpr polyExpr, IAST variablesList, String dummyStr) {
        IASTAppendable substitutedVariableList = F.ListAlloc(variablesList.size());
        for (int i = 1; i < variablesList.size(); ++i) {
            IExpr variable = variablesList.get(i);
            if (variable.isAST() && !variable.isPower()) {
                ISymbol dummy = F.Dummy(dummyStr + i);
                polyExpr = F.subst(polyExpr, F.Rule(variable, (IExpr)dummy));
                substitutedVariableList.append(dummy);
                continue;
            }
            substitutedVariableList.append(variable);
        }
        return F.list(polyExpr, substitutedVariableList);
    }

    public static void initialize() {
        Initializer.init();
    }

    private Algebra() {
    }

    private static class Variables
    extends AbstractFunctionEvaluator {
        private Variables() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return VariablesSet.getAlgebraicVariables(ast.arg1());
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class Together
    extends AbstractFunctionEvaluator {
        private static IBuiltInSymbol reduceConstantTerm = F.localFunction("reduceConstantTerm", c -> {
            if (c.isNumber()) {
                return F.list(c, F.C1);
            }
            if (c.isTimes() && c.first().isNumber()) {
                return F.list(c.first(), c.rest().oneIdentity1());
            }
            return F.list(F.C1, c);
        });

        private Together() {
        }

        private static IExpr reduceFactorConstant(IExpr p, EvalEngine engine) {
            if (!engine.isNumericMode() && p.isPlus() && !engine.isTogetherMode()) {
                IExpr e = p;
                IExpr cTerms = S.Transpose.of(engine, F.Map(F.Function(F.unaryAST1(reduceConstantTerm, F.Slot1)), F.Apply(S.List, e))).first();
                if (cTerms.isPresent()) {
                    IExpr gcd;
                    IExpr c = S.Apply.of(engine, S.GCD, cTerms);
                    if (cTerms.last().isNegative()) {
                        c = c.negate();
                    }
                    if (!c.isFree(x -> x.isInexactNumber(), false)) {
                        gcd = engine.evaluate(F.Rationalize(c));
                        gcd = engine.evalN(gcd);
                    } else {
                        gcd = engine.evaluate(c);
                    }
                    if (gcd.isFree(S.GCD)) {
                        return F.Times(gcd, S.Distribute.of(engine, F.Divide(e, gcd)));
                    }
                }
            }
            return p;
        }

        private static IASTMutable togetherForEach(IAST ast, EvalEngine engine) {
            IASTMutable result = F.NIL;
            for (int i = 1; i < ast.size(); ++i) {
                IExpr temp;
                IExpr arg = ast.get(i);
                if (!arg.isAST() || !(temp = Together.togetherNull((IAST)arg, engine)).isPresent()) continue;
                if (!result.isPresent()) {
                    result = ast.copy();
                }
                result.set(i, temp);
            }
            return result;
        }

        private static IExpr togetherNull(IAST ast, EvalEngine engine) {
            IExpr result;
            boolean evaled = false;
            IExpr temp = Algebra.expandAll(ast, null, true, false, true, engine);
            if (!temp.isPresent()) {
                temp = ast;
            } else {
                evaled = true;
            }
            if (temp.isAST() && (result = Together.togetherPlusTimesPower((IAST)temp, engine)).isPresent()) {
                return engine.evaluate(result);
            }
            if (evaled) {
                return temp;
            }
            return F.NIL;
        }

        private static IExpr togetherPlus(IAST plusAST) {
            if (plusAST.size() <= 2) {
                return F.NIL;
            }
            IASTAppendable numerator = F.ast((IExpr)S.Plus, plusAST.size());
            IASTAppendable denominator = F.ast((IExpr)S.Times, plusAST.size());
            boolean[] evaled = new boolean[1];
            plusAST.forEach((x, i) -> Together.togetherPlusArg(x, i, numerator, denominator, evaled));
            if (!evaled[0]) {
                return F.NIL;
            }
            numerator.forEach((x, i) -> Together.togetherPlusNumeratorArg(x, i, numerator, denominator, plusAST));
            int i2 = 1;
            while (denominator.size() > i2) {
                if (denominator.get(i2).isOne()) {
                    denominator.remove(i2);
                    continue;
                }
                ++i2;
            }
            if (denominator.isAST0()) {
                return F.NIL;
            }
            IExpr exprNumerator = F.evalExpand(numerator.oneIdentity0());
            IExpr denom = F.eval(denominator.oneIdentity1());
            IExpr exprDenominator = F.evalExpand(denom);
            if (exprNumerator.isZero()) {
                if (exprDenominator.isZero()) {
                    return F.Times(exprNumerator, (IExpr)F.Power(exprDenominator, F.CN1));
                }
                return F.C0;
            }
            if (!exprDenominator.isOne()) {
                try {
                    IExpr[] result = Algebra.cancelGCD(exprNumerator, exprDenominator);
                    if (result != null) {
                        IExpr pInv = result[2].inverse();
                        if (result[0].isOne()) {
                            return F.Times(pInv, result[1]);
                        }
                        return F.Times(result[0], result[1], pInv);
                    }
                    return F.Times(exprNumerator, F.Power(denom, -1L));
                }
                catch (JASConversionException jce) {
                    LOGGER.debug("Together.togetherPlus()", (Throwable)((Object)jce));
                    return F.Times(exprNumerator, (IExpr)F.Power(denom, F.CN1));
                }
            }
            return exprNumerator;
        }

        private static void togetherPlusNumeratorArg(IExpr xarg, int position, IASTAppendable numerator, IASTAppendable denominator, IAST plusAST) {
            IASTAppendable ni = F.TimesAlloc(plusAST.argSize());
            ni.append(xarg);
            for (int j = 1; j < plusAST.size(); ++j) {
                IExpr arg;
                if (position == j || (arg = denominator.get(j)).isOne()) continue;
                ni.append(arg);
            }
            numerator.set(position, ni.oneIdentity1());
        }

        private static void togetherPlusArg(IExpr x, int i, IASTAppendable numerator, IASTAppendable denominator, boolean[] evaled) {
            if (x.isFraction()) {
                numerator.append(i, ((IFraction)x).numerator());
                denominator.append(i, ((IFraction)x).denominator());
            } else if (x.isComplex()) {
                IRational re = ((IComplex)x).getRealPart();
                IRational im = ((IComplex)x).getImaginaryPart();
                if (re.isFraction() || im.isFraction()) {
                    numerator.append(i, re.numerator().times(im.denominator()).add(im.numerator().times(re.denominator()).times(F.CI)));
                    denominator.append(i, re.denominator().times(im.denominator()));
                } else {
                    numerator.append(i, x);
                    denominator.append(i, F.C1);
                }
            } else {
                IExpr[] fractionalParts = Algebra.fractionalParts(x, false);
                if (fractionalParts != null) {
                    numerator.append(i, fractionalParts[0]);
                    IExpr temp = fractionalParts[1];
                    if (!temp.isOne()) {
                        evaled[0] = true;
                    }
                    denominator.append(i, temp);
                } else {
                    numerator.append(i, x);
                    denominator.append(i, F.C1);
                }
            }
        }

        private static IExpr togetherPlusTimesPower(IAST ast, EvalEngine engine) {
            if (ast.isPlus()) {
                IASTMutable result = Together.togetherForEach(ast, engine);
                if (result.isPresent()) {
                    return Together.togetherPlus(result).orElse(result);
                }
                return Together.togetherPlus(ast);
            }
            if (ast.isTimes() || ast.isPower()) {
                try {
                    IASTMutable result = F.NIL;
                    result = ast.isTimes() ? Together.togetherForEach(ast, engine) : Together.togetherPower(ast, result, engine);
                    if (result.isPresent()) {
                        IExpr temp = engine.evaluate(result);
                        if (temp.isTimes() || temp.isPower()) {
                            return Cancel.togetherPowerTimes(temp).orElse(temp);
                        }
                        return temp;
                    }
                    return Cancel.togetherPowerTimes(ast);
                }
                catch (JASConversionException jce) {
                    LOGGER.debug("Together.togetherPlusTimesPower() failed", (Throwable)((Object)jce));
                }
            }
            return F.NIL;
        }

        private static IASTMutable togetherPower(IAST ast, IASTMutable result, EvalEngine engine) {
            IExpr temp;
            if (ast.arg1().isAST() && (temp = Together.togetherNull((IAST)ast.arg1(), engine)).isPresent()) {
                if (!result.isPresent()) {
                    result = ast.copy();
                }
                if (ast.arg2().isNegative() && temp.isTimes()) {
                    IExpr[] fractionalParts = Algebra.fractionalPartsRational(temp);
                    if (fractionalParts != null) {
                        result.set(1, F.Divide(fractionalParts[1], fractionalParts[0]));
                        result.set(2, ast.arg2().negate());
                    } else {
                        result.set(1, temp);
                    }
                } else {
                    result.set(1, temp);
                }
            }
            return result;
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            IAST list = StructureFunctions.threadLogicEquationOperators(arg1, ast, 1);
            if (list.isPresent()) {
                return list;
            }
            if (arg1.isAST()) {
                return Together.togetherExpr(arg1, engine);
            }
            return arg1;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        private static IExpr togetherExpr(IExpr arg1, EvalEngine engine) {
            if (arg1.isPlusTimesPower()) {
                IExpr temp;
                IExpr times;
                if (arg1.isPower()) {
                    if (arg1.base().isAtom() && arg1.exponent().isAtom()) {
                        return arg1;
                    }
                    if (!arg1.exponent().isMinusOne() && arg1.base().isPlusTimesPower()) {
                        if (arg1.exponent().isNegative()) {
                            return F.Power(Together.togetherExpr(arg1.base().inverse(), engine), arg1.exponent().negate());
                        }
                        return F.Power(Together.togetherExpr(arg1.base(), engine), arg1.exponent());
                    }
                } else if (arg1.isTimes() && arg1.first().isAtom() && (times = ((IAST)arg1).splice(1).oneIdentity0()).isPower()) {
                    return F.Times(arg1.first(), Together.togetherExpr(times, engine));
                }
                if ((temp = Together.togetherNull((IAST)arg1, engine).orElse(arg1)).isPresent()) {
                    return Together.reduceFactorConstant(temp, engine);
                }
            }
            return Together.reduceFactorConstant(arg1, engine);
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static class Root
    extends AbstractFunctionEvaluator {
        private Root() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            return ToRadicals.rootToRadicals(ast, engine);
        }
    }

    private static class ToRadicals
    extends AbstractFunctionEvaluator {
        private ToRadicals() {
        }

        private static IAST root1(IExpr a, IExpr b, int nthRoot) {
            if (nthRoot != 1) {
                return F.NIL;
            }
            return F.Times((IExpr)F.CN1, a, F.Power(b, -1L));
        }

        private static IAST root2(IExpr a, IExpr b, IExpr c, int nthRoot) {
            if (nthRoot < 1 || nthRoot > 3) {
                return F.NIL;
            }
            IInteger k = F.ZZ(nthRoot);
            return F.Plus((IExpr)F.Times((IExpr)F.C1D2, (IExpr)F.Power((IExpr)F.CN1, k), (IExpr)F.Sqrt(F.Times((IExpr)F.Plus((IExpr)F.Sqr(b), (IExpr)F.Times((IExpr)F.CN4, a, c)), F.Power(c, -2L)))), (IExpr)F.Times((IExpr)F.CN1D2, b, F.Power(c, -1L)));
        }

        private static IAST root3(IExpr a, IExpr b, IExpr c, IExpr d, int nthRoot) {
            if (nthRoot < 1 || nthRoot > 3) {
                return F.NIL;
            }
            IInteger k = F.ZZ(nthRoot);
            IAST r = F.Plus(F.Negate(F.Sqr(c)), (IExpr)F.Times((IExpr)F.C3, b, d));
            IAST q = F.Plus((IExpr)F.Times((IExpr)F.CN2, F.Power(c, 3L)), (IExpr)F.Times(F.C9, b, c, d), (IExpr)F.Times((IExpr)F.ZZ(-27), a, (IExpr)F.Sqr(d)));
            IAST p = F.Power((IExpr)F.Plus((IExpr)q, (IExpr)F.Sqrt(F.Plus((IExpr)F.Sqr(q), (IExpr)F.Times((IExpr)F.C4, F.Power((IExpr)r, 3L))))), F.C1D3);
            return F.Plus((IExpr)F.Times((IExpr)F.CN1D3, c, F.Power(d, -1L)), (IExpr)F.Times(F.CN1D3, F.Power((IExpr)S.E, F.Times((IExpr)F.CC(0L, 1L, -2L, 3L), (IExpr)F.Plus((IExpr)F.CN1, (IExpr)k), (IExpr)S.Pi)), F.Power((IExpr)p, -1L), r, F.Power((IExpr)F.C2, F.C1D3), F.Power(d, -1L)), (IExpr)F.Times(F.C1D3, F.Power((IExpr)F.C2, F.CN1D3), F.Power((IExpr)S.E, F.Times((IExpr)F.CC(0L, 1L, 2L, 3L), (IExpr)F.Plus((IExpr)F.CN1, (IExpr)k), (IExpr)S.Pi)), F.Power(d, -1L), p));
        }

        private static IAST root4(IExpr a, IExpr b, IExpr c, IExpr d, IExpr e, int nthRoot) {
            if (nthRoot < 1 || nthRoot > 4) {
                return F.NIL;
            }
            IInteger k = F.ZZ(nthRoot);
            IAST t = F.Sqrt(F.Plus((IExpr)F.Times((IExpr)F.CN4, F.Power((IExpr)F.Plus((IExpr)F.Sqr(c), (IExpr)F.Times((IExpr)F.CN3, b, d), (IExpr)F.Times((IExpr)F.ZZ(12), a, e)), 3L)), (IExpr)F.Sqr(F.Plus((IExpr)F.Times((IExpr)F.CN9, c, (IExpr)F.Plus((IExpr)F.Times(b, d), (IExpr)F.Times((IExpr)F.C8, a, e))), (IExpr)F.Times((IExpr)F.ZZ(27), (IExpr)F.Plus((IExpr)F.Times(a, (IExpr)F.Sqr(d)), (IExpr)F.Times((IExpr)F.Sqr(b), e))), (IExpr)F.Times((IExpr)F.C2, F.Power(c, 3L))))));
            IAST s = F.Power((IExpr)F.Plus(F.Times((IExpr)F.C2, F.Power(c, 3L)), t, F.Times((IExpr)F.CN9, c, (IExpr)F.Plus((IExpr)F.Times(b, d), (IExpr)F.Times((IExpr)F.C8, a, e))), F.Times((IExpr)F.ZZ(27), (IExpr)F.Plus((IExpr)F.Times(a, (IExpr)F.Sqr(d)), (IExpr)F.Times((IExpr)F.Sqr(b), e)))), F.C1D3);
            IASTMutable eps1 = F.Times((IExpr)F.C1D2, (IExpr)F.Sqrt(F.Plus((IExpr)F.Times((IExpr)F.QQ(1L, 12L), (IExpr)F.Plus((IExpr)F.Times((IExpr)F.C3, (IExpr)F.Sqr(d)), (IExpr)F.Times((IExpr)F.CN8, c, e), (IExpr)F.Times(F.C2, e, s, F.Power((IExpr)F.C2, F.QQ(2L, 3L)))), F.Power(e, -2L)), (IExpr)F.Times(F.C1D3, F.Plus((IExpr)F.Sqr(c), (IExpr)F.Times((IExpr)F.CN3, b, d), (IExpr)F.Times((IExpr)F.ZZ(12), a, e)), F.Power((IExpr)F.C2, F.C1D3), F.Power(e, -1L), F.Power((IExpr)s, -1L)))));
            IAST u = F.Plus((IExpr)F.Times((IExpr)F.C8, (IExpr)F.Sqr(eps1)), (IExpr)F.Times(F.CN1, F.Plus(F.Times((IExpr)F.C2, (IExpr)F.Sqr(c)), F.Times((IExpr)F.CN6, b, d), F.Times((IExpr)F.ZZ(24), a, e), F.Times((IExpr)F.Power((IExpr)F.C2, F.C1D3), (IExpr)F.Sqr(s))), F.Power((IExpr)F.C2, F.QQ(-2L, 3L)), F.Power(e, -1L), F.Power((IExpr)s, -1L)));
            IAST v = F.Times(F.QQ(1L, 8L), F.Plus(F.Power(d, 3L), (IExpr)F.Times(F.CN4, c, d, e), (IExpr)F.Times((IExpr)F.C8, b, (IExpr)F.Sqr(e))), F.Power(e, -3L), F.Power((IExpr)eps1, -1L));
            IASTMutable eps2 = F.Times((IExpr)F.C1D2, (IExpr)F.Sqrt(F.Plus((IExpr)u, (IExpr)v)));
            IASTMutable eps3 = F.Times((IExpr)F.C1D2, (IExpr)F.Sqrt(F.Plus((IExpr)u, F.Negate(v))));
            return F.Plus(F.Times((IExpr)eps1, (IExpr)F.Plus((IExpr)F.CN1, (IExpr)F.Times((IExpr)F.C2, (IExpr)F.Floor(F.Times((IExpr)F.C1D2, (IExpr)F.Plus((IExpr)F.CN1, (IExpr)k)))))), F.Times((IExpr)eps2, (IExpr)F.Plus((IExpr)F.C1, F.Negate(F.UnitStep(F.Plus((IExpr)F.CN3, (IExpr)k)))), (IExpr)F.Power((IExpr)F.CN1, k)), F.Times((IExpr)eps3, (IExpr)F.Plus((IExpr)F.CN1, (IExpr)F.UnitStep(F.Plus((IExpr)F.C2, F.Negate(k)))), (IExpr)F.Power((IExpr)F.CN1, F.Plus((IExpr)F.C1, (IExpr)k))), F.Times((IExpr)F.CN1D4, d, F.Power(e, -1L)));
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.size() >= 2) {
                IExpr arg1 = ast.arg1();
                IExpr temp = StructureFunctions.threadLogicEquationOperators(arg1, ast, 1);
                if (temp.isPresent()) {
                    return temp;
                }
                if (arg1.isAST()) {
                    ToRadicalsVisitor visitor = new ToRadicalsVisitor(ast);
                    temp = ((IAST)arg1).accept(visitor);
                    if (temp.isPresent()) {
                        return temp;
                    }
                    temp = ToRadicals.rootToRadicals((IAST)arg1, engine);
                    if (temp.isPresent()) {
                        return temp;
                    }
                }
                return arg1;
            }
            return F.NIL;
        }

        private static IExpr rootToRadicals(IAST ast, EvalEngine engine) {
            IExpr expr;
            if (ast.size() == 3 && ast.arg2().isInteger() && (expr = ast.arg1()).isFunction()) {
                expr = expr.first();
                try {
                    int k = ast.arg2().toIntDefault();
                    if (k < 0) {
                        return F.NIL;
                    }
                    IAST variables = F.list(F.Slot1);
                    ExprPolynomialRing ring = new ExprPolynomialRing(ExprRingFactory.CONST, variables);
                    ExprPolynomial polynomial = ring.create(expr, false, true, false);
                    long varDegree = polynomial.degree(0);
                    if (polynomial.isConstant()) {
                        return F.CEmptyList;
                    }
                    if (varDegree >= 1L && varDegree <= 4L) {
                        IExpr a = F.C0;
                        IExpr b = F.C0;
                        IExpr c = F.C0;
                        IExpr d = F.C0;
                        IExpr e = F.C0;
                        for (ExprMonomial monomial : polynomial) {
                            IExpr coeff = monomial.coefficient();
                            long lExp = monomial.exponent().getVal(0);
                            if (lExp == 4L) {
                                e = coeff;
                                continue;
                            }
                            if (lExp == 3L) {
                                d = coeff;
                                continue;
                            }
                            if (lExp == 2L) {
                                c = coeff;
                                continue;
                            }
                            if (lExp == 1L) {
                                b = coeff;
                                continue;
                            }
                            if (lExp == 0L) {
                                a = coeff;
                                continue;
                            }
                            throw new ArithmeticException("Root::Unexpected exponent value: " + lExp);
                        }
                        IAST result = F.NIL;
                        result = varDegree == 1L ? ToRadicals.root1(a, b, k) : (varDegree == 2L ? ToRadicals.root2(a, b, c, k) : (varDegree == 3L ? ToRadicals.root3(a, b, c, d, k) : ToRadicals.root4(a, b, c, d, e, k)));
                        if (result.isPresent()) {
                            return engine.evaluate(result);
                        }
                    }
                }
                catch (JASConversionException e2) {
                    LOGGER.debug("ToRadicals.rootToRadicals() failed", (Throwable)((Object)e2));
                }
            }
            return F.NIL;
        }

        private static class ToRadicalsVisitor
        extends VisitorExpr {
            IAST replacement;

            private ToRadicalsVisitor(IAST replacement) {
                this.replacement = replacement;
            }

            @Override
            public IExpr visit(IASTMutable ast) {
                if (!ast.isAST(S.Root)) {
                    return ast.mapThread(this.replacement, 1);
                }
                return F.NIL;
            }
        }
    }

    private static class PowerExpand
    extends AbstractFunctionEvaluator {
        private PowerExpand() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isAST()) {
                OptionArgs options;
                IExpr option;
                boolean assumptions = false;
                if (ast.isAST2() && (option = (options = new OptionArgs(ast.topHead(), ast, ast.argSize(), engine)).getOption(S.Assumptions)).isTrue()) {
                    assumptions = true;
                }
                return PowerExpand.powerExpand((IAST)ast.arg1(), assumptions);
            }
            return ast.arg1();
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        public static IExpr powerExpand(IAST ast, boolean assumptions) {
            return ast.accept(new PowerExpandVisitor(assumptions)).orElse(ast);
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            this.setOptions(newSymbol, F.list(F.Rule((IExpr)S.Assumptions, (IExpr)S.Automatic)));
        }

        private static class PowerExpandVisitor
        extends VisitorExpr {
            final boolean assumptions;

            public PowerExpandVisitor(boolean assumptions) {
                this.assumptions = assumptions;
            }

            @Override
            public IExpr visit2(IExpr head, IExpr arg1) {
                boolean evaled = false;
                IExpr result = arg1.accept(this);
                if (result.isPresent()) {
                    evaled = true;
                    arg1 = result;
                }
                if (head.equals(S.Log)) {
                    if (arg1.isPower()) {
                        IASTMutable logResult = F.Times(arg1.exponent(), PowerExpand.powerExpand(F.Log(arg1.base()), this.assumptions));
                        if (this.assumptions) {
                            IAST floorResult = F.Floor(F.Divide(F.Subtract(S.Pi, F.Im(logResult)), F.Times((IExpr)F.C2, (IExpr)S.Pi)));
                            IAST timesResult = F.Times(F.C2, S.I, S.Pi, floorResult);
                            return F.Plus((IExpr)logResult, (IExpr)timesResult);
                        }
                        return logResult;
                    }
                    if (arg1.isTimes()) {
                        IAST timesAST = (IAST)arg1;
                        IASTMutable logResult = timesAST.setAtCopy(0, S.Plus);
                        logResult = logResult.mapThread(F.Log(F.Slot1), 1);
                        return PowerExpand.powerExpand(logResult, this.assumptions);
                    }
                } else if (head.equals(S.ProductLog) && arg1.isTimes2()) {
                    IExpr a1 = arg1.first();
                    IExpr a2 = arg1.second();
                    if (a2.isExp() && a2.second().equals(a1)) {
                        return a1;
                    }
                    if (a1.isExp() && a1.second().equals(a2)) {
                        return a2;
                    }
                }
                if (evaled) {
                    return F.unaryAST1(head, arg1);
                }
                return F.NIL;
            }

            @Override
            public IExpr visit3(IExpr head, IExpr arg1, IExpr arg2) {
                boolean evaled = false;
                IExpr x1 = arg1;
                IExpr result = arg1.accept(this);
                if (result.isPresent()) {
                    evaled = true;
                    x1 = result;
                }
                IExpr x2 = arg2;
                result = arg2.accept(this);
                if (result.isPresent()) {
                    evaled = true;
                    x2 = result;
                }
                if (head.equals(F.Power)) {
                    if (x1.isTimes()) {
                        IAST timesAST = (IAST)x1;
                        IASTMutable timesResult = timesAST.mapThread(F.Power((IExpr)F.Slot1, x2), 1);
                        if (this.assumptions) {
                            IASTAppendable plusResult = F.PlusAlloc(timesAST.size() + 1);
                            plusResult.append(F.C1D2);
                            plusResult.appendArgs(timesAST.size(), i -> F.Negate(F.Divide(F.Arg(timesAST.get(i)), F.Times((IExpr)F.C2, (IExpr)S.Pi))));
                            IAST expResult = F.Power((IExpr)S.E, F.Times(F.C2, S.I, S.Pi, x2, F.Floor(plusResult)));
                            if (!(timesResult instanceof IASTAppendable)) {
                                timesResult = timesResult.copyAppendable();
                            }
                            ((IASTAppendable)timesResult).append(expResult);
                            return timesResult;
                        }
                        return timesResult;
                    }
                    if (x1.isPower()) {
                        return this.power(x1, x2);
                    }
                }
                if (evaled) {
                    return F.binaryAST2(head, x1, x2);
                }
                return F.NIL;
            }

            private IExpr power(IExpr x1, IExpr z) {
                IExpr base = x1.base();
                IExpr exponent = x1.exponent();
                IAST powerResult = F.Power(base, F.Times(exponent, z));
                if (this.assumptions) {
                    IAST floorResult = F.Floor(F.Divide(F.Subtract(S.Pi, F.Im(F.Times(exponent, (IExpr)F.Log(base)))), F.Times((IExpr)F.C2, (IExpr)S.Pi)));
                    IAST expResult = F.Power((IExpr)S.E, F.Times(F.C2, S.I, S.Pi, z, floorResult));
                    IASTMutable timesResult = F.Times((IExpr)powerResult, (IExpr)expResult);
                    return timesResult;
                }
                return powerResult;
            }
        }
    }

    private static class PolynomialRemainder
    extends PolynomialQuotientRemainder {
        private PolynomialRemainder() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr variable;
            if (ast.arg3().isAST()) {
                variable = ast.arg3();
            } else {
                variable = Validate.checkIsVariable(ast, 3, engine);
                if (!variable.isPresent()) {
                    return F.NIL;
                }
            }
            IExpr arg1 = F.evalExpandAll(ast.arg1(), engine);
            IExpr arg2 = F.evalExpandAll(ast.arg2(), engine);
            if (arg2.isZero()) {
                return F.NIL;
            }
            if (!arg1.isPolynomialStruct()) {
                return IOFunctions.printMessage(ast.topHead(), "poly", F.list(arg1), engine);
            }
            if (!arg2.isPolynomialStruct()) {
                return IOFunctions.printMessage(ast.topHead(), "poly", F.list(arg2), engine);
            }
            try {
                if (ast.size() == 5) {
                    OptionArgs options = new OptionArgs(ast.topHead(), ast, 4, engine);
                    IExpr option = options.getOption(S.Modulus);
                    if (option.isInteger() && !option.isZero()) {
                        IExpr[] result = this.quotientRemainderModInteger(arg1, arg2, variable, option);
                        if (result == null) {
                            return F.NIL;
                        }
                        return result[1];
                    }
                    return F.NIL;
                }
                IExpr[] result = PolynomialRemainder.quotientRemainder(arg1, arg2, variable);
                if (result == null) {
                    return F.NIL;
                }
                return result[1];
            }
            catch (ArithmeticException aex) {
                LOGGER.log(engine.getLogLevel(), (Object)S.PolynomialRemainder, (Throwable)aex);
            }
            catch (RuntimeException rex) {
                LOGGER.debug("PolynomialRemainder.evaluate() failed", (Throwable)rex);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_3_4;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            this.setOptions(newSymbol, F.list(F.Rule((IExpr)S.Modulus, (IExpr)F.C0)));
        }
    }

    private static class PolynomialQuotientRemainder
    extends AbstractFunctionEvaluator {
        private PolynomialQuotientRemainder() {
        }

        public static IExpr[] quotientRemainder(IExpr arg1, IExpr arg2, IExpr variable) {
            if (arg1.isFree(variable) && arg2.isFree(variable)) {
                return new IExpr[]{F.Divide(arg1, arg2), F.C0};
            }
            try {
                JASConvert jas = new JASConvert(variable, BigRational.ZERO);
                GenPolynomial poly1 = jas.expr2JAS(arg1, false);
                GenPolynomial poly2 = jas.expr2JAS(arg2, false);
                GenPolynomial[] divRem = poly1.quotientRemainder(poly2);
                return new IExpr[]{jas.rationalPoly2Expr((GenPolynomial<BigRational>)divRem[0], false), jas.rationalPoly2Expr((GenPolynomial<BigRational>)divRem[1], false)};
            }
            catch (JASConversionException e1) {
                try {
                    ExprPolynomialRing ring = new ExprPolynomialRing(F.list(variable));
                    ExprPolynomial poly1 = ring.create(arg1);
                    ExprPolynomial poly2 = ring.create(arg2);
                    ExprPolynomial[] divRem = poly1.quotientRemainder(poly2);
                    if (divRem == null) {
                        return null;
                    }
                    return new IExpr[]{divRem[0].getExpr(), divRem[1].getExpr()};
                }
                catch (LimitException le) {
                    throw le;
                }
                catch (RuntimeException rex) {
                    LOGGER.debug("PolynomialQuotientRemainder.quotientRemainder() failed", (Throwable)rex);
                    return null;
                }
            }
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr variable;
            IExpr temp = engine.getCache(ast);
            if (temp != null) {
                return temp;
            }
            if (ast.arg3().isAST()) {
                variable = ast.arg3();
            } else {
                variable = Validate.checkIsVariable(ast, 3, engine);
                if (!variable.isPresent()) {
                    return F.NIL;
                }
            }
            IExpr arg1 = ast.arg1();
            IExpr arg2 = ast.arg2();
            if (!arg1.isPolynomialStruct()) {
                return IOFunctions.printMessage(ast.topHead(), "poly", F.list(arg1), engine);
            }
            if (!arg2.isPolynomialStruct()) {
                return IOFunctions.printMessage(ast.topHead(), "poly", F.list(arg2), engine);
            }
            try {
                arg1 = F.ExpandAll.of(engine, arg1);
                arg2 = F.ExpandAll.of(engine, arg2);
                if (arg2.isZero()) {
                    return F.NIL;
                }
                IAST result = F.NIL;
                if (ast.size() == 5) {
                    IExpr[] quotientRemainderModInteger;
                    OptionArgs options = new OptionArgs(ast.topHead(), ast, 4, engine);
                    IExpr option = options.getOption(S.Modulus);
                    if (option.isInteger() && !option.isZero() && (quotientRemainderModInteger = this.quotientRemainderModInteger(arg1, arg2, variable, option)) != null) {
                        result = F.list(quotientRemainderModInteger[0], quotientRemainderModInteger[1]);
                    }
                    engine.putCache(ast, result);
                    return result;
                }
                IExpr[] quotientRemainder = PolynomialQuotientRemainder.quotientRemainder(arg1, arg2, variable);
                if (quotientRemainder != null) {
                    result = F.list(quotientRemainder[0], quotientRemainder[1]);
                }
                engine.putCache(ast, result);
                return result;
            }
            catch (ArithmeticException aex) {
                LOGGER.log(engine.getLogLevel(), (Object)S.PolynomialQuotientRemainder, (Throwable)aex);
            }
            catch (RuntimeException rex) {
                LOGGER.debug("PolynomialQuotientRemainder.evaluate() failed", (Throwable)rex);
            }
            return F.NIL;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_3_4;
        }

        public IExpr[] quotientRemainderModInteger(IExpr arg1, IExpr arg2, IExpr variable, IExpr option) {
            try {
                ModLongRing modIntegerRing = JASModInteger.option2ModLongRing((ISignedNumber)option);
                JASModInteger jas = new JASModInteger(variable, modIntegerRing);
                GenPolynomial<ModLong> poly1 = jas.expr2JAS(arg1);
                GenPolynomial<ModLong> poly2 = jas.expr2JAS(arg2);
                if (poly2.isZERO()) {
                    return null;
                }
                GenPolynomial[] divRem = poly1.quotientRemainder(poly2);
                IExpr[] result = new IExpr[]{jas.modLongPoly2Expr((GenPolynomial<ModLong>)divRem[0]), jas.modLongPoly2Expr((GenPolynomial<ModLong>)divRem[1])};
                return result;
            }
            catch (JASConversionException e) {
                LOGGER.debug("PolynomialQuotientRemainder.quotientRemainderModInteger() failed", (Throwable)((Object)e));
                return null;
            }
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            this.setOptions(newSymbol, F.list(F.Rule((IExpr)S.Modulus, (IExpr)F.C0)));
        }
    }

    private static class PolynomialQuotient
    extends PolynomialQuotientRemainder {
        private PolynomialQuotient() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.size() == 4 || ast.size() == 5) {
                IExpr variable;
                if (ast.arg3().isAST()) {
                    variable = ast.arg3();
                } else {
                    variable = Validate.checkIsVariable(ast, 3, engine);
                    if (!variable.isPresent()) {
                        return F.NIL;
                    }
                }
                IExpr arg1 = ast.arg1();
                IExpr arg2 = ast.arg2();
                try {
                    arg1 = F.ExpandAll.of(engine, arg1);
                    arg2 = F.ExpandAll.of(engine, arg2);
                    if (arg1.isZero() || arg2.isZero()) {
                        return F.NIL;
                    }
                    if (!arg1.isPolynomialStruct()) {
                        return IOFunctions.printMessage(ast.topHead(), "poly", F.list(arg1), engine);
                    }
                    if (!arg2.isPolynomialStruct()) {
                        return IOFunctions.printMessage(ast.topHead(), "poly", F.list(arg2), engine);
                    }
                    if (ast.size() == 5) {
                        OptionArgs options = new OptionArgs(ast.topHead(), ast, 4, engine);
                        IExpr option = options.getOption(S.Modulus);
                        if (option.isInteger() && !option.isZero()) {
                            IExpr[] result = this.quotientRemainderModInteger(arg1, arg2, variable, option);
                            if (result == null) {
                                return F.NIL;
                            }
                            return result[0];
                        }
                        return F.NIL;
                    }
                    IExpr[] result = PolynomialQuotient.quotientRemainder(arg1, arg2, variable);
                    if (result == null) {
                        return F.NIL;
                    }
                    return result[0];
                }
                catch (ArithmeticException aex) {
                    LOGGER.log(engine.getLogLevel(), (Object)S.PolynomialQuotient, (Throwable)aex);
                }
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            this.setOptions(newSymbol, F.list(F.Rule((IExpr)S.Modulus, (IExpr)F.C0)));
        }
    }

    private static class PolynomialQ
    extends AbstractCoreFunctionEvaluator
    implements BiPredicate<IExpr, IExpr> {
        private PolynomialQ() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST2()) {
                IExpr cached = engine.getCache(ast);
                if (cached != null) {
                    return cached;
                }
                IExpr arg1 = engine.evaluate(ast.arg1());
                IExpr arg2 = engine.evaluate(ast.arg2());
                IAST variablesList = F.NIL;
                variablesList = arg2.isList() ? (IAST)arg2 : F.list(arg2);
                IAST subst = Algebra.substituteVariablesInPolynomial(arg1, variablesList, "\u00a7PolynomialQ");
                ISymbol result = F.bool(subst.arg1().isPolynomial((IAST)subst.arg2()));
                engine.putCache(ast, result);
                return result;
            }
            if (ast.isAST1()) {
                return S.True;
            }
            return S.False;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public boolean test(IExpr firstArg, IExpr secondArg) {
            return firstArg.isPolynomial(secondArg.orNewList());
        }
    }

    private static class PolynomialLCM
    extends AbstractFunctionEvaluator {
        private PolynomialLCM() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST0()) {
                return F.NIL;
            }
            if (Algebra.checkPolyStruct(ast, engine)) {
                block18: {
                    OptionArgs options;
                    IExpr option;
                    if (ast.isAST1()) {
                        IExpr arg1 = ast.arg1();
                        if (arg1.isNegativeResult()) {
                            return arg1.negate();
                        }
                        return arg1;
                    }
                    VariablesSet eVar = new VariablesSet();
                    eVar.addVarList(ast, 1);
                    IExpr expr = F.evalExpandAll(ast.arg1(), engine);
                    if (ast.size() > 3 && (option = (options = new OptionArgs(ast.topHead(), ast, ast.argSize(), engine)).getOption(S.Modulus)).isInteger() && !option.isZero()) {
                        try {
                            List<IExpr> varList = eVar.getVarList().copyTo();
                            ModLongRing modIntegerRing = JASModInteger.option2ModLongRing((ISignedNumber)option);
                            JASModInteger jas = new JASModInteger(varList, modIntegerRing);
                            GenPolynomial poly = jas.expr2JAS(expr);
                            GreatestCommonDivisorAbstract factory = GCDFactory.getImplementation((ModLongRing)modIntegerRing);
                            for (int i = 2; i < ast.argSize(); ++i) {
                                expr = F.evalExpandAll(ast.get(i), engine);
                                GenPolynomial<ModLong> temp = jas.expr2JAS(expr);
                                poly = factory.lcm(poly, temp);
                            }
                            return Algebra.factorModulus(jas, modIntegerRing, (GenPolynomial<ModLong>)poly.monic(), false);
                        }
                        catch (ArithmeticException aex) {
                            LOGGER.log(engine.getLogLevel(), (Object)S.PolynomialLCM, (Throwable)aex);
                            return F.NIL;
                        }
                        catch (JASConversionException e) {
                            try {
                                if (eVar.size() == 0) {
                                    return F.NIL;
                                }
                                expr = F.evalExpandAll(ast.arg1(), engine);
                                IASTAppendable vars = eVar.getVarList();
                                ExprPolynomialRing ring = new ExprPolynomialRing(vars);
                                ExprPolynomial pol1 = ring.create(expr);
                                List<IExpr> varList = eVar.getVarList().copyTo();
                                JASIExpr jas = new JASIExpr(varList, true);
                                GenPolynomial p1 = jas.expr2IExprJAS(pol1);
                                GreatestCommonDivisorAbstract factory = GCDFactory.getImplementation((RingFactory)ExprRingFactory.CONST);
                                for (int i = 2; i < ast.size(); ++i) {
                                    expr = F.evalExpandAll(ast.get(i), engine);
                                    GenPolynomial<IExpr> p2 = jas.expr2IExprJAS(expr);
                                    p1 = factory.lcm(p1, p2);
                                }
                                return jas.exprPoly2Expr(p1);
                            }
                            catch (RuntimeException rex) {
                                LOGGER.debug("PolynomialLCM.evaluate() failed", (Throwable)rex);
                                return F.NIL;
                            }
                        }
                    }
                    try {
                        List<IExpr> varList = eVar.getVarList().copyTo();
                        JASConvert jas = new JASConvert((List<? extends IExpr>)varList, edu.jas.arith.BigInteger.ZERO);
                        GenPolynomial poly = jas.expr2JAS(expr, false);
                        boolean evaled = false;
                        GreatestCommonDivisorAbstract factory = GCDFactory.getImplementation((edu.jas.arith.BigInteger)edu.jas.arith.BigInteger.ZERO);
                        for (int i = 2; i < ast.size(); ++i) {
                            GenPolynomial gcd;
                            expr = F.evalExpandAll(ast.get(i), engine);
                            GenPolynomial temp = jas.expr2JAS(expr, false);
                            if (!evaled && !(gcd = factory.gcd(poly, temp)).isONE()) {
                                evaled = true;
                            }
                            poly = factory.lcm(poly, temp);
                        }
                        if (evaled) {
                            return jas.integerPoly2Expr((GenPolynomial<edu.jas.arith.BigInteger>)poly.monic());
                        }
                    }
                    catch (ClassCastException | JASConversionException e) {
                        LOGGER.debug("PolynomialLCM.evaluate() failed", (Throwable)e);
                        IASTMutable list = ast.setAtCopy(0, S.List);
                        IExpr[] result = InternalFindCommonFactorPlus.findCommonFactors(list, true);
                        if (result == null) break block18;
                        return F.Times(result[0], (IExpr)((IAST)result[1]).setAtCopy(0, S.Times));
                    }
                }
                return ast.setAtCopy(0, S.Times);
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
            this.setOptions(newSymbol, F.list(F.Rule((IExpr)S.Modulus, (IExpr)F.C0)));
        }
    }

    private static class PolynomialGCD
    extends AbstractFunctionEvaluator {
        private PolynomialGCD() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.isAST0()) {
                return F.NIL;
            }
            if (Algebra.checkPolyStruct(ast, engine)) {
                if (ast.isAST1()) {
                    IExpr arg1 = ast.arg1();
                    if (arg1.isNegativeResult()) {
                        return arg1.negate();
                    }
                    return arg1;
                }
                VariablesSet eVar = new VariablesSet();
                eVar.addVarList(ast, 1);
                IExpr expr = F.evalExpandAll(ast.arg1(), engine);
                if (ast.size() > 3 && ast.last().isRuleAST()) {
                    return this.gcdWithOption(ast, expr, eVar, engine);
                }
                try {
                    List<IExpr> varList = eVar.getVarList().copyTo();
                    JASConvert jas = new JASConvert((List<? extends IExpr>)varList, edu.jas.arith.BigInteger.ZERO);
                    GenPolynomial poly = jas.expr2JAS(expr, false);
                    GreatestCommonDivisorAbstract factory = GCDFactory.getImplementation((edu.jas.arith.BigInteger)edu.jas.arith.BigInteger.ZERO);
                    for (int i = 2; i < ast.size(); ++i) {
                        expr = F.evalExpandAll(ast.get(i), engine);
                        GenPolynomial temp = jas.expr2JAS(expr, false);
                        poly = factory.gcd(poly, temp);
                    }
                    return jas.integerPoly2Expr((GenPolynomial<edu.jas.arith.BigInteger>)poly.monic());
                }
                catch (ArithmeticException aex) {
                    LOGGER.log(engine.getLogLevel(), (Object)S.PolynomialGCD, (Throwable)aex);
                    return F.NIL;
                }
                catch (JASConversionException e) {
                    try {
                        if (eVar.size() == 0) {
                            return F.NIL;
                        }
                        IASTAppendable vars = eVar.getVarList();
                        expr = F.evalExpandAll(ast.arg1(), engine);
                        ExprPolynomialRing ring = new ExprPolynomialRing(vars);
                        ExprPolynomial p1 = ring.create(expr);
                        for (int i = 2; i < ast.size(); ++i) {
                            expr = F.evalExpandAll(ast.get(i), engine);
                            ExprPolynomial p2 = ring.create(expr);
                            p1 = p1.gcd(p2);
                        }
                        return p1.getExpr();
                    }
                    catch (RuntimeException rex) {
                        LOGGER.debug("PolynomialGCD.evaluate() failed", (Throwable)rex);
                        IASTMutable list = ast.setAtCopy(0, S.List);
                        IExpr[] result = InternalFindCommonFactorPlus.findCommonFactors(list, false);
                        if (result != null) {
                            return result[0];
                        }
                        return F.C1;
                    }
                }
            }
            return F.NIL;
        }

        private IExpr gcdWithOption(IAST ast, IExpr expr, VariablesSet eVar, EvalEngine engine) {
            OptionArgs options = new OptionArgs(ast.topHead(), ast, ast.argSize(), engine);
            IExpr option = options.getOption(S.Modulus);
            if (option.isInteger() && !option.isZero()) {
                return this.modulusGCD(ast, expr, eVar, option);
            }
            return F.NIL;
        }

        private IExpr modulusGCD(IAST ast, IExpr expr, VariablesSet eVar, IExpr option) {
            try {
                ModLongRing modIntegerRing = JASModInteger.option2ModLongRing((ISignedNumber)option);
                JASModInteger jas = new JASModInteger(eVar.getArrayList(), modIntegerRing);
                GenPolynomial poly = jas.expr2JAS(expr);
                GreatestCommonDivisorAbstract factory = GCDFactory.getImplementation((ModLongRing)modIntegerRing);
                for (int i = 2; i < ast.argSize(); ++i) {
                    IExpr arg = ast.get(i);
                    eVar = new VariablesSet(arg);
                    if (!eVar.isSize(1)) {
                        return F.NIL;
                    }
                    expr = F.evalExpandAll(arg);
                    GenPolynomial<ModLong> temp = jas.expr2JAS(expr);
                    poly = factory.gcd(poly, temp);
                }
                return Algebra.factorModulus(jas, modIntegerRing, poly, false);
            }
            catch (JASConversionException e) {
                LOGGER.debug("PolynomialGCD.modulusGCD() failed", (Throwable)((Object)e));
                return F.NIL;
            }
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
            this.setOptions(newSymbol, F.list(F.Rule((IExpr)S.Modulus, (IExpr)F.C0)));
        }
    }

    private static class PolynomialExtendedGCD
    extends AbstractFunctionEvaluator {
        private PolynomialExtendedGCD() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            List<IExpr> varList;
            IAST variables = VariablesSet.getAlgebraicVariables(ast.arg3());
            if (variables.size() != 2) {
                return IOFunctions.printMessage(ast.topHead(), "ivar", F.list(ast.arg3()), engine);
            }
            IExpr expr1 = F.evalExpandAll(ast.arg1(), engine);
            IExpr expr2 = F.evalExpandAll(ast.arg2(), engine);
            if (!expr1.isPolynomialStruct()) {
                return IOFunctions.printMessage(ast.topHead(), "poly", F.list(expr1), engine);
            }
            if (!expr2.isPolynomialStruct()) {
                return IOFunctions.printMessage(ast.topHead(), "poly", F.list(expr2), engine);
            }
            if (ast.size() == 5) {
                varList = variables.copyTo();
                OptionArgs options = new OptionArgs(ast.topHead(), ast, 4, engine);
                IExpr option = options.getOption(S.Modulus);
                if (option.isInteger() && !option.isZero()) {
                    try {
                        ModLongRing modIntegerRing = JASModInteger.option2ModLongRing((ISignedNumber)option);
                        JASModInteger jas = new JASModInteger(varList, modIntegerRing);
                        GenPolynomial<ModLong> poly1 = jas.expr2JAS(expr1);
                        GenPolynomial<ModLong> poly2 = jas.expr2JAS(expr2);
                        GenPolynomial[] result = poly1.egcd(poly2);
                        IASTAppendable list = F.ListAlloc(2);
                        list.append(jas.modLongPoly2Expr((GenPolynomial<ModLong>)result[0]));
                        IASTAppendable subList = F.ListAlloc(2);
                        subList.append(jas.modLongPoly2Expr((GenPolynomial<ModLong>)result[1]));
                        subList.append(jas.modLongPoly2Expr((GenPolynomial<ModLong>)result[2]));
                        list.append(subList);
                        return list;
                    }
                    catch (ArithmeticException aex) {
                        LOGGER.log(engine.getLogLevel(), (Object)S.PolynomialExtendedGCD, (Throwable)aex);
                    }
                    catch (JASConversionException e) {
                        LOGGER.debug("PolynomialExtendedGCD.evaluate() failed", (Throwable)((Object)e));
                    }
                    return F.NIL;
                }
            }
            try {
                IASTAppendable list;
                varList = variables.copyTo();
                IExpr variable = varList.get(0);
                if (expr1.isFree(variable) || expr2.isFree(variable)) {
                    list = F.ListAlloc(2);
                    list.append(F.C1);
                    IASTAppendable subList = F.ListAlloc(2);
                    subList.append(F.C0);
                    subList.append(F.Power(expr2, F.CN1));
                    list.append(subList);
                    return list;
                }
                if (!expr1.isPolynomial(variables) && !expr2.isPolynomial(variables)) {
                    list = F.ListAlloc(2);
                    list.append(expr2);
                    IASTAppendable subList = F.ListAlloc(2);
                    subList.append(F.C0);
                    subList.append(F.C1);
                    list.append(subList);
                    return list;
                }
                JASConvert jas = new JASConvert((List<? extends IExpr>)varList, BigRational.ZERO);
                GenPolynomial poly1 = jas.expr2JAS(expr1, false);
                GenPolynomial poly2 = jas.expr2JAS(expr2, false);
                GenPolynomial[] result = poly1.egcd(poly2);
                IASTAppendable list2 = F.ListAlloc(2);
                list2.append(jas.rationalPoly2Expr((GenPolynomial<BigRational>)result[0], true));
                IASTAppendable subList = F.ListAlloc(2);
                subList.append(jas.rationalPoly2Expr((GenPolynomial<BigRational>)result[1], true));
                subList.append(jas.rationalPoly2Expr((GenPolynomial<BigRational>)result[2], true));
                list2.append(subList);
                return list2;
            }
            catch (JASConversionException e0) {
                try {
                    ExprPolynomialRing ring = new ExprPolynomialRing(variables);
                    ExprPolynomial poly1 = ring.create(expr1);
                    ExprPolynomial poly2 = ring.create(expr2);
                    ExprPolynomial[] result = poly1.egcd(poly2);
                    if (result != null) {
                        IASTAppendable list = F.ListAlloc(2);
                        list.append(result[0].getExpr());
                        IASTAppendable subList = F.ListAlloc(2);
                        subList.append(S.Together.of(engine, result[1].getExpr()));
                        subList.append(S.Together.of(engine, result[2].getExpr()));
                        list.append(subList);
                        return list;
                    }
                    return F.NIL;
                }
                catch (RuntimeException rex) {
                    LOGGER.debug("PolynomialExtendedGCD.evaluate() failed", (Throwable)rex);
                    return F.NIL;
                }
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_3_4;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(96);
            this.setOptions(newSymbol, F.list(F.Rule((IExpr)S.Modulus, (IExpr)F.C0)));
        }
    }

    private static class Numerator
    extends AbstractFunctionEvaluator {
        private Numerator() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg;
            boolean trig = false;
            if (ast.isAST2()) {
                OptionArgs options = new OptionArgs(ast.topHead(), ast, 2, engine);
                if (options.isInvalidPosition(1)) {
                    return options.printNonopt(ast, 1, engine);
                }
                trig = options.isTrue(S.Trig);
            }
            if ((arg = ast.arg1()).isRational()) {
                return ((IRational)arg).numerator();
            }
            IExpr[] parts = Algebra.fractionalParts(arg, trig);
            if (parts == null) {
                return arg;
            }
            return parts[0];
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
            this.setOptions(newSymbol, F.list(F.Rule((IExpr)S.Trig, (IExpr)S.False)));
        }

        public static IExpr getTrigForm(IAST function, boolean trig) {
            if (trig && function.isAST1()) {
                for (int i = 0; i < F.DENOMINATOR_NUMERATOR_SYMBOLS.size(); ++i) {
                    ISymbol symbol = F.DENOMINATOR_NUMERATOR_SYMBOLS.get(i);
                    if (!function.head().equals(symbol)) continue;
                    IExpr result = F.NUMERATOR_TRIG_TRUE_EXPRS.get(i);
                    if (result.isSymbol()) {
                        return F.unaryAST1(result, function.arg1());
                    }
                    return result;
                }
            }
            return F.NIL;
        }
    }

    static class FactorTerms
    extends AbstractFunctionEvaluator {
        FactorTerms() {
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            void var5_9;
            IExpr temp = StructureFunctions.threadListLogicEquationOperators(ast.arg1(), ast, 1);
            if (temp.isPresent()) {
                return temp;
            }
            VariablesSet eVar = null;
            IAssociation iAssociation = F.NIL;
            if (ast.isAST2()) {
                if (ast.arg2().isSymbol()) {
                    ISymbol variable = (ISymbol)ast.arg2();
                    IAST iAST = F.list(variable);
                } else {
                    if (!ast.arg2().isList()) return F.NIL;
                    IAST iAST = (IAST)ast.arg2();
                }
            } else if (ast.isAST1()) {
                IExpr expr = F.evalExpandAll(ast.arg1(), engine);
                if (expr.isPlus() && (temp = Algebra.factorTermsPlus((IAST)expr, engine)).isPresent()) {
                    return temp;
                }
                eVar = new VariablesSet(ast.arg1());
                if (!eVar.isSize(1)) {
                    if (!eVar.isSize(0)) return F.NIL;
                    return ast.arg1();
                }
                IASTAppendable iASTAppendable = eVar.getVarList();
            }
            if (!var5_9.isPresent() || var5_9.size() != 2) {
                return F.NIL;
            }
            List<IExpr> varList = var5_9.copyTo();
            IExpr expr = F.evalExpandAll(ast.arg1(), engine);
            try {
                JASConvert jas = new JASConvert((List<? extends IExpr>)varList, BigRational.ZERO);
                GenPolynomial poly = jas.expr2JAS(expr, false);
                Object[] objects = jas.factorTerms(poly);
                BigInteger gcd = (BigInteger)objects[0];
                BigInteger lcm = (BigInteger)objects[1];
                if (lcm.equals(BigInteger.ZERO)) {
                    return expr;
                }
                GenPolynomial iPoly = (GenPolynomial)objects[2];
                IASTAppendable result = F.TimesAlloc(2);
                result.append(F.fraction(gcd, lcm));
                result.append(jas.integerPoly2Expr((GenPolynomial<edu.jas.arith.BigInteger>)iPoly));
                return result;
            }
            catch (JASConversionException jASConversionException) {
                return ast.arg1();
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class FactorSquareFreeList
    extends Factor {
        private FactorSquareFreeList() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            VariablesSet eVar = new VariablesSet(ast.arg1());
            try {
                IExpr expr = F.evalExpandAll(ast.arg1(), engine);
                List<IExpr> varList = eVar.getVarList().copyTo();
                return FactorSquareFreeList.factorList(expr, varList, true);
            }
            catch (JASConversionException jce) {
                LOGGER.debug("FactorSquareFreeList.evaluate() failed", (Throwable)((Object)jce));
                return F.NIL;
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        private static IExpr factorList(IExpr expr, List<IExpr> varList, boolean factorSquareFree) throws JASConversionException {
            SortedMap map;
            if (!expr.isAST()) {
                if (expr.isNumber()) {
                    return F.list(F.list(expr, F.C1));
                }
                return F.list(F.list(F.C1, F.C1), F.list(expr, F.C1));
            }
            JASConvert jas = new JASConvert((List<? extends IExpr>)varList, BigRational.ZERO);
            GenPolynomial polyRat = jas.expr2JAS(expr, false);
            Object[] objects = jas.factorTerms(polyRat);
            BigInteger gcd = (BigInteger)objects[0];
            BigInteger lcm = (BigInteger)objects[1];
            try {
                GenPolynomial poly = (GenPolynomial)objects[2];
                FactorAbstract factorAbstract = FactorFactory.getImplementation((edu.jas.arith.BigInteger)edu.jas.arith.BigInteger.ONE);
                map = factorSquareFree ? factorAbstract.squarefreeFactors(poly) : factorAbstract.factors(poly);
            }
            catch (RuntimeException rex) {
                return F.list(expr);
            }
            IASTAppendable result = F.ListAlloc(map.size() + 1);
            if (!gcd.equals(BigInteger.ONE) || !lcm.equals(BigInteger.ONE)) {
                result.append(F.list(F.fraction(gcd, lcm), F.C1));
            }
            for (Map.Entry entry : map.entrySet()) {
                if (((GenPolynomial)entry.getKey()).isONE() && ((Long)entry.getValue()).equals(1L)) continue;
                result.append(F.list(jas.integerPoly2Expr((GenPolynomial<edu.jas.arith.BigInteger>)((GenPolynomial)entry.getKey())), F.ZZ((Long)entry.getValue())));
            }
            return result;
        }
    }

    private static class FactorSquareFree
    extends Factor {
        private FactorSquareFree() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            VariablesSet eVar = new VariablesSet(ast.arg1());
            IExpr result = engine.getCache(ast);
            if (result != null) {
                if (result.isPresent()) {
                    return result;
                }
                return ast.arg1();
            }
            try {
                IExpr expr = F.evalExpandAll(ast.arg1(), engine);
                List<IExpr> varList = eVar.getVarList().copyTo();
                if (ast.isAST2()) {
                    IExpr temp = FactorSquareFree.factorWithOption(ast, expr, varList, true, engine);
                    if (temp.isPresent()) {
                        return temp;
                    }
                } else if (expr.isAST()) {
                    IExpr temp = this.factorExpr((IAST)expr, (IAST)expr, eVar, true, engine);
                    engine.putCache(ast, temp);
                    if (temp.isPresent()) {
                        return temp;
                    }
                }
                return ast.arg1();
            }
            catch (JASConversionException jce) {
                LOGGER.debug("FactorSquareFree.evaluate() failed", (Throwable)((Object)jce));
                return ast.arg1();
            }
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static class Factor
    extends AbstractFunctionEvaluator {
        private Factor() {
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            this.setOptions(newSymbol, F.list(F.Rule((IExpr)S.Extension, (IExpr)S.None), F.Rule((IExpr)S.GaussianIntegers, (IExpr)S.False), F.Rule((IExpr)S.Modulus, (IExpr)F.C0)));
            newSymbol.setAttributes(512);
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr[] parts;
            if (ast.arg1().isList()) {
                IAST list = (IAST)ast.arg1();
                return list.mapThreadEvaled(engine, F.ListAlloc(list.size()), ast, 1);
            }
            IExpr result = engine.getCache(ast);
            if (result != null) {
                if (result.isPresent()) {
                    return result;
                }
                return ast.arg1();
            }
            VariablesSet eVar = new VariablesSet(ast.arg1());
            List<IExpr> varList = eVar.getVarList().copyTo();
            IExpr expr = ast.arg1();
            if (ast.isAST1() && !ast.arg1().isTimes() && !ast.arg1().isPower() && (expr = S.Together.of(engine, expr)).isAST() && !(parts = Algebra.getNumeratorDenominator((IAST)expr, engine))[1].isOne()) {
                try {
                    IExpr numerator = this.factorExpr(F.Factor(parts[0]), parts[0], eVar, false, engine);
                    IExpr denominator = this.factorExpr(F.Factor(parts[1]), parts[1], eVar, false, engine);
                    if (numerator.isPresent() && denominator.isPresent()) {
                        IAST temp = F.Divide(numerator, denominator);
                        engine.putCache(ast, temp);
                        if (temp.isPresent()) {
                            return temp;
                        }
                    } else {
                        engine.putCache(ast, F.NIL);
                    }
                }
                catch (JASConversionException e) {
                    LOGGER.debug("Factor.evaluate() failed", (Throwable)((Object)e));
                }
                return ast.arg1();
            }
            try {
                IExpr temp;
                if (ast.isAST2() && (temp = Factor.factorWithOption(ast, expr, varList, false, engine)).isPresent()) {
                    return temp;
                }
                temp = this.factorExpr(ast, expr, eVar, false, engine);
                engine.putCache(ast, temp);
                if (temp.isPresent()) {
                    return temp;
                }
            }
            catch (JASConversionException e) {
                LOGGER.debug("Factor.evaluate() failed", (Throwable)((Object)e));
            }
            return ast.arg1();
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        public IExpr factorExpr(IAST ast, IExpr expr, VariablesSet eVar, boolean factorSquareFree, EvalEngine engine) {
            if (expr.isAST()) {
                if (expr.isPower()) {
                    IExpr p = this.factorExpr((IAST)expr, expr.base(), eVar, factorSquareFree, engine);
                    if (p.isPresent() && !p.equals(expr.base())) {
                        return F.Power(p, expr.exponent());
                    }
                    return expr;
                }
                if (expr.isTimes()) {
                    IAST temp = ((IAST)expr).map(x -> {
                        IExpr p;
                        if (x.isPlus()) {
                            return this.factorExpr(ast, (IExpr)x, eVar, factorSquareFree, engine);
                        }
                        if (x.isPower() && x.base().isPlus() && (p = this.factorExpr(ast, x.base(), eVar, factorSquareFree, engine)).isPresent() && !p.equals(x.base())) {
                            return F.Power(p, x.exponent());
                        }
                        return F.NIL;
                    }, 1);
                    return temp;
                }
                return Factor.factor((IAST)expr, eVar, factorSquareFree, engine);
            }
            return expr;
        }

        private static IExpr factor(IAST expr, VariablesSet eVar, boolean factorSquareFree, EvalEngine engine) throws JASConversionException {
            if (expr.leafCount() > 1000L) {
                return expr;
            }
            Object[] objects = null;
            JASConvert jas = new JASConvert((List<? extends IExpr>)eVar.getArrayList(), BigRational.ZERO, TermOrderByName.INVLEX);
            try {
                GenPolynomial polyRat = jas.expr2JAS(expr, false);
                if (polyRat.length() <= 1) {
                    return expr;
                }
                objects = jas.factorTerms(polyRat);
            }
            catch (JASConversionException e) {
                if (factorSquareFree) {
                    return F.NIL;
                }
                return Factor.factorWithPolynomialHomogenization(expr, eVar, engine);
            }
            if (objects != null) {
                SortedMap map;
                try {
                    GenPolynomial poly = (GenPolynomial)objects[2];
                    IExpr temp = Factor.heuristicXP2XPOne((GenPolynomial<edu.jas.arith.BigInteger>)poly, expr, eVar, engine);
                    if (temp.isPresent()) {
                        return temp;
                    }
                    FactorAbstract factorAbstract = FactorFactory.getImplementation((edu.jas.arith.BigInteger)edu.jas.arith.BigInteger.ONE);
                    map = factorSquareFree ? factorAbstract.squarefreeFactors(poly) : factorAbstract.factors(poly);
                }
                catch (RuntimeException rex) {
                    LOGGER.debug("Factor.factor() failed", (Throwable)rex);
                    return expr;
                }
                IASTAppendable result = F.TimesAlloc(map.size() + 1);
                BigInteger gcd = (BigInteger)objects[0];
                BigInteger lcm = (BigInteger)objects[1];
                IRational f = F.C1;
                if (!gcd.equals(BigInteger.ONE) || !lcm.equals(BigInteger.ONE)) {
                    f = F.fraction(gcd, lcm).normalize();
                }
                for (Map.Entry entry : map.entrySet()) {
                    if (((GenPolynomial)entry.getKey()).isONE() && ((Long)entry.getValue()).equals(1L)) continue;
                    IExpr base = jas.integerPoly2Expr((GenPolynomial<edu.jas.arith.BigInteger>)((GenPolynomial)entry.getKey()));
                    if ((Long)entry.getValue() == 1L) {
                        if (f.isMinusOne() && base.isPlus()) {
                            base = ((IAST)base).map(x -> x.negate(), 1);
                            f = F.C1;
                        }
                        result.append(base);
                        continue;
                    }
                    result.append(F.Power(base, F.ZZ((Long)entry.getValue())));
                }
                if (!f.isOne()) {
                    result.append(f);
                }
                return engine.evaluate(result);
            }
            return F.NIL;
        }

        private static IExpr heuristicXP2XPOne(GenPolynomial<edu.jas.arith.BigInteger> poly, IAST expr, VariablesSet eVar, EvalEngine engine) {
            if (poly.length() == 3 && poly.ring.tord == TermOrderByName.INVLEX && poly.ring.nvar == 1) {
                edu.jas.arith.BigInteger a = edu.jas.arith.BigInteger.ZERO;
                edu.jas.arith.BigInteger b = edu.jas.arith.BigInteger.ZERO;
                edu.jas.arith.BigInteger c = edu.jas.arith.BigInteger.ZERO;
                edu.jas.arith.BigInteger one = edu.jas.arith.BigInteger.ONE;
                long expA = 0L;
                long p = 0L;
                long expC = 0L;
                int i = 0;
                for (Monomial monomial : poly) {
                    edu.jas.arith.BigInteger coeff = (edu.jas.arith.BigInteger)monomial.coefficient();
                    long lExp = monomial.exponent().getVal(0);
                    if (++i == 1) {
                        a = coeff;
                        expA = lExp;
                        continue;
                    }
                    if (i == 2) {
                        b = coeff;
                        p = lExp;
                        continue;
                    }
                    if (i != 3) continue;
                    c = coeff;
                    expC = lExp;
                }
                if (a.equals((Object)one) && b.equals((Object)one) && c.equals((Object)one) && expC == 0L && p != 3L && expA == p * 2L && BigInteger.valueOf(p).isProbablePrime(32)) {
                    IExpr x = eVar.getArrayList().get(0);
                    IAST p1 = F.Plus((IExpr)F.Power(x, F.C2), x, (IExpr)F.C1);
                    IExpr p2 = engine.evaluate(F.PolynomialQuotient(expr, p1, x));
                    return F.Times((IExpr)p1, p2);
                }
            }
            return F.NIL;
        }

        private static IExpr factorWithPolynomialHomogenization(IAST expr, VariablesSet eVar, EvalEngine engine) {
            boolean gaussianIntegers = !expr.isFree(x -> x.isComplex() || x.isComplexNumeric(), false);
            PolynomialHomogenization substitutions = new PolynomialHomogenization(eVar.getVarList(), engine);
            IExpr subsPolynomial = substitutions.replaceForward(expr);
            if (substitutions.size() == 0) {
                return Algebra.factorComplex((IExpr)expr, eVar.getArrayList(), S.Times, gaussianIntegers, engine);
            }
            if (subsPolynomial.isAST()) {
                eVar.addAll(substitutions.substitutedVariablesSet());
                IExpr factorization = Algebra.factorComplex(subsPolynomial, eVar.getArrayList(), S.Times, gaussianIntegers, engine);
                if (factorization.isPresent()) {
                    return substitutions.replaceBackward(factorization);
                }
            }
            return expr;
        }

        public static IExpr factorWithOption(IAST ast, IExpr expr, List<IExpr> varList, boolean factorSquareFree, EvalEngine engine) throws JASConversionException {
            OptionArgs options = new OptionArgs(ast.topHead(), ast, 2, engine);
            IExpr option = options.getOption(S.Modulus);
            if (option.isInteger() && !option.isZero()) {
                return Algebra.factorModulus(expr, varList, factorSquareFree, option);
            }
            if (!factorSquareFree) {
                option = options.getOption(S.Extension);
                if (option.isImaginaryUnit()) {
                    return Algebra.factorComplex(expr, varList, S.Times, false, true, engine);
                }
                option = options.getOption(S.GaussianIntegers);
                if (option.isPresent() && option.isTrue()) {
                    return Algebra.factorComplex(expr, varList, S.Times, false, true, engine);
                }
            }
            return F.NIL;
        }
    }

    private static class ExpandAll
    extends AbstractFunctionEvaluator {
        private ExpandAll() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            Predicate<IExpr> matcher = null;
            if (ast.size() > 2) {
                matcher = Predicates.toFreeQ(ast.arg2());
            }
            if (arg1.isAST()) {
                return Algebra.expandAll((IAST)arg1, matcher, true, true, false, engine).orElse(arg1);
            }
            return arg1;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        private static IExpr setAllExpanded(IExpr expr, boolean expandNegativePowers, boolean distributePlus) {
            if (expr != null && expandNegativePowers && !distributePlus && expr.isAST()) {
                ((IAST)expr).addEvalFlags(8192);
            }
            return expr;
        }
    }

    private static class Expand
    extends AbstractFunctionEvaluator {
        private Expand() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.arg1().isAST()) {
                IAST arg1 = (IAST)ast.arg1();
                if (arg1.isList()) {
                    return arg1.mapThreadEvaled(engine, F.ListAlloc(arg1.size()), ast, 1);
                }
                Predicate<IExpr> matcher = null;
                if (ast.size() > 2) {
                    matcher = Predicates.toFreeQ(ast.arg2());
                }
                return Algebra.expand(arg1, matcher, false, true, true).orElse(arg1);
            }
            return ast.arg1();
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        private static class NumberPartititon {
            IASTAppendable expandedResult;
            int m;
            int n;
            int[] parts;
            IAST precalculatedPowerASTs;

            public NumberPartititon(IAST plusAST, int n, IASTAppendable expandedResult) {
                this.expandedResult = expandedResult;
                this.n = n;
                this.m = plusAST.argSize();
                this.parts = new int[this.m];
                IASTAppendable temp = F.ListAlloc(plusAST.size());
                temp.appendArgs(plusAST);
                this.precalculatedPowerASTs = temp;
            }

            private void addFactor(int[] j) {
                Combinatoric.KPermutationsIterable perm = new Combinatoric.KPermutationsIterable(j, this.m, this.m);
                IInteger multinomial = NumberTheory.multinomial(j, this.n);
                for (int[] indices : perm) {
                    IASTAppendable timesAST = F.TimesAlloc(this.m + 8);
                    if (!multinomial.isOne()) {
                        timesAST.append(multinomial);
                    }
                    for (int k = 0; k < this.m; ++k) {
                        if (indices[k] == 0) continue;
                        IExpr temp = this.precalculatedPowerASTs.get(k + 1);
                        if (indices[k] == 1) {
                            timesAST.append(temp);
                            continue;
                        }
                        if (temp.isTimes()) {
                            IAST ast = (IAST)temp;
                            int ki = k;
                            timesAST.appendArgs(ast.size(), i -> F.Power(ast.get(i), F.ZZ(indices[ki])));
                            continue;
                        }
                        timesAST.append(F.Power(temp, F.ZZ(indices[k])));
                    }
                    timesAST.setEvalFlags(512);
                    this.expandedResult.append(timesAST.oneIdentity0());
                }
            }

            public void partition() {
                this.partition(this.n, this.n, 0);
            }

            private void partition(int n, int max, int currentIndex) {
                int min;
                if (n == 0) {
                    this.addFactor(this.parts);
                    return;
                }
                if (currentIndex >= this.m) {
                    return;
                }
                int old = this.parts[currentIndex];
                for (int i = min = Math.min(max, n); i >= 1; --i) {
                    this.parts[currentIndex] = i;
                    this.partition(n - i, i, currentIndex + 1);
                }
                this.parts[currentIndex] = old;
            }
        }

        private static class Expander {
            Set<IAST> expandedASTs = Collections.newSetFromMap(new IdentityHashMap());
            final boolean expandNegativePowers;
            final boolean distributePlus;
            final boolean evalParts;
            final boolean factorTerms;
            final Predicate<IExpr> matcher;

            public Expander(Predicate<IExpr> matcher, boolean expandNegativePowers, boolean distributePlus, boolean evalParts, boolean factorTerms) {
                this.matcher = matcher;
                this.expandNegativePowers = expandNegativePowers;
                this.distributePlus = distributePlus;
                this.evalParts = evalParts;
                this.factorTerms = factorTerms;
            }

            private boolean isPatternFree(IExpr expression) {
                return this.matcher != null && expression.isFree(this.matcher, false);
            }

            private IExpr expandAST(IAST ast) {
                if (this.isPatternFree(ast)) {
                    return F.NIL;
                }
                if (ast.isExpanded() && this.expandNegativePowers && !this.distributePlus) {
                    return F.NIL;
                }
                if (this.expandedASTs.contains(ast)) {
                    return F.NIL;
                }
                if (ast.isPower()) {
                    return this.expandPowerNIL(ast);
                }
                if (ast.isTimes()) {
                    IExpr tempExpr;
                    EvalEngine engine = EvalEngine.get();
                    IExpr[] temp = Algebra.fractionalPartsTimesPower(ast, false, false, false, this.evalParts, true, true);
                    if (temp == null) {
                        return this.expandTimes(ast, engine);
                    }
                    if (temp[0].isOne()) {
                        IExpr denom;
                        if (temp[1].isTimes()) {
                            IExpr tempExpr2 = this.expandTimes((IAST)temp[1], engine);
                            if (tempExpr2.isPresent()) {
                                return F.Power(tempExpr2, F.CN1);
                            }
                            this.addExpanded(ast);
                            return F.NIL;
                        }
                        if ((temp[1].isPower() || temp[1].isPlus()) && (denom = this.expandAST((IAST)temp[1])).isPresent()) {
                            return F.Power(denom, F.CN1);
                        }
                        this.addExpanded(ast);
                        return F.NIL;
                    }
                    if (temp[1].isOne()) {
                        return this.expandTimes(ast, engine);
                    }
                    boolean evaled = false;
                    if (temp[0].isTimes() && (tempExpr = this.expandTimes((IAST)temp[0], engine)).isPresent()) {
                        temp[0] = tempExpr;
                        evaled = true;
                    }
                    if (this.expandNegativePowers) {
                        IExpr denom;
                        if (temp[1].isTimes()) {
                            tempExpr = this.expandTimes((IAST)temp[1], engine);
                            if (tempExpr.isPresent()) {
                                temp[1] = tempExpr;
                                evaled = true;
                            }
                        } else if ((temp[1].isPower() || temp[1].isPlus()) && (denom = this.expandAST((IAST)temp[1])).isPresent()) {
                            temp[1] = denom;
                            evaled = true;
                        }
                    }
                    IAST powerAST = F.Power(temp[1], F.CN1);
                    if (this.distributePlus && temp[0].isPlus()) {
                        IASTMutable mappedAST = ((IAST)temp[0]).mapThreadEvaled(EvalEngine.get(), F.Times(null, (IExpr)powerAST), 1);
                        IExpr flattened = Expander.flattenOneIdentity(mappedAST, F.C0);
                        return this.addExpanded(flattened);
                    }
                    if (evaled) {
                        return this.addExpanded(Expander.binaryFlatTimes(temp[0], powerAST));
                    }
                    this.addExpanded(ast);
                    return F.NIL;
                }
                if (ast.isPlus()) {
                    return this.expandPlus(ast);
                }
                this.addExpanded(ast);
                return F.NIL;
            }

            private IExpr addExpanded(IExpr expr) {
                if (expr.isAST()) {
                    if (this.expandNegativePowers && this.evalParts && !this.distributePlus && !this.factorTerms && this.matcher == null) {
                        ((IAST)expr).addEvalFlags(4096);
                    } else {
                        this.expandedASTs.add((IAST)expr);
                    }
                }
                return expr;
            }

            private IExpr expandPlus(IAST ast) {
                IASTAppendable result = F.NIL;
                for (int i = 1; i < ast.size(); ++i) {
                    IExpr temp;
                    IExpr arg = ast.get(i);
                    if (arg.isAST() && (temp = this.expandAST((IAST)arg)).isPresent()) {
                        if (!result.isPresent()) {
                            result = ast.copyUntil(ast.size(), i);
                        }
                        result.append(temp);
                        continue;
                    }
                    result.ifAppendable(r -> r.append(arg));
                }
                if (result.isPresent()) {
                    return this.addExpanded(Expander.flattenOneIdentity(result, F.C0));
                }
                this.addExpanded(ast);
                return F.NIL;
            }

            private static IExpr flattenOneIdentity(IAST result, IExpr defaultValue) {
                return EvalAttributes.flattenDeep(result).orElse(result).oneIdentity(defaultValue);
            }

            private IExpr expandPowerNIL(IAST powerAST) {
                IExpr base = powerAST.arg1();
                IExpr exponent = powerAST.arg2();
                IExpr temp = F.NIL;
                if (base.isPlusTimesPower() && (temp = this.expandAST((IAST)base)).isPresent()) {
                    base = temp;
                }
                if (base.isPlus()) {
                    IRational floorPart;
                    IFraction fraction;
                    if (exponent.isFraction() && (fraction = (IFraction)exponent).isPositive() && !(floorPart = fraction.floorFraction().normalize()).isZero()) {
                        IFraction fractionalPart = fraction.fractionalPart();
                        return this.expandAST(F.Times((IExpr)F.Power(base, fractionalPart), (IExpr)F.Power(base, floorPart)));
                    }
                    int exp = exponent.toIntDefault();
                    if (exp == Integer.MIN_VALUE) {
                        this.addExpanded(powerAST);
                        return F.NIL;
                    }
                    IAST plusAST = (IAST)base;
                    if (exp < 0) {
                        if (this.expandNegativePowers) {
                            return F.Power(this.expandPower(plusAST, exp *= -1), F.CN1);
                        }
                        this.addExpanded(powerAST);
                        return F.NIL;
                    }
                    return this.expandPower(plusAST, exp);
                }
                if (temp.isPresent()) {
                    temp = F.Power(base, exponent);
                    this.addExpanded(temp);
                    return temp;
                }
                this.addExpanded(powerAST);
                return F.NIL;
            }

            private IExpr expandPower(IAST plusAST, int n) {
                if (n == 1) {
                    IExpr temp = this.expandPlus(plusAST);
                    if (temp.isPresent()) {
                        return temp;
                    }
                    this.addExpanded(plusAST);
                    return plusAST;
                }
                if (n == 0) {
                    return F.C1;
                }
                if (this.isPatternFree(plusAST)) {
                    this.addExpanded(plusAST);
                    return F.NIL;
                }
                int k = plusAST.argSize();
                long numberOfTerms = LongMath.binomial((int)(n + k - 1), (int)(k - 1));
                if (numberOfTerms >= Integer.MAX_VALUE || numberOfTerms > (long)Config.MAX_AST_SIZE) {
                    throw new ASTElementLimitExceeded(numberOfTerms);
                }
                IASTAppendable expandedResult = F.ast((IExpr)S.Plus, (int)numberOfTerms);
                NumberPartititon part = new NumberPartititon(plusAST, n, expandedResult);
                part.partition();
                return this.addExpanded(Expander.flattenOneIdentity(expandedResult, F.C0));
            }

            private IExpr expandTimes(IAST timesAST, EvalEngine engine) {
                IExpr result = timesAST.arg1();
                if (result.isPlusTimesPower()) {
                    result = this.expandAST((IAST)result).orElse(result);
                }
                boolean evaled = false;
                if (!this.isPatternFree(result)) {
                    IExpr temp;
                    if (result.isPower()) {
                        temp = this.expandPowerNIL((IAST)result);
                        if (temp.isPresent()) {
                            result = temp;
                            evaled = true;
                        }
                    } else if (result.isPlus() && (temp = this.expandPlus((IAST)result)).isPresent()) {
                        result = temp;
                        evaled = true;
                    }
                }
                for (int i = 2; i < timesAST.size(); ++i) {
                    IExpr arg = timesAST.get(i);
                    if (!this.isPatternFree(arg)) {
                        if (arg.isPower()) {
                            if (!(arg = this.expandPowerNIL((IAST)arg)).isPresent()) {
                                arg = timesAST.get(i);
                            } else {
                                evaled = true;
                            }
                        } else if (arg.isPlus()) {
                            if (!(arg = this.expandPlus((IAST)arg)).isPresent()) {
                                arg = timesAST.get(i);
                            } else {
                                evaled = true;
                            }
                        }
                    }
                    result = this.expandTimesBinary(result, arg, engine);
                }
                if (!evaled && timesAST.equals(result)) {
                    this.addExpanded(timesAST);
                    return F.NIL;
                }
                return this.addExpanded(result);
            }

            private IExpr expandTimesBinary(IExpr arg1, IExpr arg2, EvalEngine engine) {
                if (arg1.isPlus()) {
                    if (!arg2.isPlus()) {
                        return this.expandExprTimesPlus(arg2, (IAST)arg1, engine);
                    }
                    IAST ast1 = arg2.isPlus() ? (IAST)arg2 : F.Plus(arg2);
                    return this.expandPlusTimesPlus((IAST)arg1, ast1);
                }
                if (arg2.isPlus()) {
                    IExpr temp;
                    if (this.factorTerms && arg1.isExactNumber() && (temp = S.FactorTerms.ofNIL(EvalEngine.get(), arg2)).isPresent()) {
                        return F.Times(arg1, temp);
                    }
                    return this.expandExprTimesPlus(arg1, (IAST)arg2, engine);
                }
                if (arg1.equals(arg2)) {
                    return F.Power(arg1, F.C2);
                }
                return Expander.binaryFlatTimes(arg1, arg2);
            }

            private IExpr expandPlusTimesPlus(IAST plusAST0, IAST plusAST1) {
                EvalEngine engine = EvalEngine.get();
                if (this.isPatternFree(plusAST0)) {
                    if (this.isPatternFree(plusAST1)) {
                        return F.NIL;
                    }
                    PlusOp plusOp = new PlusOp(plusAST1.argSize());
                    IAST t = plusAST0.isPlusTimesPower() ? this.expandAST(plusAST0).orElse(plusAST0) : plusAST0;
                    plusAST1.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)x -> this.evalAndExpandAST(t, false, (IExpr)x, true, plusOp, engine)));
                    return plusOp.getSum();
                }
                if (this.isPatternFree(plusAST1)) {
                    PlusOp plusOp = new PlusOp(plusAST0.argSize());
                    IAST t = plusAST1.isPlusTimesPower() ? this.expandAST(plusAST1).orElse(plusAST1) : plusAST1;
                    plusAST0.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)x -> this.evalAndExpandAST((IExpr)x, true, t, false, plusOp, engine)));
                    return plusOp.getSum();
                }
                long numberOfTerms = (long)plusAST0.argSize() * (long)plusAST1.argSize();
                if (numberOfTerms > (long)Config.MAX_AST_SIZE) {
                    throw new ASTElementLimitExceeded(numberOfTerms);
                }
                PlusOp plusOp = new PlusOp((int)numberOfTerms);
                plusAST0.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)x -> {
                    IExpr t = x.isPlusTimesPower() ? this.expandAST((IAST)x).orElse((IExpr)x) : x;
                    plusAST1.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)y -> this.evalAndExpandAST(t, false, (IExpr)y, true, plusOp, engine)));
                }));
                return plusOp.getSum();
            }

            private static IExpr binaryFlatTimes(IExpr expr1, IExpr expr2) {
                if (expr1.isIndeterminate() || expr2.isIndeterminate()) {
                    return S.Indeterminate;
                }
                if (expr1.isZero() || expr2.isZero()) {
                    return F.C0;
                }
                if (expr1.isOne()) {
                    return expr2;
                }
                if (expr2.isOne()) {
                    return expr1;
                }
                if (expr1.isNumber() && expr2.isNumber()) {
                    return expr1.times(expr2);
                }
                int size = expr1.isTimes() ? expr1.size() : 1;
                IASTAppendable timesAST = F.TimesAlloc(size += expr2.isTimes() ? expr2.size() : 1);
                if (expr1.isTimes()) {
                    timesAST.appendAll((IAST)expr1, 1, expr1.size());
                } else {
                    timesAST.append(expr1);
                }
                if (expr2.isTimes()) {
                    timesAST.appendAll((IAST)expr2, 1, expr2.size());
                } else {
                    timesAST.append(expr2);
                }
                return timesAST;
            }

            private IExpr binaryFlatTimesExpr(IExpr expr1, boolean expr1Eval, IExpr expr2, boolean expr2Eval, EvalEngine engine) {
                if (expr1.isIndeterminate() || expr2.isIndeterminate()) {
                    return S.Indeterminate;
                }
                if (expr1.isZero() || expr2.isZero()) {
                    return F.C0;
                }
                if (expr1.isOne()) {
                    if (expr2Eval && expr2.isPlusTimesPower()) {
                        expr2 = this.expandAST((IAST)expr2).orElse(expr2);
                    }
                    return expr2;
                }
                if (expr2.isOne()) {
                    if (expr1Eval && expr1.isPlusTimesPower()) {
                        expr1 = this.expandAST((IAST)expr1).orElse(expr1);
                    }
                    return expr1;
                }
                if (expr1Eval && expr1.isPlusTimesPower()) {
                    expr1 = this.expandAST((IAST)expr1).orElse(expr1);
                }
                if (expr2Eval && expr2.isPlusTimesPower()) {
                    expr2 = this.expandAST((IAST)expr2).orElse(expr2);
                }
                if (expr1.isNumber() && expr2.isNumber()) {
                    return expr1.times(expr2);
                }
                int size = expr1.isTimes() ? expr1.size() : 1;
                IASTAppendable timesAST = F.TimesAlloc(size += expr2.isTimes() ? expr2.size() : 1);
                if (expr1.isTimes()) {
                    timesAST.appendAll((IAST)expr1, 1, expr1.size());
                } else {
                    timesAST.append(expr1);
                }
                if (expr2.isTimes()) {
                    timesAST.appendAll((IAST)expr2, 1, expr2.size());
                } else {
                    timesAST.append(expr2);
                }
                return engine.evaluate(timesAST);
            }

            private IExpr expandExprTimesPlus(IExpr expr1, IAST plusAST, EvalEngine engine) {
                PlusOp plusOp = new PlusOp(plusAST.argSize());
                IExpr t = expr1.isPlusTimesPower() ? this.expandAST((IAST)expr1).orElse(expr1) : expr1;
                plusAST.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)x -> this.evalAndExpandAST(t, false, (IExpr)x, true, plusOp, engine)));
                return plusOp.getSum();
            }

            private void evalAndExpandAST(IExpr expr1, boolean expr1Eval, IExpr expr2, boolean expr2Eval, PlusOp plusOp, EvalEngine engine) {
                IExpr timesExpr = this.binaryFlatTimesExpr(expr1, expr1Eval, expr2, expr2Eval, engine);
                plusOp.plus(timesExpr);
            }
        }
    }

    private static final class Distribute
    extends AbstractFunctionEvaluator {
        private Distribute() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            IExpr head = S.Plus;
            if (ast.size() >= 3) {
                head = ast.arg2();
            }
            if (ast.isAST3() && !arg1.head().equals(ast.arg3())) {
                return arg1;
            }
            if (arg1.isAST() && ast.argSize() > 0) {
                IAST list = (IAST)arg1;
                int resultSize = ast.argSize() > 127 ? ast.argSize() : 127;
                IASTAppendable resultCollector = ast.size() >= 5 ? F.ast(ast.arg4(), resultSize) : F.ast(head, resultSize);
                DistributeAlgorithm algorithm = new DistributeAlgorithm(resultCollector, head, list);
                if (algorithm.distribute(ast)) {
                    return resultCollector;
                }
            }
            return arg1;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_5;
        }

        private static class DistributeAlgorithm {
            final IASTAppendable resultCollector;
            final IExpr head;
            final IAST arg1;
            boolean evaled;

            DistributeAlgorithm(IASTAppendable resultCollector, IExpr head, IAST arg1) {
                this.resultCollector = resultCollector;
                this.head = head;
                this.arg1 = arg1;
                this.evaled = false;
            }

            public boolean distribute(IAST ast) {
                int stepSize = this.arg1.size();
                IASTAppendable stepResult = ast.size() >= 6 ? F.ast(ast.arg5(), stepSize) : F.ast(this.arg1.head(), stepSize);
                this.distributePositionRecursive(stepResult, 1);
                return this.evaled;
            }

            public void distributePositionRecursive(IASTAppendable stepResult, int position) {
                if (this.arg1.size() == position) {
                    this.resultCollector.append(stepResult);
                    return;
                }
                if (this.arg1.size() < position) {
                    return;
                }
                if (this.arg1.get(position).isAST(this.head)) {
                    IAST temp = (IAST)this.arg1.get(position);
                    temp.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)x -> this.distributeStep((IExpr)x, stepResult, position)));
                    this.evaled = true;
                } else {
                    IASTAppendable res2 = stepResult;
                    res2.append(this.arg1.get(position));
                    this.distributePositionRecursive(res2, position + 1);
                }
            }

            private void distributeStep(IExpr x, IAST stepResult, int position) {
                IASTAppendable res2 = stepResult.copyAppendable();
                res2.append(x);
                this.distributePositionRecursive(res2, position + 1);
            }
        }
    }

    private static class Denominator
    extends AbstractFunctionEvaluator {
        private Denominator() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr expr;
            boolean trig = false;
            if (ast.isAST2()) {
                OptionArgs options = new OptionArgs(ast.topHead(), ast, 2, engine);
                if (options.isInvalidPosition(1)) {
                    return options.printNonopt(ast, 1, engine);
                }
                trig = options.isTrue(S.Trig);
            }
            if ((expr = ast.arg1()).isRational()) {
                return ((IRational)expr).denominator();
            }
            IExpr[] parts = Algebra.fractionalParts(expr, trig);
            if (parts == null) {
                return F.C1;
            }
            return parts[1];
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
            this.setOptions(newSymbol, F.list(F.Rule((IExpr)S.Trig, (IExpr)S.False)));
        }

        public static IExpr getTrigForm(IAST function, boolean trig) {
            if (trig && function.isAST1()) {
                for (int i = 0; i < F.DENOMINATOR_NUMERATOR_SYMBOLS.size(); ++i) {
                    ISymbol symbol = F.DENOMINATOR_NUMERATOR_SYMBOLS.get(i);
                    if (!function.head().equals(symbol)) continue;
                    IExpr result = F.DENOMINATOR_TRIG_TRUE_EXPRS.get(i);
                    if (result.isSymbol()) {
                        return F.unaryAST1(result, function.arg1());
                    }
                    return result;
                }
            }
            return F.NIL;
        }
    }

    private static class Collect
    extends AbstractCoreFunctionEvaluator {
        private Collect() {
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            if (ast.size() >= 3 && ast.size() <= 4) {
                try {
                    IExpr arg1 = ast.arg1();
                    IAST temp = StructureFunctions.threadLogicEquationOperators(arg1, ast, 1);
                    if (temp.isPresent()) {
                        return temp;
                    }
                    IExpr arg3Head = null;
                    arg1 = engine.evaluate(arg1);
                    arg1 = F.expandAll(arg1, true, true);
                    IExpr arg2 = engine.evalPattern(ast.arg2());
                    if (!arg2.isList()) {
                        if (ast.isAST3()) {
                            arg3Head = engine.evaluate(ast.arg3());
                        }
                        return this.collectSingleVariable(arg1, arg2, null, 1, arg3Head, engine);
                    }
                    IAST list = (IAST)arg2;
                    if (list.size() > 1) {
                        if (ast.isAST3()) {
                            arg3Head = engine.evaluate(ast.arg3());
                        }
                        return this.collectSingleVariable(arg1, list.arg1(), (IAST)arg2, 2, arg3Head, engine);
                    }
                    return arg1;
                }
                catch (Exception e) {
                    LOGGER.debug("Collect.evaluate() failed", (Throwable)e);
                }
            }
            return F.NIL;
        }

        private static IExpr getRest(IPatternMatcher matcher, IPatternSequence blankNullRest, IExpr defaultValue) {
            IExpr rest = matcher.getPatternMap().getValue(blankNullRest);
            if (rest != null) {
                return rest;
            }
            return defaultValue;
        }

        private IExpr collectSingleVariable(IExpr expr, IExpr x, IAST listOfVariables, int listPosition, IExpr head, EvalEngine engine) {
            if (expr.isAST()) {
                HashMap<IExpr, IASTAppendable> map = new HashMap<IExpr, IASTAppendable>();
                IAST poly = (IAST)expr;
                IASTAppendable rest = F.PlusAlloc(poly.size());
                if (x.isTimes()) {
                    IPatternSequence blankNullRest = F.$ps(F.Dummy("\u00a7rest\u00a7" + EvalEngine.incModuleCounter()), true);
                    IASTAppendable newLHS = ((IAST)x).copyAppendable();
                    newLHS.append(blankNullRest);
                    IPatternMatcher iPatternMatcher = engine.evalPatternMatcher(newLHS);
                    this.collectTimesToMap(x, poly, iPatternMatcher, map, rest, blankNullRest);
                } else {
                    IPatternMatcher matcher = engine.evalPatternMatcher(x);
                    this.collectToMap(x, poly, matcher, map, rest);
                }
                if (listOfVariables != null && listPosition < listOfVariables.size()) {
                    IASTAppendable result = F.PlusAlloc(map.size() + 1);
                    if (rest.size() > 1) {
                        result.append(this.collectSingleVariable(rest.oneIdentity0(), listOfVariables.get(listPosition), listOfVariables, listPosition + 1, head, engine));
                    }
                    for (Map.Entry entry : map.entrySet()) {
                        IExpr temp = this.collectSingleVariable(((IASTAppendable)entry.getValue()).oneIdentity0(), listOfVariables.get(listPosition), listOfVariables, listPosition + 1, head, engine);
                        result.append(F.Times((IExpr)entry.getKey(), temp));
                    }
                    return result;
                }
                if (head != null) {
                    IASTMutable simplifyAST = F.unaryAST1(head, null);
                    rest.forEach((arg, i) -> {
                        simplifyAST.set(1, (IExpr)arg);
                        rest.set(i, engine.evaluate(simplifyAST));
                    });
                    for (Map.Entry entry : map.entrySet()) {
                        simplifyAST.set(1, (IExpr)entry.getValue());
                        IExpr coefficient = engine.evaluate(simplifyAST);
                        if (coefficient.isPlus()) {
                            rest.append(F.Times((IExpr)entry.getKey()).appendOneIdentity((IAST)coefficient));
                            continue;
                        }
                        rest.append(((IExpr)entry.getKey()).times(coefficient));
                    }
                } else {
                    for (IExpr iExpr : map.keySet()) {
                        IAST coefficient = (IAST)map.get(iExpr);
                        IASTAppendable times = F.TimesAlloc(2);
                        times.append(iExpr);
                        times.appendOneIdentity(coefficient);
                        rest.append(times);
                    }
                }
                return rest.oneIdentity0();
            }
            return expr;
        }

        public void collectTimesToMap(IExpr key, IExpr expr, IPatternMatcher matcher, Map<IExpr, IASTAppendable> map, IASTAppendable rest, IPatternSequence blankNullRest) {
            if (expr.isFree(matcher, false)) {
                rest.append(expr);
                return;
            }
            if (matcher.test(expr)) {
                this.addPowerFactor(expr, Collect.getRest(matcher, blankNullRest, F.C1), map);
                return;
            }
            if (blankNullRest == null && this.isPowerMatched(expr, matcher)) {
                this.addPowerFactor(expr, F.C1, map);
                return;
            }
            if (expr.isPlus()) {
                IAST plusAST = (IAST)expr;
                IASTAppendable clone = plusAST.copyAppendable();
                int i2 = 1;
                while (i2 < clone.size()) {
                    if (this.collectTimesToMapPlus(key, clone.get(i2), matcher, map, blankNullRest)) {
                        clone.remove(i2);
                        continue;
                    }
                    ++i2;
                }
                if (clone.size() > 1) {
                    rest.appendOneIdentity(clone);
                }
                return;
            }
            if (blankNullRest == null && expr.isTimes()) {
                IAST timesAST = (IAST)expr;
                if (timesAST.exists((x, i) -> {
                    if (matcher.test((IExpr)x) || this.isPowerMatched((IExpr)x, matcher)) {
                        IASTAppendable clone = timesAST.copyAppendable();
                        clone.remove(i);
                        this.addOneIdentityPowerFactor((IExpr)x, clone, map);
                        return true;
                    }
                    return false;
                }, 1)) {
                    return;
                }
                rest.append(expr);
                return;
            }
            rest.append(expr);
        }

        public boolean collectTimesToMapPlus(IExpr key, IExpr expr, IPatternMatcher matcher, Map<IExpr, IASTAppendable> map, IPatternSequence blankNullRest) {
            if (expr.isFree(matcher, false)) {
                return false;
            }
            if (matcher.test(expr)) {
                this.addPowerFactor(key, Collect.getRest(matcher, blankNullRest, F.C0), map);
                return true;
            }
            return false;
        }

        public void collectToMap(IExpr key, IExpr expr, IPatternMatcher matcher, Map<IExpr, IASTAppendable> map, IASTAppendable rest) {
            if (expr.isFree(matcher, false)) {
                rest.append(expr);
                return;
            }
            if (matcher.test(expr)) {
                this.addPowerFactor(expr, F.C1, map);
                return;
            }
            if (this.isPowerMatched(expr, matcher)) {
                this.addPowerFactor(expr, F.C1, map);
                return;
            }
            if (expr.isPlus()) {
                IAST plusAST = (IAST)expr;
                IASTAppendable clone = plusAST.copyAppendable();
                int i2 = 1;
                while (i2 < clone.size()) {
                    if (this.collectToMapPlus(key, clone.get(i2), matcher, map)) {
                        clone.remove(i2);
                        continue;
                    }
                    ++i2;
                }
                if (clone.size() > 1) {
                    rest.appendOneIdentity(clone);
                }
                return;
            }
            if (expr.isTimes()) {
                IAST timesAST = (IAST)expr;
                if (timesAST.exists((x, i) -> {
                    if (matcher.test((IExpr)x) || this.isPowerMatched((IExpr)x, matcher)) {
                        IASTAppendable clone = timesAST.copyAppendable();
                        clone.remove(i);
                        this.addOneIdentityPowerFactor((IExpr)x, clone, map);
                        return true;
                    }
                    return false;
                }, 1)) {
                    return;
                }
                rest.append(expr);
                return;
            }
            rest.append(expr);
        }

        public boolean collectToMapPlus(IExpr key, IExpr expr, IPatternMatcher matcher, Map<IExpr, IASTAppendable> map) {
            if (expr.isFree(matcher, false)) {
                return false;
            }
            if (matcher.test(expr)) {
                this.addPowerFactor(expr, F.C1, map);
                return true;
            }
            if (this.isPowerMatched(expr, matcher)) {
                this.addPowerFactor(expr, F.C1, map);
                return true;
            }
            if (expr.isTimes()) {
                IAST timesAST = (IAST)expr;
                return timesAST.exists((x, i) -> {
                    if (matcher.test((IExpr)x) || this.isPowerMatched((IExpr)x, matcher)) {
                        IAST clone = timesAST.splice(i);
                        this.addOneIdentityPowerFactor((IExpr)x, clone, map);
                        return true;
                    }
                    return false;
                }, 1);
            }
            return false;
        }

        public void addOneIdentityPowerFactor(IExpr key, IAST subAST, Map<IExpr, IASTAppendable> map) {
            IASTAppendable resultList = map.get(key);
            if (resultList == null) {
                resultList = F.PlusAlloc(8);
                map.put(key, resultList);
            }
            resultList.appendOneIdentity(subAST);
        }

        public void addPowerFactor(IExpr key, IExpr value, Map<IExpr, IASTAppendable> map) {
            IASTAppendable resultList = map.get(key);
            if (resultList == null) {
                resultList = F.PlusAlloc(8);
                map.put(key, resultList);
            }
            resultList.append(value);
        }

        public boolean isPowerMatched(IExpr poly, IPatternMatcher matcher) {
            return poly.isPower() && poly.exponent().isNumber() && matcher.test(poly.base());
        }

        @Override
        public void setUp(ISymbol newSymbol) {
        }
    }

    private static class Cancel
    extends AbstractFunctionEvaluator {
        private Cancel() {
        }

        public static boolean isPolynomial(IExpr expr) {
            return expr.isPolynomial(F.CEmptyList);
        }

        private static IExpr[] calculatePlusIntegerGCD(IASTAppendable numeratorPlus, IInteger denominatorInt, IInteger gcd) {
            boolean[] error = new boolean[]{false};
            numeratorPlus.forEach((x, i) -> Cancel.calculateNumeratorGCD(x, i, numeratorPlus, gcd, error));
            if (error[0]) {
                return null;
            }
            IExpr[] result = new IExpr[]{F.C1, numeratorPlus, denominatorInt.div(gcd)};
            return result;
        }

        private static void calculateNumeratorGCD(IExpr arg, int position, IASTAppendable numeratorPlus, IInteger gcd, boolean[] error) {
            if (!error[0]) {
                if (arg.isInteger()) {
                    numeratorPlus.set(position, ((IInteger)arg).div(gcd));
                } else if (arg.isTimes() && arg.first().isInteger()) {
                    IASTMutable times = ((IAST)arg).copy();
                    times.set(1, ((IInteger)times.arg1()).div(gcd));
                    numeratorPlus.set(position, times);
                } else {
                    error[0] = true;
                }
            }
        }

        private static IExpr[] cancelPlusIntegerGCD(IAST numeratorPlus, IInteger denominatorInt) {
            IExpr temp;
            boolean evaled;
            IASTAppendable plus = numeratorPlus.copyAppendable();
            IASTAppendable gcd = F.ast((IExpr)S.GCD, plus.size() + 1);
            gcd.append(denominatorInt);
            boolean bl = evaled = !plus.exists(x -> Cancel.plusExtractGCD(x, gcd));
            if (evaled && (temp = F.eval(gcd)).isInteger() && !temp.isOne()) {
                IInteger igcd = (IInteger)temp;
                return Cancel.calculatePlusIntegerGCD(plus, denominatorInt, igcd);
            }
            return null;
        }

        private static boolean plusExtractGCD(IExpr argument, IASTAppendable gcd) {
            if (argument.isInteger()) {
                gcd.append(argument);
            } else if (argument.isTimes() && argument.first().isInteger()) {
                gcd.append(argument.first());
            } else {
                return true;
            }
            return false;
        }

        public static IExpr togetherPowerTimes(IExpr powerTimesAST) throws JASConversionException {
            IExpr[] parts = Algebra.fractionalParts(powerTimesAST, false);
            if (parts != null && parts[0].isPlus() && parts[1].isPlus()) {
                IExpr[] result;
                IAST numParts = ((IAST)parts[0]).partitionPlus(x -> Cancel.isPolynomial(x), F.C0, F.C1, S.List);
                IAST denParts = ((IAST)parts[1]).partitionPlus(x -> Cancel.isPolynomial(x), F.C0, F.C1, S.List);
                if (denParts.isPresent() && !denParts.arg1().isOne() && (result = Algebra.cancelGCD(numParts.arg1(), denParts.arg1())) != null) {
                    return F.Times(result[0], result[1], numParts.arg2(), F.Power((IExpr)F.Times(result[2], denParts.arg2()), F.CN1));
                }
            }
            return F.NIL;
        }

        private static IExpr cancelPowerTimes(IExpr powerTimesAST, EvalEngine engine) throws JASConversionException {
            IExpr[] parts = Algebra.fractionalParts(powerTimesAST, false);
            if (parts != null) {
                IExpr[] result;
                IAST denParts;
                IAST numParts;
                IExpr p00 = parts[0];
                IExpr p01 = F.C1;
                IExpr p10 = parts[1];
                IExpr p11 = F.C1;
                if (p00.isPlus() && (numParts = ((IAST)p00).partitionPlus(x -> Cancel.isPolynomial(x), F.C0, F.C1, S.List)).isPresent() && !numParts.arg1().isOne()) {
                    p00 = numParts.arg1();
                    p01 = numParts.arg2();
                }
                if (p10.isPlus() && (denParts = ((IAST)p10).partitionPlus(x -> Cancel.isPolynomial(x), F.C0, F.C1, S.List)).isPresent() && !denParts.arg1().isOne()) {
                    p10 = denParts.arg1();
                    p11 = denParts.arg2();
                }
                if (!p10.isOne() && (result = Algebra.cancelGCD(p00, p10)) != null) {
                    return engine.evaluate(F.Times(result[0], result[1], p01, F.Power((IExpr)F.Times(result[2], p11), F.CN1)));
                }
            }
            return F.NIL;
        }

        private static IExpr[] cancelQuotientRemainder(IExpr arg1, IExpr arg2, IExpr variable) {
            IExpr[] result = new IExpr[2];
            try {
                JASConvert jas = new JASConvert(variable, BigRational.ZERO);
                GenPolynomial poly1 = jas.expr2JAS(arg1, false);
                GenPolynomial poly2 = jas.expr2JAS(arg2, false);
                if (poly1.degree() > poly2.degree()) {
                    GenPolynomial[] divRem = poly1.quotientRemainder(poly2);
                    if (!divRem[1].isZERO()) {
                        return null;
                    }
                    result[0] = jas.rationalPoly2Expr((GenPolynomial<BigRational>)divRem[0], false);
                    result[1] = F.C1;
                } else {
                    GenPolynomial[] divRem = poly2.quotientRemainder(poly1);
                    if (!divRem[1].isZERO()) {
                        return null;
                    }
                    result[0] = F.C1;
                    result[1] = jas.rationalPoly2Expr((GenPolynomial<BigRational>)divRem[0], false);
                }
                return result;
            }
            catch (JASConversionException e1) {
                try {
                    JASIExpr jas = new JASIExpr(variable, (RingFactory<IExpr>)ExprRingFactory.CONST);
                    GenPolynomial<IExpr> poly1 = jas.expr2IExprJAS(arg1);
                    GenPolynomial<IExpr> poly2 = jas.expr2IExprJAS(arg2);
                    if (poly1.degree() > poly2.degree()) {
                        GenPolynomial[] divRem = poly1.quotientRemainder(poly2);
                        if (!divRem[1].isZERO()) {
                            return null;
                        }
                        result[0] = jas.exprPoly2Expr((GenPolynomial<IExpr>)divRem[0], variable);
                        result[1] = F.C1;
                    } else {
                        GenPolynomial[] divRem = poly2.quotientRemainder(poly1);
                        if (!divRem[1].isZERO()) {
                            return null;
                        }
                        result[0] = F.C1;
                        result[1] = jas.exprPoly2Expr((GenPolynomial<IExpr>)divRem[0]);
                    }
                    return result;
                }
                catch (JASConversionException e) {
                    LOGGER.debug("Cancel.cancelQuotientRemainder() failed", (Throwable)((Object)e));
                    return null;
                }
            }
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            if (ast.isAST1() && arg1.isAtom()) {
                return arg1;
            }
            IExpr temp = StructureFunctions.threadPlusLogicEquationOperators(arg1, ast, 1);
            if (temp.isPresent()) {
                return temp;
            }
            temp = this.cancelFractionPowers(engine, arg1);
            if (temp.isPresent()) {
                return temp;
            }
            temp = this.cancelNIL(arg1, engine);
            if (temp.isPresent()) {
                return temp;
            }
            return arg1;
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_1;
        }

        private IExpr cancelFractionPowers(EvalEngine engine, IExpr arg1) {
            IExpr[] parts = Algebra.fractionalParts(arg1, false);
            if (parts != null && (parts[0].isPower() && parts[0].exponent().isInteger() || parts[1].isPower() && parts[1].exponent().isInteger())) {
                IExpr temp;
                IExpr numer = parts[0];
                long numerExponent = 1L;
                long denominatorExponent = 1L;
                IExpr denom = parts[1];
                if (numer.isPower()) {
                    numerExponent = numer.exponent().toIntDefault();
                    numer = numer.base();
                }
                if (denom.isPower()) {
                    denominatorExponent = denom.exponent().toIntDefault();
                    denom = denom.base();
                }
                if (numerExponent > 0L && denominatorExponent > 0L && (temp = this.cancelNIL(F.Times(numer, F.Power(denom, -1L)), engine)).isPresent()) {
                    if (numerExponent > denominatorExponent) {
                        long exp = numerExponent - denominatorExponent;
                        return F.Times(F.Power(temp, denominatorExponent), F.Power(numer, exp));
                    }
                    if (numerExponent < denominatorExponent) {
                        long exp = denominatorExponent - numerExponent;
                        return F.Times(F.Power(temp, numerExponent), F.Power(denom, -1L * exp));
                    }
                    return F.Power(temp, numerExponent);
                }
            }
            return F.NIL;
        }

        private IExpr cancelNIL(IExpr arg1, EvalEngine engine) {
            try {
                IExpr result;
                IExpr result2;
                if ((arg1.isTimes() || arg1.isPower()) && (result2 = Cancel.togetherPowerTimes(arg1)).isPresent()) {
                    return result2;
                }
                IExpr expandedArg1 = F.evalExpandAll(arg1, engine);
                if (expandedArg1.isPlus()) {
                    return ((IAST)expandedArg1).mapThread(F.Cancel(F.Slot1), 1);
                }
                if ((expandedArg1.isTimes() || expandedArg1.isPower()) && (result = Cancel.cancelPowerTimes(expandedArg1, engine)).isPresent()) {
                    return result;
                }
            }
            catch (JASConversionException jce) {
                LOGGER.debug("Cancle failed", (Throwable)((Object)jce));
            }
            return F.NIL;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    private static class Apart
    extends AbstractFunctionEvaluator {
        private Apart() {
        }

        private static IExpr[] fractionalPartsPower(IAST powerAST, boolean trig, boolean splitPowerPlusExponents) {
            IExpr positiveExpr;
            IExpr[] parts = new IExpr[2];
            parts[0] = F.C1;
            IExpr base = powerAST.base();
            IExpr exponent = powerAST.exponent();
            if (exponent.isReal()) {
                IExpr denomForm;
                IAST function;
                IExpr numerForm;
                ISignedNumber sn = (ISignedNumber)exponent;
                if (sn.isMinusOne()) {
                    parts[1] = base;
                    return parts;
                }
                if (sn.isNegative()) {
                    parts[1] = F.Power(base, sn.negate());
                    return parts;
                }
                if (sn.isInteger() && base.isAST() && (numerForm = Numerator.getTrigForm(function = (IAST)base, trig)).isPresent() && (denomForm = Denominator.getTrigForm(function, trig)).isPresent()) {
                    parts[0] = F.Power(numerForm, sn);
                    parts[1] = F.Power(denomForm, sn);
                    return parts;
                }
            } else if (splitPowerPlusExponents && exponent.isPlus()) {
                IAST plusAST = (IAST)exponent;
                IASTAppendable[] result = plusAST.filterNIL(AbstractFunctionEvaluator::getNormalizedNegativeExpression);
                parts[1] = base.power(result[0].oneIdentity0());
                parts[0] = base.power(result[1].oneIdentity0());
                return parts;
            }
            if ((positiveExpr = AbstractFunctionEvaluator.getNormalizedNegativeExpression(exponent)).isPresent()) {
                parts[1] = F.Power(base, positiveExpr);
                return parts;
            }
            return null;
        }

        @Override
        public IExpr evaluate(IAST ast, EvalEngine engine) {
            IExpr arg1 = ast.arg1();
            IAST tempAST = StructureFunctions.threadLogicEquationOperators(arg1, ast, 1);
            if (tempAST.isPresent()) {
                return tempAST;
            }
            IAST variableList = null;
            if (ast.isAST2()) {
                variableList = Validate.checkIsVariableOrVariableList(ast, 2, ast.topHead(), engine);
                if (!variableList.isPresent()) {
                    return F.NIL;
                }
            } else {
                VariablesSet eVar = new VariablesSet(arg1);
                if (eVar.isSize(0)) {
                    return F.evalExpandAll(arg1, engine);
                }
                if (!eVar.isSize(1)) {
                    return F.evalExpandAll(arg1, engine);
                }
                variableList = eVar.getVarList();
            }
            if (variableList.size() == 2 && (arg1.isTimes() || arg1.isPower())) {
                IExpr variable;
                IExpr temp;
                IExpr[] parts = Algebra.fractionalParts(arg1, false);
                if (parts != null && (temp = Algebra.partsApart(parts, variable = variableList.arg1(), engine)).isPresent()) {
                    return temp;
                }
                return arg1;
            }
            return F.evalExpandAll(arg1, engine);
        }

        @Override
        public int[] expectedArgSize(IAST ast) {
            return ARGS_1_2;
        }

        @Override
        public void setUp(ISymbol newSymbol) {
            newSymbol.setAttributes(512);
        }
    }

    protected static class InternalFindCommonFactorPlus {
        protected InternalFindCommonFactorPlus() {
        }

        private static void splitTimesArg1(IExpr expr, HashMap<IExpr, IInteger> map) {
            if (expr.isTimes()) {
                IAST timesAST = (IAST)expr;
                for (int i = 1; i < timesAST.size(); ++i) {
                    IExpr arg = timesAST.get(i);
                    if (arg.isPower() && arg.exponent().isInteger()) {
                        if (arg.base().isNumber()) continue;
                        map.put(arg.base(), (IInteger)arg.exponent());
                        continue;
                    }
                    if (arg.isNumber()) continue;
                    map.put(arg, F.C1);
                }
            } else if (expr.isPower() && expr.exponent().isInteger()) {
                if (!expr.base().isNumber()) {
                    map.put(expr.base(), (IInteger)expr.exponent());
                }
            } else if (!expr.isNumber()) {
                map.put(expr, F.C1);
            }
        }

        private static boolean splitTimesRest(IExpr expr, HashMap<IExpr, IInteger> map) {
            block19: {
                if (map.size() <= 0) break block19;
                if (expr.isTimes()) {
                    IAST timesAST = (IAST)expr;
                    Iterator<Map.Entry<IExpr, IInteger>> iter = map.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry<IExpr, IInteger> entry = iter.next();
                        IExpr key = entry.getKey();
                        boolean foundValue = false;
                        for (int i = 1; i < timesAST.size(); ++i) {
                            IInteger value;
                            IExpr arg = timesAST.get(i);
                            if (arg.isPower() && arg.exponent().isInteger()) {
                                IInteger exponent;
                                if (!arg.base().equals(key)) continue;
                                value = entry.getValue();
                                if (value.equals((exponent = (IInteger)arg.exponent()).negate())) {
                                    return false;
                                }
                                if (exponent.isNegative()) {
                                    if (value.isLT(exponent)) {
                                        entry.setValue(exponent);
                                    }
                                } else if (value.isGT(exponent)) {
                                    entry.setValue(exponent);
                                }
                                foundValue = true;
                                break;
                            }
                            if (!arg.equals(key)) continue;
                            value = entry.getValue();
                            if (value.isMinusOne()) {
                                return false;
                            }
                            if (value.isGT(F.C1)) {
                                entry.setValue(F.C1);
                            }
                            foundValue = true;
                            break;
                        }
                        if (foundValue) continue;
                        iter.remove();
                        if (map.size() != 0) continue;
                        return false;
                    }
                } else {
                    Iterator<Map.Entry<IExpr, IInteger>> iter = map.entrySet().iterator();
                    while (iter.hasNext()) {
                        IInteger value;
                        Map.Entry<IExpr, IInteger> entry = iter.next();
                        IExpr key = entry.getKey();
                        if (expr.isPower() && expr.exponent().isInteger()) {
                            IInteger exponent;
                            if (!expr.base().equals(key)) {
                                iter.remove();
                                if (map.size() != 0) continue;
                                return false;
                            }
                            value = entry.getValue();
                            if (value.equals((exponent = (IInteger)expr.exponent()).negate())) {
                                return false;
                            }
                            if (exponent.isNegative()) {
                                if (!value.isLT(exponent)) continue;
                                entry.setValue(exponent);
                                continue;
                            }
                            if (!value.isGT(exponent)) continue;
                            entry.setValue(exponent);
                            continue;
                        }
                        if (!expr.equals(key)) {
                            iter.remove();
                            if (map.size() != 0) continue;
                            return false;
                        }
                        value = entry.getValue();
                        if (value.isMinusOne()) {
                            return false;
                        }
                        if (!value.isGT(F.C1)) continue;
                        entry.setValue(F.C1);
                    }
                }
            }
            return map.size() != 0;
        }

        public static IExpr[] findCommonFactors(IAST list, boolean reduceOneIdentityRest) {
            if (list.size() > 2) {
                HashMap<IExpr, IInteger> map = new HashMap<IExpr, IInteger>();
                InternalFindCommonFactorPlus.splitTimesArg1(list.arg1(), map);
                if (map.size() != 0) {
                    for (int i = 2; i < list.size(); ++i) {
                        if (InternalFindCommonFactorPlus.splitTimesRest(list.get(i), map)) continue;
                        return null;
                    }
                    IASTAppendable commonFactor = F.TimesAlloc(map.size());
                    for (Map.Entry<IExpr, IInteger> entry : map.entrySet()) {
                        IExpr key = entry.getKey();
                        IInteger exponent = entry.getValue();
                        if (exponent.isOne()) {
                            commonFactor.append(key);
                            continue;
                        }
                        commonFactor.append(F.Power(key, exponent));
                    }
                    IExpr[] result = new IExpr[2];
                    result[0] = commonFactor.oneIdentity1();
                    if (!result[0].isOne()) {
                        IExpr inverse = result[0].inverse();
                        IASTAppendable commonPlus = F.PlusAlloc(list.size());
                        list.forEach((Consumer<? super IExpr>)((Consumer<IExpr>)x -> commonPlus.append(F.Times(inverse, x))));
                        if (reduceOneIdentityRest) {
                            result[1] = commonPlus.oneIdentity1();
                        }
                        return result;
                    }
                }
            }
            return null;
        }
    }

    private static class Initializer {
        private Initializer() {
        }

        private static void init() {
            S.Apart.setEvaluator(new Apart());
            S.Cancel.setEvaluator(new Cancel());
            S.Collect.setEvaluator(new Collect());
            S.Denominator.setEvaluator(new Denominator());
            S.Distribute.setEvaluator(new Distribute());
            S.Expand.setEvaluator(new Expand());
            S.ExpandAll.setEvaluator(new ExpandAll());
            S.Factor.setEvaluator(new Factor());
            S.FactorSquareFree.setEvaluator(new FactorSquareFree());
            S.FactorSquareFreeList.setEvaluator(new FactorSquareFreeList());
            S.FactorTerms.setEvaluator(new FactorTerms());
            S.Numerator.setEvaluator(new Numerator());
            S.PolynomialExtendedGCD.setEvaluator(new PolynomialExtendedGCD());
            S.PolynomialGCD.setEvaluator(new PolynomialGCD());
            S.PolynomialLCM.setEvaluator(new PolynomialLCM());
            S.PolynomialQ.setEvaluator(new PolynomialQ());
            S.PolynomialQuotient.setEvaluator(new PolynomialQuotient());
            S.PolynomialQuotientRemainder.setEvaluator(new PolynomialQuotientRemainder());
            S.PolynomialRemainder.setEvaluator(new PolynomialRemainder());
            S.PowerExpand.setEvaluator(new PowerExpand());
            S.Root.setEvaluator(new Root());
            S.Together.setEvaluator(new Together());
            S.ToRadicals.setEvaluator(new ToRadicals());
            S.Variables.setEvaluator(new Variables());
        }
    }
}

