/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.basic;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.matheclipse.core.eval.exception.MemoryLimitExceeded;

public class OperationSystem {
    private static final Logger LOGGER = LogManager.getLogger();
    public static int toomCook3Threshold = Integer.MAX_VALUE;
    private static boolean jvm = true;
    private static float maxMemoryUsageFactor = 0.9f;
    private static boolean memoryWarning = false;
    private static long maxMemory = -1L;
    private static boolean abortSystem = false;

    public static boolean isJvm() {
        return jvm;
    }

    public static void setJvm(boolean jvm) {
        OperationSystem.jvm = jvm;
    }

    public static float getMemoryUsageFactor() {
        return maxMemoryUsageFactor;
    }

    public static void setMemoryUsageFactor(float memoryUsageFactor) {
        maxMemoryUsageFactor = memoryUsageFactor;
    }

    public static boolean isMemoryWarning() {
        return memoryWarning;
    }

    public static void setMemoryWarning(boolean memoryWarning) {
        OperationSystem.memoryWarning = memoryWarning;
    }

    public static void checkMemory() {
        OperationSystem.checkMemory(0L);
    }

    public static void checkInterrupt() {
        if (abortSystem) {
            throw new RuntimeException("System is interrupted");
        }
    }

    public static void setInterrupt(boolean interrupt) {
        abortSystem = interrupt;
    }

    public static long getMaxMemory() {
        return maxMemory;
    }

    public static void setMaxMemory(long maxMemory) {
        OperationSystem.maxMemory = maxMemory;
    }

    public static void checkMemory(long additionalMemoryInBytes) {
        if (OperationSystem.isJvm()) {
            float usageFactor;
            Runtime runtime = Runtime.getRuntime();
            if (maxMemory <= 0L) {
                maxMemory = runtime.maxMemory();
            }
            long usedMemory = runtime.totalMemory() - runtime.freeMemory() + additionalMemoryInBytes;
            if (LOGGER.isDebugEnabled()) {
                OperationSystem.printMemoryUsage(maxMemory, usedMemory);
            }
            if (maxMemory > 0L && maxMemory < Long.MAX_VALUE && usedMemory > 0L && (usageFactor = (float)usedMemory / (float)maxMemory) < 1.0f && usageFactor > maxMemoryUsageFactor) {
                LOGGER.debug("usedMemory = {}; maxMemory = {}", (Object)usedMemory, (Object)maxMemory);
                throw new OutOfMemoryError("Out of memory");
            }
        } else {
            if (maxMemory <= 0L) {
                return;
            }
            Runtime runtime = Runtime.getRuntime();
            long usedMemory = runtime.totalMemory() + additionalMemoryInBytes;
            if (LOGGER.isDebugEnabled()) {
                OperationSystem.printMemoryUsage(maxMemory, usedMemory);
            }
            if (usedMemory > maxMemory || memoryWarning) {
                LOGGER.debug("usedMemory = {}; maxMemory = {}", (Object)usedMemory, (Object)maxMemory);
                throw new OutOfMemoryError("Out of memory");
            }
        }
    }

    private static void printMemoryUsage(long maxMemory, long usageMemory) {
        int max = 50;
        int usage = (int)((float)usageMemory / (float)maxMemory * (float)max);
        StringBuilder str = new StringBuilder("[");
        for (int i = 1; i <= max; ++i) {
            if (i <= usage) {
                str.append("=");
                continue;
            }
            str.append(" ");
        }
        str.append("] ");
        str.append(" ").append(OperationSystem.toMegabytes(usageMemory)).append("/").append(OperationSystem.toMegabytes(maxMemory));
        LOGGER.debug((CharSequence)str);
    }

    private static String toMegabytes(long bytes) {
        return bytes / 1024L / 1024L + " MB";
    }

    public static void checkMultiplicationOperation(int magLength1, long magLength2) {
        LOGGER.debug("magLength1 = {}", (Object)magLength1);
        LOGGER.debug("magLength2 = {}", (Object)magLength2);
        if (magLength1 > toomCook3Threshold && magLength2 > (long)toomCook3Threshold) {
            throw new MemoryLimitExceeded("toomCook3Threshold " + toomCook3Threshold + " limit exceeded. magLength1 = " + magLength1 + "; magLength2 = " + magLength2);
        }
    }

    static {
        OperationSystem.setJvm(true);
    }
}

