/*
 * Decompiled with CFR 0.152.
 */
package org.matheclipse.core.basic;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hipparchus.util.Precision;
import org.matheclipse.core.eval.EvalEngine;
import org.matheclipse.core.expression.F;
import org.matheclipse.core.interfaces.IAST;
import org.matheclipse.core.interfaces.IASTAppendable;
import org.matheclipse.core.interfaces.IExpr;
import org.matheclipse.core.interfaces.IPattern;
import org.matheclipse.core.interfaces.IPatternSequence;
import org.matheclipse.core.interfaces.IStringX;
import org.matheclipse.core.interfaces.ISymbol;
import org.matheclipse.core.numbertheory.IPrimality;
import org.matheclipse.core.numbertheory.Primality;
import org.matheclipse.parser.trie.TrieBuilder;
import org.matheclipse.parser.trie.TrieMatch;
import org.matheclipse.parser.trie.TrieSequencer;
import org.matheclipse.parser.trie.TrieSequencerIntArray;

public class Config {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final boolean SHOW_STACKTRACE = false;
    public static final String SYMJA = "     _______.____    ____ .___  ___.        __       ___      \n    /       |\\   \\  /   / |   \\/   |       |  |     /   \\     \n   |   (----` \\   \\/   /  |  \\  /  |       |  |    /  ^  \\    \n    \\   \\      \\_    _/   |  |\\/|  | .--.  |  |   /  /_\\  \\   \n.----)   |       |  |     |  |  |  | |  `--'  |  /  _____  \\  \n|_______/        |__|     |__|  |__|  \\______/  /__/     \\__\\ \n                                                              \n";
    public static final String COPYRIGHT = "\nCopyright (C) 2009 - 2022 - the Symja team.\nThis program comes with ABSOLUTELY NO WARRANTY.\nDistributed under the GNU Public License.\nSee the file license.txt\n\n";
    public static Cache<IExpr, Object> EXPR_CACHE;
    private static final int MAX_EXPR_CACHE_SIZE = 10000;
    public static final int MAX_FACTOR_LEAFCOUNT = 1000;
    public static int MAX_GRAPH_VERTICES_SIZE;
    public static final int MAX_POSSIBLE_ZERO_LEAFCOUNT = 1000;
    public static final int MAX_SIMPLIFY_FACTOR_LEAFCOUNT = 100;
    public static final int MAX_SIMPLIFY_APART_LEAFCOUNT = 100;
    public static final int MAX_SIMPLIFY_TOGETHER_LEAFCOUNT = 65;
    public static long MAX_INPUT_LEAVES;
    public static int MAX_OUTPUT_SIZE;
    public static int MAX_OUTPUT_LINE;
    public static int MAX_AST_SIZE;
    public static int MAX_MATRIX_DIMENSION_SIZE;
    public static int MAX_BIT_LENGTH;
    public static int MAX_POLYNOMIAL_DEGREE;
    public static long MAX_LOOP_COUNT;
    public static final int MIN_LIMIT_PERSISTENT_LIST = 32;
    public static boolean SWING_PLOT_FRAME;
    public static final long FOREVER = 0L;
    public static final long TIME_CONSTRAINED_SLEEP_MILLISECONDS = 500L;
    public static final boolean DEBUG = false;
    public static boolean TRACE_REWRITE_RULE;
    public static boolean FUZZ_TESTING;
    public static boolean FUZZY_PARSER;
    public static int SHORTEN_STRING_LENGTH;
    public static final boolean SHOW_PATTERN_EVAL_STEPS = false;
    public static final Set<ISymbol> SHOW_PATTERN_SYMBOL_STEPS;
    public static IAST SCRIPT_COMMAND_LINE;
    public static boolean SERIALIZE_SYMBOLS;
    public static boolean SERVER_MODE;
    public static boolean UNPROTECT_ALLOWED;
    public static double DOUBLE_EPSILON;
    public static double DOUBLE_TOLERANCE;
    public static double ZERO_IN_OUTPUT_FORMAT;
    public static double MACHINE_EPSILON;
    public static double DEFAULT_ROOTS_CHOP_DELTA;
    public static double SPECIAL_FUNCTIONS_TOLERANCE;
    public static int INTEGRATE_BY_PARTS_RECURSION_LIMIT;
    public static int INTEGRATE_RUBI_RULES_RECURSION_LIMIT;
    public static int INTEGRATE_RUBI_TIMELIMIT;
    public static int LIMIT_LHOSPITAL_RECURSION_LIMIT;
    public static boolean JAS_NO_THREADS;
    public static boolean JAVA_UNSAFE;
    public static boolean TIMECONSTRAINED_NO_THREAD;
    public static ThreadFactory THREAD_FACTORY;
    @Deprecated
    public static final long MACHINE_PRECISION = 16L;
    public static long MAX_PRECISION_APFLOAT;
    public static boolean MATHML_TRIG_LOWERCASE;
    public static boolean MATRIX_TEXFORM;
    public static boolean FILESYSTEM_ENABLED;
    public static boolean EXPENSIVE_JUNIT_TESTS;
    public static boolean PACKAGE_MODE;
    public static Consumer<IExpr> PRINT_OUT;
    public static IPrimality PRIME_FACTORS;
    public static boolean USE_MANIPULATE_JS;
    public static boolean USE_VISJS;
    public static final String TRACEFORM_PAGE = "<!doctype html>\n<html>\n  <head>\n       <meta charset=\"utf-8\">\n     <title>JSLists - Very simple nested list [Example 1]</title>\n     \n<style>\n*, *:before, *:after {box-sizing: border-box;}\nul, ol {margin: 0; padding: 0;}\nli {list-style: none; line-height: 1.6rem;}\n\n/* List styling */\n.jslists{\n   font-size: 1.3rem;\n   font-family: Arial, Helvetica, sans-serif;\n}\n.jslist-ul, .jslist-ol, .jslist-li {margin-left: 12px;}        /* Unordered lists */\n.jsl-collapsed {display: none;}\n.jsl-list-closed {\n    float: left;\n   clear: both;\n margin: 2px 4px 2px 0px;\n width: 18px;\n   height: 18px;\n    cursor: pointer;\n   background-image: url('data:image/svg+xml;utf8,<svg aria-hidden=\"true\" data-prefix=\"far\" data-icon=\"plus-square\" class=\"svg-inline--fa fa-plus-square fa-w-14\" role=\"img\" xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 448 512\"><path fill=\"currentColor\" d=\"M352 240v32c0 6.6-5.4 12-12 12h-88v88c0 6.6-5.4 12-12 12h-32c-6.6 0-12-5.4-12-12v-88h-88c-6.6 0-12-5.4-12-12v-32c0-6.6 5.4-12 12-12h88v-88c0-6.6 5.4-12 12-12h32c6.6 0 12 5.4 12 12v88h88c6.6 0 12 5.4 12 12zm96-160v352c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V80c0-26.5 21.5-48 48-48h352c26.5 0 48 21.5 48 48zm-48 346V86c0-3.3-2.7-6-6-6H54c-3.3 0-6 2.7-6 6v340c0 3.3 2.7 6 6 6h340c3.3 0 6-2.7 6-6z\"></path></svg>');\n    background-repeat: no-repeat;\n    background-position: center; \n}\n.jsl-open {display: block;}\n.jsl-list-open {background-image: url('data:image/svg+xml;utf8,<svg aria-hidden=\"true\" data-prefix=\"far\" data-icon=\"minus-square\" class=\"svg-inline--fa fa-minus-square fa-w-14\" role=\"img\" xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 448 512\"><path fill=\"currentColor\" d=\"M108 284c-6.6 0-12-5.4-12-12v-32c0-6.6 5.4-12 12-12h232c6.6 0 12 5.4 12 12v32c0 6.6-5.4 12-12 12H108zM448 80v352c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V80c0-26.5 21.5-48 48-48h352c26.5 0 48 21.5 48 48zm-48 346V86c0-3.3-2.7-6-6-6H54c-3.3 0-6 2.7-6 6v340c0 3.3 2.7 6 6 6h340c3.3 0 6-2.7 6-6z\"></path></svg>');}\n\n            html, body {\n             width: 100%;\n               height: 100%;\n                margin: 0;\n               padding: 0;\n          }\n            body {\n               font-family: Arial, Helvetica, sans-serif;\n               font-size: 16px;\n         }\n            header {\n               position: absolute;\n              top: 0;\n               left: 0;\n             width: 100%;\n               height: 90px;\n               background-color: rgb(156, 158, 160);\n               padding-left: 18px;\n          }\n           header > div {\n               position: relative;\n               display: inline-block;\n               top: 50%;\n               transform: translateY(-50%);\n             font-size: 3.4rem;\n               font-weight: 900;\n            }\n            main {\n               position: absolute;\n              top: 90px;\n               height: calc(100vh - 90px);\n          }\n           main > div:nth-child(1) {\n                padding: 16px;\n           }\n            main > div:nth-child(2) {\n               padding: 18px;\n</style>\n    </head>\n  <body> \n               <ul id='traceform' class='jslists'>\n                   <li>TraceForm\n`1`\n                 </li>\n                </ul>\n            </div>\n \n       <script>\nvar blackCircle = '&#9679; ';\nvar openCircle = '&#9678; ';\n\n(function() {\n \"use strict\";\n    function define_JSLists() {\n     var JSLists = {};\n\n       var JSLists_Error = function(error, alertType) {\n           console.log(error);\n      }\n        var getUl = function(){\n           return document.getElementsByTagName(\"UL\");\n        };\n\n       var getOl = function(){\n           return document.getElementsByTagName(\"OL\");\n        };\n\n       var getAllLists = function(){\n           var olLists = Array.prototype.slice.call(document.getElementsByTagName(\"UL\")),\n               ulLists = Array.prototype.slice.call(document.getElementsByTagName(\"OL\"))\n           var gLists = olLists.concat(ulLists);\n            return gLists;\n       }\n\n     JSLists.searchList = function(listId, searchTerm) {\n           var i, j, lilNodes, liItems = document.getElementsByTagName(\"LI\");\n           for(i=0; i<liItems.length; i++) {\n                if(liItems[i].hasChildNodes()) {\n                    for(j=0; j<liItems[i].childNodes.length; j++) {\n                        if(liItems[i].childNodes[j].innerHTML == searchTerm) {\n                           //?????\n                        }\n                    }\n                }\n           }\n        }\n\n        JSLists.collapseAll = function(listId) {\n           var i, ulLists = document.getElementsByTagName(\"UL\");\n           for(i=0; i<ulLists.length; i++) {\n               if(ulLists[i].className == \"jsl-collapsed\") {\n                    console.log(ulLists[i].className + '\\n' + '@');\n               }\n            };\n       };\n\n       JSLists.openAll = function(listId){\n           var i, olLists = Array.prototype.slice.call(document.getElementsByTagName(\"UL\")),\n               ulLists = Array.prototype.slice.call(document.getElementsByTagName(\"OL\"))\n           var gLists = olLists.concat(ulLists);\n\n           for(i=1; i<gLists.length; i++) {\n               gLists[i].setAttribute('class', 'jsl-open');\n         };\n       };\n\n        JSLists.padUnorderedLists = function(listId) {\n           var i, listItems = document.getElementById(listId).getElementsByTagName(\"UL\");\n           for(i=0; i<listItems.length; i++) {\n               listItems[i].classList.add('jslist-ul');\n         }\n       };\n\n        JSLists.padOrderedLists = function(listId) {\n           var i, listItems = document.getElementById(listId).getElementsByTagName(\"UL\");\n           for(i=0; i<listItems.length; i++) {\n               listItems[i].classList.add('jslist-ol');\n         }\n       };\n\n        JSLists.padLists = function(listId) {\n           var i, listItems = document.getElementById(listId).getElementsByTagName(\"LI\");\n           for(i=0; i<listItems.length; i++) {\n               if(listItems[i].childNodes[0].className != \"jsl-collapsed-arrow\") {\n                   listItems[i].classList.add('jslist-li');\n             }\n           }\n            for(i=1; i<listItems.length; i++) {\n               // console.log(listItems[i].childNodes.length);\n               if(listItems[i].classList = \"jslist-li\" && listItems[i].childNodes.length < 2) {\n                   listItems[i].innerHTML = blackCircle + listItems[i].innerHTML\n               }\n            }\n           this.padUnorderedLists(listId);\n           this.padOrderedLists(listId);\n        };\n\n        JSLists.createTree = function(listId, bulletPoint) {\n           document.getElementById(listId).style.display = \"none;\"\n           var i, j, curElem, ulCount, olCount, listItems = document.getElementById(listId).getElementsByTagName('LI'); //this should be the main parent\n           for(i=0; i<listItems.length; i++) {\n               if(listItems[i].id.length > 0) {\n                   curElem = document.getElementById(listItems[i].id);\n                    ulCount = document.getElementById(listItems[i].id).getElementsByTagName(\"UL\");\n                    if(ulCount.length > 0){\n                        for(j=0; j<ulCount.length; j++) {\n                            if(ulCount[j].nodeName == \"UL\") {\n                                break;\n                            }\n                        }\n                        ulCount[j].setAttribute('class', 'jsl-collapsed');\n                        var tglDiv = document.createElement(\"div\");\n                        tglDiv.setAttribute('class', 'jsl-list-closed');\n                        tglDiv.setAttribute(\"id\", listItems[i].id + i +'_tgl');\n                        curElem.insertBefore(tglDiv, curElem.childNodes[0]);\n\n                        document.getElementById(listItems[i].id + i +'_tgl').addEventListener('click', function(e) {\n                            document.getElementById(e.target.id).classList.toggle('jsl-list-open');\n                            document.getElementById(e.target.id).parentElement.lastElementChild.classList.toggle('jsl-open');\n                            e.stopPropagation();\n                        },true);\n                    }\n                } else {\n                   listItems[i].setAttribute(\"id\", listId+\"tmp\"+i);\n                   curElem = document.getElementById(listId+\"tmp\"+i);\n                   ulCount = document.getElementById(listItems[i].id).getElementsByTagName(\"UL\");\n\n                   if(ulCount.length > 0) { //There is a nested UL in this LI element, now find the position of the UL\n                       for(j=0; j<ulCount.length; j++) {\n                           if(ulCount[j].nodeName == \"UL\") {\n                               break; //Multiple UL's? //Set class collapseAll here\n                           }\n                        }\n                       ulCount[j].setAttribute('class', 'jsl-collapsed');\n                       var tglDiv = document.createElement(\"div\");\n                       tglDiv.setAttribute('class', 'jsl-list-closed');\n                       tglDiv.setAttribute(\"id\", listItems[i].id + i +'_tgl');\n                       curElem.insertBefore(tglDiv, curElem.childNodes[0]);\n\n                       document.getElementById(listItems[i].id + i +'_tgl').addEventListener('click', function(e){\n                           document.getElementById(e.target.id).classList.toggle('jsl-list-open');\n                           document.getElementById(e.target.id).parentElement.lastElementChild.classList.toggle('jsl-open');\n                           e.stopPropagation();\n                     },true);\n                   }\n                    listItems[i].removeAttribute(\"id\");\n               }\n            }\n            setTimeout(function() {\n               document.getElementById(listId).style.display = \"block;\"\n           }, 50); // stops FOUC!\n           this.padLists(listId);\n       };\n\n       // JSLists.applyToList = function(listId, listType, applyIcons, applyTheme, themeNumber){\n       //Check the params here\n      // does the id exist?\n       JSLists.applyToList = function(listId, bulletPoint) {\n            this.createTree(listId, \"UL\");\n        };\n   return JSLists;\n    }\n\n   //define the JSLists library in the global namespace if it doesn't already exist\n   if(typeof(JSLists) === 'undefined') {\n       window.JSLists = define_JSLists();\n   }else{\n       console.log(\"JSLists already defined.\");\n   }\n})();       \n       </script>\n        <script> \n           JSLists.createTree(\"traceform\");\n       </script>\n   </body>\n</html>";
    public static final String VISJS_PAGE = "<html>\n<head>\n<meta charset=\"utf-8\">\n<head>\n  <title>VIS-Network</title>\n\n  <script type=\"text/javascript\" src=\"https://cdn.jsdelivr.net/npm/vis-network@6.0.0/dist/vis-network.min.js\"></script>\n  <style type=\"text/css\">\n    #mynetwork {\n      width: 600px;\n      height: 400px;\n      border: 1px solid lightgray;\n    }\n  </style>\n</head>\n<body>\n\n<h1>VIS-Network</h1>\n\n<div id=\"vis\"></div>\n\n<script type=\"text/javascript\">\n`1`\n  // create a network\n  var container = document.getElementById('vis');\n  var data = {\n    nodes: nodes,\n    edges: edges\n  };\n`2`\n  var network = new vis.Network(container, data, options);\n</script>\n\n\n</body>\n</html>";
    public static final String SVG_PAGE = "<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" viewBox=\"-0.333333 -0.333333 350.666667 350.666667\" width=\"350.6666666px\" height=\"350.6666666px\">\n`1`\n</svg>";
    public static final String HTML_PAGE = "<html>\n<head>\n<meta charset=\"utf-8\">\n<title>HTML</title>\n</head>\n<body>\n`1`\n</body>\n</html>";
    public static final double DEFAULT_CHOP_DELTA = 1.0E-10;
    public static boolean RUBI_CONVERT_SYMBOLS;
    public static final TrieBuilder<int[], IExpr, ArrayList<IExpr>> TRIE_INT2EXPR_BUILDER;
    public static final TrieBuilder<String, IExpr, ArrayList<IExpr>> TRIE_STRING2EXPR_BUILDER;
    public static final TrieBuilder<String, ISymbol, ArrayList<ISymbol>> TRIE_STRING2SYMBOL_BUILDER;
    public static final TrieBuilder<String, IStringX, ArrayList<IStringX>> TRIE_STRING2STRINGX_BUILDER;
    public static final TrieBuilder<String, IPattern, ArrayList<IPattern>> TRIE_STRING2PATTERN_BUILDER;
    public static final TrieBuilder<String, IPatternSequence, ArrayList<IPatternSequence>> TRIE_STRING2PATTERNSEQUENCE_BUILDER;
    public static final int DEFAULT_RECURSION_LIMIT = 512;
    public static final int DEFAULT_ITERATION_LIMIT = 1000;
    public static int BUILTIN_PROTECTED;
    public static URLClassLoader URL_CLASS_LOADER;

    public static boolean isFileSystemEnabled(EvalEngine engine) {
        return FILESYSTEM_ENABLED || engine.isFileSystemEnabled();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getVersion() {
        try (InputStream resourceAsStream = Config.class.getResourceAsStream("/META-INF/maven/org.matheclipse/matheclipse-core/pom.properties");){
            if (resourceAsStream == null) return "0.0.0";
            Properties prop = new Properties();
            prop.load(resourceAsStream);
            String string = prop.getProperty("version");
            return string;
        }
        catch (IOException e) {
            LOGGER.error("Config.getVersion() failed", (Throwable)e);
        }
        return "0.0.0";
    }

    public static void setScriptCommandLine(String[] args) {
        IASTAppendable commandLine = F.ListAlloc(args.length + 1);
        String javaHome = System.getProperty("java.home");
        if (javaHome != null) {
            commandLine.append(javaHome);
        } else {
            commandLine.append("");
        }
        for (int i = 0; i < args.length; ++i) {
            commandLine.append(args[i]);
        }
        LOGGER.info((Object)commandLine);
        SCRIPT_COMMAND_LINE = commandLine;
    }

    static {
        MAX_GRAPH_VERTICES_SIZE = 100;
        MAX_INPUT_LEAVES = Long.MAX_VALUE;
        MAX_OUTPUT_SIZE = Integer.MAX_VALUE;
        MAX_OUTPUT_LINE = 80;
        MAX_AST_SIZE = Integer.MAX_VALUE;
        MAX_MATRIX_DIMENSION_SIZE = Integer.MAX_VALUE;
        MAX_BIT_LENGTH = Integer.MAX_VALUE;
        MAX_POLYNOMIAL_DEGREE = Integer.MAX_VALUE;
        MAX_LOOP_COUNT = Long.MAX_VALUE;
        EXPR_CACHE = CacheBuilder.newBuilder().maximumSize(10000L).weakKeys().weakValues().build();
        SWING_PLOT_FRAME = false;
        TRACE_REWRITE_RULE = false;
        FUZZ_TESTING = false;
        FUZZY_PARSER = false;
        SHORTEN_STRING_LENGTH = 80;
        SHOW_PATTERN_SYMBOL_STEPS = new HashSet<ISymbol>();
        SCRIPT_COMMAND_LINE = null;
        SERIALIZE_SYMBOLS = false;
        SERVER_MODE = false;
        UNPROTECT_ALLOWED = true;
        DOUBLE_EPSILON = Precision.EPSILON;
        DOUBLE_TOLERANCE = DOUBLE_EPSILON * 10.0;
        ZERO_IN_OUTPUT_FORMAT = 1.0E-100;
        MACHINE_EPSILON = Math.nextUp(1.0) - 1.0;
        DEFAULT_ROOTS_CHOP_DELTA = 1.0E-5;
        SPECIAL_FUNCTIONS_TOLERANCE = 1.0E-10;
        INTEGRATE_BY_PARTS_RECURSION_LIMIT = 10;
        INTEGRATE_RUBI_RULES_RECURSION_LIMIT = 100;
        INTEGRATE_RUBI_TIMELIMIT = 8;
        LIMIT_LHOSPITAL_RECURSION_LIMIT = 128;
        JAS_NO_THREADS = false;
        JAVA_UNSAFE = false;
        TIMECONSTRAINED_NO_THREAD = false;
        THREAD_FACTORY = null;
        MAX_PRECISION_APFLOAT = 32767L;
        MATHML_TRIG_LOWERCASE = true;
        MATRIX_TEXFORM = true;
        FILESYSTEM_ENABLED = false;
        EXPENSIVE_JUNIT_TESTS = false;
        PACKAGE_MODE = true;
        PRINT_OUT = x -> {};
        PRIME_FACTORS = new Primality();
        USE_MANIPULATE_JS = true;
        USE_VISJS = false;
        RUBI_CONVERT_SYMBOLS = false;
        TRIE_INT2EXPR_BUILDER = new TrieBuilder((TrieSequencer)TrieSequencerIntArray.INSTANCE, TrieMatch.EXACT, () -> new ArrayList(), (Object)null, false);
        TRIE_STRING2EXPR_BUILDER = TrieBuilder.create();
        TRIE_STRING2SYMBOL_BUILDER = TrieBuilder.create();
        TRIE_STRING2STRINGX_BUILDER = TrieBuilder.create();
        TRIE_STRING2PATTERN_BUILDER = TrieBuilder.create();
        TRIE_STRING2PATTERNSEQUENCE_BUILDER = TrieBuilder.create();
        BUILTIN_PROTECTED = 32768;
        URL_CLASS_LOADER = null;
    }
}

