/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.message.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import org.mariadb.r2dbc.ExceptionFactory;
import org.mariadb.r2dbc.client.Client;
import org.mariadb.r2dbc.message.ClientMessage;
import org.mariadb.r2dbc.message.Context;
import org.mariadb.r2dbc.message.MessageSequence;
import org.mariadb.r2dbc.message.client.PreparePacket;
import org.mariadb.r2dbc.message.server.Sequencer;
import org.mariadb.r2dbc.util.BindValue;
import org.mariadb.r2dbc.util.ServerPrepareResult;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class ExecutePacket
implements ClientMessage {
    private final BindValue[] bindValues;
    private int statementId;
    private final int parameterCount;
    private final String sql;
    private final MessageSequence sequencer = new Sequencer(-1);
    private ByteBuf savedBuf = null;

    public ExecutePacket(String sql, ServerPrepareResult prepareResult, BindValue[] bindValues) {
        this.sql = sql;
        this.bindValues = bindValues;
        this.statementId = prepareResult == null ? -1 : prepareResult.getStatementId();
        this.parameterCount = prepareResult == null ? bindValues.length : prepareResult.getNumParams();
    }

    @Override
    public Mono<ByteBuf> encode(Context context, ByteBufAllocator allocator) {
        if (this.savedBuf != null) {
            ByteBuf tmp = this.savedBuf;
            this.savedBuf = null;
            return Mono.just((Object)tmp);
        }
        ByteBuf buf = allocator.ioBuffer();
        buf.writeByte(23);
        buf.writeIntLE(this.statementId);
        buf.writeByte(0);
        buf.writeIntLE(1);
        boolean direct = true;
        if (this.parameterCount > 0) {
            int i2;
            int nullCount = (this.parameterCount + 7) / 8;
            byte[] nullBitsBuffer = new byte[nullCount];
            for (i2 = 0; i2 < this.parameterCount; ++i2) {
                BindValue param = this.bindValues[i2];
                if (param.isNull()) {
                    int n = i2 / 8;
                    nullBitsBuffer[n] = (byte)(nullBitsBuffer[n] | 1 << i2 % 8);
                }
                if (param.getCodec().isDirect()) continue;
                direct = false;
            }
            buf.writeBytes(nullBitsBuffer);
            buf.writeByte(1);
            for (i2 = 0; i2 < this.parameterCount; ++i2) {
                buf.writeShortLE((int)this.bindValues[i2].getCodec().getBinaryEncodeType().get());
            }
        }
        if (direct) {
            for (int i3 = 0; i3 < this.parameterCount; ++i3) {
                if (this.bindValues[i3].isNull()) continue;
                this.bindValues[i3].encodeDirectBinary(allocator, buf, context);
            }
            return Mono.just((Object)buf);
        }
        return Flux.range((int)0, (int)this.parameterCount).flatMap(i -> {
            BindValue param = this.bindValues[i];
            if (param.getValue() != null) {
                if (param.getCodec().isDirect()) {
                    param.encodeDirectBinary(allocator, buf, context);
                } else {
                    return param.encodeBinary(allocator).map(b -> {
                        buf.writeBytes(b);
                        b.release();
                        return Mono.empty();
                    });
                }
            }
            return Mono.empty();
        }).then(Mono.just((Object)buf));
    }

    public Mono<ClientMessage> rePrepare(Client client) {
        ServerPrepareResult res;
        if (client.getPrepareCache() != null && (res = (ServerPrepareResult)client.getPrepareCache().get(this.sql)) != null) {
            this.forceStatementId(res.getStatementId());
            return Mono.just((Object)this);
        }
        return client.sendPrepare(new PreparePacket(this.sql), ExceptionFactory.INSTANCE, this.sql).flatMap(serverPrepareResult -> {
            this.forceStatementId(serverPrepareResult.getStatementId());
            return Mono.just((Object)this);
        });
    }

    @Override
    public void save(ByteBuf buf, int initialReaderIndex) {
        this.savedBuf = buf.readerIndex(initialReaderIndex).retain();
    }

    @Override
    public void releaseSave() {
        if (this.savedBuf != null) {
            this.savedBuf.release();
            this.savedBuf = null;
        }
    }

    public void forceStatementId(int statementId) {
        this.statementId = statementId;
        if (this.savedBuf != null) {
            int writerIndex = this.savedBuf.writerIndex();
            this.savedBuf.writerIndex(this.savedBuf.readerIndex() + 1);
            this.savedBuf.writeIntLE(statementId);
            this.savedBuf.writerIndex(writerIndex);
        }
    }

    @Override
    public MessageSequence getSequencer() {
        return this.sequencer;
    }

    @Override
    public void resetSequencer() {
        this.sequencer.reset();
    }

    public String getSql() {
        return this.sql;
    }

    public String toString() {
        return "ExecutePacket{sql='" + this.sql + '\'' + '}';
    }
}

