/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc;

import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mariadb.r2dbc.ExceptionFactory;
import org.mariadb.r2dbc.MariadbConnectionConfiguration;
import org.mariadb.r2dbc.api.MariadbResult;
import org.mariadb.r2dbc.client.Client;
import org.mariadb.r2dbc.message.Protocol;
import org.mariadb.r2dbc.message.ServerMessage;
import org.mariadb.r2dbc.message.client.QueryPacket;
import org.mariadb.r2dbc.util.Assert;
import org.mariadb.r2dbc.util.ClientParser;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;

final class MariadbBatch
implements org.mariadb.r2dbc.api.MariadbBatch {
    private final Client client;
    private final MariadbConnectionConfiguration configuration;
    private final List<String> statements = new ArrayList<String>();

    MariadbBatch(Client client, MariadbConnectionConfiguration configuration) {
        this.client = client;
        this.configuration = configuration;
    }

    @Override
    public MariadbBatch add(String sql) {
        Assert.requireNonNull(sql, "sql must not be null");
        if ((sql.contains("?") || sql.contains(":")) && ClientParser.hasParameter(sql, this.client.noBackslashEscapes())) {
            throw new IllegalArgumentException(String.format("Statement with parameters cannot be batched (sql:'%s')", sql));
        }
        this.statements.add(sql);
        return this;
    }

    @Override
    public Flux<MariadbResult> execute() {
        if (this.configuration.allowMultiQueries()) {
            return this.client.sendCommand(new QueryPacket(String.join((CharSequence)";", this.statements)), true).doOnDiscard(ReferenceCounted.class, ReferenceCountUtil::release).windowUntil(it -> it.resultSetEnd()).map(dataRow -> new org.mariadb.r2dbc.client.MariadbResult(Protocol.TEXT, null, (Flux<ServerMessage>)dataRow, ExceptionFactory.INSTANCE, null, this.client.getVersion().supportReturning(), this.configuration));
        }
        Iterator<String> iterator = this.statements.iterator();
        Sinks.Many commandsSink = Sinks.many().unicast().onBackpressureBuffer();
        AtomicBoolean canceled = new AtomicBoolean();
        return commandsSink.asFlux().map(sql -> this.client.sendCommand(new QueryPacket((String)sql), false).doOnComplete(() -> MariadbBatch.tryNextCommand(iterator, (Sinks.Many<String>)commandsSink, canceled)).windowUntil(it -> it.resultSetEnd()).map(dataRow -> new org.mariadb.r2dbc.client.MariadbResult(Protocol.TEXT, null, (Flux<ServerMessage>)dataRow, ExceptionFactory.INSTANCE, null, this.client.getVersion().supportReturning(), this.configuration)).cast(MariadbResult.class)).flatMap(mariadbResultFlux -> mariadbResultFlux).doOnCancel(() -> canceled.set(true)).doOnSubscribe(it -> commandsSink.emitNext((Object)((String)iterator.next()), Sinks.EmitFailureHandler.FAIL_FAST));
    }

    private static void tryNextCommand(Iterator<String> iterator, Sinks.Many<String> bindingSink, AtomicBoolean canceled) {
        if (canceled.get()) {
            return;
        }
        try {
            if (iterator.hasNext()) {
                bindingSink.emitNext((Object)iterator.next(), Sinks.EmitFailureHandler.FAIL_FAST);
            } else {
                bindingSink.emitComplete(Sinks.EmitFailureHandler.FAIL_FAST);
            }
        }
        catch (Exception e) {
            bindingSink.emitError((Throwable)e, Sinks.EmitFailureHandler.FAIL_FAST);
        }
    }
}

