/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.mysql;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.mariadb.jdbc.internal.common.packet.RawPacket;
import org.mariadb.jdbc.internal.common.packet.buffer.Reader;
import org.mariadb.jdbc.internal.mysql.MySQLType;

public class MySQLColumnInformation {
    RawPacket buffer;
    private short charsetNumber;
    private long length;
    private MySQLType type;
    private byte decimals;
    private short flags;
    private static final int[] maxCharlen = new int[]{0, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 2, 1, 1, 1, 0, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1, 1, 3, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 4, 1, 1, 1, 1, 1, 1, 1, 4, 4, 0, 1, 1, 1, 4, 4, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 1, 1, 1, 1, 1, 3, 2, 2, 2, 2, 2, 1, 2, 3, 1, 1, 1, 2, 2, 3, 3, 1, 0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 0, 3, 4, 4, 0, 0, 0, 0, 0, 0, 0, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public static MySQLColumnInformation create(String name, MySQLType type) {
        try {
            int i;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (i = 0; i < 4; ++i) {
                baos.write(new byte[]{1, 0});
            }
            for (i = 0; i < 2; ++i) {
                baos.write(new byte[]{(byte)name.length()});
                baos.write(name.getBytes());
            }
            baos.write(12);
            baos.write(new byte[]{33, 0});
            int len = 1;
            switch (type.getSqlType()) {
                case 1: 
                case 12: {
                    len = 192;
                    break;
                }
                case 5: {
                    len = 5;
                    break;
                }
                case 0: {
                    len = 0;
                    break;
                }
                default: {
                    len = 1;
                }
            }
            baos.write(new byte[]{(byte)len, 0, 0, 0});
            baos.write(MySQLType.toServer(type.getSqlType()).getType());
            baos.write(new byte[]{0, 0});
            baos.write(0);
            baos.write(new byte[]{0, 0});
            return new MySQLColumnInformation(new RawPacket(ByteBuffer.wrap(baos.toByteArray()).order(ByteOrder.LITTLE_ENDIAN), 0));
        }
        catch (IOException ioe) {
            throw new RuntimeException("unexpected condition", ioe);
        }
    }

    public MySQLColumnInformation(RawPacket buffer) throws IOException {
        this.buffer = buffer;
        buffer.getByteBuffer().mark();
        Reader reader = new Reader(buffer);
        reader.skipLengthEncodedBytes();
        reader.skipLengthEncodedBytes();
        reader.skipLengthEncodedBytes();
        reader.skipLengthEncodedBytes();
        reader.skipLengthEncodedBytes();
        reader.skipLengthEncodedBytes();
        reader.skipBytes(1);
        this.charsetNumber = reader.readShort();
        this.length = reader.readInt();
        this.type = MySQLType.fromServer(reader.readByte() & 0xFF);
        this.flags = reader.readShort();
        this.decimals = reader.readByte();
        int sqlType = this.type.getSqlType();
        if (!(sqlType != 2004 && sqlType != -3 && sqlType != -2 && sqlType != -4 || this.isBinary())) {
            this.type = MySQLType.VARCHAR;
        }
    }

    private String getString(int idx) {
        try {
            this.buffer.getByteBuffer().reset();
            this.buffer.getByteBuffer().mark();
            Reader reader = new Reader(this.buffer);
            for (int i = 0; i < idx; ++i) {
                reader.skipLengthEncodedBytes();
            }
            return new String(reader.getLengthEncodedBytes(), "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException("this does not happen", e);
        }
    }

    public String getCatalog() {
        return null;
    }

    public String getDb() {
        return this.getString(1);
    }

    public String getTable() {
        return this.getString(2);
    }

    public String getOriginalTable() {
        return this.getString(3);
    }

    public String getName() {
        return this.getString(4);
    }

    public String getOriginalName() {
        return this.getString(5);
    }

    public short getCharsetNumber() {
        return this.charsetNumber;
    }

    public long getLength() {
        return this.length;
    }

    public int getDisplaySize() {
        int t = this.type.getSqlType();
        if (t == 12 || t == 1) {
            int maxWidth = maxCharlen[this.charsetNumber & 0xFF];
            if (maxWidth == 0) {
                maxWidth = 1;
            }
            return (int)this.length / maxWidth;
        }
        return (int)this.length;
    }

    public byte getDecimals() {
        return this.decimals;
    }

    public MySQLType getType() {
        return this.type;
    }

    public short getFlags() {
        return this.flags;
    }

    public boolean isSigned() {
        return (this.flags & 0x20) == 0;
    }

    public boolean isBinary() {
        return this.getCharsetNumber() == 63;
    }
}

