/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.util;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import org.mapstruct.ap.internal.util.ElementUtils;
import org.mapstruct.ap.shaded.org.mapstruct.tools.gem.Gem;

public abstract class MetaAnnotations<G extends Gem, V> {
    private static final String JAVA_LANG_ANNOTATION_PGK = "java.lang.annotation";
    private final ElementUtils elementUtils;
    private final String annotationFqn;

    protected MetaAnnotations(ElementUtils elementUtils, String annotationFqn) {
        this.elementUtils = elementUtils;
        this.annotationFqn = annotationFqn;
    }

    public Set<V> getProcessedAnnotations(Element source) {
        return this.getValues(source, source, new LinkedHashSet(), new HashSet<Element>());
    }

    protected abstract G instanceOn(Element var1);

    protected abstract void addInstance(G var1, Element var2, Set<V> var3);

    private Set<V> getValues(Element source, Element element, Set<V> values, Set<Element> handledElements) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            Element annotationElement = annotationMirror.getAnnotationType().asElement();
            if (this.isAnnotation(annotationElement, this.annotationFqn)) {
                G gem = this.instanceOn(element);
                this.addInstance(gem, source, values);
                continue;
            }
            if (!this.isNotJavaAnnotation(element) || handledElements.contains(annotationElement)) continue;
            handledElements.add(annotationElement);
            this.getValues(source, annotationElement, values, handledElements);
        }
        return values;
    }

    private boolean isNotJavaAnnotation(Element element) {
        if (ElementKind.ANNOTATION_TYPE == element.getKind()) {
            return !this.elementUtils.getPackageOf(element).getQualifiedName().contentEquals(JAVA_LANG_ANNOTATION_PGK);
        }
        return true;
    }

    private boolean isAnnotation(Element element, String annotationFqn) {
        if (ElementKind.ANNOTATION_TYPE == element.getKind()) {
            return ((TypeElement)element).getQualifiedName().contentEquals(annotationFqn);
        }
        return false;
    }
}

