/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.gem;

import java.util.HashMap;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.mapstruct.ap.shaded.org.mapstruct.tools.gem.Gem;
import org.mapstruct.ap.shaded.org.mapstruct.tools.gem.GemValue;

public class SubclassMappingGem
implements Gem {
    private final GemValue<TypeMirror> source;
    private final GemValue<TypeMirror> target;
    private final GemValue<List<TypeMirror>> qualifiedBy;
    private final GemValue<List<String>> qualifiedByName;
    private final boolean isValid;
    private final AnnotationMirror mirror;

    private SubclassMappingGem(BuilderImpl builder) {
        this.source = builder.source;
        this.target = builder.target;
        this.qualifiedBy = builder.qualifiedBy;
        this.qualifiedByName = builder.qualifiedByName;
        this.isValid = this.source != null && this.source.isValid() && this.target != null && this.target.isValid() && this.qualifiedBy != null && this.qualifiedBy.isValid() && this.qualifiedByName != null && this.qualifiedByName.isValid();
        this.mirror = builder.mirror;
    }

    public GemValue<TypeMirror> source() {
        return this.source;
    }

    public GemValue<TypeMirror> target() {
        return this.target;
    }

    public GemValue<List<TypeMirror>> qualifiedBy() {
        return this.qualifiedBy;
    }

    public GemValue<List<String>> qualifiedByName() {
        return this.qualifiedByName;
    }

    @Override
    public AnnotationMirror mirror() {
        return this.mirror;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    public static SubclassMappingGem instanceOn(Element element) {
        return SubclassMappingGem.build(element, new BuilderImpl());
    }

    public static SubclassMappingGem instanceOn(AnnotationMirror mirror) {
        return SubclassMappingGem.build(mirror, new BuilderImpl());
    }

    public static <T> T build(Element element, Builder<T> builder) {
        AnnotationMirror mirror = element.getAnnotationMirrors().stream().filter(a -> "org.mapstruct.SubclassMapping".contentEquals(((TypeElement)a.getAnnotationType().asElement()).getQualifiedName())).findAny().orElse(null);
        return SubclassMappingGem.build(mirror, builder);
    }

    public static <T> T build(AnnotationMirror mirror, Builder<T> builder) {
        if (mirror == null || builder == null) {
            return null;
        }
        List<ExecutableElement> enclosed = ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements());
        HashMap defaultValues = new HashMap(enclosed.size());
        enclosed.forEach(e -> defaultValues.put(e.getSimpleName().toString(), e.getDefaultValue()));
        HashMap values = new HashMap(enclosed.size());
        mirror.getElementValues().entrySet().forEach(e -> values.put(((ExecutableElement)e.getKey()).getSimpleName().toString(), (AnnotationValue)e.getValue()));
        for (String methodName : defaultValues.keySet()) {
            if ("source".equals(methodName)) {
                builder.setSource(GemValue.create((AnnotationValue)values.get(methodName), (AnnotationValue)defaultValues.get(methodName), TypeMirror.class));
                continue;
            }
            if ("target".equals(methodName)) {
                builder.setTarget(GemValue.create((AnnotationValue)values.get(methodName), (AnnotationValue)defaultValues.get(methodName), TypeMirror.class));
                continue;
            }
            if ("qualifiedBy".equals(methodName)) {
                builder.setQualifiedby(GemValue.createArray((AnnotationValue)values.get(methodName), (AnnotationValue)defaultValues.get(methodName), TypeMirror.class));
                continue;
            }
            if (!"qualifiedByName".equals(methodName)) continue;
            builder.setQualifiedbyname(GemValue.createArray((AnnotationValue)values.get(methodName), (AnnotationValue)defaultValues.get(methodName), String.class));
        }
        builder.setMirror(mirror);
        return builder.build();
    }

    private static class BuilderImpl
    implements Builder<SubclassMappingGem> {
        private GemValue<TypeMirror> source;
        private GemValue<TypeMirror> target;
        private GemValue<List<TypeMirror>> qualifiedBy;
        private GemValue<List<String>> qualifiedByName;
        private AnnotationMirror mirror;

        private BuilderImpl() {
        }

        @Override
        public Builder setSource(GemValue<TypeMirror> source) {
            this.source = source;
            return this;
        }

        @Override
        public Builder setTarget(GemValue<TypeMirror> target) {
            this.target = target;
            return this;
        }

        @Override
        public Builder setQualifiedby(GemValue<List<TypeMirror>> qualifiedBy) {
            this.qualifiedBy = qualifiedBy;
            return this;
        }

        @Override
        public Builder setQualifiedbyname(GemValue<List<String>> qualifiedByName) {
            this.qualifiedByName = qualifiedByName;
            return this;
        }

        @Override
        public Builder setMirror(AnnotationMirror mirror) {
            this.mirror = mirror;
            return this;
        }

        @Override
        public SubclassMappingGem build() {
            return new SubclassMappingGem(this);
        }
    }

    public static interface Builder<T> {
        public Builder setSource(GemValue<TypeMirror> var1);

        public Builder setTarget(GemValue<TypeMirror> var1);

        public Builder setQualifiedby(GemValue<List<TypeMirror>> var1);

        public Builder setQualifiedbyname(GemValue<List<String>> var1);

        public Builder setMirror(AnnotationMirror var1);

        public T build();
    }
}

