/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.writer;

import java.io.BufferedWriter;
import java.util.HashMap;
import java.util.Map;
import javax.tools.JavaFileObject;
import org.mapstruct.ap.shaded.freemarker.log.Logger;
import org.mapstruct.ap.shaded.freemarker.template.Configuration;
import org.mapstruct.ap.shaded.freemarker.template.DefaultObjectWrapper;
import org.mapstruct.ap.writer.IndentationCorrectingWriter;
import org.mapstruct.ap.writer.ModelIncludeDirective;
import org.mapstruct.ap.writer.Writable;

public class ModelWriter {
    private static final Configuration CONFIGURATION;

    public void writeModel(JavaFileObject sourceFile, Writable model) {
        try {
            BufferedWriter writer = new BufferedWriter(new IndentationCorrectingWriter(sourceFile.openWriter()));
            HashMap values = new HashMap();
            values.put(Configuration.class, CONFIGURATION);
            model.write(new DefaultModelElementWriterContext(values), writer);
            writer.flush();
            writer.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        try {
            Logger.selectLoggerLibrary(0);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        CONFIGURATION = new Configuration();
        CONFIGURATION.setClassForTemplateLoading(ModelWriter.class, "/");
        CONFIGURATION.setObjectWrapper(new DefaultObjectWrapper());
        CONFIGURATION.setSharedVariable("includeModel", new ModelIncludeDirective(CONFIGURATION));
    }

    static class DefaultModelElementWriterContext
    implements Writable.Context {
        private final Map<Class<?>, Object> values;

        DefaultModelElementWriterContext(Map<Class<?>, Object> values) {
            this.values = new HashMap(values);
        }

        @Override
        public <T> T get(Class<T> type) {
            return (T)this.values.get(type);
        }
    }
}

