/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Collections {
    private Collections() {
    }

    public static <T> Set<T> asSet(T ... elements) {
        HashSet<T> set = new HashSet<T>();
        for (T element : elements) {
            set.add(element);
        }
        return set;
    }

    public static <T> List<T> newArrayList(T ... elements) {
        ArrayList<T> list = new ArrayList<T>();
        list.addAll(Arrays.asList(elements));
        return list;
    }

    public static <T> Set<T> asSet(Collection<T> collection, T ... elements) {
        HashSet<T> set = new HashSet<T>(collection);
        for (T element : elements) {
            set.add(element);
        }
        return set;
    }

    public static <T> Set<T> asSet(Collection<T> collection, Collection<T> ... elements) {
        HashSet<T> set = new HashSet<T>(collection);
        for (Collection<T> element : elements) {
            set.addAll(element);
        }
        return set;
    }

    public static <T> T first(Collection<T> collection) {
        return collection.iterator().next();
    }

    public static <T> List<T> join(List<T> a, List<T> b) {
        ArrayList<T> result = new ArrayList<T>(a.size() + b.size());
        result.addAll(a);
        result.addAll(b);
        return result;
    }
}

