/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.model.source.selector;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.mapstruct.ap.model.common.Type;
import org.mapstruct.ap.model.source.Method;
import org.mapstruct.ap.model.source.SourceMethod;
import org.mapstruct.ap.model.source.selector.MethodSelector;
import org.mapstruct.ap.model.source.selector.SelectionCriteria;
import org.mapstruct.ap.prism.QualifierPrism;

public class QualifierSelector
implements MethodSelector {
    private final Types typeUtils;

    public QualifierSelector(Types typeUtils, Elements elementUtils) {
        this.typeUtils = typeUtils;
    }

    @Override
    public <T extends Method> List<T> getMatchingMethods(Method mappingMethod, List<T> methods, Type sourceType, Type targetType, SelectionCriteria criteria) {
        List<TypeMirror> qualifiers = criteria.getQualifiers();
        if (qualifiers == null || qualifiers.isEmpty()) {
            ArrayList<Method> nonQualiferAnnotatedMethods = new ArrayList<Method>();
            for (Method candidate : methods) {
                if (candidate instanceof SourceMethod) {
                    Set<TypeMirror> qualifierAnnotations = this.getQualifierAnnotations(candidate);
                    if (!qualifierAnnotations.isEmpty()) continue;
                    nonQualiferAnnotatedMethods.add(candidate);
                    continue;
                }
                nonQualiferAnnotatedMethods.add(candidate);
            }
            return nonQualiferAnnotatedMethods;
        }
        ArrayList<Method> matches = new ArrayList<Method>();
        for (Method candidate : methods) {
            if (!(candidate instanceof SourceMethod)) continue;
            Set<TypeMirror> qualifierAnnotations = this.getQualifierAnnotations(candidate);
            int matchingQualifierCounter = 0;
            block2: for (TypeMirror qualifier : qualifiers) {
                for (TypeMirror annotationType : qualifierAnnotations) {
                    if (!this.typeUtils.isSameType(qualifier, annotationType)) continue;
                    ++matchingQualifierCounter;
                    continue block2;
                }
            }
            if (matchingQualifierCounter != qualifiers.size()) continue;
            matches.add(candidate);
        }
        if (!matches.isEmpty()) {
            return matches;
        }
        return methods;
    }

    private Set<TypeMirror> getQualifierAnnotations(Method candidate) {
        HashSet<TypeMirror> qualiferAnnotations = new HashSet<TypeMirror>();
        SourceMethod candidateSM = (SourceMethod)candidate;
        List<? extends AnnotationMirror> methodAnnotations = candidateSM.getExecutable().getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : methodAnnotations) {
            this.addOnlyWhenQualifier(qualiferAnnotations, annotationMirror);
        }
        Type mapper = candidate.getDeclaringMapper();
        if (mapper != null) {
            List<? extends AnnotationMirror> list = mapper.getTypeElement().getAnnotationMirrors();
            for (AnnotationMirror annotationMirror : list) {
                this.addOnlyWhenQualifier(qualiferAnnotations, annotationMirror);
            }
        }
        return qualiferAnnotations;
    }

    private void addOnlyWhenQualifier(Set<TypeMirror> annotationSet, AnnotationMirror candidate) {
        if (QualifierPrism.getInstanceOn(candidate.getAnnotationType().asElement()) != null) {
            annotationSet.add(candidate.getAnnotationType());
        }
    }
}

