/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.model.source;

import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.mapstruct.ap.prism.IterableMappingPrism;
import org.mapstruct.ap.prism.NullValueMappingStrategyPrism;
import org.mapstruct.ap.util.FormattingMessager;
import org.mapstruct.ap.util.Message;

public class IterableMapping {
    private final String dateFormat;
    private final List<TypeMirror> qualifiers;
    private final TypeMirror qualifyingElementTargetType;
    private final AnnotationMirror mirror;
    private final AnnotationValue dateFormatAnnotationValue;
    private final NullValueMappingStrategyPrism nullValueMappingStrategy;

    public static IterableMapping fromPrism(IterableMappingPrism iterableMapping, ExecutableElement method, FormattingMessager messager) {
        if (iterableMapping == null) {
            return null;
        }
        boolean elementTargetTypeIsDefined = !TypeKind.VOID.equals((Object)iterableMapping.elementTargetType().getKind());
        NullValueMappingStrategyPrism nullValueMappingStrategy = NullValueMappingStrategyPrism.valueOf(iterableMapping.nullValueMappingStrategy());
        if (!elementTargetTypeIsDefined && iterableMapping.dateFormat().isEmpty() && iterableMapping.qualifiedBy().isEmpty() && nullValueMappingStrategy == NullValueMappingStrategyPrism.DEFAULT) {
            messager.printMessage((Element)method, Message.ITERABLEMAPPING_NO_ELEMENTS, new Object[0]);
        }
        return new IterableMapping(iterableMapping.dateFormat(), iterableMapping.qualifiedBy(), elementTargetTypeIsDefined ? iterableMapping.elementTargetType() : null, iterableMapping.mirror, iterableMapping.values.dateFormat(), nullValueMappingStrategy);
    }

    private IterableMapping(String dateFormat, List<TypeMirror> qualifiers, TypeMirror resultType, AnnotationMirror mirror, AnnotationValue dateFormatAnnotationValue, NullValueMappingStrategyPrism nvms) {
        this.dateFormat = dateFormat;
        this.qualifiers = qualifiers;
        this.qualifyingElementTargetType = resultType;
        this.mirror = mirror;
        this.dateFormatAnnotationValue = dateFormatAnnotationValue;
        this.nullValueMappingStrategy = nvms;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public List<TypeMirror> getQualifiers() {
        return this.qualifiers;
    }

    public TypeMirror getQualifyingElementTargetType() {
        return this.qualifyingElementTargetType;
    }

    public AnnotationMirror getMirror() {
        return this.mirror;
    }

    public AnnotationValue getDateFormatAnnotationValue() {
        return this.dateFormatAnnotationValue;
    }

    public NullValueMappingStrategyPrism getNullValueMappingStrategy() {
        return this.nullValueMappingStrategy;
    }
}

