/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import org.mapstruct.ap.model.AssignmentFactory;
import org.mapstruct.ap.model.IterableMappingMethod;
import org.mapstruct.ap.model.MapMappingMethod;
import org.mapstruct.ap.model.MappingBuilderContext;
import org.mapstruct.ap.model.MethodReference;
import org.mapstruct.ap.model.NestedPropertyMappingMethod;
import org.mapstruct.ap.model.assignment.AdderWrapper;
import org.mapstruct.ap.model.assignment.ArrayCopyWrapper;
import org.mapstruct.ap.model.assignment.Assignment;
import org.mapstruct.ap.model.assignment.AssignmentWrapper;
import org.mapstruct.ap.model.assignment.GetterWrapperForCollectionsAndMaps;
import org.mapstruct.ap.model.assignment.NewCollectionOrMapWrapper;
import org.mapstruct.ap.model.assignment.NullCheckWrapper;
import org.mapstruct.ap.model.assignment.SetterWrapper;
import org.mapstruct.ap.model.assignment.SetterWrapperForCollectionsAndMaps;
import org.mapstruct.ap.model.assignment.UpdateWrapper;
import org.mapstruct.ap.model.common.ModelElement;
import org.mapstruct.ap.model.common.Parameter;
import org.mapstruct.ap.model.common.Type;
import org.mapstruct.ap.model.source.ForgedMethod;
import org.mapstruct.ap.model.source.SourceMethod;
import org.mapstruct.ap.model.source.SourceReference;
import org.mapstruct.ap.util.Executables;
import org.mapstruct.ap.util.Message;
import org.mapstruct.ap.util.Strings;

public class PropertyMapping
extends ModelElement {
    private final String name;
    private final String sourceBeanName;
    private final String targetWriteAccessorName;
    private final String targetReadAccessorName;
    private final Type targetType;
    private final Assignment assignment;
    private final List<String> dependsOn;

    private PropertyMapping(String name, String targetWriteAccessorName, String targetReadAccessorName, Type targetType, Assignment propertyAssignment, List<String> dependsOn) {
        this(name, null, targetWriteAccessorName, targetReadAccessorName, targetType, propertyAssignment, dependsOn);
    }

    private PropertyMapping(String name, String sourceBeanName, String targetWriteAccessorName, String targetReadAccessorName, Type targetType, Assignment assignment, List<String> dependsOn) {
        this.name = name;
        this.sourceBeanName = sourceBeanName;
        this.targetWriteAccessorName = targetWriteAccessorName;
        this.targetReadAccessorName = targetReadAccessorName;
        this.targetType = targetType;
        this.assignment = assignment;
        this.dependsOn = dependsOn != null ? dependsOn : Collections.emptyList();
    }

    public String getName() {
        return this.name;
    }

    public String getSourceBeanName() {
        return this.sourceBeanName;
    }

    public String getTargetWriteAccessorName() {
        return this.targetWriteAccessorName;
    }

    public String getTargetReadAccessorName() {
        return this.targetReadAccessorName;
    }

    public Type getTargetType() {
        return this.targetType;
    }

    public Assignment getAssignment() {
        return this.assignment;
    }

    @Override
    public Set<Type> getImportTypes() {
        return this.assignment.getImportTypes();
    }

    public List<String> getDependsOn() {
        return this.dependsOn;
    }

    public String toString() {
        return "PropertyMapping {\n    name='" + this.name + "'," + "\n    targetWriteAccessorName='" + this.targetWriteAccessorName + "'," + "\n    targetReadAccessorName='" + this.targetReadAccessorName + "'," + "\n    targetType=" + this.targetType + "," + "\n    propertyAssignment=" + this.assignment + "," + "\n    dependsOn=" + this.dependsOn + "\n}";
    }

    public static class JavaExpressionMappingBuilder {
        private MappingBuilderContext ctx;
        private SourceMethod method;
        private String javaExpression;
        private Collection<String> existingVariableNames;
        private String targetPropertyName;
        private List<String> dependsOn;
        private ExecutableElement targetWriteAccessor;
        private ExecutableElement targetReadAccessor;

        public JavaExpressionMappingBuilder mappingContext(MappingBuilderContext mappingContext) {
            this.ctx = mappingContext;
            return this;
        }

        public JavaExpressionMappingBuilder souceMethod(SourceMethod sourceMethod) {
            this.method = sourceMethod;
            return this;
        }

        public JavaExpressionMappingBuilder javaExpression(String javaExpression) {
            this.javaExpression = javaExpression;
            return this;
        }

        public JavaExpressionMappingBuilder targetWriteAccessor(ExecutableElement targetWriteAccessor) {
            this.targetWriteAccessor = targetWriteAccessor;
            return this;
        }

        public JavaExpressionMappingBuilder targetReadAccessor(ExecutableElement targetReadAccessor) {
            this.targetReadAccessor = targetReadAccessor;
            return this;
        }

        public JavaExpressionMappingBuilder existingVariableNames(Collection<String> existingVariableNames) {
            this.existingVariableNames = existingVariableNames;
            return this;
        }

        public JavaExpressionMappingBuilder targetPropertyName(String targetPropertyName) {
            this.targetPropertyName = targetPropertyName;
            return this;
        }

        public JavaExpressionMappingBuilder dependsOn(List<String> dependsOn) {
            this.dependsOn = dependsOn;
            return this;
        }

        public PropertyMapping build() {
            Type targetType;
            ModelElement assignment = AssignmentFactory.createDirect(this.javaExpression);
            if (Executables.isSetterMethod(this.targetWriteAccessor)) {
                assignment = new SetterWrapper((Assignment)((Object)assignment), this.method.getThrownTypes());
                targetType = this.ctx.getTypeFactory().getSingleParameter(this.targetWriteAccessor).getType();
            } else {
                targetType = this.ctx.getTypeFactory().getReturnType(this.targetWriteAccessor);
                assignment = new GetterWrapperForCollectionsAndMaps((Assignment)((Object)assignment), this.method.getThrownTypes(), targetType, this.existingVariableNames);
            }
            return new PropertyMapping(this.targetPropertyName, this.targetWriteAccessor.getSimpleName().toString(), this.targetReadAccessor != null ? this.targetReadAccessor.getSimpleName().toString() : null, targetType, (Assignment)((Object)assignment), this.dependsOn);
        }
    }

    public static class ConstantMappingBuilder {
        private MappingBuilderContext ctx;
        private SourceMethod method;
        private String constantExpression;
        private String targetPropertyName;
        private ExecutableElement targetWriteAccessor;
        private ExecutableElement targetReadAccessor;
        private String dateFormat;
        private List<TypeMirror> qualifiers;
        private TypeMirror resultType;
        private Collection<String> existingVariableNames;
        private List<String> dependsOn;

        public ConstantMappingBuilder mappingContext(MappingBuilderContext mappingContext) {
            this.ctx = mappingContext;
            return this;
        }

        public ConstantMappingBuilder sourceMethod(SourceMethod sourceMethod) {
            this.method = sourceMethod;
            return this;
        }

        public ConstantMappingBuilder constantExpression(String constantExpression) {
            this.constantExpression = constantExpression;
            return this;
        }

        public ConstantMappingBuilder targetWriteAccessor(ExecutableElement targetAccessor) {
            this.targetWriteAccessor = targetAccessor;
            return this;
        }

        public ConstantMappingBuilder targetReadAccessor(ExecutableElement targetReadAccessor) {
            this.targetReadAccessor = targetReadAccessor;
            return this;
        }

        public ConstantMappingBuilder targetPropertyName(String targetPropertyName) {
            this.targetPropertyName = targetPropertyName;
            return this;
        }

        public ConstantMappingBuilder dateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
            return this;
        }

        public ConstantMappingBuilder qualifiers(List<TypeMirror> qualifiers) {
            this.qualifiers = qualifiers;
            return this;
        }

        public ConstantMappingBuilder resultType(TypeMirror resultType) {
            this.resultType = resultType;
            return this;
        }

        public ConstantMappingBuilder existingVariableNames(Collection<String> existingVariableNames) {
            this.existingVariableNames = existingVariableNames;
            return this;
        }

        public ConstantMappingBuilder dependsOn(List<String> dependsOn) {
            this.dependsOn = dependsOn;
            return this;
        }

        public PropertyMapping build() {
            String mappedElement = "constant '" + this.constantExpression + "'";
            Type sourceType = this.ctx.getTypeFactory().getType(String.class);
            Type targetType = Executables.isSetterMethod(this.targetWriteAccessor) ? this.ctx.getTypeFactory().getSingleParameter(this.targetWriteAccessor).getType() : this.ctx.getTypeFactory().getReturnType(this.targetWriteAccessor);
            Assignment assignment = this.ctx.getMappingResolver().getTargetAssignment(this.method, mappedElement, sourceType, targetType, this.targetPropertyName, this.dateFormat, this.qualifiers, this.resultType, this.constantExpression, this.method.getMappingTargetParameter() != null);
            if (assignment != null) {
                if (Executables.isSetterMethod(this.targetWriteAccessor)) {
                    if (assignment.isUpdateMethod()) {
                        if (this.targetReadAccessor == null) {
                            this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.CONSTANTMAPPING_NO_READ_ACCESSOR_FOR_TARGET_TYPE, this.targetPropertyName);
                        }
                        MethodReference factoryMethod = this.ctx.getMappingResolver().getFactoryMethod(this.method, targetType, null, null);
                        assignment = new UpdateWrapper(assignment, this.method.getThrownTypes(), targetType, factoryMethod);
                    } else {
                        assignment = new SetterWrapper(assignment, this.method.getThrownTypes());
                    }
                } else {
                    assignment = new GetterWrapperForCollectionsAndMaps(assignment, this.method.getThrownTypes(), targetType, this.existingVariableNames);
                }
            } else {
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.CONSTANTMAPPING_MAPPING_NOT_FOUND, sourceType, this.constantExpression, targetType, this.targetPropertyName);
            }
            return new PropertyMapping(this.targetPropertyName, this.targetWriteAccessor.getSimpleName().toString(), this.targetReadAccessor != null ? this.targetReadAccessor.getSimpleName().toString() : null, targetType, assignment, this.dependsOn);
        }
    }

    public static class PropertyMappingBuilder {
        private MappingBuilderContext ctx;
        private SourceMethod method;
        private ExecutableElement targetWriteAccessor;
        private ExecutableElement targetReadAccessor;
        private String targetPropertyName;
        private String dateFormat;
        private List<TypeMirror> qualifiers;
        private TypeMirror resultType;
        private SourceReference sourceReference;
        private Collection<String> existingVariableNames;
        private List<String> dependsOn;

        public PropertyMappingBuilder mappingContext(MappingBuilderContext mappingContext) {
            this.ctx = mappingContext;
            return this;
        }

        public PropertyMappingBuilder souceMethod(SourceMethod sourceMethod) {
            this.method = sourceMethod;
            return this;
        }

        public PropertyMappingBuilder targetReadAccessor(ExecutableElement targetReadAccessor) {
            this.targetReadAccessor = targetReadAccessor;
            return this;
        }

        public PropertyMappingBuilder targetWriteAccessor(ExecutableElement targetWriteAccessor) {
            this.targetWriteAccessor = targetWriteAccessor;
            return this;
        }

        public PropertyMappingBuilder targetPropertyName(String targetPropertyName) {
            this.targetPropertyName = targetPropertyName;
            return this;
        }

        public PropertyMappingBuilder sourceReference(SourceReference sourceReference) {
            this.sourceReference = sourceReference;
            return this;
        }

        public PropertyMappingBuilder qualifiers(List<TypeMirror> qualifiers) {
            this.qualifiers = qualifiers;
            return this;
        }

        public PropertyMappingBuilder resultType(TypeMirror resultType) {
            this.resultType = resultType;
            return this;
        }

        public PropertyMappingBuilder dateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
            return this;
        }

        public PropertyMappingBuilder existingVariableNames(Collection<String> existingVariableNames) {
            this.existingVariableNames = existingVariableNames;
            return this;
        }

        public PropertyMappingBuilder dependsOn(List<String> dependsOn) {
            this.dependsOn = dependsOn;
            return this;
        }

        public PropertyMapping build() {
            String sourceRefStr;
            TargetWriteAccessorType targetAccessorType = this.getTargetAcccessorType();
            Type targetType = this.getTargetType(targetAccessorType);
            String sourceElement = this.getSourceElement();
            Type sourceType = this.getSourceType();
            if (targetAccessorType == TargetWriteAccessorType.ADDER && sourceType.isCollectionType()) {
                sourceType = sourceType.getTypeParameters().get(0);
                sourceRefStr = Executables.getElementNameForAdder(this.targetWriteAccessor);
            } else {
                sourceRefStr = this.getSourceRef();
            }
            boolean preferUpdateMethods = targetType.isCollectionOrMapType() || targetType.isArrayType() || targetAccessorType == TargetWriteAccessorType.ADDER ? false : this.method.getMappingTargetParameter() != null;
            Assignment assignment = this.ctx.getMappingResolver().getTargetAssignment(this.method, sourceElement, sourceType, targetType, this.targetPropertyName, this.dateFormat, this.qualifiers, this.resultType, sourceRefStr, preferUpdateMethods);
            if (assignment == null) {
                assignment = this.forgeMapOrIterableMapping(sourceType, targetType, sourceRefStr, this.method.getExecutable());
            }
            if (assignment != null) {
                if (targetType.isCollectionOrMapType()) {
                    assignment = this.assignCollection(targetType, targetAccessorType, assignment);
                } else if (targetType.isArrayType() && sourceType.isArrayType() && assignment.getType() == Assignment.AssignmentType.DIRECT) {
                    Type arrayType = this.ctx.getTypeFactory().getType(Arrays.class);
                    assignment = new ArrayCopyWrapper(assignment, this.targetPropertyName, arrayType, targetType, this.existingVariableNames);
                    assignment = new NullCheckWrapper(assignment);
                } else {
                    assignment = this.assignObject(sourceType, targetType, targetAccessorType, assignment);
                }
            } else {
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.PROPERTYMAPPING_MAPPING_NOT_FOUND, sourceElement, targetType, this.targetPropertyName, targetType, this.getSourceType());
            }
            return new PropertyMapping(this.targetPropertyName, this.sourceReference.getParameter().getName(), this.targetWriteAccessor.getSimpleName().toString(), this.targetReadAccessor != null ? this.targetReadAccessor.getSimpleName().toString() : null, targetType, assignment, this.dependsOn);
        }

        private Assignment assignObject(Type sourceType, Type targetType, TargetWriteAccessorType targetAccessorType, Assignment rhs) {
            Assignment result = rhs;
            if (targetAccessorType == TargetWriteAccessorType.SETTER) {
                if (result.isUpdateMethod()) {
                    if (this.targetReadAccessor == null) {
                        this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.PROPERTYMAPPING_NO_READ_ACCESSOR_FOR_TARGET_TYPE, this.targetPropertyName);
                    }
                    MethodReference factoryMethod = this.ctx.getMappingResolver().getFactoryMethod(this.method, targetType, null, null);
                    result = new UpdateWrapper(result, this.method.getThrownTypes(), targetType, factoryMethod);
                } else {
                    result = new SetterWrapper(result, this.method.getThrownTypes());
                }
                if (!sourceType.isPrimitive() && !this.sourceReference.getPropertyEntries().isEmpty() && (result.getType() == Assignment.AssignmentType.TYPE_CONVERTED || result.getType() == Assignment.AssignmentType.TYPE_CONVERTED_MAPPED || result.getType() == Assignment.AssignmentType.DIRECT && targetType.isPrimitive())) {
                    result = new NullCheckWrapper(result);
                }
            } else if (this.getSourceType().isCollectionType()) {
                result = new AdderWrapper(result, this.method.getThrownTypes(), this.getSourceRef(), sourceType);
            } else {
                result = new SetterWrapper(result, this.method.getThrownTypes());
                result = new NullCheckWrapper(result);
            }
            return result;
        }

        private Assignment assignCollection(Type targetType, TargetWriteAccessorType targetAccessorType, Assignment rhs) {
            Assignment result = rhs;
            if (targetAccessorType == TargetWriteAccessorType.SETTER) {
                AssignmentWrapper newCollectionOrMap = null;
                if (result.getType() == Assignment.AssignmentType.DIRECT) {
                    newCollectionOrMap = new NewCollectionOrMapWrapper(result, targetType.getImportTypes());
                    newCollectionOrMap = new SetterWrapper(newCollectionOrMap, this.method.getThrownTypes());
                }
                result = new SetterWrapper(result, this.method.getThrownTypes());
                result = new SetterWrapperForCollectionsAndMaps(result, this.targetWriteAccessor.getSimpleName().toString(), newCollectionOrMap);
            } else {
                result = new GetterWrapperForCollectionsAndMaps(result, this.method.getThrownTypes(), targetType, this.existingVariableNames);
            }
            if (result.getType() == Assignment.AssignmentType.DIRECT) {
                result = new NullCheckWrapper(result);
            }
            return result;
        }

        private Type getSourceType() {
            Parameter sourceParam = this.sourceReference.getParameter();
            List<SourceReference.PropertyEntry> propertyEntries = this.sourceReference.getPropertyEntries();
            if (propertyEntries.isEmpty()) {
                return sourceParam.getType();
            }
            if (propertyEntries.size() == 1) {
                SourceReference.PropertyEntry propertyEntry = propertyEntries.get(0);
                return propertyEntry.getType();
            }
            SourceReference.PropertyEntry lastPropertyEntry = propertyEntries.get(propertyEntries.size() - 1);
            return lastPropertyEntry.getType();
        }

        private String getSourceRef() {
            Parameter sourceParam = this.sourceReference.getParameter();
            List<SourceReference.PropertyEntry> propertyEntries = this.sourceReference.getPropertyEntries();
            if (propertyEntries.isEmpty()) {
                return sourceParam.getName();
            }
            if (propertyEntries.size() == 1) {
                SourceReference.PropertyEntry propertyEntry = propertyEntries.get(0);
                return sourceParam.getName() + "." + propertyEntry.getAccessor().getSimpleName() + "()";
            }
            SourceReference.PropertyEntry lastPropertyEntry = propertyEntries.get(propertyEntries.size() - 1);
            String forgedName = Strings.joinAndCamelize(this.sourceReference.getElementNames());
            forgedName = Strings.getSaveVariableName(forgedName, this.ctx.getNamesOfMappingsToGenerate());
            ForgedMethod methodRef = new ForgedMethod(forgedName, this.sourceReference.getParameter().getType(), lastPropertyEntry.getType(), this.method.getExecutable());
            NestedPropertyMappingMethod.Builder builder = new NestedPropertyMappingMethod.Builder();
            NestedPropertyMappingMethod nestedPropertyMapping = builder.method(methodRef).propertyEntries(this.sourceReference.getPropertyEntries()).build();
            if (!this.ctx.getMappingsToGenerate().contains(nestedPropertyMapping)) {
                this.ctx.getMappingsToGenerate().add(nestedPropertyMapping);
            } else {
                forgedName = this.ctx.getExistingMappingMethod(nestedPropertyMapping).getName();
            }
            return forgedName + "( " + sourceParam.getName() + " )";
        }

        private String getSourceElement() {
            Parameter sourceParam = this.sourceReference.getParameter();
            List<SourceReference.PropertyEntry> propertyEntries = this.sourceReference.getPropertyEntries();
            if (propertyEntries.isEmpty()) {
                return String.format("parameter \"%s %s\"", sourceParam.getType(), sourceParam.getName());
            }
            if (propertyEntries.size() == 1) {
                SourceReference.PropertyEntry propertyEntry = propertyEntries.get(0);
                return String.format("property \"%s %s\"", propertyEntry.getType(), propertyEntry.getName());
            }
            SourceReference.PropertyEntry lastPropertyEntry = propertyEntries.get(propertyEntries.size() - 1);
            return String.format("property \"%s %s\"", lastPropertyEntry.getType(), Strings.join(this.sourceReference.getElementNames(), "."));
        }

        private TargetWriteAccessorType getTargetAcccessorType() {
            if (Executables.isSetterMethod(this.targetWriteAccessor)) {
                return TargetWriteAccessorType.SETTER;
            }
            if (Executables.isAdderMethod(this.targetWriteAccessor)) {
                return TargetWriteAccessorType.ADDER;
            }
            return TargetWriteAccessorType.GETTER;
        }

        private Type getTargetType(TargetWriteAccessorType targetAccessorType) {
            switch (targetAccessorType) {
                case ADDER: 
                case SETTER: {
                    return this.ctx.getTypeFactory().getSingleParameter(this.targetWriteAccessor).getType();
                }
            }
            return this.ctx.getTypeFactory().getReturnType(this.targetWriteAccessor);
        }

        private Assignment forgeMapOrIterableMapping(Type sourceType, Type targetType, String sourceReference, ExecutableElement element) {
            Assignment assignment = null;
            String name = this.getName(sourceType, targetType);
            name = Strings.getSaveVariableName(name, this.ctx.getNamesOfMappingsToGenerate());
            if ((sourceType.isCollectionType() || sourceType.isArrayType()) && (targetType.isCollectionType() || targetType.isArrayType())) {
                ForgedMethod methodRef = new ForgedMethod(name, sourceType, targetType, element);
                IterableMappingMethod.Builder builder = new IterableMappingMethod.Builder();
                IterableMappingMethod iterableMappingMethod = builder.mappingContext(this.ctx).method(methodRef).build();
                if (!this.ctx.getMappingsToGenerate().contains(iterableMappingMethod)) {
                    this.ctx.getMappingsToGenerate().add(iterableMappingMethod);
                } else {
                    String existingName = this.ctx.getExistingMappingMethod(iterableMappingMethod).getName();
                    methodRef = new ForgedMethod(existingName, methodRef);
                }
                assignment = AssignmentFactory.createMethodReference(methodRef, null, targetType);
                assignment.setAssignment(AssignmentFactory.createDirect(sourceReference));
            } else if (sourceType.isMapType() && targetType.isMapType()) {
                ForgedMethod methodRef = new ForgedMethod(name, sourceType, targetType, element);
                MapMappingMethod.Builder builder = new MapMappingMethod.Builder();
                MapMappingMethod mapMappingMethod = builder.mappingContext(this.ctx).method(methodRef).build();
                if (!this.ctx.getMappingsToGenerate().contains(mapMappingMethod)) {
                    this.ctx.getMappingsToGenerate().add(mapMappingMethod);
                } else {
                    String existingName = this.ctx.getExistingMappingMethod(mapMappingMethod).getName();
                    methodRef = new ForgedMethod(existingName, methodRef);
                }
                assignment = AssignmentFactory.createMethodReference(methodRef, null, targetType);
                assignment.setAssignment(AssignmentFactory.createDirect(sourceReference));
            }
            return assignment;
        }

        private String getName(Type sourceType, Type targetType) {
            String fromName = this.getName(sourceType);
            String toName = this.getName(targetType);
            return Strings.decapitalize(fromName + "To" + toName);
        }

        private String getName(Type type) {
            StringBuilder builder = new StringBuilder();
            for (Type typeParam : type.getTypeParameters()) {
                builder.append(typeParam.getName().replace("[]", "Array"));
            }
            builder.append(type.getName().replace("[]", "Array"));
            return builder.toString();
        }

        private static enum TargetWriteAccessorType {
            GETTER,
            SETTER,
            ADDER;

        }
    }
}

