/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.model;

import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.mapstruct.ap.model.MappingBuilderContext;
import org.mapstruct.ap.model.MappingMethod;
import org.mapstruct.ap.model.MethodReference;
import org.mapstruct.ap.model.assignment.Assignment;
import org.mapstruct.ap.model.assignment.LocalVarWrapper;
import org.mapstruct.ap.model.assignment.SetterWrapper;
import org.mapstruct.ap.model.common.Parameter;
import org.mapstruct.ap.model.common.Type;
import org.mapstruct.ap.model.source.Method;
import org.mapstruct.ap.prism.NullValueMappingStrategyPrism;
import org.mapstruct.ap.util.Collections;
import org.mapstruct.ap.util.Message;
import org.mapstruct.ap.util.Strings;

public class IterableMappingMethod
extends MappingMethod {
    private final Assignment elementAssignment;
    private final MethodReference factoryMethod;
    private final boolean overridden;
    private final boolean mapNullToDefault;
    private final String loopVariableName;

    private IterableMappingMethod(Method method, Assignment parameterAssignment, MethodReference factoryMethod, boolean mapNullToDefault, String loopVariableName) {
        super(method);
        this.elementAssignment = parameterAssignment;
        this.factoryMethod = factoryMethod;
        this.overridden = method.overridesMethod();
        this.mapNullToDefault = mapNullToDefault;
        this.loopVariableName = loopVariableName;
    }

    public Parameter getSourceParameter() {
        for (Parameter parameter : this.getParameters()) {
            if (parameter.isMappingTarget()) continue;
            return parameter;
        }
        throw new IllegalStateException("Method " + this + " has no source parameter.");
    }

    public Assignment getElementAssignment() {
        return this.elementAssignment;
    }

    @Override
    public Set<Type> getImportTypes() {
        Set<Type> types = super.getImportTypes();
        if (this.elementAssignment != null) {
            types.addAll(this.elementAssignment.getImportTypes());
        }
        if (this.factoryMethod == null) {
            types.addAll(this.getReturnType().getImportTypes());
        }
        return types;
    }

    public boolean isMapNullToDefault() {
        return this.mapNullToDefault;
    }

    public boolean isOverridden() {
        return this.overridden;
    }

    public String getLoopVariableName() {
        return this.loopVariableName;
    }

    public String getDefaultValue() {
        TypeKind kind = this.getResultElementType().getTypeMirror().getKind();
        switch (kind) {
            case BOOLEAN: {
                return "false";
            }
            case BYTE: 
            case SHORT: 
            case INT: 
            case CHAR: {
                return "0";
            }
            case LONG: {
                return "0L";
            }
            case FLOAT: {
                return "0.0f";
            }
            case DOUBLE: {
                return "0.0d";
            }
        }
        return "null";
    }

    public MethodReference getFactoryMethod() {
        return this.factoryMethod;
    }

    public Type getSourceElementType() {
        Type sourceParameterType = this.getSourceParameter().getType();
        if (sourceParameterType.isArrayType()) {
            return sourceParameterType.getComponentType();
        }
        return sourceParameterType.getTypeParameters().get(0);
    }

    public Type getResultElementType() {
        if (this.getResultType().isArrayType()) {
            return this.getResultType().getComponentType();
        }
        return this.getResultType().getTypeParameters().get(0);
    }

    public String getIndex1Name() {
        return Strings.getSaveVariableName("i", this.loopVariableName, this.getSourceParameter().getName(), this.getResultName());
    }

    public String getIndex2Name() {
        return Strings.getSaveVariableName("j", this.loopVariableName, this.getSourceParameter().getName(), this.getResultName());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getResultType() == null ? 0 : this.getResultType().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IterableMappingMethod other = (IterableMappingMethod)obj;
        if (!this.getResultType().equals(other.getResultType())) {
            return false;
        }
        if (this.getSourceParameters().size() != other.getSourceParameters().size()) {
            return false;
        }
        for (int i = 0; i < this.getSourceParameters().size(); ++i) {
            if (this.getSourceParameters().get(i).getType().getTypeParameters().get(0).equals(other.getSourceParameters().get(i).getType().getTypeParameters().get(0))) continue;
            return false;
        }
        return true;
    }

    public static class Builder {
        private Method method;
        private MappingBuilderContext ctx;
        private String dateFormat;
        private List<TypeMirror> qualifiers;
        private TypeMirror qualifyingElementTargetType;
        private NullValueMappingStrategyPrism nullValueMappingStrategy;

        public Builder mappingContext(MappingBuilderContext mappingContext) {
            this.ctx = mappingContext;
            return this;
        }

        public Builder method(Method sourceMethod) {
            this.method = sourceMethod;
            return this;
        }

        public Builder dateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
            return this;
        }

        public Builder qualifiers(List<TypeMirror> qualifiers) {
            this.qualifiers = qualifiers;
            return this;
        }

        public Builder qualifyingElementTargetType(TypeMirror qualifyingElementTargetType) {
            this.qualifyingElementTargetType = qualifyingElementTargetType;
            return this;
        }

        public Builder nullValueMappingStrategy(NullValueMappingStrategyPrism nullValueMappingStrategy) {
            this.nullValueMappingStrategy = nullValueMappingStrategy;
            return this;
        }

        public IterableMappingMethod build() {
            Type sourceParameterType = Collections.first(this.method.getSourceParameters()).getType();
            Type resultType = this.method.getResultType();
            Type sourceElementType = sourceParameterType.isArrayType() ? sourceParameterType.getComponentType() : sourceParameterType.getTypeParameters().get(0);
            Type targetElementType = resultType.isArrayType() ? resultType.getComponentType() : resultType.getTypeParameters().get(0);
            String elementTypeName = sourceParameterType.isArrayType() ? sourceParameterType.getComponentType().getName() : sourceParameterType.getTypeParameters().get(0).getName();
            String loopVariableName = Strings.getSaveVariableName(elementTypeName, this.method.getParameterNames());
            Assignment assignment = this.ctx.getMappingResolver().getTargetAssignment(this.method, "collection element", sourceElementType, targetElementType, null, this.dateFormat, this.qualifiers, this.qualifyingElementTargetType, loopVariableName, false);
            if (assignment == null) {
                this.ctx.getMessager().printMessage((Element)this.method.getExecutable(), Message.ITERABLEMAPPING_MAPPING_NOT_FOUND, new Object[0]);
            }
            assignment = resultType.isArrayType() ? new LocalVarWrapper(assignment, this.method.getThrownTypes()) : new SetterWrapper(assignment, this.method.getThrownTypes());
            boolean mapNullToDefault = false;
            if (this.method.getMapperConfiguration() != null) {
                mapNullToDefault = this.method.getMapperConfiguration().isMapToDefault(this.nullValueMappingStrategy);
            }
            MethodReference factoryMethod = this.ctx.getMappingResolver().getFactoryMethod(this.method, this.method.getResultType(), null, null);
            return new IterableMappingMethod(this.method, assignment, factoryMethod, mapNullToDefault, loopVariableName);
        }
    }
}

