/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.model;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import org.mapstruct.ap.model.DecoratorConstructor;
import org.mapstruct.ap.model.Field;
import org.mapstruct.ap.model.GeneratedType;
import org.mapstruct.ap.model.MappingMethod;
import org.mapstruct.ap.model.common.Accessibility;
import org.mapstruct.ap.model.common.Type;
import org.mapstruct.ap.model.common.TypeFactory;
import org.mapstruct.ap.option.Options;
import org.mapstruct.ap.prism.DecoratedWithPrism;
import org.mapstruct.ap.version.VersionInformation;

public class Decorator
extends GeneratedType {
    private static final String IMPLEMENTATION_SUFFIX = "Impl";
    private final Type decoratorType;

    private Decorator(TypeFactory typeFactory, String packageName, String name, Type decoratorType, String interfaceName, List<MappingMethod> methods, List<? extends Field> fields, Options options, VersionInformation versionInformation, Accessibility accessibility, DecoratorConstructor decoratorConstructor) {
        super(typeFactory, packageName, name, decoratorType.getName(), interfaceName, methods, fields, options, versionInformation, accessibility, new TreeSet<Type>(), decoratorConstructor);
        this.decoratorType = decoratorType;
    }

    @Override
    public SortedSet<Type> getImportTypes() {
        Set importTypes = super.getImportTypes();
        this.addWithDependents(importTypes, this.decoratorType);
        return importTypes;
    }

    @Override
    protected String getTemplateName() {
        return GeneratedType.class.getName() + ".ftl";
    }

    public static class Builder {
        private Elements elementUtils;
        private TypeFactory typeFactory;
        private TypeElement mapperElement;
        private DecoratedWithPrism decoratorPrism;
        private List<MappingMethod> methods;
        private Options options;
        private VersionInformation versionInformation;
        private boolean hasDelegateConstructor;

        public Builder elementUtils(Elements elementUtils) {
            this.elementUtils = elementUtils;
            return this;
        }

        public Builder typeFactory(TypeFactory typeFactory) {
            this.typeFactory = typeFactory;
            return this;
        }

        public Builder mapperElement(TypeElement mapperElement) {
            this.mapperElement = mapperElement;
            return this;
        }

        public Builder decoratorPrism(DecoratedWithPrism decoratorPrism) {
            this.decoratorPrism = decoratorPrism;
            return this;
        }

        public Builder methods(List<MappingMethod> methods) {
            this.methods = methods;
            return this;
        }

        public Builder options(Options options) {
            this.options = options;
            return this;
        }

        public Builder versionInformation(VersionInformation versionInformation) {
            this.versionInformation = versionInformation;
            return this;
        }

        public Builder hasDelegateConstructor(boolean hasDelegateConstructor) {
            this.hasDelegateConstructor = hasDelegateConstructor;
            return this;
        }

        public Decorator build() {
            Type decoratorType = this.typeFactory.getType(this.decoratorPrism.value());
            DecoratorConstructor decoratorConstructor = new DecoratorConstructor(this.mapperElement.getSimpleName().toString() + Decorator.IMPLEMENTATION_SUFFIX, this.mapperElement.getSimpleName().toString() + "Impl_", this.hasDelegateConstructor);
            return new Decorator(this.typeFactory, this.elementUtils.getPackageOf(this.mapperElement).getQualifiedName().toString(), this.mapperElement.getSimpleName().toString() + Decorator.IMPLEMENTATION_SUFFIX, decoratorType, this.mapperElement.getKind() == ElementKind.INTERFACE ? this.mapperElement.getSimpleName().toString() : null, this.methods, Arrays.asList(new Field(this.typeFactory.getType(this.mapperElement), "delegate", true)), this.options, this.versionInformation, Accessibility.fromModifiers(this.mapperElement.getModifiers()), decoratorConstructor);
        }
    }
}

