/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.conversion;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.util.Elements;
import org.mapstruct.ap.conversion.BigDecimalToBigIntegerConversion;
import org.mapstruct.ap.conversion.BigDecimalToPrimitiveConversion;
import org.mapstruct.ap.conversion.BigDecimalToStringConversion;
import org.mapstruct.ap.conversion.BigDecimalToWrapperConversion;
import org.mapstruct.ap.conversion.BigIntegerToPrimitiveConversion;
import org.mapstruct.ap.conversion.BigIntegerToStringConversion;
import org.mapstruct.ap.conversion.BigIntegerToWrapperConversion;
import org.mapstruct.ap.conversion.CharToStringConversion;
import org.mapstruct.ap.conversion.CharWrapperToStringConversion;
import org.mapstruct.ap.conversion.ConversionProvider;
import org.mapstruct.ap.conversion.DateToStringConversion;
import org.mapstruct.ap.conversion.EnumStringConversion;
import org.mapstruct.ap.conversion.JavaLocalDateTimeToDateConversion;
import org.mapstruct.ap.conversion.JavaLocalDateTimeToStringConversion;
import org.mapstruct.ap.conversion.JavaLocalDateToStringConversion;
import org.mapstruct.ap.conversion.JavaLocalTimeToStringConversion;
import org.mapstruct.ap.conversion.JavaZonedDateTimeToDateConversion;
import org.mapstruct.ap.conversion.JavaZonedDateTimeToStringConversion;
import org.mapstruct.ap.conversion.JodaDateTimeToCalendarConversion;
import org.mapstruct.ap.conversion.JodaDateTimeToStringConversion;
import org.mapstruct.ap.conversion.JodaLocalDateTimeToStringConversion;
import org.mapstruct.ap.conversion.JodaLocalDateToStringConversion;
import org.mapstruct.ap.conversion.JodaLocalTimeToStringConversion;
import org.mapstruct.ap.conversion.JodaTimeToDateConversion;
import org.mapstruct.ap.conversion.PrimitiveToPrimitiveConversion;
import org.mapstruct.ap.conversion.PrimitiveToStringConversion;
import org.mapstruct.ap.conversion.PrimitiveToWrapperConversion;
import org.mapstruct.ap.conversion.ReverseConversion;
import org.mapstruct.ap.conversion.WrapperToStringConversion;
import org.mapstruct.ap.conversion.WrapperToWrapperConversion;
import org.mapstruct.ap.model.common.Type;
import org.mapstruct.ap.model.common.TypeFactory;

public class Conversions {
    private final Map<Key, ConversionProvider> conversions = new HashMap<Key, ConversionProvider>();
    private final Type enumType;
    private final Type stringType;
    private final TypeFactory typeFactory;

    public Conversions(Elements elementUtils, TypeFactory typeFactory) {
        this.typeFactory = typeFactory;
        this.enumType = typeFactory.getType(Enum.class);
        this.stringType = typeFactory.getType(String.class);
        this.registerNativeTypeConversion(Byte.TYPE, Byte.class);
        this.registerNativeTypeConversion(Byte.TYPE, Short.TYPE);
        this.registerNativeTypeConversion(Byte.TYPE, Short.class);
        this.registerNativeTypeConversion(Byte.TYPE, Integer.TYPE);
        this.registerNativeTypeConversion(Byte.TYPE, Integer.class);
        this.registerNativeTypeConversion(Byte.TYPE, Long.TYPE);
        this.registerNativeTypeConversion(Byte.TYPE, Long.class);
        this.registerNativeTypeConversion(Byte.TYPE, Float.TYPE);
        this.registerNativeTypeConversion(Byte.TYPE, Float.class);
        this.registerNativeTypeConversion(Byte.TYPE, Double.TYPE);
        this.registerNativeTypeConversion(Byte.TYPE, Double.class);
        this.registerNativeTypeConversion(Byte.class, Short.TYPE);
        this.registerNativeTypeConversion(Byte.class, Short.class);
        this.registerNativeTypeConversion(Byte.class, Integer.TYPE);
        this.registerNativeTypeConversion(Byte.class, Integer.class);
        this.registerNativeTypeConversion(Byte.class, Long.TYPE);
        this.registerNativeTypeConversion(Byte.class, Long.class);
        this.registerNativeTypeConversion(Byte.class, Float.TYPE);
        this.registerNativeTypeConversion(Byte.class, Float.class);
        this.registerNativeTypeConversion(Byte.class, Double.TYPE);
        this.registerNativeTypeConversion(Byte.class, Double.class);
        this.registerNativeTypeConversion(Short.TYPE, Short.class);
        this.registerNativeTypeConversion(Short.TYPE, Integer.TYPE);
        this.registerNativeTypeConversion(Short.TYPE, Integer.class);
        this.registerNativeTypeConversion(Short.TYPE, Long.TYPE);
        this.registerNativeTypeConversion(Short.TYPE, Long.class);
        this.registerNativeTypeConversion(Short.TYPE, Float.TYPE);
        this.registerNativeTypeConversion(Short.TYPE, Float.class);
        this.registerNativeTypeConversion(Short.TYPE, Double.TYPE);
        this.registerNativeTypeConversion(Short.TYPE, Double.class);
        this.registerNativeTypeConversion(Short.class, Integer.TYPE);
        this.registerNativeTypeConversion(Short.class, Integer.class);
        this.registerNativeTypeConversion(Short.class, Long.TYPE);
        this.registerNativeTypeConversion(Short.class, Long.class);
        this.registerNativeTypeConversion(Short.class, Float.TYPE);
        this.registerNativeTypeConversion(Short.class, Float.class);
        this.registerNativeTypeConversion(Short.class, Double.TYPE);
        this.registerNativeTypeConversion(Short.class, Double.class);
        this.registerNativeTypeConversion(Integer.TYPE, Integer.class);
        this.registerNativeTypeConversion(Integer.TYPE, Long.TYPE);
        this.registerNativeTypeConversion(Integer.TYPE, Long.class);
        this.registerNativeTypeConversion(Integer.TYPE, Float.TYPE);
        this.registerNativeTypeConversion(Integer.TYPE, Float.class);
        this.registerNativeTypeConversion(Integer.TYPE, Double.TYPE);
        this.registerNativeTypeConversion(Integer.TYPE, Double.class);
        this.registerNativeTypeConversion(Integer.class, Long.TYPE);
        this.registerNativeTypeConversion(Integer.class, Long.class);
        this.registerNativeTypeConversion(Integer.class, Float.TYPE);
        this.registerNativeTypeConversion(Integer.class, Float.class);
        this.registerNativeTypeConversion(Integer.class, Double.TYPE);
        this.registerNativeTypeConversion(Integer.class, Double.class);
        this.registerNativeTypeConversion(Long.TYPE, Long.class);
        this.registerNativeTypeConversion(Long.TYPE, Float.TYPE);
        this.registerNativeTypeConversion(Long.TYPE, Float.class);
        this.registerNativeTypeConversion(Long.TYPE, Double.TYPE);
        this.registerNativeTypeConversion(Long.TYPE, Double.class);
        this.registerNativeTypeConversion(Long.class, Float.TYPE);
        this.registerNativeTypeConversion(Long.class, Float.class);
        this.registerNativeTypeConversion(Long.class, Double.TYPE);
        this.registerNativeTypeConversion(Long.class, Double.class);
        this.registerNativeTypeConversion(Float.TYPE, Float.class);
        this.registerNativeTypeConversion(Float.TYPE, Double.TYPE);
        this.registerNativeTypeConversion(Float.TYPE, Double.class);
        this.registerNativeTypeConversion(Float.class, Double.TYPE);
        this.registerNativeTypeConversion(Float.class, Double.class);
        this.registerNativeTypeConversion(Double.TYPE, Double.class);
        this.registerNativeTypeConversion(Boolean.TYPE, Boolean.class);
        this.registerNativeTypeConversion(Character.TYPE, Character.class);
        this.registerBigIntegerConversion(Byte.TYPE);
        this.registerBigIntegerConversion(Byte.class);
        this.registerBigIntegerConversion(Short.TYPE);
        this.registerBigIntegerConversion(Short.class);
        this.registerBigIntegerConversion(Integer.TYPE);
        this.registerBigIntegerConversion(Integer.class);
        this.registerBigIntegerConversion(Long.TYPE);
        this.registerBigIntegerConversion(Long.class);
        this.registerBigIntegerConversion(Float.TYPE);
        this.registerBigIntegerConversion(Float.class);
        this.registerBigIntegerConversion(Double.TYPE);
        this.registerBigIntegerConversion(Double.class);
        this.registerBigDecimalConversion(Byte.TYPE);
        this.registerBigDecimalConversion(Byte.class);
        this.registerBigDecimalConversion(Short.TYPE);
        this.registerBigDecimalConversion(Short.class);
        this.registerBigDecimalConversion(Integer.TYPE);
        this.registerBigDecimalConversion(Integer.class);
        this.registerBigDecimalConversion(Long.TYPE);
        this.registerBigDecimalConversion(Long.class);
        this.registerBigDecimalConversion(Float.TYPE);
        this.registerBigDecimalConversion(Float.class);
        this.registerBigDecimalConversion(Double.TYPE);
        this.registerBigDecimalConversion(Double.class);
        this.registerToStringConversion(Byte.TYPE);
        this.registerToStringConversion(Byte.class);
        this.registerToStringConversion(Short.TYPE);
        this.registerToStringConversion(Short.class);
        this.registerToStringConversion(Integer.TYPE);
        this.registerToStringConversion(Integer.class);
        this.registerToStringConversion(Long.TYPE);
        this.registerToStringConversion(Long.class);
        this.registerToStringConversion(Float.TYPE);
        this.registerToStringConversion(Float.class);
        this.registerToStringConversion(Double.TYPE);
        this.registerToStringConversion(Double.class);
        this.registerToStringConversion(Boolean.TYPE);
        this.registerToStringConversion(Boolean.class);
        this.register(Character.TYPE, String.class, (ConversionProvider)new CharToStringConversion());
        this.register(Character.class, String.class, (ConversionProvider)new CharWrapperToStringConversion());
        this.register(BigInteger.class, String.class, (ConversionProvider)new BigIntegerToStringConversion());
        this.register(BigDecimal.class, String.class, (ConversionProvider)new BigDecimalToStringConversion());
        this.registerJodaConversions();
        this.registerJava8TimeConversions();
        this.register(Enum.class, String.class, (ConversionProvider)new EnumStringConversion());
        this.register(Date.class, String.class, (ConversionProvider)new DateToStringConversion());
        this.register(BigDecimal.class, BigInteger.class, (ConversionProvider)new BigDecimalToBigIntegerConversion());
    }

    private void registerJodaConversions() {
        if (!this.isJodaTimeAvailable()) {
            return;
        }
        this.register("org.joda.time.DateTime", String.class, (ConversionProvider)new JodaDateTimeToStringConversion());
        this.register("org.joda.time.LocalDate", String.class, (ConversionProvider)new JodaLocalDateToStringConversion());
        this.register("org.joda.time.LocalDateTime", String.class, (ConversionProvider)new JodaLocalDateTimeToStringConversion());
        this.register("org.joda.time.LocalTime", String.class, (ConversionProvider)new JodaLocalTimeToStringConversion());
        this.register("org.joda.time.DateTime", Date.class, (ConversionProvider)new JodaTimeToDateConversion());
        this.register("org.joda.time.LocalDate", Date.class, (ConversionProvider)new JodaTimeToDateConversion());
        this.register("org.joda.time.LocalDateTime", Date.class, (ConversionProvider)new JodaTimeToDateConversion());
        this.register("org.joda.time.DateTime", Calendar.class, (ConversionProvider)new JodaDateTimeToCalendarConversion());
    }

    private void registerJava8TimeConversions() {
        if (!this.isJava8TimeAvailable()) {
            return;
        }
        this.register("java.time.ZonedDateTime", String.class, (ConversionProvider)new JavaZonedDateTimeToStringConversion());
        this.register("java.time.LocalDate", String.class, (ConversionProvider)new JavaLocalDateToStringConversion());
        this.register("java.time.LocalDateTime", String.class, (ConversionProvider)new JavaLocalDateTimeToStringConversion());
        this.register("java.time.LocalTime", String.class, (ConversionProvider)new JavaLocalTimeToStringConversion());
        this.register("java.time.ZonedDateTime", Date.class, (ConversionProvider)new JavaZonedDateTimeToDateConversion());
        this.register("java.time.LocalDateTime", Date.class, (ConversionProvider)new JavaLocalDateTimeToDateConversion());
    }

    private boolean isJodaTimeAvailable() {
        return this.typeFactory.isTypeAvailable("org.joda.time.DateTime");
    }

    private boolean isJava8TimeAvailable() {
        return this.typeFactory.isTypeAvailable("java.time.ZonedDateTime");
    }

    private void registerNativeTypeConversion(Class<?> sourceType, Class<?> targetType) {
        if (sourceType.isPrimitive() && targetType.isPrimitive()) {
            this.register(sourceType, targetType, (ConversionProvider)new PrimitiveToPrimitiveConversion(sourceType));
        } else if (sourceType.isPrimitive() && !targetType.isPrimitive()) {
            this.register(sourceType, targetType, (ConversionProvider)new PrimitiveToWrapperConversion(sourceType, targetType));
        } else if (!sourceType.isPrimitive() && targetType.isPrimitive()) {
            this.register(sourceType, targetType, (ConversionProvider)ReverseConversion.reverse(new PrimitiveToWrapperConversion(targetType, sourceType)));
        } else {
            this.register(sourceType, targetType, (ConversionProvider)new WrapperToWrapperConversion(sourceType, targetType));
        }
    }

    private void registerToStringConversion(Class<?> sourceType) {
        if (sourceType.isPrimitive()) {
            this.register(sourceType, String.class, (ConversionProvider)new PrimitiveToStringConversion(sourceType));
        } else {
            this.register(sourceType, String.class, (ConversionProvider)new WrapperToStringConversion(sourceType));
        }
    }

    private void registerBigIntegerConversion(Class<?> targetType) {
        if (targetType.isPrimitive()) {
            this.register(BigInteger.class, targetType, (ConversionProvider)new BigIntegerToPrimitiveConversion(targetType));
        } else {
            this.register(BigInteger.class, targetType, (ConversionProvider)new BigIntegerToWrapperConversion(targetType));
        }
    }

    private void registerBigDecimalConversion(Class<?> targetType) {
        if (targetType.isPrimitive()) {
            this.register(BigDecimal.class, targetType, (ConversionProvider)new BigDecimalToPrimitiveConversion(targetType));
        } else {
            this.register(BigDecimal.class, targetType, (ConversionProvider)new BigDecimalToWrapperConversion(targetType));
        }
    }

    private void register(Class<?> sourceClass, Class<?> targetClass, ConversionProvider conversion) {
        Type sourceType = this.typeFactory.getType(sourceClass);
        Type targetType = this.typeFactory.getType(targetClass);
        this.conversions.put(new Key(sourceType, targetType), conversion);
        this.conversions.put(new Key(targetType, sourceType), ReverseConversion.reverse(conversion));
    }

    private void register(String sourceTypeName, Class<?> targetClass, ConversionProvider conversion) {
        Type sourceType = this.typeFactory.getType(sourceTypeName);
        Type targetType = this.typeFactory.getType(targetClass);
        this.conversions.put(new Key(sourceType, targetType), conversion);
        this.conversions.put(new Key(targetType, sourceType), ReverseConversion.reverse(conversion));
    }

    public ConversionProvider getConversion(Type sourceType, Type targetType) {
        if (sourceType.isEnumType() && targetType.equals(this.stringType)) {
            sourceType = this.enumType;
        } else if (targetType.isEnumType() && sourceType.equals(this.stringType)) {
            targetType = this.enumType;
        }
        return this.conversions.get(new Key(sourceType, targetType));
    }

    private static class Key {
        private final Type sourceType;
        private final Type targetType;

        private Key(Type sourceType, Type targetType) {
            this.sourceType = sourceType;
            this.targetType = targetType;
        }

        public String toString() {
            return "Key [sourceType=" + this.sourceType + ", targetType=" + this.targetType + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.sourceType == null ? 0 : this.sourceType.hashCode());
            result = 31 * result + (this.targetType == null ? 0 : this.targetType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.sourceType == null ? other.sourceType != null : !this.sourceType.equals(other.sourceType)) {
                return false;
            }
            return !(this.targetType == null ? other.targetType != null : !this.targetType.equals(other.targetType));
        }
    }
}

