/*
 * Decompiled with CFR 0.152.
 */
package org.liquibase.maven.plugins;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.bind.annotation.XmlSchema;
import liquibase.GlobalConfiguration;
import liquibase.Liquibase;
import liquibase.Scope;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.changelog.visitor.DefaultChangeExecListener;
import liquibase.configuration.ConfigurationValueProvider;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.configuration.core.DefaultsFileValueProvider;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.integration.IntegrationDetails;
import liquibase.integration.commandline.ChangeExecListenerUtils;
import liquibase.integration.commandline.CommandLineUtils;
import liquibase.integration.commandline.LiquibaseCommandLineConfiguration;
import liquibase.resource.DirectoryResourceAccessor;
import liquibase.resource.ResourceAccessor;
import liquibase.resource.SearchPathResourceAccessor;
import liquibase.util.FileUtil;
import liquibase.util.StringUtil;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.liquibase.maven.plugins.MavenLogService;
import org.liquibase.maven.plugins.MavenResourceAccessor;
import org.liquibase.maven.plugins.MavenUtils;
import org.liquibase.maven.property.PropertyElement;

public abstract class AbstractLiquibaseMojo
extends AbstractMojo {
    private static final String DEFAULT_FIELD_SUFFIX = "Default";
    @PropertyElement
    protected Boolean preserveSchemaCase;
    @PropertyElement
    protected String driver;
    @PropertyElement
    protected String url;
    protected WagonManager wagonManager;
    @PropertyElement
    protected String username;
    @PropertyElement
    protected String password;
    @PropertyElement
    protected boolean emptyPassword;
    @PropertyElement
    protected boolean outputDefaultSchema;
    @PropertyElement
    protected boolean outputDefaultCatalog;
    @PropertyElement
    protected String defaultCatalogName;
    @PropertyElement
    protected String defaultSchemaName;
    @PropertyElement
    protected String databaseClass;
    @PropertyElement
    protected String propertyProviderClass;
    @PropertyElement
    protected boolean promptOnNonLocalDatabase;
    @PropertyElement
    protected boolean includeArtifact;
    @PropertyElement
    protected boolean includeTestOutputDirectory;
    @PropertyElement
    protected boolean verbose;
    @PropertyElement
    protected String logging;
    @PropertyElement
    protected String propertyFile;
    @PropertyElement
    protected boolean propertyFileWillOverride;
    @PropertyElement
    protected boolean clearCheckSums;
    @PropertyElement
    protected Properties systemProperties;
    protected MavenProject project;
    @PropertyElement
    protected boolean skip;
    @PropertyElement
    protected String outputFileEncoding;
    @PropertyElement
    protected String changelogCatalogName;
    @PropertyElement
    protected String changelogSchemaName;
    @PropertyElement
    protected String databaseChangeLogTableName;
    @PropertyElement
    protected String databaseChangeLogLockTableName;
    @PropertyElement
    protected boolean showBanner = true;
    @PropertyElement
    private String server;
    @PropertyElement
    private Liquibase liquibase;
    @PropertyElement
    protected String searchPath;
    private Properties expressionVars;
    private Map expressionVariables;
    private File driverPropertiesFile;
    @PropertyElement
    @Deprecated
    private String liquibaseProLicenseKey;
    @PropertyElement
    private String liquibaseLicenseKey;
    @PropertyElement
    protected String psqlPath;
    @PropertyElement
    protected Boolean psqlKeepTemp;
    @PropertyElement
    protected String psqlKeepTempName;
    @PropertyElement
    protected String psqlKeepTempPath;
    @PropertyElement
    protected String psqlArgs;
    @PropertyElement
    protected Integer psqlTimeout;
    @PropertyElement
    protected String psqlLogFile;
    @PropertyElement
    protected String sqlPlusPath;
    @PropertyElement
    protected Boolean sqlPlusKeepTemp;
    @PropertyElement
    protected String sqlPlusKeepTempName;
    @PropertyElement
    protected String sqlPlusKeepTempPath;
    @PropertyElement
    protected Boolean sqlPlusKeepTempOverwrite;
    @PropertyElement
    protected String sqlPlusArgs;
    @PropertyElement
    protected Integer sqlPlusTimeout;
    @PropertyElement
    protected String sqlPlusLogFile;
    @PropertyElement
    protected String sqlcmdPath;
    @PropertyElement
    protected Boolean sqlcmdKeepTemp;
    @PropertyElement
    protected String sqlcmdKeepTempName;
    @PropertyElement
    protected String sqlcmdKeepTempPath;
    @PropertyElement
    protected Boolean sqlcmdKeepTempOverwrite;
    @PropertyElement
    protected String sqlcmdArgs;
    @PropertyElement
    protected Integer sqlcmdTimeout;
    @PropertyElement
    protected String sqlcmdLogFile;
    @PropertyElement
    protected String sqlcmdCatalogName;
    @PropertyElement
    protected String changeExecListenerClass;
    @PropertyElement
    protected String changeExecListenerPropertiesFile;
    protected String commandName;
    protected DefaultChangeExecListener defaultChangeExecListener;

    protected String getLicenseKey() {
        if (StringUtil.isNotEmpty((String)this.liquibaseLicenseKey)) {
            return this.liquibaseLicenseKey;
        }
        return this.liquibaseProLicenseKey;
    }

    protected Writer getOutputWriter(File outputFile) throws IOException {
        String encoding = this.outputFileEncoding;
        if (encoding == null) {
            encoding = (String)GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue();
        }
        this.getLog().debug((CharSequence)("Writing output file with '" + encoding + "' file encoding."));
        return new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(outputFile.toPath(), new OpenOption[0]), encoding));
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (StringUtil.trimToNull((String)this.logging) != null) {
            this.getLog().error((CharSequence)"The liquibase-maven-plugin now manages logging via the standard maven logging config, not the 'logging' configuration. Use the -e, -X or -q flags or see https://maven.apache.org/maven-logging.html");
        }
        try {
            Scope.child((Enum)Scope.Attr.logService, (Object)((Object)new MavenLogService(this.getLog())), () -> {
                AuthenticationInfo info;
                this.getLog().info((CharSequence)"------------------------------------------------------------------------");
                if (this.server != null && (info = this.wagonManager.getAuthenticationInfo(this.server)) != null) {
                    this.username = info.getUserName();
                    this.password = info.getPassword();
                }
                this.processSystemProperties();
                if (!((Boolean)LiquibaseCommandLineConfiguration.SHOULD_RUN.getCurrentValue()).booleanValue()) {
                    this.getLog().info((CharSequence)("Liquibase did not run because " + LiquibaseCommandLineConfiguration.SHOULD_RUN.getKey() + " was set to false"));
                    return;
                }
                if (this.skip) {
                    this.getLog().warn((CharSequence)"Liquibase skipped due to Maven configuration");
                    return;
                }
                ClassLoader mavenClassLoader = this.getClassLoaderIncludingProjectClasspath();
                HashMap<String, Object> scopeValues = new HashMap<String, Object>();
                scopeValues.put(Scope.Attr.resourceAccessor.name(), this.getResourceAccessor(mavenClassLoader));
                scopeValues.put(Scope.Attr.classLoader.name(), this.getClassLoaderIncludingProjectClasspath());
                IntegrationDetails integrationDetails = new IntegrationDetails();
                integrationDetails.setName("maven");
                PluginDescriptor pluginDescriptor = (PluginDescriptor)this.getPluginContext().get("pluginDescriptor");
                for (MojoDescriptor descriptor : pluginDescriptor.getMojos()) {
                    if (!descriptor.getImplementationClass().equals(((Object)((Object)this)).getClass())) continue;
                    for (Parameter param : descriptor.getParameters()) {
                        String name = param.getName();
                        if (name.equalsIgnoreCase("project") || name.equalsIgnoreCase("systemProperties")) continue;
                        Field field = this.getField(((Object)((Object)this)).getClass(), name);
                        if (field == null) {
                            this.getLog().debug((CharSequence)("Cannot read current maven value for. Will not send the value to hub " + name));
                            continue;
                        }
                        field.setAccessible(true);
                        Object value = field.get((Object)this);
                        if (value == null) continue;
                        try {
                            integrationDetails.setParameter("maven__" + param.getName().replaceAll("[${}]", ""), String.valueOf(value));
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                }
                scopeValues.put("integrationDetails", integrationDetails);
                scopeValues.put("liquibase.licenseKey", this.getLicenseKey());
                String key = GlobalConfiguration.PRESERVE_SCHEMA_CASE.getKey();
                scopeValues.put(key, this.preserveSchemaCase);
                scopeValues.putAll(this.getNativeExecutorProperties());
                Scope.child(scopeValues, () -> {
                    this.configureFieldsAndValues();
                    if (this.showBanner) {
                        this.getLog().info((CharSequence)CommandLineUtils.getBanner());
                    }
                    this.displayMojoSettings();
                    this.checkRequiredParametersAreSpecified();
                    Database database = null;
                    try {
                        if (this.databaseConnectionRequired()) {
                            String dbPassword = this.emptyPassword || this.password == null ? "" : this.password;
                            String driverPropsFile = this.driverPropertiesFile == null ? null : this.driverPropertiesFile.getAbsolutePath();
                            database = CommandLineUtils.createDatabaseObject((ClassLoader)mavenClassLoader, (String)this.url, (String)this.username, (String)dbPassword, (String)this.driver, (String)this.defaultCatalogName, (String)this.defaultSchemaName, (boolean)this.outputDefaultCatalog, (boolean)this.outputDefaultSchema, (String)this.databaseClass, (String)driverPropsFile, (String)this.propertyProviderClass, (String)this.changelogCatalogName, (String)this.changelogSchemaName, (String)this.databaseChangeLogTableName, (String)this.databaseChangeLogLockTableName);
                            this.liquibase = this.createLiquibase(database);
                            this.configureChangeLogProperties();
                            ChangeExecListener listener = ChangeExecListenerUtils.getChangeExecListener((Database)this.liquibase.getDatabase(), (ResourceAccessor)this.liquibase.getResourceAccessor(), (String)this.changeExecListenerClass, (String)this.changeExecListenerPropertiesFile);
                            this.defaultChangeExecListener = new DefaultChangeExecListener(new ChangeExecListener[]{listener});
                            this.liquibase.setChangeExecListener((ChangeExecListener)this.defaultChangeExecListener);
                            this.getLog().debug((CharSequence)("expressionVars = " + this.expressionVars));
                            if (this.expressionVars != null) {
                                for (Map.Entry<Object, Object> entry : this.expressionVars.entrySet()) {
                                    this.liquibase.setChangeLogParameter(entry.getKey().toString(), entry.getValue());
                                }
                            }
                            this.getLog().debug((CharSequence)("expressionVariables = " + this.expressionVariables));
                            if (this.expressionVariables != null) {
                                for (Map.Entry<Object, Object> entry : this.expressionVariables.entrySet()) {
                                    if (entry.getValue() == null) continue;
                                    this.liquibase.setChangeLogParameter(entry.getKey().toString(), entry.getValue());
                                }
                            }
                            if (this.clearCheckSums) {
                                this.getLog().info((CharSequence)"Clearing the Liquibase checksums on the database");
                                this.liquibase.clearCheckSums();
                            }
                            this.getLog().info((CharSequence)("Executing on Database: " + this.url));
                            if (this.isPromptOnNonLocalDatabase()) {
                                this.getLog().info((CharSequence)"NOTE: The promptOnLocalDatabase functionality has been removed");
                            }
                        }
                        this.setupBindInfoPackage();
                        HashMap<String, Boolean> innerScopeValues = new HashMap<String, Boolean>();
                        innerScopeValues.put(key, this.preserveSchemaCase);
                        Scope.child(innerScopeValues, () -> this.performLiquibaseTask(this.liquibase));
                    }
                    catch (LiquibaseException e) {
                        this.cleanup(database);
                        throw new MojoExecutionException("\nError setting up or running Liquibase:\n" + e.getMessage(), (Exception)((Object)e));
                    }
                    this.cleanup(database);
                    this.getLog().info((CharSequence)"------------------------------------------------------------------------");
                    this.getLog().info((CharSequence)"");
                });
            });
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    protected Field getField(Class clazz, String name) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            if (clazz.equals(Object.class)) {
                return null;
            }
            return this.getField(clazz.getSuperclass(), name);
        }
    }

    protected Liquibase getLiquibase() {
        return this.liquibase;
    }

    protected void setupBindInfoPackage() {
        String nsuri = "http://www.hibernate.org/xsd/orm/hbm";
        String packageInfoClassName = "org.hibernate.boot.jaxb.hbm.spi.package-info";
        try {
            Class<?> packageInfoClass = Class.forName(packageInfoClassName);
            XmlSchema xmlSchema = packageInfoClass.getAnnotation(XmlSchema.class);
            if (xmlSchema == null) {
                this.getLog().warn((CharSequence)MessageFormat.format("Class [{0}] is missing the [{1}] annotation. Processing bindings will probably fail.", packageInfoClassName, XmlSchema.class.getName()));
            } else {
                String namespace = xmlSchema.namespace();
                if (nsuri.equals(namespace)) {
                    this.getLog().warn((CharSequence)MessageFormat.format("Namespace of the [{0}] annotation does not match [{1}]. Processing bindings will probably fail.", XmlSchema.class.getName(), nsuri));
                }
            }
        }
        catch (ClassNotFoundException cnfex) {
            this.getLog().debug((CharSequence)MessageFormat.format("Class [{0}] could not be found. Processing hibernate bindings will probably fail if applicable.", packageInfoClassName), (Throwable)cnfex);
        }
    }

    protected abstract void performLiquibaseTask(Liquibase var1) throws LiquibaseException;

    protected boolean isPromptOnNonLocalDatabase() {
        return false;
    }

    private void displayMojoSettings() {
        if (this.verbose) {
            this.getLog().info((CharSequence)"Settings\n----------------------------");
            this.printSettings("    ");
            this.getLog().info((CharSequence)"------------------------------------------------------------------------");
        }
    }

    protected Liquibase createLiquibase(Database db) throws MojoExecutionException {
        return new Liquibase("", Scope.getCurrentScope().getResourceAccessor(), db);
    }

    public void configureFieldsAndValues() throws MojoExecutionException {
        if (this.propertyFile != null) {
            Throwable throwable;
            InputStream is;
            this.getLog().info((CharSequence)"Parsing Liquibase Properties File");
            this.getLog().info((CharSequence)("  File: " + this.propertyFile));
            try {
                is = AbstractLiquibaseMojo.handlePropertyFileInputStream(this.propertyFile);
                throwable = null;
                try {
                    if (is == null) {
                        throw new MojoExecutionException(FileUtil.getFileNotFoundMessage((String)this.propertyFile));
                    }
                    this.parsePropertiesFile(is);
                    this.getLog().info((CharSequence)"------------------------------------------------------------------------");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is != null) {
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            catch (IOException | MojoFailureException e) {
                throw new UnexpectedLiquibaseException(e);
            }
            try {
                is = AbstractLiquibaseMojo.handlePropertyFileInputStream(this.propertyFile);
                throwable = null;
                try {
                    LiquibaseConfiguration liquibaseConfiguration = (LiquibaseConfiguration)Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class);
                    DefaultsFileValueProvider fileProvider = new DefaultsFileValueProvider(is, "Property file " + this.propertyFile);
                    liquibaseConfiguration.registerProvider((ConfigurationValueProvider)fileProvider);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (is != null) {
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            catch (IOException | MojoFailureException e) {
                throw new UnexpectedLiquibaseException(e);
            }
        }
    }

    protected void configureChangeLogProperties() throws MojoFailureException, MojoExecutionException {
        if (this.propertyFile != null) {
            this.getLog().info((CharSequence)("Parsing Liquibase Properties File " + this.propertyFile + " for changeLog parameters"));
            try (InputStream propertiesInputStream = AbstractLiquibaseMojo.handlePropertyFileInputStream(this.propertyFile);){
                Properties props = AbstractLiquibaseMojo.loadProperties(propertiesInputStream);
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    String key = (String)entry.getKey();
                    if (!key.startsWith("parameter.")) continue;
                    this.getLog().debug((CharSequence)("Setting changeLog parameter " + key));
                    this.liquibase.setChangeLogParameter(key.replaceFirst("^parameter.", ""), entry.getValue());
                }
            }
            catch (IOException e) {
                throw new UnexpectedLiquibaseException((Throwable)e);
            }
        }
    }

    private static InputStream handlePropertyFileInputStream(String propertyFile) throws MojoFailureException {
        try {
            return Scope.getCurrentScope().getResourceAccessor().getExisting(propertyFile).openInputStream();
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to resolve the properties file.", (Throwable)e);
        }
    }

    protected ClassLoader getMavenArtifactClassLoader() throws MojoExecutionException {
        try {
            return MavenUtils.getArtifactClassloader(this.project, this.includeArtifact, this.includeTestOutputDirectory, ((Object)((Object)this)).getClass(), this.getLog(), this.verbose);
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Failed to create artifact classloader", (Exception)e);
        }
    }

    protected ClassLoader getClassLoaderIncludingProjectClasspath() throws MojoExecutionException {
        try {
            List classpathElements = this.project.getCompileClasspathElements();
            classpathElements.add(this.project.getBuild().getOutputDirectory());
            URL[] urls = new URL[classpathElements.size()];
            for (int i = 0; i < classpathElements.size(); ++i) {
                urls[i] = new File((String)classpathElements.get(i)).toURI().toURL();
            }
            return new URLClassLoader(urls, this.getMavenArtifactClassLoader());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to create project classloader", e);
        }
    }

    protected ResourceAccessor getResourceAccessor(ClassLoader cl) throws IOException, MojoFailureException {
        MavenResourceAccessor mFO = new MavenResourceAccessor(cl);
        DirectoryResourceAccessor fsFO = new DirectoryResourceAccessor(this.project.getBasedir());
        return new SearchPathResourceAccessor(this.searchPath, new ResourceAccessor[]{mFO, fsFO});
    }

    protected void checkRequiredParametersAreSpecified() throws MojoFailureException {
        if (this.databaseConnectionRequired()) {
            if (this.url == null) {
                throw new MojoFailureException("The database URL has not been specified either as a parameter or in a properties file.");
            }
            if (this.password != null && this.emptyPassword) {
                throw new MojoFailureException("A password cannot be present and the empty password property both be specified.");
            }
        }
    }

    public boolean databaseConnectionRequired() {
        return true;
    }

    protected void printSettings(String indent) {
        if (indent == null) {
            indent = "";
        }
        this.getLog().info((CharSequence)(indent + "driver: " + this.driver));
        this.getLog().info((CharSequence)(indent + "url: " + this.url));
        this.getLog().info((CharSequence)(indent + "username: *****"));
        this.getLog().info((CharSequence)(indent + "password: *****"));
        this.getLog().info((CharSequence)(indent + "use empty password: " + this.emptyPassword));
        this.getLog().info((CharSequence)(indent + "properties file: " + this.propertyFile));
        this.getLog().info((CharSequence)(indent + "properties file will override? " + this.propertyFileWillOverride));
        this.getLog().info((CharSequence)(indent + "clear checksums? " + this.clearCheckSums));
    }

    protected void cleanup(Database db) {
        if (db != null) {
            try {
                db.rollback();
                db.close();
            }
            catch (DatabaseException e) {
                this.getLog().error((CharSequence)"Failed to close open connection to database.", (Throwable)e);
            }
        }
    }

    private static Properties loadProperties(InputStream propertiesInputStream) throws MojoExecutionException {
        Properties props = new Properties();
        try {
            props.load(propertiesInputStream);
            return props;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not load the properties Liquibase file", (Exception)e);
        }
    }

    protected void parsePropertiesFile(InputStream propertiesInputStream) throws MojoExecutionException {
        if (propertiesInputStream == null) {
            throw new MojoExecutionException("Properties file InputStream is null.");
        }
        Properties props = AbstractLiquibaseMojo.loadProperties(propertiesInputStream);
        Iterator<Object> it = props.keySet().iterator();
        while (it.hasNext()) {
            String key = null;
            try {
                key = (String)it.next();
                Field field = MavenUtils.getDeclaredField(((Object)((Object)this)).getClass(), key);
                if (this.propertyFileWillOverride) {
                    this.getLog().debug((CharSequence)("  properties file setting value: " + field.getName()));
                    this.setFieldValue(field, props.get(key).toString());
                    continue;
                }
                if (this.isCurrentFieldValueSpecified(field)) continue;
                this.getLog().debug((CharSequence)("  properties file setting value: " + field.getName()));
                this.setFieldValue(field, props.get(key).toString());
            }
            catch (Exception e) {
                this.getLog().info((CharSequence)("  '" + key + "' in properties file is not being used by this task."));
            }
        }
    }

    private boolean isCurrentFieldValueSpecified(Field f) throws IllegalAccessException {
        Object currentValue = f.get((Object)this);
        if (currentValue == null) {
            return false;
        }
        Object defaultValue = this.getDefaultValue(f);
        if (defaultValue == null) {
            return currentValue != null;
        }
        return !defaultValue.equals(f.get((Object)this));
    }

    private Object getDefaultValue(Field field) throws IllegalAccessException {
        ArrayList<Field> allFields = new ArrayList<Field>();
        allFields.addAll(Arrays.asList(((Object)((Object)this)).getClass().getDeclaredFields()));
        allFields.addAll(Arrays.asList(AbstractLiquibaseMojo.class.getDeclaredFields()));
        for (Field f : allFields) {
            if (!f.getName().equals(field.getName() + DEFAULT_FIELD_SUFFIX)) continue;
            f.setAccessible(true);
            return f.get((Object)this);
        }
        return null;
    }

    private void setFieldValue(Field field, String value) throws IllegalAccessException {
        if (field.getType().equals(Boolean.class) || field.getType().equals(Boolean.TYPE)) {
            field.set((Object)this, Boolean.valueOf(value));
        } else if (field.getType().equals(File.class)) {
            field.set((Object)this, new File(value));
        } else {
            field.set((Object)this, value);
        }
    }

    private void processSystemProperties() {
        if (this.systemProperties == null) {
            this.systemProperties = new Properties();
        }
        for (String string : this.systemProperties.keySet()) {
            String value = this.systemProperties.getProperty(string);
            System.setProperty(string, value);
        }
    }

    private Map<String, Object> getNativeExecutorProperties() {
        HashMap<String, Object> nativeProperties = new HashMap<String, Object>();
        nativeProperties.computeIfAbsent("liquibase.psql.path", val -> this.psqlPath);
        nativeProperties.computeIfAbsent("liquibase.psql.keep.temp", val -> this.psqlKeepTemp);
        nativeProperties.computeIfAbsent("liquibase.psql.keep.temp.name", val -> this.psqlKeepTempName);
        nativeProperties.computeIfAbsent("liquibase.psql.keep.temp.path", val -> this.psqlKeepTempPath);
        nativeProperties.computeIfAbsent("liquibase.psql.args", val -> this.psqlArgs);
        nativeProperties.computeIfAbsent("liquibase.psql.timeout", val -> this.psqlTimeout);
        nativeProperties.computeIfAbsent("liquibase.psql.logFile", val -> this.psqlLogFile);
        nativeProperties.computeIfAbsent("liquibase.sqlplus.path", val -> this.sqlPlusPath);
        nativeProperties.computeIfAbsent("liquibase.sqlplus.keep.temp", val -> this.sqlPlusKeepTemp);
        nativeProperties.computeIfAbsent("liquibase.sqlplus.keep.temp.name", val -> this.sqlPlusKeepTempName);
        nativeProperties.computeIfAbsent("liquibase.sqlplus.keep.temp.path", val -> this.sqlPlusKeepTempPath);
        nativeProperties.computeIfAbsent("liquibase.sqlplus.keep.temp.overwrite", val -> this.sqlPlusKeepTempOverwrite);
        nativeProperties.computeIfAbsent("liquibase.sqlplus.args", val -> this.sqlPlusArgs);
        nativeProperties.computeIfAbsent("liquibase.sqlplus.timeout", val -> this.sqlPlusTimeout);
        nativeProperties.computeIfAbsent("liquibase.sqlplus.logFile", val -> this.sqlPlusLogFile);
        nativeProperties.computeIfAbsent("liquibase.sqlcmd.path", val -> this.sqlcmdPath);
        nativeProperties.computeIfAbsent("liquibase.sqlcmd.keep.temp", val -> this.sqlcmdKeepTemp);
        nativeProperties.computeIfAbsent("liquibase.sqlcmd.keep.temp.name", val -> this.sqlcmdKeepTempName);
        nativeProperties.computeIfAbsent("liquibase.sqlcmd.keep.temp.path", val -> this.sqlcmdKeepTempPath);
        nativeProperties.computeIfAbsent("liquibase.sqlcmd.keep.temp.overwrite", val -> this.sqlcmdKeepTempOverwrite);
        nativeProperties.computeIfAbsent("liquibase.sqlcmd.args", val -> this.sqlcmdArgs);
        nativeProperties.computeIfAbsent("liquibase.sqlcmd.timeout", val -> this.sqlcmdTimeout);
        nativeProperties.computeIfAbsent("liquibase.sqlcmd.logFile", val -> this.sqlcmdLogFile);
        nativeProperties.computeIfAbsent("liquibase.sqlcmd.catalogName", val -> this.sqlcmdCatalogName);
        return nativeProperties;
    }
}

