/*
 * Decompiled with CFR 0.152.
 */
package liquibase.changelog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import liquibase.ContextExpression;
import liquibase.change.Change;
import liquibase.change.ChangeFactory;
import liquibase.change.CheckSum;
import liquibase.change.DbmsTargetedChange;
import liquibase.change.core.EmptyChange;
import liquibase.change.core.RawSQLChange;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.database.Database;
import liquibase.database.DatabaseList;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.exception.DatabaseException;
import liquibase.exception.MigrationFailedException;
import liquibase.exception.PreconditionErrorException;
import liquibase.exception.PreconditionFailedException;
import liquibase.exception.RollbackFailedException;
import liquibase.exception.SetupException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.logging.LogFactory;
import liquibase.logging.Logger;
import liquibase.parser.core.ParsedNode;
import liquibase.parser.core.ParsedNodeException;
import liquibase.precondition.Conditional;
import liquibase.precondition.ErrorPrecondition;
import liquibase.precondition.FailedPrecondition;
import liquibase.precondition.core.PreconditionContainer;
import liquibase.resource.ResourceAccessor;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.sql.visitor.SqlVisitor;
import liquibase.sql.visitor.SqlVisitorFactory;
import liquibase.statement.SqlStatement;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtils;

public class ChangeSet
implements Conditional,
LiquibaseSerializable {
    private ChangeLogParameters changeLogParameters;
    private List<Change> changes;
    private String id;
    private String author;
    private String filePath = "UNKNOWN CHANGE LOG";
    private Logger log;
    private boolean alwaysRun;
    private boolean runOnChange;
    private ContextExpression contexts;
    private Set<String> dbmsSet;
    private Boolean failOnError;
    private Set<CheckSum> validCheckSums = new HashSet<CheckSum>();
    private boolean runInTransaction;
    private ValidationFailOption onValidationFail = ValidationFailOption.HALT;
    private boolean validationFailed;
    private List<Change> rollBackChanges = new ArrayList<Change>();
    private String comments;
    private PreconditionContainer preconditions;
    private List<SqlVisitor> sqlVisitors = new ArrayList<SqlVisitor>();
    private ObjectQuotingStrategy objectQuotingStrategy;
    private DatabaseChangeLog changeLog;

    public boolean shouldAlwaysRun() {
        return this.alwaysRun;
    }

    public boolean shouldRunOnChange() {
        return this.runOnChange;
    }

    public ChangeSet(DatabaseChangeLog databaseChangeLog) {
        this.changes = new ArrayList<Change>();
        this.log = LogFactory.getLogger();
        this.changeLog = databaseChangeLog;
    }

    public ChangeSet(String id, String author, boolean alwaysRun, boolean runOnChange, String filePath, String contextList, String dbmsList, DatabaseChangeLog databaseChangeLog) {
        this(id, author, alwaysRun, runOnChange, filePath, contextList, dbmsList, true, ObjectQuotingStrategy.LEGACY, databaseChangeLog);
    }

    public ChangeSet(String id, String author, boolean alwaysRun, boolean runOnChange, String filePath, String contextList, String dbmsList, boolean runInTransaction, DatabaseChangeLog databaseChangeLog) {
        this(id, author, alwaysRun, runOnChange, filePath, contextList, dbmsList, runInTransaction, ObjectQuotingStrategy.LEGACY, databaseChangeLog);
    }

    public ChangeSet(String id, String author, boolean alwaysRun, boolean runOnChange, String filePath, String contextList, String dbmsList, ObjectQuotingStrategy quotingStrategy, DatabaseChangeLog databaseChangeLog) {
        this(id, author, alwaysRun, runOnChange, filePath, contextList, dbmsList, true, quotingStrategy, databaseChangeLog);
    }

    public ChangeSet(String id, String author, boolean alwaysRun, boolean runOnChange, String filePath, String contextList, String dbmsList, boolean runInTransaction, ObjectQuotingStrategy quotingStrategy, DatabaseChangeLog databaseChangeLog) {
        this(databaseChangeLog);
        this.id = id;
        this.author = author;
        this.filePath = filePath;
        this.alwaysRun = alwaysRun;
        this.runOnChange = runOnChange;
        this.runInTransaction = runInTransaction;
        this.objectQuotingStrategy = quotingStrategy;
        this.contexts = new ContextExpression(contextList);
        this.setDbms(dbmsList);
    }

    protected void setDbms(String dbmsList) {
        if (StringUtils.trimToNull(dbmsList) != null) {
            String[] strings = dbmsList.toLowerCase().split(",");
            this.dbmsSet = new HashSet<String>();
            for (String string : strings) {
                this.dbmsSet.add(string.trim().toLowerCase());
            }
        }
    }

    public String getFilePath() {
        return this.filePath;
    }

    public CheckSum generateCheckSum() {
        StringBuffer stringToMD5 = new StringBuffer();
        for (Change change : this.getChanges()) {
            stringToMD5.append(change.generateCheckSum()).append(":");
        }
        for (SqlVisitor visitor : this.getSqlVisitors()) {
            stringToMD5.append(visitor.generateCheckSum()).append(";");
        }
        return CheckSum.compute(stringToMD5.toString());
    }

    @Override
    public void load(ParsedNode node, ResourceAccessor resourceAccessor) throws ParsedNodeException {
        this.id = node.getChildValue((String)null, "id", String.class);
        this.author = node.getChildValue((String)null, "author", String.class);
        this.alwaysRun = node.getChildValue(null, "runAlways", node.getChildValue(null, "alwaysRun", false));
        this.runOnChange = node.getChildValue(null, "runOnChange", false);
        this.contexts = new ContextExpression(node.getChildValue((String)null, "context", String.class));
        this.setDbms(node.getChildValue((String)null, "dbms", String.class));
        this.runInTransaction = node.getChildValue(null, "runInTransaction", true);
        this.comments = StringUtils.join(node.getChildren(null, "comment"), "\n", new StringUtils.StringUtilsFormatter(){

            public String toString(Object obj) {
                if (((ParsedNode)obj).getValue() == null) {
                    return "";
                }
                return ((ParsedNode)obj).getValue().toString();
            }
        });
        this.comments = StringUtils.trimToNull(this.comments);
        String objectQuotingStrategyString = StringUtils.trimToNull(node.getChildValue((String)null, "objectQuotingStrategy", String.class));
        if (this.changeLog != null) {
            this.objectQuotingStrategy = this.changeLog.getObjectQuotingStrategy();
        }
        if (objectQuotingStrategyString != null) {
            this.objectQuotingStrategy = ObjectQuotingStrategy.valueOf(objectQuotingStrategyString);
        }
        if (this.objectQuotingStrategy == null) {
            this.objectQuotingStrategy = ObjectQuotingStrategy.LEGACY;
        }
        this.filePath = StringUtils.trimToNull(node.getChildValue((String)null, "logicalFilePath", String.class));
        if (this.filePath == null) {
            this.filePath = this.changeLog.getFilePath();
        }
        this.setFailOnError(node.getChildValue((String)null, "failOnError", Boolean.class));
        String onValidationFailString = node.getChildValue(null, "onValidationFail", "HALT");
        this.setOnValidationFail(ValidationFailOption.valueOf(onValidationFailString));
        for (ParsedNode child : node.getChildren()) {
            this.handleChildNode(child, resourceAccessor);
        }
    }

    protected void handleChildNode(ParsedNode child, ResourceAccessor resourceAccessor) throws ParsedNodeException {
        if (child.getName().equals("rollback")) {
            this.handleRollbackNode(child, resourceAccessor);
        } else if (child.getName().equals("validCheckSum") || child.getName().equals("validCheckSums")) {
            if (child.getValue() == null) {
                return;
            }
            if (child.getValue() instanceof Collection) {
                for (Object checksum : (Collection)child.getValue()) {
                    this.addValidCheckSum((String)checksum);
                }
            } else {
                this.addValidCheckSum(child.getValue(String.class));
            }
        } else if (child.getName().equals("modifySql")) {
            String dbmsString = StringUtils.trimToNull(child.getChildValue((String)null, "dbms", String.class));
            String contextString = StringUtils.trimToNull(child.getChildValue((String)null, "context", String.class));
            boolean applyToRollback = child.getChildValue(null, "applyToRollback", false);
            HashSet<String> dbms = new HashSet<String>();
            if (dbmsString != null) {
                dbms.addAll(StringUtils.splitAndTrim(dbmsString, ","));
            }
            ContextExpression context = null;
            if (contextString != null) {
                context = new ContextExpression(contextString);
            }
            List<ParsedNode> potentialVisitors = child.getChildren();
            for (ParsedNode node : potentialVisitors) {
                SqlVisitor sqlVisitor = SqlVisitorFactory.getInstance().create(node.getName());
                if (sqlVisitor == null) continue;
                sqlVisitor.setApplyToRollback(applyToRollback);
                if (dbms.size() > 0) {
                    sqlVisitor.setApplicableDbms(dbms);
                }
                sqlVisitor.setContexts(context);
                sqlVisitor.load(node, resourceAccessor);
                this.addSqlVisitor(sqlVisitor);
            }
        } else if (child.getName().equals("preConditions")) {
            this.preconditions = new PreconditionContainer();
            try {
                this.preconditions.load(child, resourceAccessor);
            }
            catch (ParsedNodeException e) {
                e.printStackTrace();
            }
        } else if (child.getName().equals("changes")) {
            for (ParsedNode changeNode : child.getChildren()) {
                this.handleChildNode(changeNode, resourceAccessor);
            }
        } else {
            this.addChange(this.toChange(child, resourceAccessor));
        }
    }

    protected void handleRollbackNode(ParsedNode rollbackNode, ResourceAccessor resourceAccessor) throws ParsedNodeException {
        String changeSetId = rollbackNode.getChildValue((String)null, "changeSetId", String.class);
        if (changeSetId != null) {
            String changeSetAuthor = rollbackNode.getChildValue((String)null, "changeSetAuthor", String.class);
            String changeSetPath = rollbackNode.getChildValue(null, "changeSetPath", this.getFilePath());
            ChangeSet changeSet = this.getChangeLog().getChangeSet(changeSetPath, changeSetAuthor, changeSetId);
            if (changeSet == null) {
                throw new ParsedNodeException("Change set " + new ChangeSet(changeSetId, changeSetAuthor, false, false, changeSetPath, null, null, null).toString(false) + " does not exist");
            }
            for (Change change : changeSet.getChanges()) {
                this.addRollbackChange(change);
            }
            return;
        }
        boolean foundValue = false;
        for (ParsedNode childNode : rollbackNode.getChildren()) {
            this.addRollbackChange(this.toChange(childNode, resourceAccessor));
            foundValue = true;
        }
        Object value = rollbackNode.getValue();
        if (value != null) {
            if (value instanceof String) {
                String finalValue = StringUtils.trimToNull((String)value);
                if (finalValue != null) {
                    String[] strings;
                    for (String string : strings = StringUtils.processMutliLineSQL(finalValue, true, true, ";")) {
                        this.addRollbackChange(new RawSQLChange(string));
                        foundValue = true;
                    }
                }
            } else {
                throw new ParsedNodeException("Unexpected object: " + value.getClass().getName() + " '" + value.toString() + "'");
            }
        }
        if (!foundValue) {
            this.addRollbackChange(new EmptyChange());
        }
    }

    protected Change toChange(ParsedNode value, ResourceAccessor resourceAccessor) throws ParsedNodeException {
        Change change = ChangeFactory.getInstance().create(value.getName());
        if (change == null) {
            return null;
        }
        try {
            change.load(value, resourceAccessor);
        }
        catch (ParsedNodeException e) {
            e.printStackTrace();
        }
        return change;
    }

    @Override
    public ParsedNode serialize() {
        throw new RuntimeException("TODO");
    }

    public ExecType execute(DatabaseChangeLog databaseChangeLog, Database database) throws MigrationFailedException {
        return this.execute(databaseChangeLog, null, database);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecType execute(DatabaseChangeLog databaseChangeLog, ChangeExecListener listener, Database database) throws MigrationFailedException {
        ExecType execType;
        block54: {
            if (this.validationFailed) {
                return ExecType.MARK_RAN;
            }
            long startTime = new Date().getTime();
            execType = null;
            boolean skipChange = false;
            Executor executor = ExecutorService.getInstance().getExecutor(database);
            try {
                block53: {
                    StringBuffer message;
                    database.setObjectQuotingStrategy(this.objectQuotingStrategy);
                    if (database.supportsDDLInTransaction()) {
                        database.setAutoCommit(!this.runInTransaction);
                    }
                    executor.comment("Changeset " + this.toString(false));
                    if (StringUtils.trimToNull(this.getComments()) != null) {
                        String comments = this.getComments();
                        String[] lines = comments.split("\\n");
                        for (int i = 0; i < lines.length; ++i) {
                            if (i <= 0) continue;
                            lines[i] = database.getLineComment() + " " + lines[i];
                        }
                        executor.comment(StringUtils.join(Arrays.asList(lines), "\n"));
                    }
                    try {
                        if (this.preconditions != null) {
                            this.preconditions.check(database, databaseChangeLog, this);
                        }
                    }
                    catch (PreconditionFailedException e) {
                        if (listener != null) {
                            listener.preconditionFailed(e, this.preconditions.getOnFail());
                        }
                        message = new StringBuffer();
                        message.append(StreamUtil.getLineSeparator());
                        for (FailedPrecondition failedPrecondition : e.getFailedPreconditions()) {
                            message.append("          ").append(failedPrecondition.toString());
                            message.append(StreamUtil.getLineSeparator());
                        }
                        if (this.preconditions.getOnFail().equals((Object)PreconditionContainer.FailOption.HALT)) {
                            throw new MigrationFailedException(this, message.toString(), e);
                        }
                        if (this.preconditions.getOnFail().equals((Object)PreconditionContainer.FailOption.CONTINUE)) {
                            skipChange = true;
                            execType = ExecType.SKIPPED;
                            LogFactory.getLogger().info("Continuing past: " + this.toString() + " despite precondition failure due to onFail='CONTINUE': " + message);
                            break block53;
                        }
                        if (this.preconditions.getOnFail().equals((Object)PreconditionContainer.FailOption.MARK_RAN)) {
                            execType = ExecType.MARK_RAN;
                            skipChange = true;
                            this.log.info("Marking ChangeSet: " + this.toString() + " ran despite precondition failure due to onFail='MARK_RAN': " + message);
                            break block53;
                        }
                        if (this.preconditions.getOnFail().equals((Object)PreconditionContainer.FailOption.WARN)) {
                            execType = null;
                            break block53;
                        }
                        throw new UnexpectedLiquibaseException("Unexpected precondition onFail attribute: " + (Object)((Object)this.preconditions.getOnFail()), e);
                    }
                    catch (PreconditionErrorException e) {
                        if (listener != null) {
                            listener.preconditionErrored(e, this.preconditions.getOnError());
                        }
                        message = new StringBuffer();
                        message.append(StreamUtil.getLineSeparator());
                        for (ErrorPrecondition errorPrecondition : e.getErrorPreconditions()) {
                            message.append("          ").append(errorPrecondition.toString());
                            message.append(StreamUtil.getLineSeparator());
                        }
                        if (this.preconditions.getOnError().equals((Object)PreconditionContainer.ErrorOption.HALT)) {
                            throw new MigrationFailedException(this, message.toString(), e);
                        }
                        if (this.preconditions.getOnError().equals((Object)PreconditionContainer.ErrorOption.CONTINUE)) {
                            skipChange = true;
                            execType = ExecType.SKIPPED;
                        } else if (this.preconditions.getOnError().equals((Object)PreconditionContainer.ErrorOption.MARK_RAN)) {
                            execType = ExecType.MARK_RAN;
                            skipChange = true;
                            this.log.info("Marking ChangeSet: " + this.toString() + " ran despite precondition error: " + message);
                        } else if (this.preconditions.getOnError().equals((Object)PreconditionContainer.ErrorOption.WARN)) {
                            execType = null;
                        } else {
                            throw new UnexpectedLiquibaseException("Unexpected precondition onError attribute: " + (Object)((Object)this.preconditions.getOnError()), e);
                        }
                        database.rollback();
                    }
                    finally {
                        database.rollback();
                    }
                }
                if (!skipChange) {
                    for (Change change : this.changes) {
                        try {
                            change.finishInitialization();
                        }
                        catch (SetupException se) {
                            throw new MigrationFailedException(this, (Throwable)se);
                        }
                    }
                    this.log.debug("Reading ChangeSet: " + this.toString());
                    for (Change change : this.getChanges()) {
                        if (!(change instanceof DbmsTargetedChange) || DatabaseList.definitionMatches(((DbmsTargetedChange)((Object)change)).getDbms(), database, true)) {
                            if (listener != null) {
                                listener.willRun(change, this, this.changeLog, database);
                            }
                            database.executeStatements(change, databaseChangeLog, this.sqlVisitors);
                            this.log.info(change.getConfirmationMessage());
                            if (listener == null) continue;
                            listener.ran(change, this, this.changeLog, database);
                            continue;
                        }
                        this.log.debug("Change " + change.getSerializedObjectName() + " not included for database " + database.getShortName());
                    }
                    if (this.runInTransaction) {
                        database.commit();
                    }
                    this.log.info("ChangeSet " + this.toString(false) + " ran successfully in " + (new Date().getTime() - startTime) + "ms");
                    if (execType == null) {
                        execType = ExecType.EXECUTED;
                    }
                } else {
                    this.log.debug("Skipping ChangeSet: " + this.toString());
                }
            }
            catch (Exception e) {
                try {
                    database.rollback();
                }
                catch (Exception e1) {
                    throw new MigrationFailedException(this, (Throwable)e);
                }
                if (this.getFailOnError() != null && !this.getFailOnError().booleanValue()) {
                    this.log.info("Change set " + this.toString(false) + " failed, but failOnError was false.  Error: " + e.getMessage());
                    this.log.debug("Failure Stacktrace", e);
                    execType = ExecType.FAILED;
                    break block54;
                }
                this.log.severe("Change Set " + this.toString(false) + " failed.  Error: " + e.getMessage(), e);
                if (e instanceof MigrationFailedException) {
                    throw (MigrationFailedException)e;
                }
                throw new MigrationFailedException(this, (Throwable)e);
            }
            finally {
                if (!this.runInTransaction && database.supportsDDLInTransaction()) {
                    try {
                        database.setAutoCommit(false);
                    }
                    catch (DatabaseException e) {
                        throw new MigrationFailedException(this, "Could not resetInternalState autocommit", e);
                    }
                }
            }
        }
        return execType;
    }

    public void rollback(Database database) throws RollbackFailedException {
        try {
            Executor executor = ExecutorService.getInstance().getExecutor(database);
            executor.comment("Rolling Back ChangeSet: " + this.toString());
            if (database.supportsDDLInTransaction()) {
                database.setAutoCommit(!this.runInTransaction);
            }
            RanChangeSet ranChangeSet = database.getRanChangeSet(this);
            if (this.rollBackChanges != null && this.rollBackChanges.size() > 0) {
                for (Change rollback : this.rollBackChanges) {
                    SqlStatement[] statements;
                    if (rollback instanceof DbmsTargetedChange && !DatabaseList.definitionMatches(((DbmsTargetedChange)((Object)rollback)).getDbms(), database, true) || (statements = rollback.generateStatements(database)) == null) continue;
                    for (SqlStatement statement : statements) {
                        try {
                            executor.execute(statement, this.sqlVisitors);
                        }
                        catch (DatabaseException e) {
                            throw new RollbackFailedException("Error executing custom SQL [" + statement + "]", e);
                        }
                    }
                }
            } else {
                List<Change> changes = this.getChanges();
                for (int i = changes.size() - 1; i >= 0; --i) {
                    Change change = changes.get(i);
                    database.executeRollbackStatements(change, this.sqlVisitors);
                }
            }
            if (this.runInTransaction) {
                database.commit();
            }
            this.log.debug("ChangeSet " + this.toString() + " has been successfully rolled back.");
        }
        catch (Exception e) {
            try {
                database.rollback();
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
            throw new RollbackFailedException(e);
        }
        finally {
            if (!this.runInTransaction && database.supportsDDLInTransaction()) {
                try {
                    database.setAutoCommit(false);
                }
                catch (DatabaseException e) {
                    throw new RollbackFailedException("Could not resetInternalState autocommit", e);
                }
            }
        }
    }

    public List<Change> getChanges() {
        return Collections.unmodifiableList(this.changes);
    }

    public void addChange(Change change) {
        if (change == null) {
            return;
        }
        this.changes.add(change);
        change.setChangeSet(this);
    }

    public String getId() {
        return this.id;
    }

    public String getAuthor() {
        return this.author;
    }

    public ContextExpression getContexts() {
        return this.contexts;
    }

    public Set<String> getDbmsSet() {
        return this.dbmsSet;
    }

    public DatabaseChangeLog getChangeLog() {
        return this.changeLog;
    }

    public String toString(boolean includeMD5Sum) {
        return this.filePath + "::" + this.getId() + "::" + this.getAuthor() + (includeMD5Sum ? "::(Checksum: " + this.generateCheckSum() + ")" : "");
    }

    public String toString() {
        return this.toString(false);
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public boolean isAlwaysRun() {
        return this.alwaysRun;
    }

    public boolean isRunOnChange() {
        return this.runOnChange;
    }

    public boolean isRunInTransaction() {
        return this.runInTransaction;
    }

    public Change[] getRollBackChanges() {
        return this.rollBackChanges.toArray(new Change[this.rollBackChanges.size()]);
    }

    public void addRollBackSQL(String sql) {
        if (StringUtils.trimToNull(sql) == null) {
            if (this.rollBackChanges.size() == 0) {
                this.rollBackChanges.add(new EmptyChange());
            }
            return;
        }
        for (String statment : StringUtils.splitSQL(sql, null)) {
            this.rollBackChanges.add(new RawSQLChange(statment.trim()));
        }
    }

    public void addRollbackChange(Change change) {
        if (change == null) {
            return;
        }
        this.rollBackChanges.add(change);
        change.setChangeSet(this);
    }

    public boolean supportsRollback(Database database) {
        if (this.rollBackChanges != null && this.rollBackChanges.size() > 0) {
            return true;
        }
        for (Change change : this.getChanges()) {
            if (change.supportsRollback(database)) continue;
            return false;
        }
        return true;
    }

    public String getDescription() {
        List<Change> changes = this.getChanges();
        if (changes.size() == 0) {
            return "Empty";
        }
        StringBuffer returnString = new StringBuffer();
        Class<?> lastChangeClass = null;
        int changeCount = 0;
        for (Change change : changes) {
            if (change.getClass().equals(lastChangeClass)) {
                ++changeCount;
            } else if (changeCount > 1) {
                returnString.append(" (x").append(changeCount).append(")");
                returnString.append(", ");
                returnString.append(ChangeFactory.getInstance().getChangeMetaData(change).getName());
                changeCount = 1;
            } else {
                returnString.append(", ").append(ChangeFactory.getInstance().getChangeMetaData(change).getName());
                changeCount = 1;
            }
            lastChangeClass = change.getClass();
        }
        if (changeCount > 1) {
            returnString.append(" (x").append(changeCount).append(")");
        }
        return returnString.toString().replaceFirst("^, ", "");
    }

    public Boolean getFailOnError() {
        return this.failOnError;
    }

    public void setFailOnError(Boolean failOnError) {
        this.failOnError = failOnError;
    }

    public ValidationFailOption getOnValidationFail() {
        return this.onValidationFail;
    }

    public void setOnValidationFail(ValidationFailOption onValidationFail) {
        this.onValidationFail = onValidationFail;
    }

    public void setValidationFailed(boolean validationFailed) {
        this.validationFailed = validationFailed;
    }

    public void addValidCheckSum(String text) {
        this.validCheckSums.add(CheckSum.parse(text));
    }

    public Set<CheckSum> getValidCheckSums() {
        return Collections.unmodifiableSet(this.validCheckSums);
    }

    public boolean isCheckSumValid(CheckSum storedCheckSum) {
        for (CheckSum validCheckSum : this.validCheckSums) {
            if (!validCheckSum.toString().equalsIgnoreCase("1:any")) continue;
            return true;
        }
        CheckSum currentMd5Sum = this.generateCheckSum();
        if (currentMd5Sum == null) {
            return true;
        }
        if (storedCheckSum == null) {
            return true;
        }
        if (currentMd5Sum.equals(storedCheckSum)) {
            return true;
        }
        for (CheckSum validCheckSum : this.validCheckSums) {
            if (!currentMd5Sum.equals(validCheckSum)) continue;
            return true;
        }
        return false;
    }

    @Override
    public PreconditionContainer getPreconditions() {
        return this.preconditions;
    }

    @Override
    public void setPreconditions(PreconditionContainer preconditionContainer) {
        this.preconditions = preconditionContainer;
    }

    public void addSqlVisitor(SqlVisitor sqlVisitor) {
        this.sqlVisitors.add(sqlVisitor);
    }

    public List<SqlVisitor> getSqlVisitors() {
        return this.sqlVisitors;
    }

    public ChangeLogParameters getChangeLogParameters() {
        return this.changeLogParameters;
    }

    public void setChangeLogParameters(ChangeLogParameters changeLogParameters) {
        this.changeLogParameters = changeLogParameters;
    }

    public ObjectQuotingStrategy getObjectQuotingStrategy() {
        return this.objectQuotingStrategy;
    }

    @Override
    public String getSerializedObjectName() {
        return "changeSet";
    }

    @Override
    public Set<String> getSerializableFields() {
        return new HashSet<String>(Arrays.asList("id", "author", "runAlways", "runOnChange", "failOnError", "context", "dbms", "comment", "changes", "rollback"));
    }

    @Override
    public Object getSerializableFieldValue(String field) {
        if (field.equals("id")) {
            return this.getId();
        }
        if (field.equals("author")) {
            return this.getAuthor();
        }
        if (field.equals("runAlways")) {
            if (this.isAlwaysRun()) {
                return true;
            }
            return null;
        }
        if (field.equals("runOnChange")) {
            if (this.isRunOnChange()) {
                return true;
            }
            return null;
        }
        if (field.equals("failOnError")) {
            return this.getFailOnError();
        }
        if (field.equals("context")) {
            if (!this.getContexts().isEmpty()) {
                return this.getContexts().toString();
            }
            return null;
        }
        if (field.equals("dbms")) {
            if (this.getDbmsSet() != null && this.getDbmsSet().size() > 0) {
                StringBuffer dbmsString = new StringBuffer();
                for (String dbms : this.getDbmsSet()) {
                    dbmsString.append(dbms).append(",");
                }
                return dbmsString.toString().replaceFirst(",$", "");
            }
            return null;
        }
        if (field.equals("comment")) {
            return StringUtils.trimToNull(this.getComments());
        }
        if (field.equals("changes")) {
            return this.getChanges();
        }
        if (field.equals("rollback")) {
            if (this.getRollBackChanges() != null && this.getRollBackChanges().length > 0) {
                return this.getRollBackChanges();
            }
            return null;
        }
        throw new UnexpectedLiquibaseException("Unexpected field request on changeSet: " + field);
    }

    @Override
    public LiquibaseSerializable.SerializationType getSerializableFieldType(String field) {
        if (field.equals("comment") || field.equals("changes") || field.equals("rollback")) {
            return LiquibaseSerializable.SerializationType.NESTED_OBJECT;
        }
        return LiquibaseSerializable.SerializationType.NAMED_FIELD;
    }

    @Override
    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/dbchangelog";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ChangeSet)) {
            return false;
        }
        return this.toString(false).equals(((ChangeSet)obj).toString(false));
    }

    public int hashCode() {
        return this.toString(false).hashCode();
    }

    public static enum ValidationFailOption {
        HALT("HALT"),
        MARK_RAN("MARK_RAN");

        String key;

        private ValidationFailOption(String key) {
            this.key = key;
        }

        public String toString() {
            return this.key;
        }
    }

    public static enum ExecType {
        EXECUTED("EXECUTED", false, true),
        FAILED("FAILED", false, false),
        SKIPPED("SKIPPED", false, false),
        RERAN("RERAN", true, true),
        MARK_RAN("MARK_RAN", false, true);

        public final String value;
        public final boolean ranBefore;
        public final boolean ran;

        private ExecType(String value, boolean ranBefore, boolean ran) {
            this.value = value;
            this.ranBefore = ranBefore;
            this.ran = ran;
        }
    }

    public static enum RunStatus {
        NOT_RAN,
        ALREADY_RAN,
        RUN_AGAIN,
        MARK_RAN,
        INVALID_MD5SUM;

    }
}

