/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.sql;

import liquibase.database.CacheDatabase;
import liquibase.database.DB2Database;
import liquibase.database.Database;
import liquibase.database.DerbyDatabase;
import liquibase.database.FirebirdDatabase;
import liquibase.database.HsqlDatabase;
import liquibase.database.MSSQLDatabase;
import liquibase.database.MaxDBDatabase;
import liquibase.database.MySQLDatabase;
import liquibase.database.SQLiteDatabase;
import liquibase.database.sql.SqlStatement;
import liquibase.exception.StatementNotSupportedOnDatabaseException;

public class RenameColumnStatement
implements SqlStatement {
    private String schemaName;
    private String tableName;
    private String oldColumnName;
    private String newColumnName;
    private String columnDataType;

    public RenameColumnStatement(String schemaName, String tableName, String oldColumnName, String newColumnName, String columnDataType) {
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.oldColumnName = oldColumnName;
        this.newColumnName = newColumnName;
        this.columnDataType = columnDataType;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getOldColumnName() {
        return this.oldColumnName;
    }

    public void setOldColumnName(String oldColumnName) {
        this.oldColumnName = oldColumnName;
    }

    public String getNewColumnName() {
        return this.newColumnName;
    }

    public void setNewColumnName(String newColumnName) {
        this.newColumnName = newColumnName;
    }

    public String getColumnDataType() {
        return this.columnDataType;
    }

    public void setColumnDataType(String columnDataType) {
        this.columnDataType = columnDataType;
    }

    public String getSqlStatement(Database database) throws StatementNotSupportedOnDatabaseException {
        if (!this.supportsDatabase(database)) {
            throw new StatementNotSupportedOnDatabaseException(this, database);
        }
        if (database instanceof MSSQLDatabase) {
            return "exec sp_rename '" + database.escapeTableName(this.getSchemaName(), this.getTableName()) + "." + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getOldColumnName()) + "', '" + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getNewColumnName()) + "'";
        }
        if (database instanceof MySQLDatabase) {
            if (this.getColumnDataType() == null) {
                throw new StatementNotSupportedOnDatabaseException("columnDataType is required to rename columns", this, database);
            }
            return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " CHANGE " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getOldColumnName()) + " " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getNewColumnName()) + " " + this.getColumnDataType();
        }
        if (database instanceof HsqlDatabase) {
            return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " ALTER COLUMN " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getOldColumnName()) + " RENAME TO " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getNewColumnName());
        }
        if (database instanceof FirebirdDatabase) {
            return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " ALTER COLUMN " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getOldColumnName()) + " TO " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getNewColumnName());
        }
        if (database instanceof MaxDBDatabase || database instanceof DerbyDatabase) {
            return "RENAME COLUMN " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + "." + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getOldColumnName()) + " TO " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getNewColumnName());
        }
        return "ALTER TABLE " + database.escapeTableName(this.getSchemaName(), this.getTableName()) + " RENAME COLUMN " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getOldColumnName()) + " TO " + database.escapeColumnName(this.getSchemaName(), this.getTableName(), this.getNewColumnName());
    }

    public String getEndDelimiter(Database database) {
        return ";";
    }

    public boolean supportsDatabase(Database database) {
        return !(database instanceof DB2Database) && !(database instanceof CacheDatabase) && !(database instanceof SQLiteDatabase);
    }
}

