/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.update;

import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ParenthesedExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.schema.Column;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Select;

public class UpdateSet
implements Serializable {
    protected ExpressionList<Column> columns = new ExpressionList((Expression[])new Column[0]);
    protected ExpressionList<Expression> values = new ExpressionList(new Expression[0]);

    public UpdateSet() {
    }

    public UpdateSet(Column column) {
        this.columns.add(column);
    }

    public UpdateSet(Column column, Expression value) {
        this.columns.add(column);
        this.values.add(value);
    }

    public ExpressionList<Column> getColumns() {
        return this.columns;
    }

    public Column getColumn(int index) {
        return (Column)this.columns.get(index);
    }

    public void setColumns(ExpressionList<Column> columns) {
        this.columns = Objects.requireNonNull(columns);
    }

    public ExpressionList<?> getValues() {
        return this.values;
    }

    public Expression getValue(int index) {
        return (Expression)this.values.get(index);
    }

    public void setValues(ExpressionList values) {
        this.values = Objects.requireNonNull(values);
    }

    public void add(Column column, Expression value) {
        this.add(column);
        this.add(value);
    }

    public void add(Column column) {
        if (this.columns.size() < 2 && !(this.columns instanceof ParenthesedExpressionList)) {
            this.columns = new ParenthesedExpressionList<Column>(this.columns);
        }
        this.columns.add(column);
    }

    public void add(Expression expression) {
        if (this.values.size() < 2 && !(this.values instanceof ParenthesedExpressionList)) {
            this.values = new ParenthesedExpressionList<Expression>(this.values);
        }
        this.values.add(expression);
    }

    public void add(ExpressionList<?> expressionList) {
        this.values.addAll(expressionList);
    }

    public static final StringBuilder appendUpdateSetsTo(StringBuilder builder, Collection<UpdateSet> updateSets) {
        int j = 0;
        for (UpdateSet updateSet : updateSets) {
            updateSet.appendTo(builder, j);
            ++j;
        }
        return builder;
    }

    StringBuilder appendTo(StringBuilder builder, int j) {
        if (j > 0) {
            builder.append(", ");
        }
        builder.append(Select.getStringList(this.columns, true, this.columns instanceof ParenthesedExpressionList));
        builder.append(" = ");
        builder.append(Select.getStringList(this.values, true, this.values instanceof ParenthesedExpressionList));
        return builder;
    }
}

