/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.com.github.mustachejava.reflect.guards;

import java.util.List;
import liquibase.repackaged.com.github.mustachejava.ObjectHandler;
import liquibase.repackaged.com.github.mustachejava.reflect.Guard;
import liquibase.repackaged.com.github.mustachejava.reflect.ReflectionObjectHandler;
import liquibase.repackaged.com.github.mustachejava.util.Wrapper;

public class WrappedGuard
implements Guard {
    private static final Wrapper[] EMPTY_WRAPPERS = new Wrapper[0];
    protected final ObjectHandler oh;
    protected final int index;
    protected final Wrapper[] wrappers;
    private final List<Guard> wrapperGuard;

    public WrappedGuard(ObjectHandler oh, int index, List<Wrapper> wrappers, List<Guard> wrapperGuard) {
        this.oh = oh;
        this.index = index;
        this.wrappers = wrappers.toArray(EMPTY_WRAPPERS);
        this.wrapperGuard = wrapperGuard;
    }

    @Override
    public boolean apply(List<Object> objects) {
        Object scope = ReflectionObjectHandler.unwrap(this.oh, this.index, this.wrappers, objects);
        for (Guard predicate : this.wrapperGuard) {
            if (predicate.apply(ObjectHandler.makeList(scope))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "[WrappedGuard: " + this.index + " " + this.wrapperGuard + "]";
    }
}

