/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.databasepackage.change;

import com.datical.liquibase.ext.storedlogic.databasepackage.change.CreatePackageStatement;
import java.util.ArrayList;
import liquibase.database.Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.sqlgenerator.core.CreateProcedureGenerator;
import liquibase.structure.DatabaseObject;

public class CreatePackageGenerator
extends AbstractSqlGenerator<CreatePackageStatement> {
    public int getPriority() {
        return 6;
    }

    public ValidationErrors validate(CreatePackageStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("packageName", (Object)statement.getPackageName());
        validationErrors.checkRequiredField("packageText", (Object)statement.getPackageText());
        return validationErrors;
    }

    public Sql[] generateSql(CreatePackageStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        String endDelimiter = ";";
        if (database instanceof OracleDatabase) {
            endDelimiter = "\n/";
        } else if (database instanceof DB2Database) {
            endDelimiter = "";
        }
        ArrayList<UnparsedSql> sql = new ArrayList<UnparsedSql>();
        sql.add(new UnparsedSql(CreateProcedureGenerator.addSchemaToText((String)CreateProcedureGenerator.removeTrailingDelimiter((String)statement.getPackageText(), (String)endDelimiter), (String)statement.getSchemaName(), (String)"PACKAGE", (Database)database), endDelimiter, new DatabaseObject[0]));
        CreateProcedureGenerator.surroundWithSchemaSets(sql, (String)statement.getSchemaName(), (Database)database);
        return sql.toArray(new Sql[sql.size()]);
    }
}

