/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.parser;

import liquibase.Scope;
import liquibase.util.StandardSqlParser;
import liquibase.util.StringClauses;

public class ExceptionSwallowingSqlParser
extends StandardSqlParser {
    private boolean printedCommentRemovalWarning = false;
    private int priority = -1;

    public StringClauses parse(String sqlBlock) {
        try {
            return super.parse(sqlBlock);
        }
        catch (Throwable e) {
            return this.handleException(e, sqlBlock);
        }
    }

    public StringClauses parse(String sqlBlock, boolean preserveWhitespace, boolean preserveComments) {
        try {
            return super.parse(sqlBlock, preserveWhitespace, preserveComments);
        }
        catch (Throwable e) {
            return this.handleException(e, sqlBlock);
        }
    }

    private StringClauses handleException(Throwable e, String sql) {
        if (!this.printedCommentRemovalWarning) {
            String message = "WARNING: Liquibase was unable to remove comments from a changeset; quality checks will be run without removing comments.";
            Scope.getCurrentScope().getUI().sendMessage(message);
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning(message, e);
            this.printedCommentRemovalWarning = true;
        }
        StringClauses stringClauses = new StringClauses();
        stringClauses.append(sql);
        return stringClauses;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }
}

