/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.config;

import liquibase.configuration.AutoloadedConfigurations;
import liquibase.configuration.ConfigurationDefinition;

public class SqlcmdConfiguration
implements AutoloadedConfigurations {
    public static final ConfigurationDefinition<String> PATH;
    public static final ConfigurationDefinition<Integer> TIMEOUT;
    public static final ConfigurationDefinition<Boolean> TEMP_KEEP;
    public static final ConfigurationDefinition<String> ARGS;
    public static final ConfigurationDefinition<String> TEMP_NAME;
    public static final ConfigurationDefinition<String> TEMP_PATH;
    public static final ConfigurationDefinition<Boolean> TEMP_OVERWRITE;
    public static final ConfigurationDefinition<String> LOG_FILE;
    public static final ConfigurationDefinition<String> CATALOG_NAME;

    static {
        ConfigurationDefinition.Builder builder = new ConfigurationDefinition.Builder("liquibase.sqlcmd");
        PATH = builder.define("path", String.class).setDescription("Path to sqlcmd executable").build();
        TIMEOUT = builder.define("timeout", Integer.class).setDescription("Seconds to wait for sqlcmd timeout").build();
        TEMP_KEEP = builder.define("keep.temp", Boolean.class).setDescription("If true, do not delete temporary sql files generated").build();
        TEMP_NAME = builder.define("keep.temp.name", String.class).setDescription("Optionally, specify a custom filename").build();
        TEMP_PATH = builder.define("keep.temp.path", String.class).setDescription("Optionally, specify the path in which to store the temporary files. If not specified, the files will be stored in the system's temp directory.").build();
        TEMP_OVERWRITE = builder.define("keep.temp.overwrite", Boolean.class).setDescription("If true, overwrite any files in the specified directory with the same name").build();
        LOG_FILE = builder.define("logFile", String.class).setDescription("Log file for SQLCMD output").build();
        ARGS = builder.define("args", String.class).setDescription("Extra arguments which will be passed to the sqlcmd executable").build();
        CATALOG_NAME = builder.define("catalogName", String.class).setDescription("Database to use when running SQLCMD").build();
    }

    public static class ConfigurationKeys {
        public static final String BASE = "liquibase.sqlcmd";
        public static final String KEEP_TEMP_BASE = "keep.temp";
        public static final String KEEP_TEMP_NAME = "keep.temp.name";
        public static final String KEEP_TEMP_PATH = "keep.temp.path";
        public static final String KEEP_TEMP_OVERWRITE = "keep.temp.overwrite";
        public static final String LOG_FILE = "logFile";
        public static final String CATALOG_NAME = "catalogName";

        public static String getFullKey(String keyName) {
            return "liquibase.sqlcmd." + keyName;
        }
    }
}

