/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.checks.config.CheckSettingsConfigHelper;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfig;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.command.checks.AbstractChecksCommandStep;
import com.datical.liquibase.ext.command.checks.ChecksShowCommandStep;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.LiquibaseException;

public class ChecksResetCommandStep
extends AbstractChecksCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"checks", "reset"};
    public static final CommandArgumentDefinition<String> CHECK_NAME_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_SETTINGS_FILE_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_AUTO_UPDATE_ARG;

    public final void run(CommandResultsBuilder resultsBuilder) throws Exception {
        CommandScope commandScope = resultsBuilder.getCommandScope();
        String checksSettingsFile = (String)commandScope.getConfiguredValue(CHECKS_SETTINGS_FILE_ARG).getValue();
        ChecksResetCommandStep.checkFileArgExistence(checksSettingsFile, "checks settings");
        String checkName = (String)commandScope.getConfiguredValue(CHECK_NAME_ARG).getValue();
        List<AbstractLiquibaseRule> rules = ChecksResetCommandStep.listAllRules();
        String autoUpdate = (String)commandScope.getConfiguredValue(CHECKS_AUTO_UPDATE_ARG).getValue();
        CheckSettingsConfigHelper helper = new CheckSettingsConfigHelper(checksSettingsFile, autoUpdate);
        CheckSettingsConfig csc = helper.read(rules);
        this.throwExceptionIfPackageFile(csc);
        if (csc == null) {
            resultsBuilder.addResult("statusCode", (Object)0);
            return;
        }
        Optional<AbstractLiquibaseRule> optRule = rules.stream().filter(r -> r.getShortName().equalsIgnoreCase(checkName)).findFirst();
        if (optRule.isPresent() && !optRule.get().isConfigurable()) {
            if (this.resetBasicRule(checkName, helper, csc, optRule.get())) {
                ChecksShowCommandStep.writeTableToOutput(resultsBuilder, csc, false);
            }
            resultsBuilder.addResult("statusCode", (Object)0);
            return;
        }
        DynamicRule configurableRule = csc.getDynamicConfigurableRuleByShortName(checkName, "has not been customized and is not a copy. It cannot be reset");
        AbstractLiquibaseRule parentRule = ChecksResetCommandStep.findConfigurableParentRule(configurableRule, rules, checkName, "does not have customization options");
        if (!parentRule.hasDefaultParameterValues() && !configurableRule.isCopy()) {
            throw new CommandExecutionException("This check can not be reset because it is not a copy of a check or has no customization options.");
        }
        if (!parentRule.hasDefaultParameterValues() && configurableRule.isCopy()) {
            throw new CommandExecutionException("This check can not be reset because the check from which it was copied does not include default values for one or more fields.  If you no longer need to run this check delete it or disable it.");
        }
        Scope.getCurrentScope().getUI().sendMessage(System.lineSeparator() + "Resetting check with short name '" + configurableRule.getShortName() + "' to original configuration of its base check '" + parentRule.getShortName() + "'");
        List<RuleParameter<?>> parameters = parentRule.getParameters();
        ArrayList<DynamicRuleParameter> newParameterValues = new ArrayList<DynamicRuleParameter>(parameters.size());
        for (RuleParameter<?> ruleParameter : parameters) {
            newParameterValues.add(new DynamicRuleParameter(ruleParameter.getParameter(), ruleParameter.getDefaultValue()));
        }
        StringBuilder currentCustomizationSettings = new StringBuilder(System.lineSeparator() + "Current Customization Settings" + System.lineSeparator());
        currentCustomizationSettings.append("Severity = ").append((Object)configurableRule.getSeverity());
        for (DynamicRuleParameter dynamicRuleParameter : configurableRule.getParameters()) {
            currentCustomizationSettings.append("  ");
            currentCustomizationSettings.append(dynamicRuleParameter.getParameterAsEnum().toString());
            currentCustomizationSettings.append(" = '");
            currentCustomizationSettings.append(dynamicRuleParameter.getValue());
            currentCustomizationSettings.append("'");
            currentCustomizationSettings.append(System.lineSeparator());
        }
        Scope.getCurrentScope().getUI().sendMessage(currentCustomizationSettings.toString());
        StringBuilder stringBuilder = new StringBuilder("Default Settings" + System.lineSeparator());
        stringBuilder.append("Severity = ").append((Object)SeverityEnum.INFO);
        for (RuleParameter<?> ruleParameter : parameters) {
            stringBuilder.append("  ");
            stringBuilder.append(ruleParameter.toString());
            stringBuilder.append(" = '");
            stringBuilder.append(ruleParameter.getDefaultValue());
            stringBuilder.append("'");
            stringBuilder.append(System.lineSeparator());
        }
        Scope.getCurrentScope().getUI().sendMessage(stringBuilder.toString());
        String string = this.getShouldReset(checkName);
        if (string != null && string.equalsIgnoreCase("y")) {
            configurableRule.setSeverity(SeverityEnum.INFO);
            configurableRule.getParameters().clear();
            configurableRule.getParameters().addAll(newParameterValues);
            helper.write(csc);
            Scope.getCurrentScope().getUI().sendMessage("Reset complete. Review the table below to confirm your changes.");
        } else {
            Scope.getCurrentScope().getUI().sendMessage("No changes have been made to check configuration.");
        }
        ChecksShowCommandStep.writeTableToOutput(resultsBuilder, csc, false);
        Scope.getCurrentScope().getUI().sendMessage(System.lineSeparator() + "TIP" + System.lineSeparator() + "  Test your changes by running checks against your changelog with 'liquibase checks run'" + System.lineSeparator());
        csc.outputWarningMessage();
        resultsBuilder.addResult("statusCode", (Object)0);
    }

    private boolean resetBasicRule(String checkName, CheckSettingsConfigHelper helper, CheckSettingsConfig csc, AbstractLiquibaseRule rule) throws IOException, LiquibaseException {
        Scope.getCurrentScope().getUI().sendMessage(System.lineSeparator() + "Resetting check with short name '" + rule.getShortName() + "' to original configuration of its base check '");
        AbstractConfigurableRule ruleToModify = csc.getRuleById(rule.getId());
        if (ruleToModify == null) {
            throw new CommandExecutionException("Unable to locate check to modify '" + rule.getShortName() + "' in configuration settings.");
        }
        Scope.getCurrentScope().getUI().sendMessage(System.lineSeparator() + "Current Customization Settings" + System.lineSeparator());
        Scope.getCurrentScope().getUI().sendMessage("Severity = " + (Object)((Object)ruleToModify.getSeverity()));
        Scope.getCurrentScope().getUI().sendMessage("Default severity = " + (Object)((Object)SeverityEnum.INFO));
        String shouldReset = this.getShouldReset(checkName);
        if (shouldReset == null || !shouldReset.equalsIgnoreCase("y")) {
            Scope.getCurrentScope().getUI().sendMessage("No changes have been made to check configuration.");
            return false;
        }
        ruleToModify.setSeverity(SeverityEnum.INFO);
        helper.write(csc);
        Scope.getCurrentScope().getUI().sendMessage("Reset complete. Review the table below to confirm your changes.");
        return true;
    }

    private String getShouldReset(String checkName) {
        return (String)Scope.getCurrentScope().getUI().prompt("Would you like to set '" + checkName + "' to it's default settings? (Y/n)", (Object)"Y", (input, type) -> {
            if (input == null || !input.equalsIgnoreCase("y") && !input.equalsIgnoreCase("n")) {
                throw new IllegalArgumentException();
            }
            return input;
        }, String.class);
    }

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription("Reset the customization options for a check to defaults");
        commandDefinition.setGroupShortDescription(new String[]{"checks"}, "Quality Checks commands");
    }

    static {
        CommandBuilder builder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        CHECK_NAME_ARG = builder.argument("checkName", String.class).required().description("Name of check to reset").build();
        CHECKS_SETTINGS_FILE_ARG = builder.argument("checksSettingsFile", String.class).description("Relative or fully qualified path to a configuration file for checks execution").build();
        CHECKS_AUTO_UPDATE_ARG = builder.argument("autoUpdate", String.class).description("Allows automatic backup and updating of liquibase.checks.conf file when new quality checks are available. Options: [on|off]").setValueHandler(input -> {
            if (input == null) {
                return null;
            }
            String autoUpdateArg = (String)input;
            if (autoUpdateArg.equalsIgnoreCase("on") || autoUpdateArg.equalsIgnoreCase("off")) {
                return autoUpdateArg;
            }
            String messageString = "\nWARNING:  The autoUpdate value '" + autoUpdateArg + "' is not valid.  Valid values include: 'on' or 'off'";
            throw new IllegalArgumentException(messageString);
        }).build();
    }
}

