/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.command.checks.AbstractChecksStateModificationCommand;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;

public class ChecksEnableCommandStep
extends AbstractChecksStateModificationCommand {
    public static final String[] COMMAND_NAME = new String[]{"checks", "enable"};
    public static final CommandArgumentDefinition<String> CHECK_NAME_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_SETTINGS_FILE_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_AUTO_UPDATE_ARG;

    public final void run(CommandResultsBuilder resultsBuilder) throws Exception {
        String autoUpdate;
        String checkName;
        CommandScope commandScope = resultsBuilder.getCommandScope();
        String checksSettingsFile = (String)commandScope.getConfiguredValue(CHECKS_SETTINGS_FILE_ARG).getValue();
        if (!this.doWork(resultsBuilder, checksSettingsFile, checkName = (String)commandScope.getConfiguredValue(CHECK_NAME_ARG).getValue(), autoUpdate = (String)commandScope.getConfiguredValue(CHECKS_AUTO_UPDATE_ARG).getValue())) {
            return;
        }
        resultsBuilder.addResult("statusCode", (Object)0);
    }

    @Override
    public boolean validateStateModification(AbstractConfigurableRule rule, String checkName) {
        if (rule.isEnabled()) {
            String message = String.format("\n\nCheck '%s' is already %s.  No changes made.\n", checkName, this.describeStateModification());
            Scope.getCurrentScope().getUI().sendMessage(message);
            return false;
        }
        return true;
    }

    @Override
    public void doStateModification(AbstractConfigurableRule configuredRule) {
        configuredRule.setEnabled(true);
    }

    @Override
    public String describeStateModification() {
        return "enabled";
    }

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription("Enable a disabled check for current configuration");
        commandDefinition.setGroupShortDescription(new String[]{"checks"}, "Quality Checks commands");
    }

    static {
        CommandBuilder builder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        CHECK_NAME_ARG = builder.argument("checkName", String.class).required().description("Name of check to enable").build();
        CHECKS_SETTINGS_FILE_ARG = builder.argument("checksSettingsFile", String.class).description("Relative or fully qualified path to a configuration file for checks execution").build();
        CHECKS_AUTO_UPDATE_ARG = builder.argument("autoUpdate", String.class).description("Allows automatic backup and updating of liquibase.checks.conf file when new quality checks are available. Options: [on|off]").setValueHandler(input -> {
            if (input == null) {
                return null;
            }
            String autoUpdateArg = (String)input;
            if (autoUpdateArg.equalsIgnoreCase("on") || autoUpdateArg.equalsIgnoreCase("off")) {
                return autoUpdateArg;
            }
            String messageString = "\nWARNING:  The autoUpdate value '" + autoUpdateArg + "' is not valid.  Valid values include: 'on' or 'off'";
            throw new IllegalArgumentException(messageString);
        }).build();
    }
}

