/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.changelog.filter.SinglePendingChangeSetFilter;
import com.datical.liquibase.ext.util.ProStringUtil;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.RuntimeEnvironment;
import liquibase.Scope;
import liquibase.changelog.ChangeLogHistoryService;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.ChangeSetStatus;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.filter.ContextChangeSetFilter;
import liquibase.changelog.filter.IgnoreChangeSetFilter;
import liquibase.changelog.filter.LabelChangeSetFilter;
import liquibase.changelog.filter.ShouldRunChangeSetFilter;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.changelog.visitor.DefaultChangeExecListener;
import liquibase.changelog.visitor.StatusVisitor;
import liquibase.changelog.visitor.UpdateVisitor;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CleanUpCommandStep;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.exception.LockException;
import liquibase.executor.ExecutorService;
import liquibase.license.LicenseServiceUtils;
import liquibase.lockservice.LockService;
import liquibase.lockservice.LockServiceFactory;
import liquibase.logging.Logger;
import liquibase.logging.mdc.CustomMdcObject;
import liquibase.logging.mdc.MdcObject;
import liquibase.logging.mdc.customobjects.ChangesetsUpdated;

public class UpdateOneChangeSetCommandStep
extends AbstractCommandStep
implements CleanUpCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"updateOneChangeset"};
    public static final CommandArgumentDefinition<String> CHANGESET_ID_ARG;
    public static final CommandArgumentDefinition<String> CHANGESET_AUTHOR_ARG;
    public static final CommandArgumentDefinition<String> CHANGESET_PATH_ARG;
    public static final CommandArgumentDefinition<Boolean> FORCE_ARG;
    public static final CommandArgumentDefinition<Boolean> OVERRIDE_CHANGESET_IGNORE_FLAG_ARG;
    private Database database;
    private String changeSetId;
    private String changeSetAuthor;
    private String changeSetPath;
    private Boolean force;
    private static final ResourceBundle coreBundle;

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        commandDefinition.setShortDescription(ProStringUtil.markWithPro("Runs single changeset"));
    }

    public List<Class<?>> requiredDependencies() {
        return Arrays.asList(Database.class, LockService.class, DatabaseChangeLog.class, ChangeLogParameters.class);
    }

    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        LicenseServiceUtils.checkProLicenseAndThrowException((String[])COMMAND_NAME);
        CommandScope commandScope = resultsBuilder.getCommandScope();
        Logger log = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());
        Writer writer = (Writer)commandScope.getDependency(Writer.class);
        DatabaseChangeLog changeLog = (DatabaseChangeLog)commandScope.getDependency(DatabaseChangeLog.class);
        ChangeLogParameters changeLogParameters = (ChangeLogParameters)commandScope.getDependency(ChangeLogParameters.class);
        Contexts contexts = changeLogParameters.getContexts();
        LabelExpression labels = changeLogParameters.getLabels();
        this.setup(commandScope, writer);
        Scope.getCurrentScope().addMdcValue("commandLabelFilter", contexts.toString());
        Scope.getCurrentScope().addMdcValue("commandContextFilter", labels.toString());
        this.checkLiquibaseTables();
        changeLog.validate(this.database, changeLogParameters.getContexts(), changeLogParameters.getLabels());
        SinglePendingChangeSetFilter updateChangeSetFilter = new SinglePendingChangeSetFilter(this.changeSetId, this.changeSetAuthor, this.changeSetPath, changeLog);
        ArrayList<SinglePendingChangeSetFilter> changeSetFilters = new ArrayList<SinglePendingChangeSetFilter>();
        changeSetFilters.add(updateChangeSetFilter);
        changeSetFilters.add((SinglePendingChangeSetFilter)new ContextChangeSetFilter(contexts));
        changeSetFilters.add((SinglePendingChangeSetFilter)new LabelChangeSetFilter(labels));
        if (!((Boolean)commandScope.getArgumentValue(OVERRIDE_CHANGESET_IGNORE_FLAG_ARG)).booleanValue()) {
            changeSetFilters.add((SinglePendingChangeSetFilter)new IgnoreChangeSetFilter());
        }
        ChangeLogIterator updateChangeLogIterator = new ChangeLogIterator(changeLog, changeSetFilters);
        DefaultChangeExecListener changeExecListener = new DefaultChangeExecListener(new ChangeExecListener[0]);
        try {
            this.setupExecutionServices(this.database);
            resultsBuilder.addResult("defaultChangeExecListener", (Object)changeExecListener);
            this.printIgnoredChangesets(updateChangeLogIterator, changeLogParameters);
            UpdateVisitor updateVisitor = new UpdateVisitor(this.database, (ChangeExecListener)changeExecListener, new ShouldRunChangeSetFilter(this.database, true));
            updateChangeLogIterator.run((ChangeSetVisitor)updateVisitor, new RuntimeEnvironment(this.database, changeLogParameters.getContexts(), changeLogParameters.getLabels()));
            this.logDeploymentOutcomeMdc(true, changeExecListener);
            resultsBuilder.addResult("statusCode", (Object)0);
        }
        catch (LiquibaseException updateException) {
            this.logDeploymentOutcomeMdc(false, changeExecListener);
            throw new RuntimeException(updateException);
        }
        finally {
            try {
                LockServiceFactory.getInstance().getLockService(this.database).releaseLock();
            }
            catch (LockException lockException) {
                log.severe(coreBundle.getString("could.not.release.lock"), (Throwable)lockException);
            }
        }
    }

    private void printIgnoredChangesets(ChangeLogIterator updateChangeLogIterator, ChangeLogParameters changeLogParameters) throws LiquibaseException {
        StatusVisitor statusVisitor = new StatusVisitor(this.database);
        updateChangeLogIterator.run((ChangeSetVisitor)statusVisitor, new RuntimeEnvironment(this.database, changeLogParameters.getContexts(), changeLogParameters.getLabels()));
        List changeSetsToSkip = statusVisitor.getChangeSetsToSkip();
        for (ChangeSetStatus changeSetStatus : changeSetsToSkip) {
            ChangeSet changeSet = changeSetStatus.getChangeSet();
            boolean wasIgnored = changeSetStatus.getFilterResults().stream().anyMatch(csfr -> csfr.getFilter().isAssignableFrom(IgnoreChangeSetFilter.class));
            boolean wasMatchedToArgs = changeSetStatus.getFilterResults().stream().noneMatch(csfr -> csfr.getFilter().isAssignableFrom(SinglePendingChangeSetFilter.class));
            if (!wasIgnored || !wasMatchedToArgs) continue;
            Scope.getCurrentScope().getUI().sendMessage("INFO: The changeset (id: " + changeSet.getId() + ", author: " + changeSet.getAuthor() + ", filepath: " + changeSet.getFilePath() + " was skipped because the \"ignore=true\" attribute was set.");
        }
    }

    private void logDeploymentOutcomeMdc(boolean success, DefaultChangeExecListener changeExecListener) {
        List deployedChangeSets = Collections.emptyList();
        try {
            if (changeExecListener != null) {
                deployedChangeSets = changeExecListener.getDeployedChangeSets();
            }
        }
        catch (Exception e) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Failed to calculate deployed changeset count for MDC", (Throwable)e);
        }
        ChangesetsUpdated changesetsUpdated = new ChangesetsUpdated(deployedChangeSets);
        try (MdcObject deploymentOutcomeCountMdc = Scope.getCurrentScope().addMdcValue("deploymentOutcomeCount", String.valueOf(deployedChangeSets.size()));
             MdcObject deploymentOutcomeMdc = Scope.getCurrentScope().addMdcValue("deploymentOutcome", success ? "success" : "fail");
             MdcObject changesetsUpdatedMdc = Scope.getCurrentScope().addMdcValue("changesetsUpdated", (CustomMdcObject)changesetsUpdated);){
            String successLog = "Update command completed successfully.";
            String failureLog = "Update command encountered an exception.";
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info(success ? successLog : failureLog);
        }
    }

    private void setup(CommandScope commandScope, Writer writer) throws LiquibaseException {
        this.database = (Database)commandScope.getDependency(Database.class);
        this.changeSetId = (String)commandScope.getArgumentValue(CHANGESET_ID_ARG);
        this.changeSetAuthor = (String)commandScope.getArgumentValue(CHANGESET_AUTHOR_ARG);
        this.changeSetPath = (String)commandScope.getArgumentValue(CHANGESET_PATH_ARG);
        this.force = (Boolean)commandScope.getArgumentValue(FORCE_ARG);
        Scope.getCurrentScope().addMdcValue("updateOneChangesetForce", String.valueOf(this.force));
        this.checkArgs(writer);
    }

    private void checkArgs(Writer writer) throws LiquibaseException {
        if (this.changeSetId == null || this.changeSetAuthor == null || this.changeSetPath == null) {
            throw new LiquibaseException(coreBundle.getString("id.author.path.required"));
        }
        if (!(writer != null || this.force != null && this.force.booleanValue())) {
            String messageString = "\nWARNING: Targeted update of this changeset may result in unexpected outcomes.  To review the update\nSQL before executing it, please run 'update-one-changeset-sql'. This message can be suppressed by adding the --force flag.";
            throw new LiquibaseException(messageString, Level.WARNING);
        }
    }

    public void cleanUp(CommandResultsBuilder resultsBuilder) {
        LockServiceFactory.getInstance().resetAll();
        ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).reset();
        ChangeLogHistoryServiceFactory.getInstance().resetAll();
    }

    private void setupExecutionServices(Database database) throws LiquibaseException {
        LockService lockService = LockServiceFactory.getInstance().getLockService(database);
        lockService.waitForLock();
        ChangeLogHistoryService changeLogHistoryService = ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(database);
        changeLogHistoryService.init();
        changeLogHistoryService.generateDeploymentId();
        Scope.getCurrentScope().addMdcValue("deploymentId", changeLogHistoryService.getDeploymentId());
    }

    protected void checkLiquibaseTables() throws LiquibaseException {
        ChangeLogHistoryService changeLogHistoryService = ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(this.database);
        changeLogHistoryService.init();
    }

    static {
        coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
        CommandBuilder commandBuilder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        CHANGESET_ID_ARG = commandBuilder.argument("changesetId", String.class).description("Id of the changeset to execute").required().build();
        CHANGESET_AUTHOR_ARG = commandBuilder.argument("changesetAuthor", String.class).description("Author of the changeset to execute").required().build();
        CHANGESET_PATH_ARG = commandBuilder.argument("changesetPath", String.class).description("Path to the changeset to execute").required().build();
        FORCE_ARG = commandBuilder.argument("force", Boolean.class).description("A required safety flag to indicate you intend to use this feature").defaultValue((Object)false).build();
        OVERRIDE_CHANGESET_IGNORE_FLAG_ARG = commandBuilder.argument("overrideChangesetIgnoreFlag", Boolean.class).description("If true, the ignore flag on the changeset will be ignored, and the changeset will be run regardless of the ignore flag.").defaultValue((Object)false).hidden().build();
    }
}

