/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.changelog.filter.SingleRanChangeSetFilter;
import com.datical.liquibase.ext.command.AbstractRollbackOneCommand;
import com.datical.liquibase.ext.util.ProStringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.RuntimeEnvironment;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.change.core.RawSQLChange;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.CommandValidationException;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.RollbackImpossibleException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.license.LicenseServiceUtils;
import liquibase.lockservice.LockService;
import liquibase.logging.Logger;
import liquibase.logging.mdc.CustomMdcObject;
import liquibase.logging.mdc.MdcObject;
import liquibase.logging.mdc.customobjects.ChangesetsRolledback;

public class RollbackOneChangesetCommandStep
extends AbstractRollbackOneCommand {
    public static final String[] COMMAND_NAME = new String[]{"rollbackOneChangeset"};
    public static final CommandArgumentDefinition<String> CHANGESET_ID_ARG;
    public static final CommandArgumentDefinition<String> CHANGESET_AUTHOR_ARG;
    public static final CommandArgumentDefinition<String> CHANGESET_PATH_ARG;
    public static CommandArgumentDefinition<Boolean> FORCE_ARG;
    public static final CommandArgumentDefinition<String> ROLLBACK_SCRIPT_ARG;
    private static final ResourceBundle coreBundle;
    public static final CommandArgumentDefinition<Boolean> SHOULD_LOG_MDC_CHANGESETS_ROLLED_BACK;

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public List<Class<?>> requiredDependencies() {
        return Arrays.asList(Database.class, LockService.class, DatabaseChangeLog.class, ChangeExecListener.class, ChangeLogParameters.class);
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        commandDefinition.setShortDescription(ProStringUtil.markWithPro("Rollback one changeset from the database"));
    }

    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        LicenseServiceUtils.checkProLicenseAndThrowException((String[])COMMAND_NAME);
        Logger log = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());
        CommandScope commandScope = resultsBuilder.getCommandScope();
        String changeSetId = (String)commandScope.getArgumentValue(CHANGESET_ID_ARG);
        String changeSetAuthor = (String)commandScope.getArgumentValue(CHANGESET_AUTHOR_ARG);
        String changeSetPath = (String)commandScope.getArgumentValue(CHANGESET_PATH_ARG);
        String rollbackScript = (String)commandScope.getArgumentValue(ROLLBACK_SCRIPT_ARG);
        ChangeLogParameters changeLogParameters = (ChangeLogParameters)commandScope.getDependency(ChangeLogParameters.class);
        Contexts contexts = changeLogParameters.getContexts();
        LabelExpression labelExpression = changeLogParameters.getLabels();
        DatabaseChangeLog changeLog = (DatabaseChangeLog)commandScope.getDependency(DatabaseChangeLog.class);
        Database database = (Database)commandScope.getDependency(Database.class);
        Boolean force = (Boolean)commandScope.getArgumentValue(FORCE_ARG);
        boolean shouldLogMdcChangesetsRolledBack = (Boolean)commandScope.getArgumentValue(SHOULD_LOG_MDC_CHANGESETS_ROLLED_BACK);
        ChangeExecListener changeExecListener = (ChangeExecListener)commandScope.getDependency(ChangeExecListener.class);
        if (changeSetId == null || changeSetAuthor == null || changeSetPath == null) {
            throw new CommandValidationException(coreBundle.getString("id.author.path.required"));
        }
        if (force == null || !force.booleanValue()) {
            String messageString = "\nWARNING: Targeted rollback of this changeset may result in unexpected outcomes.  To review the rollback\nSQL before executing it, please run 'rollback-one-changeset-sql'. This message can be suppressed by adding the --force flag.";
            throw new LiquibaseException(messageString, Level.WARNING);
        }
        Scope.getCurrentScope().addMdcValue("rollbackScript", rollbackScript);
        Scope.getCurrentScope().addMdcValue("liquibaseTargetUrl", JdbcConnection.sanitizeUrl((String)database.getConnection().getURL()));
        Scope.getCurrentScope().addMdcValue("rollbackOneChangesetForce", String.valueOf(force));
        SingleRanChangeSetFilter singleChangeSetFilter = null;
        try {
            changeLog.validate(database, contexts, labelExpression);
            List ranChangeSetList = database.getRanChangeSetList();
            singleChangeSetFilter = new SingleRanChangeSetFilter(changeSetId, changeSetAuthor, changeSetPath, ranChangeSetList, changeLog);
            if (singleChangeSetFilter.isEmpty()) {
                throw new LiquibaseException(this.buildNoChangesetFoundException(singleChangeSetFilter, changeSetPath, changeSetId, changeSetAuthor));
            }
            ChangeLogIterator runChangeLogIterator = this.createChangeLogIterator(ranChangeSetList, singleChangeSetFilter, changeLog, contexts, labelExpression, database);
            if (rollbackScript == null) {
                ArrayList<ChangeSet> processedChangesets = new ArrayList<ChangeSet>();
                runChangeLogIterator.run((ChangeSetVisitor)this.createRollbackVisitor(processedChangesets, database, changeExecListener), new RuntimeEnvironment(database, contexts, labelExpression));
                if (shouldLogMdcChangesetsRolledBack) {
                    Scope.getCurrentScope().addMdcValue("changesetsRolledback", (CustomMdcObject)ChangesetsRolledback.fromChangesetList(processedChangesets), false);
                }
                resultsBuilder.addResult("processedChangesets", processedChangesets);
            } else {
                ChangeSet changeSet = singleChangeSetFilter.getMatchingChangeSet();
                this.executeRollbackScript(rollbackScript, changeSet, changeLog, changeLogParameters, database, changeExecListener);
                this.removeRunStatus(runChangeLogIterator, contexts, labelExpression, database);
                List<ChangeSet> processedChangesets = Collections.singletonList(changeSet);
                if (shouldLogMdcChangesetsRolledBack) {
                    Scope.getCurrentScope().addMdcValue("changesetsRolledback", (CustomMdcObject)ChangesetsRolledback.fromChangesetList(processedChangesets));
                }
                resultsBuilder.addResult("processedChangesets", processedChangesets);
                log.info("Executed rollback script " + rollbackScript);
            }
            this.logSuccess(changeLog);
        }
        catch (LiquibaseException exception) {
            this.handleRollbackError((Exception)((Object)exception), singleChangeSetFilter, changeSetPath, changeSetId, changeSetAuthor);
        }
        Scope.getCurrentScope().getUI().sendMessage("rollback-one-changeset executed for " + database.getConnection().getConnectionUserName() + "@" + database.getConnection().getURL());
    }

    protected String getChangeSetString(ChangeSet changeSet) {
        if (changeSet == null) {
            return null;
        }
        return changeSet.toString(false);
    }

    private void executeRollbackScript(String rollbackScript, ChangeSet changeSet, DatabaseChangeLog changeLog, ChangeLogParameters changeLogParameters, Database database, ChangeExecListener changeExecListener) throws LiquibaseException {
        Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
        String changeSetString = this.getChangeSetString(changeSet);
        String rollbackScriptContents = this.getRollbackScriptContents(rollbackScript, executor.toString(), changeLogParameters, changeLog);
        RawSQLChange rollbackChange = this.buildRawSQLChange(rollbackScriptContents);
        boolean hasListener = changeExecListener != null;
        try {
            if (hasListener) {
                changeExecListener.willRollback(changeSet, changeLog, database);
            }
            Scope.getCurrentScope().getUI().sendMessage("Rolling Back Changeset:" + changeSetString);
            executor.execute((Change)rollbackChange);
            if (hasListener) {
                changeExecListener.rolledBack(changeSet, changeLog, database);
            }
        }
        catch (DatabaseException e) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).severe("Error executing rollback script: " + e.getMessage());
            if (hasListener) {
                changeExecListener.rollbackFailed(changeSet, changeLog, database, (Exception)((Object)e));
            }
            throw new LiquibaseException("\nError executing rollback for the targeted changeset '" + changeSetString + "':\n" + e.getMessage(), (Throwable)e);
        }
        database.commit();
        if (rollbackScriptContents.length() == 0) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("No rollback logic defined in empty rollback script. Changesets have been removed from the DATABASECHANGELOG table but no other logic was performed.");
        }
    }

    private String buildNoChangesetFoundException(SingleRanChangeSetFilter singleChangeSetFilter, String changeSetPath, String changeSetId, String changeSetAuthor) throws LiquibaseException {
        String commandName = "rollback-one-changeset";
        String changeSetString = changeSetPath + "::" + changeSetId + "::" + changeSetAuthor;
        String warningMessage = "\n\nWARNING:  The command '" + commandName + "' failed because the targeted changeset\n'" + changeSetString + "' cannot be located.\nAt least one supplied parameter cannot be found in combination with the other parameters.\nPlease check your details and try again.\n";
        RanChangeSet ranChangeSet = singleChangeSetFilter.getMatchingIdChangeSet();
        if (ranChangeSet != null) {
            warningMessage = warningMessage + "\nNOTE:  A changeset with this ID was located.\n";
        }
        warningMessage = warningMessage + "No rollback was performed.";
        return warningMessage;
    }

    private void handleRollbackError(Exception rollbackError, SingleRanChangeSetFilter singleChangeSetFilter, String changeSetPath, String changeSetId, String changeSetAuthor) throws LiquibaseException {
        Logger log = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());
        String changeSetString = null;
        changeSetString = singleChangeSetFilter != null && !singleChangeSetFilter.isEmpty() ? this.getChangeSetString(singleChangeSetFilter.getMatchingChangeSet()) : changeSetPath + "::" + changeSetId + "::" + changeSetAuthor;
        Throwable t = rollbackError.getCause();
        try (MdcObject deploymentOutcomeMdc = Scope.getCurrentScope().addMdcValue("deploymentOutcome", "fail");){
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Rollback command encountered an exception.");
        }
        if (t instanceof RollbackImpossibleException) {
            log.severe("\nError executing rollback:\nThe targeted changeset '" + changeSetString + "' does not have a rollback defined\nPlease add a rollback change or script in the appropriate changeset.  You can also specify a rollback script as an argument to this command.\n", (Throwable)rollbackError);
            throw new LiquibaseException("\nError executing rollback:\nThe targeted changeset '" + changeSetString + "' does not have a rollback defined.\nPlease add a rollback change or script in the appropriate changeset.  You can also specify a rollback script as an argument to this command.\n", (Throwable)rollbackError);
        }
        log.severe("\nError executing rollback for the targeted changeset '" + changeSetString + "'.");
        throw new LiquibaseException("\nError executing rollback for the targeted changeset '" + changeSetString + "':\n" + rollbackError.getMessage(), (Throwable)rollbackError);
    }

    static {
        coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
        CommandBuilder builder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        CHANGESET_ID_ARG = builder.argument("changesetId", String.class).description("The id of the changeset to rollback").required().build();
        CHANGESET_AUTHOR_ARG = builder.argument("changesetAuthor", String.class).description("The author of the changeset to rollback").required().build();
        CHANGESET_PATH_ARG = builder.argument("changesetPath", String.class).description("The target database password").required().build();
        FORCE_ARG = builder.argument("force", Boolean.class).description("A required safety flag to indicate you intend to use this feature").defaultValue((Object)false).build();
        ROLLBACK_SCRIPT_ARG = builder.argument("rollbackScript", String.class).description("The path to the script to use to perform the rollback").build();
        SHOULD_LOG_MDC_CHANGESETS_ROLLED_BACK = builder.argument("shouldLogMdcChangesetsRolledBack", Boolean.class).hidden().defaultValue((Object)true).build();
    }
}

