/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.dynamic;

import com.datical.liquibase.ext.checks.dynamic.FunctionWithSqlParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import liquibase.change.AbstractChange;
import liquibase.change.AddColumnConfig;
import liquibase.change.ColumnConfig;
import liquibase.change.core.AddColumnChange;
import liquibase.change.core.AlterSequenceChange;
import liquibase.change.core.CreateIndexChange;
import liquibase.change.core.CreateSequenceChange;
import liquibase.change.core.CreateTableChange;
import liquibase.change.core.DropIndexChange;
import liquibase.change.core.DropSequenceChange;
import liquibase.change.core.DropTableChange;
import liquibase.change.core.MergeColumnChange;
import liquibase.change.core.RenameColumnChange;
import liquibase.change.core.RenameSequenceChange;
import liquibase.change.core.RenameTableChange;
import liquibase.repackaged.net.sf.jsqlparser.schema.Table;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.statement.alter.Alter;
import liquibase.repackaged.net.sf.jsqlparser.statement.alter.AlterExpression;
import liquibase.repackaged.net.sf.jsqlparser.statement.alter.AlterOperation;
import liquibase.repackaged.net.sf.jsqlparser.statement.alter.RenameTableStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.alter.sequence.AlterSequence;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.index.CreateIndex;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.schema.CreateSchema;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.sequence.CreateSequence;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.table.CreateTable;
import liquibase.repackaged.net.sf.jsqlparser.statement.drop.Drop;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.Index;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Sequence;
import liquibase.util.StringUtil;

public enum ObjectTypesEnum {
    TABLE(statement -> {
        if (statement instanceof CreateTable) {
            return Collections.singletonList(((CreateTable)statement).getTable().getName());
        }
        if (statement instanceof Drop) {
            if (((Drop)statement).getType().equalsIgnoreCase("table")) {
                return Collections.singletonList(((Drop)statement).getName().getName());
            }
        } else {
            if (statement instanceof Alter) {
                return ((Alter)statement).getAlterExpressions().stream().map(AlterExpression::getNewTableName).filter(StringUtil::isNotEmpty).collect(Collectors.toList());
            }
            if (statement instanceof RenameTableStatement) {
                return ((RenameTableStatement)statement).getTableNames().stream().filter(tableName -> StringUtil.isNotEmpty((String)((Table)tableName.getValue()).getName())).map(tableName -> ((Table)tableName.getValue()).getName()).collect(Collectors.toList());
            }
        }
        return Collections.singletonList("");
    }, change -> {
        if (change instanceof RenameTableChange) {
            return Collections.singletonList(((RenameTableChange)change).getNewTableName());
        }
        if (change instanceof CreateTableChange) {
            return Collections.singletonList(((CreateTableChange)change).getTableName());
        }
        if (change instanceof DropTableChange) {
            return Collections.singletonList(((DropTableChange)change).getTableName());
        }
        return Collections.singletonList("");
    }, liquibase.structure.core.Table.class),
    COLUMN(statement -> {
        if (statement instanceof Alter) {
            for (AlterExpression alterExpression : ((Alter)statement).getAlterExpressions()) {
                String columnName;
                if (alterExpression.getOperation() == AlterOperation.ADD) {
                    return alterExpression.getColDataTypeList().stream().map(ColumnDefinition::getColumnName).collect(Collectors.toList());
                }
                if (alterExpression.getOperation() != AlterOperation.RENAME || !StringUtil.isNotEmpty((String)(columnName = alterExpression.getColumnName()))) continue;
                return Collections.singletonList(columnName);
            }
        } else if (statement instanceof CreateTable) {
            return ((CreateTable)statement).getColumnDefinitions().stream().map(ColumnDefinition::getColumnName).collect(Collectors.toList());
        }
        return Collections.singletonList("");
    }, abstractChange -> {
        List<Object> columnNames = new ArrayList<String>();
        if (abstractChange instanceof CreateTableChange) {
            columnNames = ((CreateTableChange)abstractChange).getColumns().stream().map(ColumnConfig::getName).collect(Collectors.toList());
        } else if (abstractChange instanceof RenameColumnChange) {
            columnNames.add(((RenameColumnChange)abstractChange).getNewColumnName());
        } else if (abstractChange instanceof AddColumnChange) {
            columnNames.addAll(((AddColumnChange)abstractChange).getColumns().stream().map(AddColumnConfig::getAfterColumn).collect(Collectors.toList()));
        } else if (abstractChange instanceof MergeColumnChange) {
            columnNames.add(((MergeColumnChange)abstractChange).getFinalColumnName());
        }
        return columnNames;
    }, Column.class),
    SEQUENCE(statement -> {
        if (statement instanceof CreateSequence) {
            return Collections.singletonList(((CreateSequence)statement).getSequence().getName());
        }
        if (statement instanceof AlterSequence) {
            return Collections.singletonList(((AlterSequence)statement).getSequence().getName());
        }
        if (statement instanceof Drop && ((Drop)statement).getType().equalsIgnoreCase("sequence")) {
            return Collections.singletonList(((Drop)statement).getName().getName());
        }
        return Collections.singletonList("");
    }, change -> {
        if (change instanceof CreateSequenceChange) {
            return Collections.singletonList(((CreateSequenceChange)change).getSequenceName());
        }
        if (change instanceof AlterSequenceChange) {
            return Collections.singletonList(((AlterSequenceChange)change).getSequenceName());
        }
        if (change instanceof DropSequenceChange) {
            return Collections.singletonList(((DropSequenceChange)change).getSequenceName());
        }
        if (change instanceof RenameSequenceChange) {
            return Collections.singletonList(((RenameSequenceChange)change).getNewSequenceName());
        }
        return Collections.singletonList("");
    }, Sequence.class),
    INDEX(statement -> {
        if (statement instanceof CreateIndex) {
            return Collections.singletonList(((CreateIndex)statement).getIndex().getName());
        }
        if (statement instanceof CreateTable) {
            return ((CreateTable)statement).getIndexes().stream().map(liquibase.repackaged.net.sf.jsqlparser.statement.create.table.Index::getName).collect(Collectors.toList());
        }
        if (statement instanceof Drop) {
            if (((Drop)statement).getType().equalsIgnoreCase("index")) {
                return Collections.singletonList(((Drop)statement).getName().toString());
            }
        } else if (statement instanceof Alter) {
            ArrayList<String> indexNames = new ArrayList<String>();
            for (AlterExpression alterExpression : ((Alter)statement).getAlterExpressions()) {
                if (alterExpression.getIndex() == null) continue;
                indexNames.add(alterExpression.getIndex().getName());
            }
            return indexNames;
        }
        return Collections.singletonList("");
    }, change -> {
        if (change instanceof CreateIndexChange) {
            return Collections.singletonList(((CreateIndexChange)change).getIndexName());
        }
        if (change instanceof DropIndexChange) {
            return Collections.singletonList(((DropIndexChange)change).getIndexName());
        }
        return Collections.singletonList("");
    }, Index.class),
    SCHEMA(statement -> {
        if (statement instanceof CreateSchema) {
            return Collections.singletonList(((CreateSchema)statement).getSchemaName());
        }
        if (statement instanceof Drop && ((Drop)statement).getType().equalsIgnoreCase("schema")) {
            return Collections.singletonList(((Drop)statement).getName().toString());
        }
        return Collections.singletonList("");
    }, change -> Collections.singletonList(""), Schema.class);

    public final FunctionWithSqlParseException<Statement, List<String>> sqlCallback;
    public final Function<AbstractChange, List<String>> abstractChangeCallback;
    public final Class<? extends DatabaseObject> objectClass;

    private ObjectTypesEnum(FunctionWithSqlParseException<Statement, List<String>> sqlCallback, Function<AbstractChange, List<String>> abstractChangeCallback, Class<? extends DatabaseObject> objectClass) {
        this.sqlCallback = sqlCallback;
        this.abstractChangeCallback = abstractChangeCallback;
        this.objectClass = objectClass;
    }

    public List<String> getNamesFromDatabaseObject(DatabaseObject databaseObject) {
        if (this.objectClass.isAssignableFrom(databaseObject.getClass())) {
            return Collections.singletonList(databaseObject.getName());
        }
        return Collections.emptyList();
    }
}

