/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.config.model;

import com.datical.liquibase.ext.checks.config.CheckSettingsConfigHelper;
import com.datical.liquibase.ext.checks.config.CheckSettingsConfigYaml;
import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.FileAccessorDTO;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.BasicRule;
import com.datical.liquibase.ext.checks.config.model.CheckPackagesConfig;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfigFileInfo;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.command.checks.AbstractChecksCommandStep;
import com.datical.liquibase.ext.command.checks.ChecksPackageNotFoundException;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.configuration.ConfiguredValueModifierFactory;
import liquibase.exception.CommandExecutionException;
import liquibase.resource.Resource;
import liquibase.util.CollectionUtil;
import liquibase.util.StringUtil;

public class CheckSettingsConfig {
    private String version;
    private Date fileModified;
    private Date fileCreated;
    private List<AbstractConfigurableRule> rules;
    private List<AbstractConfigurableRule> unrecognizedRules = new ArrayList<AbstractConfigurableRule>();
    private String warningMessage;
    private List<Resource> resources = new ArrayList<Resource>();

    public CheckSettingsConfig(List<AbstractConfigurableRule> rules, List<Resource> resources) {
        this.rules = rules;
        this.resources = resources;
    }

    public AbstractConfigurableRule getRuleById(UUID id) {
        for (AbstractConfigurableRule rule : this.rules) {
            if (!rule.getId().equals(id)) continue;
            return rule;
        }
        return null;
    }

    public List<AbstractConfigurableRule> getExecutableRulesByRuleId(UUID instanceId) {
        return this.rules.stream().filter(r -> r.getId().equals(instanceId) || r instanceof DynamicRule && instanceId.equals(((DynamicRule)r).getParentRuleId())).sorted(Comparator.comparing(AbstractConfigurableRule::getShortName)).collect(Collectors.toList());
    }

    public DynamicRule getDynamicRuleByShortName(String shortName) {
        return this.rules.stream().filter(r -> r instanceof DynamicRule && ((DynamicRule)r).getShortName().equalsIgnoreCase(shortName)).findFirst().orElse(null);
    }

    public AbstractConfigurableRule getRuleByShortName(String shortName) {
        try {
            AbstractLiquibaseRule ruleByShortName = AbstractChecksCommandStep.findRuleByShortName(shortName);
            return this.rules.stream().filter(r -> r.getId().equals(ruleByShortName.getId())).findFirst().orElse(null);
        }
        catch (CommandExecutionException e) {
            return this.getDynamicRuleByShortName(shortName);
        }
    }

    public DynamicRule getDynamicConfigurableRuleByShortName(String shortName, String ruleNotConfigurableErrorMessage) throws CommandExecutionException {
        DynamicRule configurableRule = this.getDynamicRuleByShortName(shortName);
        if (configurableRule == null) {
            AbstractLiquibaseRule rule = AbstractChecksCommandStep.findRuleByShortName(shortName);
            if (!rule.isConfigurable()) {
                throw new CommandExecutionException(System.lineSeparator() + System.lineSeparator() + "Check '" + shortName + "' " + ruleNotConfigurableErrorMessage + "." + System.lineSeparator() + "Run 'liquibase checks show' to see a list of all available checks and customization options for checks.");
            }
            throw new CommandExecutionException("Check appears to be configurable, but cannot be located in the check settings configuration file.");
        }
        return configurableRule;
    }

    public String getUnrecognizedRulesWarningMessage() {
        if (this.unrecognizedRules != null && !this.unrecognizedRules.isEmpty()) {
            StringBuilder msg = new StringBuilder("Unknown Checks Skipped (Upgrade Liquibase to use more official checks):" + System.lineSeparator());
            for (AbstractConfigurableRule unknownRule : this.unrecognizedRules) {
                msg.append("  ");
                if (unknownRule.isConfigurable()) {
                    msg.append(((DynamicRule)unknownRule).getShortName());
                } else {
                    msg.append(unknownRule.getId());
                }
                msg.append(System.lineSeparator());
            }
            msg.append(System.lineSeparator());
            return msg.toString();
        }
        return "";
    }

    public static CheckSettingsConfig generateDefaultConfigFromRules(List<AbstractLiquibaseRule> rules, Resource resource) {
        ArrayList<AbstractConfigurableRule> configuredRules = new ArrayList<AbstractConfigurableRule>(rules.size());
        for (AbstractLiquibaseRule rule : rules) {
            configuredRules.add(AbstractConfigurableRule.fromRuleImplementation(rule, null));
        }
        CheckSettingsConfig csc = new CheckSettingsConfig(configuredRules, Collections.singletonList(resource));
        csc.setVersion("1.1");
        return csc;
    }

    public static Optional<AbstractConfigurableRule> findRuleById(List<AbstractConfigurableRule> rules, UUID id) {
        return rules.stream().filter(configRule -> id.equals(configRule.getId())).findFirst();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CheckSettingsConfig that = (CheckSettingsConfig)o;
        return Objects.equals(this.rules, that.rules);
    }

    public int hashCode() {
        return Objects.hash(this.rules);
    }

    public void outputWarningMessage() {
        if (StringUtil.isNotEmpty((String)this.warningMessage)) {
            Scope.getCurrentScope().getLog(this.getClass()).warning(this.warningMessage);
            Scope.getCurrentScope().getUI().sendMessage("WARNING: " + this.warningMessage);
        }
    }

    public void setWarningMessage(String warningMessage) {
        this.warningMessage = warningMessage;
    }

    public static CheckSettingsConfig fromFileAccessorDTO(FileAccessorDTO dto, String selectedPackages, boolean isLoadedFromPackageFile, Set<String> processedFiles) throws CommandExecutionException, IOException {
        CheckSettingsConfigYaml yaml = new CheckSettingsConfigYaml();
        Map checksMap = (Map)yaml.load(FileAccessorDTO.stripClassIdentifiers(dto.contents));
        CheckSettingsConfig checkSettingsConfig = new CheckSettingsConfig();
        checkSettingsConfig.setWarningMessage(dto.warningMessage);
        checkSettingsConfig.resources = Collections.singletonList(dto.resource);
        String rulesKey = CollectionUtil.findKeyInMapIgnoreCase((String)"rules", (Map)checksMap);
        checkSettingsConfig = CheckSettingsConfig.handleChecksPackageFile(dto, selectedPackages, processedFiles, rulesKey, checksMap, checkSettingsConfig);
        Object rulesObject = checksMap.get(rulesKey);
        if (rulesObject != null) {
            List rules = (List)rulesObject;
            ArrayList<AbstractConfigurableRule> configurableRules = new ArrayList<AbstractConfigurableRule>(rules.size());
            for (Map rule : rules) {
                Boolean enabled = (Boolean)rule.get(CollectionUtil.findKeyInMapIgnoreCase((String)"enabled", (Map)rule));
                String description = (String)rule.get(CollectionUtil.findKeyInMapIgnoreCase((String)"description", (Map)rule));
                String id = (String)rule.get(CollectionUtil.findKeyInMapIgnoreCase((String)"id", (Map)rule));
                String name = (String)rule.get(CollectionUtil.findKeyInMapIgnoreCase((String)"name", (Map)rule));
                String parentRuleIdKey = CollectionUtil.findKeyInMapIgnoreCase((String)"parentRuleId", (Map)rule);
                String parentRuleId = (String)rule.get(parentRuleIdKey);
                Object severity = rule.get(CollectionUtil.findKeyInMapIgnoreCase((String)"severity", (Map)rule));
                String shortName = (String)rule.get(CollectionUtil.findKeyInMapIgnoreCase((String)"shortName", (Map)rule));
                String parametersKey = CollectionUtil.findKeyInMapIgnoreCase((String)"parameters", (Map)rule);
                if (parentRuleIdKey != null && parametersKey != null) {
                    List parameters = (List)rule.get(parametersKey);
                    ArrayList<DynamicRuleParameter> drpList = new ArrayList<DynamicRuleParameter>(parameters.size());
                    for (Map parameter : parameters) {
                        String parameterName = (String)parameter.get(CollectionUtil.findKeyInMapIgnoreCase((String)"parameter", (Map)parameter));
                        Object value = parameter.get(CollectionUtil.findKeyInMapIgnoreCase((String)"value", (Map)parameter));
                        try {
                            drpList.add(new DynamicRuleParameter(DynamicRuleParameterEnum.valueOf(parameterName), value));
                        }
                        catch (Exception e) {
                            Scope.getCurrentScope().getLog(CheckSettingsConfig.class).warning("Rule parameter '" + parameterName + "' not found. Skipping.");
                        }
                    }
                    configurableRules.add(new DynamicRule(enabled, SeverityEnum.fromYamlFile(severity), UUID.fromString(id), shortName, name, description, parentRuleId == null ? null : UUID.fromString(parentRuleId), drpList, new CheckSettingsConfigFileInfo(isLoadedFromPackageFile, dto.resource.getPath())));
                    continue;
                }
                configurableRules.add(new BasicRule(enabled, SeverityEnum.fromYamlFile(severity), UUID.fromString(id), shortName, name, description, new CheckSettingsConfigFileInfo(isLoadedFromPackageFile, dto.resource.getPath())));
            }
            checkSettingsConfig.setRules(configurableRules);
        }
        String versionKey = CollectionUtil.findKeyInMapIgnoreCase((String)"version", (Map)checksMap);
        checkSettingsConfig.setVersion((String)checksMap.get(versionKey));
        try {
            String fileCreatedKey = CollectionUtil.findKeyInMapIgnoreCase((String)"fileCreated", (Map)checksMap);
            checkSettingsConfig.setFileCreated((Date)checksMap.get(fileCreatedKey));
        }
        catch (Exception e) {
            Scope.getCurrentScope().getLog(CheckSettingsConfig.class).warning("Failed to read fileCreated key from checks file.", (Throwable)e);
        }
        try {
            String fileModifiedKey = CollectionUtil.findKeyInMapIgnoreCase((String)"fileModified", (Map)checksMap);
            checkSettingsConfig.setFileModified((Date)checksMap.get(fileModifiedKey));
        }
        catch (Exception e) {
            Scope.getCurrentScope().getLog(CheckSettingsConfig.class).warning("Failed to read fileModified key from checks file.", (Throwable)e);
        }
        return checkSettingsConfig;
    }

    private static CheckSettingsConfig handleChecksPackageFile(FileAccessorDTO dto, String selectedPackages, Set<String> processedFiles, String rulesKey, Map<String, Object> checksMap, CheckSettingsConfig checkSettingsConfig) throws IOException, CommandExecutionException {
        String checksPackagesKey;
        if (rulesKey == null && (checksPackagesKey = CollectionUtil.findKeyInMapIgnoreCase((String)"checksPackages", checksMap)) != null) {
            dto.isPackageFile = true;
            if (processedFiles == null) {
                processedFiles = new HashSet<String>();
            }
            List requestedPackages = CollectionUtil.createIfNull((List)StringUtil.splitAndTrim((String)selectedPackages, (String)","));
            checkSettingsConfig = new CheckPackagesConfig();
            checkSettingsConfig.setRules(new ArrayList<AbstractConfigurableRule>());
            List packages = (List)checksMap.get(checksPackagesKey);
            for (LinkedHashMap aPackage : packages) {
                String nameKey = CollectionUtil.findKeyInMapIgnoreCase((String)"name", (Map)aPackage);
                String name = String.valueOf(aPackage.get(nameKey));
                if (StringUtil.isEmpty((String)selectedPackages) || requestedPackages.contains(name)) {
                    Scope.getCurrentScope().getLog(CheckSettingsConfig.class).fine("Including checks settings package " + name);
                    requestedPackages.remove(name);
                } else if (!requestedPackages.contains(name)) {
                    Scope.getCurrentScope().getLog(CheckSettingsConfig.class).warning("Not including checks settings package " + name + " because the name does not match the any of the requested packages");
                    continue;
                }
                for (String file : CheckSettingsConfig.getFilesFromPackage(aPackage, processedFiles)) {
                    Scope.getCurrentScope().getLog(CheckSettingsConfig.class).fine("Loading contents from " + file);
                    CheckSettingsConfigHelper helper = new CheckSettingsConfigHelper(file, null);
                    CheckSettingsConfig loadedFileCsc = helper.read(AbstractChecksCommandStep.listAllRules(), selectedPackages, true, processedFiles);
                    checkSettingsConfig.getRules().addAll(loadedFileCsc.getRules());
                    checkSettingsConfig.getResources().addAll(loadedFileCsc.getResources());
                }
            }
            if (!requestedPackages.isEmpty()) {
                String packageWord = requestedPackages.size() > 1 ? "packages" : "package";
                String wasWord = requestedPackages.size() > 1 ? "were" : "was";
                String errorMsg = String.format("ERROR: The %s '%s' %s not found in '%s'. Liquibase checks operation was aborted. Learn more at https://docs.liquibase.com/quality-checks", packageWord, StringUtil.join((Collection)requestedPackages, (String)"', '"), wasWord, dto.resource.getPath());
                throw new ChecksPackageNotFoundException(errorMsg);
            }
        }
        return checkSettingsConfig;
    }

    private static List<String> getFilesFromPackage(LinkedHashMap<String, Object> aPackage, Set<String> processedFilenames) {
        String filesKey = CollectionUtil.findKeyInMapIgnoreCase((String)"files", aPackage);
        List files = (List)aPackage.get(filesKey);
        ArrayList<String> returnList = new ArrayList<String>(files.size());
        for (String file : files) {
            file = ((ConfiguredValueModifierFactory)Scope.getCurrentScope().getSingleton(ConfiguredValueModifierFactory.class)).override(file);
            if (processedFilenames != null && processedFilenames.contains(file)) {
                Scope.getCurrentScope().getUI().sendMessage("INFO: The checks file " + file + " was included more than once in this checks package, but it will only be processed one time.");
                continue;
            }
            if (processedFilenames != null) {
                processedFilenames.add(file);
            }
            returnList.add(file);
        }
        return returnList;
    }

    public String toYaml() {
        CheckSettingsConfigYaml yaml = new CheckSettingsConfigYaml();
        String dumped = yaml.dumpAsMap(this);
        dumped = FileAccessorDTO.stripClassIdentifiers(dumped);
        return dumped;
    }

    public boolean isPackageFile() {
        return this.rules.stream().anyMatch(r -> r.getFileInfo() != null && r.getFileInfo().isLoadedFromPackageFile());
    }

    public String getVersion() {
        return this.version;
    }

    public Date getFileModified() {
        return this.fileModified;
    }

    public Date getFileCreated() {
        return this.fileCreated;
    }

    public List<AbstractConfigurableRule> getRules() {
        return this.rules;
    }

    public List<AbstractConfigurableRule> getUnrecognizedRules() {
        return this.unrecognizedRules;
    }

    public String getWarningMessage() {
        return this.warningMessage;
    }

    public List<Resource> getResources() {
        return this.resources;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setFileModified(Date fileModified) {
        this.fileModified = fileModified;
    }

    public void setFileCreated(Date fileCreated) {
        this.fileCreated = fileCreated;
    }

    public void setRules(List<AbstractConfigurableRule> rules) {
        this.rules = rules;
    }

    public void setUnrecognizedRules(List<AbstractConfigurableRule> unrecognizedRules) {
        this.unrecognizedRules = unrecognizedRules;
    }

    public void setResources(List<Resource> resources) {
        this.resources = resources;
    }

    public CheckSettingsConfig() {
    }

    public static final class Fields {
        public static final String version = "version";
        public static final String fileModified = "fileModified";
        public static final String fileCreated = "fileCreated";
        public static final String rules = "rules";
        public static final String unrecognizedRules = "unrecognizedRules";
        public static final String warningMessage = "warningMessage";
        public static final String resources = "resources";

        private Fields() {
        }
    }
}

