/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.security;

import java.security.SecureRandom;
import java.util.UUID;
import org.bouncycastle.crypto.generators.Argon2BytesGenerator;
import org.bouncycastle.crypto.params.Argon2Parameters;
import org.linguafranca.pwdb.security.KeyDerivationFunction;
import org.linguafranca.pwdb.security.VariantDictionary;

public class Argon2
implements KeyDerivationFunction {
    private static final UUID argon2_kdf = UUID.fromString("EF636DDF-8C29-444B-91F7-A9A403E30A0C");
    private static final String name = "Argon2";
    private static final Argon2 instance = new Argon2();
    static final SecureRandom random = new SecureRandom();

    private Argon2() {
    }

    public static Argon2 getInstance() {
        return instance;
    }

    @Override
    public UUID getKdfUuid() {
        return argon2_kdf;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public byte[] getTransformedKey(byte[] digest, VariantDictionary argonParameterKeys) {
        int version = argonParameterKeys.mustGet("V").asInteger();
        byte[] salt = argonParameterKeys.mustGet("S").asByteArray();
        int parallelism = argonParameterKeys.mustGet("P").asInteger();
        int memoryCost = (int)argonParameterKeys.mustGet("M").asLong();
        int timeCost = (int)argonParameterKeys.mustGet("I").asLong();
        Argon2Parameters.Builder builder = new Argon2Parameters.Builder(0).withVersion(version).withIterations(timeCost).withMemoryAsKB(memoryCost / 1024).withParallelism(parallelism).withSalt(salt);
        Argon2BytesGenerator gen = new Argon2BytesGenerator();
        gen.init(builder.build());
        byte[] result = new byte[32];
        gen.generateBytes(digest, result, 0, result.length);
        return result;
    }

    @Override
    public VariantDictionary createKdfParameters() {
        VariantDictionary vd = new VariantDictionary(1);
        vd.putUInt("P", 2);
        vd.putUInt("V", 19);
        vd.putULong("I", 2L);
        vd.putULong("M", 0x4000000L);
        vd.putUuid("$UUID", argon2_kdf);
        vd.put("S", VariantDictionary.EntryType.ARRAY, random.generateSeed(32));
        return vd;
    }

    public static class VariantDictionaryKeys {
        static final String paramSalt = "S";
        static final String paramParallelism = "P";
        static final String paramMemory = "M";
        static final String paramIterations = "I";
        static final String paramVersion = "V";
        static final String paramSecretKey = "K";
        static final String paramAssocData = "A";
    }
}

