/*
 * Decompiled with CFR 0.152.
 */
package org.libheiffx;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.ProviderNotFoundException;
import java.nio.file.StandardCopyOption;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NativeUtils {
    private static final int MIN_PREFIX_LENGTH = 3;
    public static final String NATIVE_FOLDER_PATH_PREFIX = "nativeutils";
    private static File temporaryDir;

    private NativeUtils() {
    }

    public static String[] loadLibraryFromJar(String tempDir, String ... path) throws IOException {
        String filename;
        Logger.getLogger(NativeUtils.class.getName()).log(Level.FINEST, null, "Extracting native lib to " + tempDir + "...");
        if (null == path || !path[0].startsWith("/")) {
            throw new IllegalArgumentException("The path has to be absolute (start with '/').");
        }
        String[] parts = path[0].split("/");
        String string = filename = parts.length > 1 ? parts[parts.length - 1] : null;
        if (filename == null || filename.length() < 3) {
            throw new IllegalArgumentException("The filename has to be at least 3 characters long.");
        }
        if (tempDir == null) {
            if (temporaryDir == null) {
                temporaryDir = NativeUtils.createTempDirectory(NATIVE_FOLDER_PATH_PREFIX);
            }
        } else {
            temporaryDir = new File(tempDir);
            if (!temporaryDir.exists()) {
                temporaryDir.mkdirs();
            }
        }
        String[] nativeLibs = new String[path.length];
        for (int i = 0; i < path.length; ++i) {
            String part = path[i];
            String filenm = new File(part).getName();
            File temp = new File(temporaryDir, filenm);
            try (InputStream is = NativeUtils.class.getResourceAsStream(part);){
                Files.copy(is, temp.toPath(), StandardCopyOption.REPLACE_EXISTING);
                nativeLibs[i] = temp.toString();
                continue;
            }
            catch (IOException e) {
                temp.delete();
                throw e;
            }
            catch (NullPointerException e) {
                temp.delete();
                throw new FileNotFoundException("File " + part + " was not found inside JAR.");
            }
        }
        Logger.getLogger(NativeUtils.class.getName()).log(Level.FINEST, null, "Extracting native lib to " + tempDir + "...finished");
        return nativeLibs;
    }

    private static boolean isPosixCompliant() {
        try {
            return FileSystems.getDefault().supportedFileAttributeViews().contains("posix");
        }
        catch (SecurityException | FileSystemNotFoundException | ProviderNotFoundException e) {
            return false;
        }
    }

    private static File createTempDirectory(String prefix) throws IOException {
        String tempDir = System.getProperty("java.io.tmpdir");
        File generatedDir = new File(tempDir, prefix + System.nanoTime());
        if (!generatedDir.mkdir()) {
            throw new IOException("Failed to create temp directory " + generatedDir.getName());
        }
        return generatedDir;
    }
}

