/*
 * Decompiled with CFR 0.152.
 */
package org.libheiffx;

import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import javax.imageio.ImageTypeSpecifier;
import org.libheiffx.GenericWritableRaster;
import org.libheiffx.MappedFileBuffer;

public final class MappedImageFactory {
    private static final boolean DEBUG = "true".equalsIgnoreCase(System.getProperty("com.twelvemonkeys.image.mapped.debug"));
    private static final int DCM_RED_MASK = 0xFF0000;
    private static final int DCM_GREEN_MASK = 65280;
    private static final int DCM_BLUE_MASK = 255;
    private static final int DCM_ALPHA_MASK = -16777216;
    private static final int DCM_565_RED_MASK = 63488;
    private static final int DCM_565_GRN_MASK = 2016;
    private static final int DCM_565_BLU_MASK = 31;
    private static final int DCM_555_RED_MASK = 31744;
    private static final int DCM_555_GRN_MASK = 992;
    private static final int DCM_555_BLU_MASK = 31;
    private static final int DCM_BGR_RED_MASK = 255;
    private static final int DCM_BGR_GRN_MASK = 65280;
    private static final int DCM_BGR_BLU_MASK = 0xFF0000;
    static final RasterFactory RASTER_FACTORY = MappedImageFactory.createRasterFactory();

    private MappedImageFactory() {
    }

    public static BufferedImage createCompatibleMappedImage(int width, int height, int type) throws IOException {
        BufferedImage temp = new BufferedImage(1, 1, type);
        return MappedImageFactory.createCompatibleMappedImage(width, height, temp.getSampleModel().createCompatibleSampleModel(width, height), temp.getColorModel());
    }

    public static BufferedImage createCompatibleMappedImage(int width, int height, GraphicsConfiguration configuration, int transparency) throws IOException {
        return MappedImageFactory.createCompatibleMappedImage(width, height, configuration.getColorModel(transparency));
    }

    public static BufferedImage createCompatibleMappedImage(int width, int height, ImageTypeSpecifier type) throws IOException {
        return MappedImageFactory.createCompatibleMappedImage(width, height, type.getSampleModel(width, height), type.getColorModel());
    }

    static BufferedImage createCompatibleMappedImage(int width, int height, ColorModel cm) throws IOException {
        return MappedImageFactory.createCompatibleMappedImage(width, height, cm.createCompatibleSampleModel(width, height), cm);
    }

    static BufferedImage createCompatibleMappedImage(int width, int height, SampleModel sm, ColorModel cm) throws IOException {
        DataBuffer buffer = MappedFileBuffer.create(sm.getTransferType(), width * height * sm.getNumDataElements(), 1);
        return new BufferedImage(cm, RASTER_FACTORY.createRaster(sm, buffer, new Point()), cm.isAlphaPremultiplied(), null);
    }

    public static int getCompatibleBufferedImageType(BufferedImage image) {
        if (image == null) {
            throw new IllegalArgumentException("image object was: " + image);
        }
        WritableRaster raster = image.getRaster();
        SampleModel sm = raster.getSampleModel();
        int numBands = raster.getNumBands();
        ColorModel cm = image.getColorModel();
        ColorSpace cs = cm.getColorSpace();
        boolean isAlphaPre = cm.isAlphaPremultiplied();
        int csType = cs.getType();
        int dataType = raster.getDataBuffer().getDataType();
        if (csType != 5) {
            if (csType == 6 && cm instanceof ComponentColorModel) {
                if (sm instanceof ComponentSampleModel && ((ComponentSampleModel)sm).getPixelStride() != numBands) {
                    return 0;
                }
                if (dataType == 0 && raster.getNumBands() == 1 && cm.getComponentSize(0) == 8 && ((ComponentSampleModel)sm).getPixelStride() == 1) {
                    return 10;
                }
                if (dataType == 1 && raster.getNumBands() == 1 && cm.getComponentSize(0) == 16 && ((ComponentSampleModel)sm).getPixelStride() == 1) {
                    return 11;
                }
            } else {
                return 0;
            }
        }
        if (dataType == 3 && (numBands == 3 || numBands == 4)) {
            int pixSize = cm.getPixelSize();
            if (cm instanceof DirectColorModel && sm.getNumDataElements() == 1 && (pixSize == 32 || pixSize == 24)) {
                DirectColorModel dcm = (DirectColorModel)cm;
                int rmask = dcm.getRedMask();
                int gmask = dcm.getGreenMask();
                int bmask = dcm.getBlueMask();
                if (rmask == 0xFF0000 && gmask == 65280 && bmask == 255) {
                    if (dcm.getAlphaMask() == -16777216) {
                        return isAlphaPre ? 3 : 2;
                    }
                    if (!dcm.hasAlpha()) {
                        return 1;
                    }
                } else if (rmask == 255 && gmask == 65280 && bmask == 0xFF0000 && !dcm.hasAlpha()) {
                    return 4;
                }
            }
        } else if (!(!(cm instanceof IndexColorModel) || numBands != 1 || cm.hasAlpha() && isAlphaPre)) {
            ComponentSampleModel csm;
            IndexColorModel icm = (IndexColorModel)cm;
            int pixSize = icm.getPixelSize();
            if (dataType == 0 && sm instanceof MultiPixelPackedSampleModel) {
                return 12;
            }
            if (dataType == 0 && sm instanceof ComponentSampleModel && (csm = (ComponentSampleModel)sm).getPixelStride() == 1 && pixSize <= 8) {
                return 13;
            }
        } else if (dataType == 1 && cm instanceof DirectColorModel && numBands == 3 && !cm.hasAlpha()) {
            DirectColorModel dcm = (DirectColorModel)cm;
            if (dcm.getRedMask() == 63488 && dcm.getGreenMask() == 2016 && dcm.getBlueMask() == 31) {
                return 8;
            }
            if (dcm.getRedMask() == 31744 && dcm.getGreenMask() == 992 && dcm.getBlueMask() == 31) {
                return 9;
            }
        } else if (dataType == 0 && cm instanceof ComponentColorModel && raster.getSampleModel() instanceof PixelInterleavedSampleModel && (numBands == 3 || numBands == 4)) {
            ComponentColorModel ccm = (ComponentColorModel)cm;
            PixelInterleavedSampleModel csm = (PixelInterleavedSampleModel)raster.getSampleModel();
            int[] offs = csm.getBandOffsets();
            int[] nBits = ccm.getComponentSize();
            boolean is8bit = true;
            for (int i = 0; i < numBands; ++i) {
                if (nBits[i] == 8) continue;
                is8bit = false;
                break;
            }
            if (is8bit && csm.getPixelStride() == numBands && offs[0] == numBands - 1 && offs[1] == numBands - 2 && offs[2] == numBands - 3) {
                if (numBands == 3 && !ccm.hasAlpha()) {
                    return 5;
                }
                if (offs[3] == 0 && ccm.hasAlpha()) {
                    return isAlphaPre ? 7 : 6;
                }
            }
        }
        return 0;
    }

    private static RasterFactory createRasterFactory() {
        try {
            return new SunRasterFactory();
        }
        catch (LinkageError e) {
            if (DEBUG) {
                e.printStackTrace();
            }
            System.err.println("Could not instantiate SunWritableRaster, falling back to GenericWritableRaster.");
            return new GenericRasterFactory();
        }
    }

    static interface RasterFactory {
        public WritableRaster createRaster(SampleModel var1, DataBuffer var2, Point var3);
    }

    static final class SunRasterFactory
    implements RasterFactory {
        private final Constructor<WritableRaster> factoryMethod = SunRasterFactory.getFactoryMethod();

        SunRasterFactory() {
        }

        private static Constructor<WritableRaster> getFactoryMethod() {
            try {
                Class<?> cls = Class.forName("sun.awt.image.SunWritableRaster");
                if (Modifier.isAbstract(cls.getModifiers())) {
                    throw new IncompatibleClassChangeError("sun.awt.image.SunWritableRaster has become abstract and can't be instantiated");
                }
                return cls.getConstructor(SampleModel.class, DataBuffer.class, Point.class);
            }
            catch (ClassNotFoundException e) {
                throw new NoClassDefFoundError(e.getMessage());
            }
            catch (NoSuchMethodException e) {
                throw new NoSuchMethodError(e.getMessage());
            }
        }

        @Override
        public WritableRaster createRaster(SampleModel model, DataBuffer buffer, Point origin) {
            try {
                return this.factoryMethod.newInstance(model, buffer, origin);
            }
            catch (InstantiationException e) {
                throw new Error("Could not create SunWritableRaster: ", e);
            }
            catch (IllegalAccessException e) {
                throw new Error("Could not create SunWritableRaster: ", e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                throw new UndeclaredThrowableException(cause);
            }
        }
    }

    static final class GenericRasterFactory
    implements RasterFactory {
        GenericRasterFactory() {
        }

        @Override
        public WritableRaster createRaster(SampleModel model, DataBuffer buffer, Point origin) {
            return new GenericWritableRaster(model, buffer, origin);
        }
    }
}

