/*
 * Decompiled with CFR 0.152.
 */
package org.libheiffx;

import com.sun.javafx.iio.ImageFormatDescription;
import com.sun.javafx.iio.ImageFrame;
import com.sun.javafx.iio.ImageMetadata;
import com.sun.javafx.iio.ImageStorage;
import com.sun.javafx.iio.common.ImageLoaderImpl;
import com.sun.javafx.iio.common.ImageTools;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.stage.Screen;
import org.libheiffx.FixedPixelDensityImageFrame;
import org.libheiffx.HEIFDescriptor;
import org.libheiffx.LibheifImage;
import org.libheiffx.ScreenHelper;
import org.libheiffx.dimension.DimensionProvider;

public class HEIFImageLoader
extends ImageLoaderImpl {
    private final InputStream input;
    private float maxPixelScale = 0.0f;
    private final DimensionProvider dimensionProvider;
    private final Lock accessLock = new Lock();
    private boolean isDisposed = false;
    private LibheifImage libheif;

    protected HEIFImageLoader(InputStream input, DimensionProvider dimensionProvider) {
        super((ImageFormatDescription)HEIFDescriptor.getInstance());
        if (input == null) {
            throw new IllegalArgumentException("input == null!");
        }
        this.input = input;
        this.dimensionProvider = dimensionProvider;
        this.libheif = new LibheifImage(this);
    }

    public synchronized void dispose() {
        if (!this.accessLock.isLocked() && !this.isDisposed) {
            this.isDisposed = true;
        }
    }

    protected void updateImageMetadata(ImageMetadata im) {
        super.updateImageMetadata(im);
    }

    protected void updateImageProgress(float f) {
        super.updateImageProgress(f);
    }

    protected void emitWarning(String string) {
        super.emitWarning(string);
    }

    public ImageFrame load(int imageIndex, int width, int height, boolean preserveAspectRatio, boolean smooth) throws IOException {
        if (0 != imageIndex) {
            return null;
        }
        Logger.getLogger(HEIFImageLoader.class.getName()).log(Level.FINEST, null, "locking native call " + this.accessLock.isLocked());
        this.accessLock.lock();
        ByteBuffer imageData = null;
        int rawImageWidth = -1;
        int rawImageHeight = -1;
        int rawImageStride = 0;
        try {
            this.updateImageProgress(0.0f);
            long start = System.currentTimeMillis();
            imageData = this.getImageData(this.libheif);
            double diff = (System.currentTimeMillis() - start) / 1000L;
            Logger.getLogger(HEIFImageLoader.class.getName()).log(Level.FINE, null, "Raw loading took: " + diff + "s");
            this.updateImageProgress(this.lastPercentDone + 1);
            rawImageWidth = this.libheif.getImageWidth();
            Logger.getLogger(HEIFImageLoader.class.getName()).log(Level.FINEST, null, "rawImageWidth " + rawImageWidth);
            rawImageHeight = this.libheif.getImageHeight();
            rawImageStride = this.libheif.getStride();
            int[] widthHeight = ImageTools.computeDimensions((int)rawImageWidth, (int)rawImageHeight, (int)width, (int)height, (boolean)preserveAspectRatio);
            width = widthHeight[0];
            height = widthHeight[1];
            this.updateImageProgress(this.lastPercentDone + 1);
        }
        catch (IOException e) {
            Logger.getLogger(HEIFImageLoader.class.getName()).log(Level.SEVERE, null, e);
            throw e;
        }
        catch (Throwable et) {
            Logger.getLogger(HEIFImageLoader.class.getName()).log(Level.SEVERE, null, et);
            throw new IOException(et);
        }
        finally {
            Logger.getLogger(HEIFImageLoader.class.getName()).log(Level.FINEST, null, "Unlock native access...");
            this.accessLock.unlock();
            this.dispose();
            Logger.getLogger(HEIFImageLoader.class.getName()).log(Level.FINEST, null, "Unlock native access...finished");
        }
        Logger.getLogger(HEIFImageLoader.class.getName()).log(Level.FINEST, null, "locked 2: " + this.accessLock.isLocked());
        if (imageData == null) {
            Logger.getLogger(HEIFImageLoader.class.getName()).log(Level.SEVERE, null, "Error decompressing HEIF/AVIF Image stream!");
            throw new IOException("Error decompressing HEIF/AVIF Image stream!");
        }
        ImageMetadata md = new ImageMetadata(null, Boolean.valueOf(true), null, null, null, null, null, Integer.valueOf(width), Integer.valueOf(height), null, null, null);
        this.updateImageMetadata(md);
        this.updateImageProgress(this.lastPercentDone + 1);
        if (rawImageWidth != width || rawImageHeight != height) {
            imageData = ImageTools.scaleImage((ByteBuffer)imageData, (int)rawImageWidth, (int)rawImageHeight, (int)this.libheif.getNumBands(), (int)width, (int)height, (boolean)smooth);
        }
        this.updateImageProgress(this.lastPercentDone + 1);
        rawImageStride = width * this.libheif.getNumBands();
        Logger.getLogger(HEIFImageLoader.class.getName()).log(Level.FINEST, null, "Creating image frame...");
        FixedPixelDensityImageFrame createImageFrame = new FixedPixelDensityImageFrame(ImageStorage.ImageType.RGBA, imageData, width, height, rawImageStride, null, this.getPixelScale(), md);
        Logger.getLogger(HEIFImageLoader.class.getName()).log(Level.FINEST, null, "Creating image frame...finished");
        return createImageFrame;
    }

    public float getPixelScale() {
        if (this.maxPixelScale == 0.0f) {
            this.maxPixelScale = this.calculateMaxRenderScale();
        }
        return this.maxPixelScale;
    }

    public float calculateMaxRenderScale() {
        float maxRenderScale = 0.0f;
        ScreenHelper.ScreenAccessor accessor = ScreenHelper.getScreenAccessor();
        for (Screen screen : Screen.getScreens()) {
            maxRenderScale = Math.max(maxRenderScale, accessor.getRenderScale(screen));
        }
        return maxRenderScale;
    }

    private synchronized ByteBuffer getImageData(LibheifImage libheif) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] datab = new byte[1024];
        long reading = System.currentTimeMillis();
        while ((nRead = this.input.read(datab, 0, datab.length)) != -1) {
            buffer.write(datab, 0, nRead);
        }
        buffer.flush();
        byte[] targetArray = buffer.toByteArray();
        byte[] raw = libheif.readPixelDataFromStream(targetArray);
        double diff = (System.currentTimeMillis() - reading) / 1000L;
        Logger.getLogger(HEIFImageLoader.class.getName()).log(Level.FINE, null, "Raw convert took: " + diff + "s");
        return ByteBuffer.wrap(raw);
    }

    public void updateImageProgress(int outLinesDecoded, int outHeight) {
        float res = 100.0f * (float)outLinesDecoded / (float)outHeight;
        this.updateImageProgress(res);
    }

    private static class Lock {
        private boolean locked = false;

        public synchronized boolean isLocked() {
            return this.locked;
        }

        public synchronized void lock() {
            if (this.locked) {
                throw new IllegalStateException("Recursive loading is not allowed.");
            }
            this.locked = true;
        }

        public synchronized void unlock() {
            if (!this.locked) {
                throw new IllegalStateException("Invalid loader state.");
            }
            this.locked = false;
        }
    }
}

