/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif.makernotes;

import com.drew.lang.Rational;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.makernotes.OlympusFocusInfoMakernoteDirectory;

public class OlympusFocusInfoMakernoteDescriptor
extends TagDescriptor<OlympusFocusInfoMakernoteDirectory> {
    public OlympusFocusInfoMakernoteDescriptor(@NotNull OlympusFocusInfoMakernoteDirectory directory) {
        super(directory);
    }

    @Override
    @Nullable
    public String getDescription(int tagType) {
        switch (tagType) {
            case 0: {
                return this.getFocusInfoVersionDescription();
            }
            case 521: {
                return this.getAutoFocusDescription();
            }
            case 773: {
                return this.getFocusDistanceDescription();
            }
            case 776: {
                return this.getAfPointDescription();
            }
            case 4609: {
                return this.getExternalFlashDescription();
            }
            case 4612: {
                return this.getExternalFlashBounceDescription();
            }
            case 4613: {
                return this.getExternalFlashZoomDescription();
            }
            case 4617: {
                return this.getManualFlashDescription();
            }
            case 4618: {
                return this.getMacroLedDescription();
            }
            case 5376: {
                return this.getSensorTemperatureDescription();
            }
            case 5632: {
                return this.getImageStabilizationDescription();
            }
        }
        return super.getDescription(tagType);
    }

    @Nullable
    public String getFocusInfoVersionDescription() {
        return this.getVersionBytesDescription(0, 4);
    }

    @Nullable
    public String getAutoFocusDescription() {
        return this.getIndexedDescription(521, "Off", "On");
    }

    @Nullable
    public String getFocusDistanceDescription() {
        Rational value = ((OlympusFocusInfoMakernoteDirectory)this._directory).getRational(773);
        if (value == null) {
            return "inf";
        }
        if (value.getNumerator() == 0xFFFFFFFFL || value.getNumerator() == 0L) {
            return "inf";
        }
        return (double)value.getNumerator() / 1000.0 + " m";
    }

    @Nullable
    public String getAfPointDescription() {
        Integer value = ((OlympusFocusInfoMakernoteDirectory)this._directory).getInteger(776);
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    @Nullable
    public String getExternalFlashDescription() {
        int[] values = ((OlympusFocusInfoMakernoteDirectory)this._directory).getIntArray(4609);
        if (values == null || values.length < 2) {
            return null;
        }
        String join = String.format("%d %d", (short)values[0], (short)values[1]);
        if (join.equals("0 0")) {
            return "Off";
        }
        if (join.equals("1 0")) {
            return "On";
        }
        return "Unknown (" + join + ")";
    }

    @Nullable
    public String getExternalFlashBounceDescription() {
        return this.getIndexedDescription(4612, "Bounce or Off", "Direct");
    }

    @Nullable
    public String getExternalFlashZoomDescription() {
        int[] values = ((OlympusFocusInfoMakernoteDirectory)this._directory).getIntArray(4613);
        if (values == null) {
            Integer value = ((OlympusFocusInfoMakernoteDirectory)this._directory).getInteger(4613);
            if (value == null) {
                return null;
            }
            values = new int[]{value};
        }
        if (values.length == 0) {
            return null;
        }
        Object join = String.format("%d", (short)values[0]);
        if (values.length > 1) {
            join = (String)join + " " + String.format("%d", (short)values[1]);
        }
        if (((String)join).equals("0")) {
            return "Off";
        }
        if (((String)join).equals("1")) {
            return "On";
        }
        if (((String)join).equals("0 0")) {
            return "Off";
        }
        if (((String)join).equals("1 0")) {
            return "On";
        }
        return "Unknown (" + (String)join + ")";
    }

    @Nullable
    public String getManualFlashDescription() {
        int[] values = ((OlympusFocusInfoMakernoteDirectory)this._directory).getIntArray(4617);
        if (values == null) {
            return null;
        }
        if ((short)values[0] == 0) {
            return "Off";
        }
        if ((short)values[1] == 1) {
            return "Full";
        }
        return "On (1/" + (short)values[1] + " strength)";
    }

    @Nullable
    public String getMacroLedDescription() {
        return this.getIndexedDescription(4618, "Off", "On");
    }

    @Nullable
    public String getSensorTemperatureDescription() {
        return ((OlympusFocusInfoMakernoteDirectory)this._directory).getString(5376);
    }

    @Nullable
    public String getImageStabilizationDescription() {
        byte[] values = ((OlympusFocusInfoMakernoteDirectory)this._directory).getByteArray(5632);
        if (values == null) {
            return null;
        }
        if ((values[0] | values[1] | values[2] | values[3]) == 0) {
            return "Off";
        }
        return "On, " + ((values[43] & 1) > 0 ? "Mode 1" : "Mode 2");
    }
}

