/*
 * Decompiled with CFR 0.152.
 */
package org.laxture.sbp.spring.boot;

import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.laxture.sbp.SpringBootPlugin;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.flyway.FlywayAutoConfiguration;
import org.springframework.boot.autoconfigure.flyway.FlywayMigrationStrategy;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={FlywayAutoConfiguration.class})
@ConditionalOnProperty(prefix="spring.flyway", name={"enabled"}, matchIfMissing=true)
@ConditionalOnBean(value={SpringBootPlugin.class, FlywayMigrationStrategy.class})
public class FlywayClassLoaderConfiguration {
    @Autowired
    private SpringBootPlugin plugin;

    @Bean
    @ConditionalOnMissingBean
    public FlywayMigrationStrategy migrationStrategy() {
        return flyway -> {
            FluentConfiguration alterConf = Flyway.configure((ClassLoader)this.plugin.getWrapper().getPluginClassLoader());
            alterConf.configuration(flyway.getConfiguration());
            new Flyway((org.flywaydb.core.api.configuration.Configuration)alterConf).migrate();
        };
    }
}

