/*
 * Decompiled with CFR 0.152.
 */
package org.laxture.sbp.spring.boot.configurer;

import java.util.stream.Stream;
import org.laxture.sbp.SpringBootPlugin;
import org.laxture.sbp.internal.PluginRequestMappingAdapter;
import org.laxture.sbp.spring.boot.IPluginConfigurer;
import org.pf4j.PluginWrapper;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.function.RouterFunction;

public class SbpWebConfigurer
implements IPluginConfigurer {
    @Override
    public void onStart(SpringBootPlugin plugin) {
        this.getMainRequestMapping(plugin).registerControllers(plugin);
        this.getMainRequestMapping(plugin).registerRouterFunction(plugin);
    }

    @Override
    public void onStop(SpringBootPlugin plugin) {
        this.getMainRequestMapping(plugin).unregisterControllers(plugin);
        this.getMainRequestMapping(plugin).unregisterRouterFunction(plugin);
    }

    private PluginRequestMappingAdapter getMainRequestMapping(SpringBootPlugin plugin) {
        return (PluginRequestMappingAdapter)plugin.getMainApplicationContext().getBean("requestMappingHandlerMapping");
    }

    @Override
    public void releaseLeaveOverResource(PluginWrapper plugin, GenericApplicationContext mainAppCtx) {
        Stream stream = mainAppCtx.getBeansWithAnnotation(Controller.class).values().stream();
        stream = Stream.concat(stream, mainAppCtx.getBeansWithAnnotation(RestController.class).values().stream());
        try {
            stream = Stream.concat(stream, mainAppCtx.getBeansOfType(RouterFunction.class).values().stream());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            stream = Stream.concat(stream, mainAppCtx.getBeansOfType(org.springframework.web.reactive.function.server.RouterFunction.class).values().stream());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        stream.filter(bean -> bean.getClass().getClassLoader() == plugin.getPluginClassLoader()).forEach(bean -> SpringBootPlugin.unregisterBeanFromMainContext(mainAppCtx, bean));
    }
}

