/*
 * Decompiled with CFR 0.152.
 */
package org.laxture.sbp.internal;

import org.laxture.sbp.SpringBootPlugin;
import org.laxture.sbp.SpringBootPluginManager;
import org.pf4j.ExtensionFactory;
import org.pf4j.PluginWrapper;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.support.GenericApplicationContext;

public class SpringExtensionFactory
implements ExtensionFactory {
    private final SpringBootPluginManager pluginManager;

    public SpringExtensionFactory(SpringBootPluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    public <T> T create(Class<T> extensionClass) {
        GenericApplicationContext pluginApplicationContext = this.getApplicationContext(extensionClass);
        Object extension = null;
        try {
            extension = pluginApplicationContext.getBean(extensionClass);
        }
        catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
            // empty catch block
        }
        if (extension == null) {
            Object extensionBean = this.createWithoutSpring(extensionClass);
            pluginApplicationContext.getBeanFactory().registerSingleton(extensionClass.getName(), extensionBean);
            extension = extensionBean;
        }
        return (T)extension;
    }

    public String getExtensionBeanName(Class<?> extensionClass) {
        GenericApplicationContext pluginAppCtx = this.getApplicationContext(extensionClass);
        if (pluginAppCtx == null) {
            return null;
        }
        String[] beanNames = pluginAppCtx.getBeanNamesForType(extensionClass);
        return beanNames.length > 0 ? beanNames[0] : null;
    }

    private Object createWithoutSpring(Class<?> extensionClass) {
        try {
            return extensionClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private GenericApplicationContext getApplicationContext(Class<?> extensionClass) {
        PluginWrapper pluginWrapper = this.pluginManager.whichPlugin(extensionClass);
        SpringBootPlugin plugin = (SpringBootPlugin)pluginWrapper.getPlugin();
        return plugin.getApplicationContext();
    }
}

