/*
 * Decompiled with CFR 0.152.
 */
package org.laxture.sbp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.laxture.sbp.SpringBootPluginManager;
import org.laxture.sbp.internal.SpringExtensionFactory;
import org.laxture.sbp.spring.boot.IPluginConfigurer;
import org.laxture.sbp.spring.boot.SbpPluginRestartedEvent;
import org.laxture.sbp.spring.boot.SbpPluginStartedEvent;
import org.laxture.sbp.spring.boot.SbpPluginStoppedEvent;
import org.laxture.sbp.spring.boot.SpringBootstrap;
import org.laxture.sbp.spring.boot.configurer.SbpWebConfigurer;
import org.laxture.sbp.util.BeanUtil;
import org.laxture.spring.util.ApplicationContextProvider;
import org.pf4j.Plugin;
import org.pf4j.PluginState;
import org.pf4j.PluginWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.support.AbstractAutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.util.Assert;

public abstract class SpringBootPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SpringBootPlugin.class);
    private final SpringBootstrap springBootstrap;
    private ApplicationContext applicationContext;
    private final Set<String> injectedExtensionNames = new HashSet<String>();
    private final List<IPluginConfigurer> pluginConfigurers = new ArrayList<IPluginConfigurer>();

    public SpringBootPlugin(PluginWrapper wrapper, IPluginConfigurer ... pluginConfigurers) {
        super(wrapper);
        boolean containsWebConfigurer = false;
        if (pluginConfigurers != null) {
            for (IPluginConfigurer configurer : pluginConfigurers) {
                this.pluginConfigurers.add(configurer);
                containsWebConfigurer = containsWebConfigurer || configurer instanceof SbpWebConfigurer;
            }
        }
        if (!containsWebConfigurer) {
            this.pluginConfigurers.add(new SbpWebConfigurer());
        }
        this.springBootstrap = this.createSpringBootstrap();
    }

    public void start() {
        if (this.getWrapper().getPluginState() == PluginState.STARTED) {
            return;
        }
        long startTs = System.currentTimeMillis();
        log.debug("Starting plugin {} ......", (Object)this.getWrapper().getPluginId());
        this.applicationContext = this.springBootstrap.run(new String[0]);
        for (IPluginConfigurer configurer : this.pluginConfigurers) {
            configurer.onStart(this);
        }
        Set extensionClassNames = this.getWrapper().getPluginManager().getExtensionClassNames(this.getWrapper().getPluginId());
        for (String extensionClassName : extensionClassNames) {
            try {
                log.debug("Register extension <{}> to main ApplicationContext", (Object)extensionClassName);
                Class<?> extensionClass = this.getWrapper().getPluginClassLoader().loadClass(extensionClassName);
                SpringExtensionFactory extensionFactory = (SpringExtensionFactory)this.getWrapper().getPluginManager().getExtensionFactory();
                Object bean = extensionFactory.create(extensionClass);
                String beanName = extensionFactory.getExtensionBeanName(extensionClass);
                this.registerBeanToMainContext(beanName, bean);
                this.injectedExtensionNames.add(beanName);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        ApplicationContextProvider.registerApplicationContext((ApplicationContext)this.applicationContext);
        this.applicationContext.publishEvent((ApplicationEvent)new SbpPluginStartedEvent(this.applicationContext));
        if (this.getPluginManager().isMainApplicationStarted()) {
            this.applicationContext.publishEvent((ApplicationEvent)new SbpPluginRestartedEvent(this.applicationContext));
        }
        log.debug("Plugin {} is started in {}ms", (Object)this.getWrapper().getPluginId(), (Object)(System.currentTimeMillis() - startTs));
    }

    public void stop() {
        if (this.getWrapper().getPluginState() != PluginState.STARTED) {
            return;
        }
        log.debug("Stopping plugin {} ......", (Object)this.getWrapper().getPluginId());
        for (String extensionName : this.injectedExtensionNames) {
            log.debug("Unregister extension <{}> to main ApplicationContext", (Object)extensionName);
            this.unregisterBeanFromMainContext(extensionName);
        }
        for (IPluginConfigurer configurer : this.pluginConfigurers) {
            configurer.onStop(this);
        }
        this.applicationContext.publishEvent((ApplicationEvent)new SbpPluginStoppedEvent(this.applicationContext));
        ApplicationContextProvider.unregisterApplicationContext((ApplicationContext)this.applicationContext);
        this.injectedExtensionNames.clear();
        ((ConfigurableApplicationContext)this.applicationContext).close();
        log.debug("Plugin {} is stopped", (Object)this.getWrapper().getPluginId());
    }

    public static void releaseLegacyResources(PluginWrapper plugin, GenericApplicationContext mainAppCtx) {
        try {
            SpringBootPlugin springBootPlugin = (SpringBootPlugin)plugin.getPlugin();
            for (IPluginConfigurer configurer : springBootPlugin.pluginConfigurers) {
                configurer.releaseLeaveOverResource(plugin, mainAppCtx);
            }
        }
        catch (Exception e) {
            log.trace("Release registered resources failed. " + e.getMessage(), (Throwable)e);
        }
    }

    protected abstract SpringBootstrap createSpringBootstrap();

    public GenericApplicationContext getApplicationContext() {
        return (GenericApplicationContext)this.applicationContext;
    }

    public SpringBootPluginManager getPluginManager() {
        return (SpringBootPluginManager)this.getWrapper().getPluginManager();
    }

    public GenericApplicationContext getMainApplicationContext() {
        return (GenericApplicationContext)this.getPluginManager().getMainApplicationContext();
    }

    public void registerBeanToMainContext(String beanName, Object bean) {
        Assert.notNull((Object)bean, (String)"bean must not be null");
        beanName = StringUtils.isEmpty((CharSequence)beanName) ? bean.getClass().getName() : beanName;
        this.getMainApplicationContext().getBeanFactory().registerSingleton(beanName, bean);
    }

    public void unregisterBeanFromMainContext(String beanName) {
        SpringBootPlugin.unregisterBeanFromMainContext(this.getMainApplicationContext(), beanName);
        Assert.notNull((Object)beanName, (String)"bean must not be null");
        ((AbstractAutowireCapableBeanFactory)this.getMainApplicationContext().getBeanFactory()).destroySingleton(beanName);
    }

    public void unregisterBeanFromMainContext(Object bean) {
        SpringBootPlugin.unregisterBeanFromMainContext(this.getMainApplicationContext(), bean);
    }

    public static void unregisterBeanFromMainContext(GenericApplicationContext mainCtx, String beanName) {
        Assert.notNull((Object)beanName, (String)"bean must not be null");
        ((AbstractAutowireCapableBeanFactory)mainCtx.getBeanFactory()).destroySingleton(beanName);
    }

    public static void unregisterBeanFromMainContext(GenericApplicationContext mainCtx, Object bean) {
        Assert.notNull((Object)bean, (String)"bean must not be null");
        String beanName = BeanUtil.getBeanName((BeanFactory)mainCtx.getBeanFactory(), bean);
        if (beanName != null) {
            ((AbstractAutowireCapableBeanFactory)mainCtx.getBeanFactory()).destroySingleton(beanName);
        }
    }

    public void onPluginBootstrap(SpringBootstrap bootstrap, GenericApplicationContext pluginApplicationContext) {
        for (IPluginConfigurer configurer : this.pluginConfigurers) {
            configurer.onBootstrap(bootstrap, pluginApplicationContext);
        }
    }

    public void afterPluginBootstrap(SpringBootstrap bootstrap, GenericApplicationContext pluginApplicationContext) {
        for (IPluginConfigurer configurer : this.pluginConfigurers) {
            configurer.afterBootstrap(bootstrap, pluginApplicationContext);
        }
    }

    public Set<String> getExcludeConfigurations() {
        HashSet<String> configurations = new HashSet<String>();
        for (IPluginConfigurer configurer : this.pluginConfigurers) {
            configurations.addAll(Arrays.asList(configurer.excludeConfigurations()));
        }
        return configurations;
    }
}

