/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.examples.backend.server;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.enterprise.event.Event;
import org.guvnor.common.services.project.backend.server.utils.PathUtil;
import org.guvnor.common.services.project.context.WorkspaceProjectContextChangeEvent;
import org.guvnor.common.services.project.events.NewProjectEvent;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.project.model.POM;
import org.guvnor.common.services.project.model.WorkspaceProject;
import org.guvnor.common.services.project.service.WorkspaceProjectService;
import org.guvnor.common.services.shared.metadata.MetadataService;
import org.guvnor.structure.organizationalunit.OrganizationalUnit;
import org.guvnor.structure.organizationalunit.config.RepositoryConfiguration;
import org.guvnor.structure.organizationalunit.config.RepositoryInfo;
import org.guvnor.structure.organizationalunit.config.SpaceConfigStorageRegistry;
import org.guvnor.structure.repositories.Branch;
import org.guvnor.structure.repositories.Repository;
import org.guvnor.structure.repositories.RepositoryEnvironmentConfigurations;
import org.guvnor.structure.repositories.RepositoryService;
import org.guvnor.structure.repositories.impl.git.GitRepository;
import org.kie.soup.commons.validation.PortablePreconditions;
import org.kie.workbench.common.screens.examples.exception.EmptyRemoteRepositoryException;
import org.kie.workbench.common.screens.examples.exception.ProjectAlreadyExistException;
import org.kie.workbench.common.screens.examples.model.Credentials;
import org.kie.workbench.common.screens.examples.model.ExampleRepository;
import org.kie.workbench.common.screens.examples.model.ImportProject;
import org.kie.workbench.common.screens.examples.service.ImportService;
import org.kie.workbench.common.screens.examples.validation.ImportProjectValidator;
import org.kie.workbench.common.screens.examples.validation.ImportProjectValidators;
import org.kie.workbench.common.screens.projecteditor.service.ProjectScreenService;
import org.kie.workbench.common.services.shared.project.KieModuleService;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.LinkOption;
import org.uberfire.java.nio.file.NoSuchFileException;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.attribute.BasicFileAttributes;
import org.uberfire.java.nio.file.spi.FileSystemProvider;

public abstract class BaseProjectImportService
implements ImportService {
    private static final String PROJECT_DESCRIPTON = "project.description";
    private static final String SYSTEM = "system";
    protected IOService ioService;
    protected MetadataService metadataService;
    protected ImportProjectValidators validators;
    protected KieModuleService moduleService;
    protected WorkspaceProjectService projectService;
    protected ProjectScreenService projectScreenService;
    protected SpaceConfigStorageRegistry spaceConfigStorageRegistry;
    private PathUtil pathUtil;
    private RepositoryService repoService;
    private Event<NewProjectEvent> newProjectEvent;

    public BaseProjectImportService(IOService ioService, MetadataService metadataService, ImportProjectValidators validators, KieModuleService moduleService, WorkspaceProjectService projectService, ProjectScreenService projectScreenService, SpaceConfigStorageRegistry spaceConfigStorageRegistry, PathUtil pathUtil, RepositoryService repoService, Event<NewProjectEvent> newProjectEvent) {
        this.ioService = ioService;
        this.metadataService = metadataService;
        this.validators = validators;
        this.moduleService = moduleService;
        this.projectService = projectService;
        this.projectScreenService = projectScreenService;
        this.spaceConfigStorageRegistry = spaceConfigStorageRegistry;
        this.pathUtil = pathUtil;
        this.repoService = repoService;
        this.newProjectEvent = newProjectEvent;
    }

    protected String getRepositoryAlias(String url) {
        String alias = url;
        int lastDotIndex = (alias = alias.substring(alias.lastIndexOf(47) + 1)).lastIndexOf(46);
        if (lastDotIndex > 0) {
            alias = alias.substring(0, lastDotIndex);
        }
        return alias;
    }

    protected List<String> getTags(Module module) {
        List tags = this.metadataService.getTags(module.getPomXMLPath());
        tags.sort(String::compareTo);
        return tags;
    }

    protected Set<ImportProject> convert(Branch branch, ExampleRepository repository) {
        Set modules = this.moduleService.getAllModules(branch);
        return modules.stream().map(p -> this.makeExampleProject((Module)p, repository)).collect(Collectors.toSet());
    }

    protected ImportProject makeExampleProject(Module module, ExampleRepository repository) {
        String description = this.readDescription(module);
        List<String> tags = this.getTags(module);
        return new ImportProject(module.getRootPath(), module.getModuleName(), description, repository.getUrl(), tags, repository.getCredentials(), Collections.emptyList(), false);
    }

    protected String readDescription(Module module) {
        org.uberfire.backend.vfs.Path root = module.getRootPath();
        POM pom = module.getPom();
        Path nioRoot = Paths.convert((org.uberfire.backend.vfs.Path)root);
        Path nioDescription = nioRoot.resolve(PROJECT_DESCRIPTON);
        String description = "Example '" + module.getModuleName() + "' module";
        if (this.ioService.exists(nioDescription)) {
            description = this.ioService.readAllString(nioDescription);
        } else if (pom != null && pom.getDescription() != null && !pom.getDescription().isEmpty()) {
            description = pom.getDescription();
        }
        if (description != null) {
            return description.replaceAll("\\s+", " ");
        }
        return description;
    }

    protected Set<ImportProject> validateProjects(OrganizationalUnit targetOu, Set<ImportProject> projects) {
        return projects.stream().map(project -> {
            List errors = this.getValidators().stream().map(exampleProjectValidation -> exampleProjectValidation.validate(targetOu, project)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
            return new ImportProject(project.getRoot(), project.getName(), project.getDescription(), project.getOrigin(), project.getTags(), errors, project.getCredentials(), project.getAllBranches(), project.getSelectedBranches(), project.canSelectBranches());
        }).collect(Collectors.toSet());
    }

    protected RepositoryInfo createConfigGroup(String alias, Map<String, Object> env) {
        RepositoryConfiguration configuration = new RepositoryConfiguration(env);
        configuration.add("avoid_index", (Object)true);
        configuration.add("space", (Object)this.getDefaultSpace());
        RepositoryInfo repositoryConfig = new RepositoryInfo(alias, false, configuration);
        return repositoryConfig;
    }

    protected String getDefaultSpace() {
        return SYSTEM;
    }

    protected Map<String, Object> buildGitEnv(final String url, final String username, final String password, final boolean mirror) {
        return new HashMap<String, Object>(){
            {
                this.put("origin", url);
                this.put("scheme", GitRepository.SCHEME.toString());
                this.put("replaceIfExists", false);
                this.put("username", username);
                this.put("password", password);
                this.put("mirror", mirror);
            }
        };
    }

    public boolean exist(OrganizationalUnit ou, ImportProject project) {
        String name = project.getName();
        Collection projectsWithSameName = this.projectService.getAllWorkspaceProjectsByName(ou, name);
        return !projectsWithSameName.isEmpty();
    }

    public void checkIfProjectAlreadyExist(OrganizationalUnit ou, ImportProject project) {
        if (this.exist(ou, project)) {
            String message = "Space [{0}] already contains a project with name [{1}]. Please delete existing project or create a new one with a different name";
            throw new ProjectAlreadyExistException(MessageFormat.format(message, ou.getSpace().getName(), project.getName()));
        }
    }

    public Set<ImportProject> getProjects(OrganizationalUnit target, ExampleRepository repository) {
        if (repository == null) {
            return Collections.emptySet();
        }
        String repositoryURL = repository.getUrl();
        if (repositoryURL == null || repositoryURL.trim().isEmpty()) {
            return Collections.emptySet();
        }
        Repository gitRepository = this.resolveGitRepository(repository);
        if (gitRepository == null) {
            return Collections.emptySet();
        }
        if (gitRepository.getBranches().isEmpty()) {
            throw new EmptyRemoteRepositoryException(this.getRepositoryAlias(repositoryURL));
        }
        Set<ImportProject> importProjects = this.convert((Branch)gitRepository.getBranch("master").get(), repository);
        return this.validateProjects(target, importProjects);
    }

    protected List<ImportProjectValidator> getValidators() {
        return this.validators.getValidators();
    }

    public WorkspaceProject importProject(OrganizationalUnit organizationalUnit, ImportProject importProject) {
        this.checkIfProjectAlreadyExist(organizationalUnit, importProject);
        Path rootPath = this.getProjectRoot(importProject);
        String origin = importProject.getOrigin();
        RepositoryEnvironmentConfigurations configurations = new RepositoryEnvironmentConfigurations();
        configurations.setInit(false);
        configurations.setOrigin(origin);
        configurations.setBranches(this.getBranches(importProject, rootPath));
        Credentials credentials = importProject.getCredentials();
        if (credentials != null && credentials.getUsername() != null && credentials.getPassword() != null) {
            configurations.setUserName(credentials.getUsername());
            configurations.setPassword(credentials.getPassword());
        }
        configurations.setMirror(false);
        String projectName = importProject.getName();
        if (!this.pathUtil.convert(importProject.getRoot()).equals(rootPath)) {
            String subdirectoryPath = this.pathUtil.stripRepoNameAndSpace(this.pathUtil.stripProtocolAndBranch(importProject.getRoot().toURI()));
            configurations.setSubdirectory(subdirectoryPath);
        } else {
            projectName = this.inferProjectName(importProject.getOrigin());
        }
        Repository importedRepo = this.repoService.createRepository(organizationalUnit, GitRepository.SCHEME.toString(), projectName, configurations);
        WorkspaceProject project = this.projectService.resolveProject(importedRepo);
        this.ioService.deleteIfExists(rootPath.getFileSystem().getPath(null, new String[0]), new DeleteOption[0]);
        return project;
    }

    protected List<String> getBranches(Path rootPath, org.uberfire.backend.vfs.Path projectPath) {
        FileSystem fs = rootPath.getFileSystem();
        String exampleRootPath = this.pathUtil.stripRepoNameAndSpace(this.pathUtil.stripProtocolAndBranch(projectPath.toURI()));
        return StreamSupport.stream(fs.getRootDirectories().spliterator(), false).filter(root -> this.exists(root.resolve(exampleRootPath))).map(arg_0 -> ((PathUtil)this.pathUtil).convert(arg_0)).map(root -> this.pathUtil.extractBranch(root.toURI())).flatMap(oBranch -> oBranch.map(Stream::of).orElse(Stream.empty())).collect(Collectors.toList());
    }

    protected List<String> getBranches(ImportProject importProject, Path rootPath) {
        if (importProject.getSelectedBranches() == null || importProject.getSelectedBranches().isEmpty()) {
            return this.getBranches(rootPath, importProject.getRoot());
        }
        return importProject.getSelectedBranches();
    }

    protected Path getProjectRoot(ImportProject importProject) {
        return this.getProjectRoot(importProject.getRoot());
    }

    protected Path getProjectRoot(org.uberfire.backend.vfs.Path rootPath) {
        return Stream.iterate(this.pathUtil.convert(rootPath), p -> p.getParent()).filter(p -> p != null && p.getParent() == null).findFirst().get();
    }

    private boolean exists(Path path) {
        try {
            FileSystemProvider provider = path.getFileSystem().provider();
            provider.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            return true;
        }
        catch (NoSuchFileException nfe) {
            return false;
        }
    }

    public WorkspaceProjectContextChangeEvent importProjects(OrganizationalUnit activeOU, List<ImportProject> projects) {
        PortablePreconditions.checkNotNull((String)"activeOU", (Object)activeOU);
        PortablePreconditions.checkNotNull((String)"projects", projects);
        PortablePreconditions.checkCondition((String)"Must have at least one Project", (projects.size() > 0 ? 1 : 0) != 0);
        return (WorkspaceProjectContextChangeEvent)this.spaceConfigStorageRegistry.getBatch(activeOU.getSpace().getName()).run(context -> {
            List importedProjects = projects.stream().map(exampleProject -> {
                WorkspaceProject project = this.importProject(activeOU, (ImportProject)exampleProject);
                this.newProjectEvent.fire((Object)new NewProjectEvent(project));
                return project;
            }).collect(Collectors.toList());
            if (importedProjects.size() == 1) {
                WorkspaceProject importedProject = (WorkspaceProject)importedProjects.get(0);
                return new WorkspaceProjectContextChangeEvent(importedProject, importedProject.getMainModule());
            }
            return new WorkspaceProjectContextChangeEvent(activeOU);
        });
    }

    protected String inferProjectName(String repositoryURL) {
        if ((repositoryURL = repositoryURL.replaceAll("\\\\", "/")).endsWith(".git")) {
            repositoryURL = repositoryURL.substring(0, repositoryURL.length() - 4);
        }
        if (repositoryURL.endsWith("/")) {
            repositoryURL = repositoryURL.substring(0, repositoryURL.length() - 1);
        }
        if (repositoryURL.lastIndexOf(47) < 0) {
            return "new-project";
        }
        return repositoryURL.substring(repositoryURL.lastIndexOf(47) + 1);
    }

    protected abstract Repository resolveGitRepository(ExampleRepository var1);
}

