"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = __importStar(require("react"));
var Card_1 = require("@patternfly/react-core/dist/js/components/Card");
var Page_1 = require("@patternfly/react-core/dist/js/components/Page");
var OuiaUtils_1 = require("@kogito-apps/ouia-tools/dist/utils/OuiaUtils");
var WorkflowFormContainer_1 = __importDefault(require("../../containers/WorkflowFormContainer/WorkflowFormContainer"));
require("../../styles.css");
var PageTitle_1 = require("@kogito-apps/consoles-common/dist/components/layout/PageTitle");
var FormNotification_1 = require("@kogito-apps/components-common/dist/components/FormNotification");
var react_router_dom_1 = require("react-router-dom");
var InlineEdit_1 = require("../ProcessFormPage/components/InlineEdit/InlineEdit");
var WorkflowFormContext_1 = require("../../../channel/WorkflowForm/WorkflowFormContext");
var WorkflowFormPage = function (_a) {
    var ouiaId = _a.ouiaId, ouiaSafe = _a.ouiaSafe;
    var _b = __read((0, react_1.useState)(), 2), notification = _b[0], setNotification = _b[1];
    var inlineEditRef = (0, react_1.useRef)();
    var history = (0, react_router_dom_1.useHistory)();
    var gatewayApi = (0, WorkflowFormContext_1.useWorkflowFormGatewayApi)();
    var workflowDefinition = history.location.state['workflowDefinition'];
    var goToWorkflowList = function () {
        history.push('/Processes');
    };
    var showNotification = function (notificationType, submitMessage, notificationDetails) {
        setNotification({
            type: notificationType,
            message: submitMessage,
            details: notificationDetails,
            customActions: [
                {
                    label: 'Go to workflow list',
                    onClick: function () {
                        setNotification(null);
                        goToWorkflowList();
                    }
                }
            ],
            close: function () {
                setNotification(null);
            }
        });
    };
    var onSubmitSuccess = function (message) {
        showNotification('success', message);
    };
    var onSubmitError = function (details) {
        var message = 'Failed to trigger workflow.';
        showNotification('error', message, details);
    };
    var onResetForm = function () {
        gatewayApi.setBusinessKey('');
        inlineEditRef.current.reset();
    };
    var getBusinessKey = function () {
        return gatewayApi.getBusinessKey();
    };
    (0, react_1.useEffect)(function () {
        onResetForm();
        return (0, OuiaUtils_1.ouiaPageTypeAndObjectId)('workflow-form');
    }, []);
    return ((0, jsx_runtime_1.jsxs)(react_1.default.Fragment, { children: [(0, jsx_runtime_1.jsxs)(Page_1.PageSection, __assign({}, (0, OuiaUtils_1.componentOuiaProps)("title".concat(ouiaId ? '-' + ouiaId : ''), 'workflow-form-page-section', ouiaSafe), { variant: "light" }, { children: [(0, jsx_runtime_1.jsx)(PageTitle_1.PageTitle, { title: "Start New Workflow", extra: (0, jsx_runtime_1.jsx)(InlineEdit_1.InlineEdit, { ref: inlineEditRef, setBusinessKey: function (bk) { return gatewayApi.setBusinessKey(bk); }, getBusinessKey: getBusinessKey }) }), notification && ((0, jsx_runtime_1.jsx)("div", { children: (0, jsx_runtime_1.jsx)(FormNotification_1.FormNotification, { notification: notification }) }))] })), (0, jsx_runtime_1.jsx)(Page_1.PageSection, __assign({}, (0, OuiaUtils_1.componentOuiaProps)("content".concat(ouiaId ? '-' + ouiaId : ''), 'workflow-form-page-section', ouiaSafe), { children: (0, jsx_runtime_1.jsx)(Card_1.Card, __assign({ className: "Dev-ui__card-size" }, { children: (0, jsx_runtime_1.jsx)(Card_1.CardBody, __assign({ className: "pf-u-h-100" }, { children: (0, jsx_runtime_1.jsx)(WorkflowFormContainer_1.default, { workflowDefinitionData: workflowDefinition, onSubmitSuccess: onSubmitSuccess, onSubmitError: onSubmitError, onResetForm: onResetForm }) })) })) }))] }));
};
exports.default = WorkflowFormPage;
//# sourceMappingURL=WorkflowFormPage.js.map