"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = __importStar(require("react"));
var Drawer_1 = require("@patternfly/react-core/dist/js/components/Drawer");
var Card_1 = require("@patternfly/react-core/dist/js/components/Card");
var Grid_1 = require("@patternfly/react-core/dist/js/layouts/Grid");
var Flex_1 = require("@patternfly/react-core/dist/js/layouts/Flex");
var Bullseye_1 = require("@patternfly/react-core/dist/js/layouts/Bullseye");
var Button_1 = require("@patternfly/react-core/dist/js/components/Button");
var Title_1 = require("@patternfly/react-core/dist/js/components/Title");
var Page_1 = require("@patternfly/react-core/dist/js/components/Page");
var KogitoSpinner_1 = require("@kogito-apps/components-common/dist/components/KogitoSpinner");
var FormNotification_1 = require("@kogito-apps/components-common/dist/components/FormNotification");
var KogitoEmptyState_1 = require("@kogito-apps/components-common/dist/components/KogitoEmptyState");
var ServerErrors_1 = require("@kogito-apps/components-common/dist/components/ServerErrors");
var OuiaUtils_1 = require("@kogito-apps/ouia-tools/dist/utils/OuiaUtils");
var PageTitle_1 = require("@kogito-apps/consoles-common/dist/components/layout/PageTitle");
var task_console_shared_1 = require("@kogito-apps/task-console-shared");
var TaskInboxContext_1 = require("../../../channel/TaskInbox/TaskInboxContext");
var TaskFormContainer_1 = __importDefault(require("../../containers/TaskFormContainer/TaskFormContainer"));
require("../../styles.css");
var task_details_1 = require("@kogito-apps/task-details");
var DevUIAppContext_1 = require("../../contexts/DevUIAppContext");
var TaskDetailsPage = function (_a) {
    var ouiaId = _a.ouiaId, ouiaSafe = _a.ouiaSafe, props = __rest(_a, ["ouiaId", "ouiaSafe"]);
    var taskInboxGatewayApi = (0, TaskInboxContext_1.useTaskInboxGatewayApi)();
    var appContext = (0, DevUIAppContext_1.useDevUIAppContext)();
    var _b = __read((0, react_1.useState)(props.match.params.taskId), 1), taskId = _b[0];
    var _c = __read((0, react_1.useState)(true), 2), isLoading = _c[0], setIsLoading = _c[1];
    var _d = __read((0, react_1.useState)(), 2), userTask = _d[0], setUserTask = _d[1];
    var _e = __read((0, react_1.useState)(), 2), notification = _e[0], setNotification = _e[1];
    var _f = __read((0, react_1.useState)(), 2), error = _f[0], setError = _f[1];
    var _g = __read((0, react_1.useState)(false), 2), isDetailsExpanded = _g[0], setIsDetailsExpanded = _g[1];
    (0, react_1.useEffect)(function () {
        return (0, OuiaUtils_1.ouiaPageTypeAndObjectId)('task-details-page', taskId);
    });
    var loadTask = function () { return __awaiter(void 0, void 0, void 0, function () {
        var task, err_1;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    _a.trys.push([0, 2, 3, 4]);
                    return [4, taskInboxGatewayApi.getTaskById(taskId)];
                case 1:
                    task = _a.sent();
                    setUserTask(task);
                    return [3, 4];
                case 2:
                    err_1 = _a.sent();
                    setError(err_1);
                    return [3, 4];
                case 3:
                    setIsLoading(false);
                    return [7];
                case 4: return [2];
            }
        });
    }); };
    (0, react_1.useEffect)(function () {
        loadTask();
    }, []);
    var showNotification = function (notificationType, submitMessage, notificationDetails) {
        setNotification({
            type: notificationType,
            message: submitMessage,
            details: notificationDetails,
            customActions: [
                {
                    label: 'Go to Task Inbox',
                    onClick: function () {
                        setNotification(null);
                        goToInbox();
                    }
                }
            ],
            close: function () {
                setNotification(null);
            }
        });
    };
    var goToInbox = function () {
        taskInboxGatewayApi.clearOpenTask();
        props.history.push('/TaskInbox');
    };
    var onSubmitSuccess = function (phase) {
        var message = "Task '".concat(userTask.referenceName, "' successfully transitioned to phase '").concat(phase, "'.");
        showNotification('success', message);
    };
    var onSubmitError = function (phase, details) {
        var message = "Task '".concat(userTask.referenceName, "' couldn't transition to phase '").concat(phase, "'.");
        showNotification('error', message, details);
    };
    if (isLoading) {
        return ((0, jsx_runtime_1.jsx)(Page_1.PageSection, __assign({}, (0, OuiaUtils_1.componentOuiaProps)('spinner' + (ouiaId ? '-' + ouiaId : ''), 'task-details-page-section', ouiaSafe), { children: (0, jsx_runtime_1.jsx)(Card_1.Card, __assign({ className: "Dev-ui__card-size" }, { children: (0, jsx_runtime_1.jsx)(Bullseye_1.Bullseye, { children: (0, jsx_runtime_1.jsx)(KogitoSpinner_1.KogitoSpinner, { spinnerText: "Loading details for task: ".concat(taskId) }) }) })) })));
    }
    if (error) {
        return ((0, jsx_runtime_1.jsx)(Page_1.PageSection, __assign({}, (0, OuiaUtils_1.componentOuiaProps)('error' + (ouiaId ? '-' + ouiaId : ''), 'task-details-page-section', ouiaSafe), { children: (0, jsx_runtime_1.jsx)(Grid_1.Grid, __assign({ hasGutter: true, md: 1, className: 'Dev-ui__card-size' }, { children: (0, jsx_runtime_1.jsx)(Grid_1.GridItem, __assign({ span: 12, className: 'Dev-ui__card-size' }, { children: (0, jsx_runtime_1.jsx)(Card_1.Card, __assign({ className: 'Dev-ui__card-size' }, { children: (0, jsx_runtime_1.jsx)(ServerErrors_1.ServerErrors, __assign({ error: error, variant: "large" }, { children: (0, jsx_runtime_1.jsx)(Button_1.Button, __assign({ variant: "primary", onClick: function () { return goToInbox(); } }, { children: "Go to Inbox" })) })) })) })) })) })));
    }
    if (!userTask) {
        return ((0, jsx_runtime_1.jsx)(Page_1.PageSection, __assign({}, (0, OuiaUtils_1.componentOuiaProps)('empty' + (ouiaId ? '-' + ouiaId : ''), 'task-details-page-section', ouiaSafe), { children: (0, jsx_runtime_1.jsx)(Grid_1.Grid, __assign({ hasGutter: true, md: 1, className: 'Dev-ui__card-size' }, { children: (0, jsx_runtime_1.jsx)(Grid_1.GridItem, __assign({ span: 12, className: 'Dev-ui__card-size' }, { children: (0, jsx_runtime_1.jsx)(Card_1.Card, __assign({ className: 'Dev-ui__card-size' }, { children: (0, jsx_runtime_1.jsx)(KogitoEmptyState_1.KogitoEmptyState, { type: KogitoEmptyState_1.KogitoEmptyStateType.Info, title: 'Cannot find task', body: "Cannot find task with id '".concat(taskId, "'") }) })) })) })) })));
    }
    var onViewDetailsClick = function () {
        setIsDetailsExpanded(!isDetailsExpanded);
    };
    var onDetailsCloseClick = function () {
        setIsDetailsExpanded(false);
    };
    var panelContent = ((0, jsx_runtime_1.jsxs)(Drawer_1.DrawerPanelContent, __assign({ className: 'Dev-ui__card-size' }, { children: [(0, jsx_runtime_1.jsxs)(Drawer_1.DrawerHead, { children: [(0, jsx_runtime_1.jsx)("span", __assign({ tabIndex: isDetailsExpanded ? 0 : -1 }, { children: (0, jsx_runtime_1.jsx)(Title_1.Title, __assign({ headingLevel: "h3", size: "xl" }, { children: "Details" })) })), (0, jsx_runtime_1.jsx)(Drawer_1.DrawerActions, { children: (0, jsx_runtime_1.jsx)(Drawer_1.DrawerCloseButton, { onClick: onDetailsCloseClick }) })] }), (0, jsx_runtime_1.jsx)(Drawer_1.DrawerPanelBody, { children: (0, jsx_runtime_1.jsx)(task_details_1.EmbeddedTaskDetails, { targetOrigin: appContext.getDevUIUrl(), userTask: userTask }) })] })));
    return ((0, jsx_runtime_1.jsxs)(react_1.default.Fragment, { children: [(0, jsx_runtime_1.jsxs)(Page_1.PageSection, __assign({ variant: "light" }, (0, OuiaUtils_1.componentOuiaProps)('header' + (ouiaId ? '-' + ouiaId : ''), 'task-details-page-section', ouiaSafe), { children: [(0, jsx_runtime_1.jsxs)(Flex_1.Flex, __assign({ justifyContent: { default: 'justifyContentSpaceBetween' } }, { children: [(0, jsx_runtime_1.jsx)(Flex_1.FlexItem, { children: (0, jsx_runtime_1.jsx)(PageTitle_1.PageTitle, { title: userTask.referenceName, extra: (0, jsx_runtime_1.jsx)(task_console_shared_1.TaskState, { task: userTask, variant: 'label' }) }) }), (0, jsx_runtime_1.jsx)(Flex_1.FlexItem, { children: (0, jsx_runtime_1.jsx)(Button_1.Button, __assign({ variant: "secondary", id: "view-details", onClick: onViewDetailsClick }, { children: "View details" })) })] })), notification && ((0, jsx_runtime_1.jsx)("div", __assign({ className: "kogito-task-console__task-details-page" }, { children: (0, jsx_runtime_1.jsx)(FormNotification_1.FormNotification, { notification: notification }) })))] })), (0, jsx_runtime_1.jsx)(Page_1.PageSection, __assign({}, (0, OuiaUtils_1.componentOuiaProps)('content' + (ouiaId ? '-' + ouiaId : ''), 'task-details-page-section', ouiaSafe), { children: (0, jsx_runtime_1.jsx)(Drawer_1.Drawer, __assign({ isExpanded: isDetailsExpanded }, { children: (0, jsx_runtime_1.jsx)(Drawer_1.DrawerContent, __assign({ panelContent: panelContent }, { children: (0, jsx_runtime_1.jsx)(Drawer_1.DrawerContentBody, { children: (0, jsx_runtime_1.jsx)(Grid_1.Grid, __assign({ hasGutter: true, md: 1, className: 'Dev-ui__card-size' }, { children: (0, jsx_runtime_1.jsx)(Grid_1.GridItem, __assign({ span: 12, className: 'Dev-ui__card-size' }, { children: (0, jsx_runtime_1.jsx)(Card_1.Card, __assign({ className: 'Dev-ui__card-size' }, { children: (0, jsx_runtime_1.jsx)(Card_1.CardBody, __assign({ className: "pf-u-h-100" }, { children: (0, jsx_runtime_1.jsx)(TaskFormContainer_1.default, { userTask: userTask, onSubmitSuccess: onSubmitSuccess, onSubmitError: onSubmitError }) })) })) })) })) }) })) })) }))] }));
};
exports.default = TaskDetailsPage;
//# sourceMappingURL=TaskDetailsPage.js.map