"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var react_1 = __importStar(require("react"));
var Card_1 = require("@patternfly/react-core/dist/js/components/Card");
var Page_1 = require("@patternfly/react-core/dist/js/components/Page");
var Label_1 = require("@patternfly/react-core/dist/js/components/Label");
var Text_1 = require("@patternfly/react-core/dist/js/components/Text");
var OuiaUtils_1 = require("@kogito-apps/ouia-tools/dist/utils/OuiaUtils");
var FormDetailsContainer_1 = __importDefault(require("../../containers/FormDetailsContainer/FormDetailsContainer"));
require("../../styles.css");
var react_router_dom_1 = require("react-router-dom");
var PageTitle_1 = require("@kogito-apps/consoles-common/dist/components/layout/PageTitle");
var FormNotification_1 = require("@kogito-apps/components-common/dist/components/FormNotification");
var react_moment_1 = __importDefault(require("react-moment"));
var FormDetailsPage = function () {
    var _a = __read((0, react_1.useState)(), 2), notification = _a[0], setNotification = _a[1];
    (0, react_1.useEffect)(function () {
        return (0, OuiaUtils_1.ouiaPageTypeAndObjectId)('form-detail');
    });
    var history = (0, react_router_dom_1.useHistory)();
    var formData = history.location.state['formData'];
    var onSuccess = function () {
        var message = "The form '".concat(formData.name, ".").concat(formData.type, "' has been successfully saved.");
        showNotification('success', message);
    };
    var onError = function (details) {
        var message = "The form '".concat(formData.name, ".").concat(formData.type, "' couldn't be saved.");
        showNotification('error', message, details);
    };
    var showNotification = function (notificationType, submitMessage, notificationDetails) {
        setNotification({
            type: notificationType,
            message: submitMessage,
            details: notificationDetails,
            close: function () {
                setNotification(null);
            }
        });
    };
    var getFormType = function (type) {
        if (type.toLowerCase() === 'html') {
            return 'HTML';
        }
        else if (type.toLowerCase() === 'tsx') {
            return 'REACT';
        }
        else {
            return type;
        }
    };
    return ((0, jsx_runtime_1.jsxs)(react_1.default.Fragment, { children: [(0, jsx_runtime_1.jsxs)(Page_1.PageSection, __assign({ variant: "light" }, { children: [(0, jsx_runtime_1.jsx)(PageTitle_1.PageTitle, { title: formData.name, extra: (0, jsx_runtime_1.jsx)(Label_1.Label, __assign({ variant: "outline" }, { children: getFormType(formData.type) })) }), (0, jsx_runtime_1.jsxs)(Text_1.Text, __assign({ component: Text_1.TextVariants.p, style: { marginTop: '10px' } }, { children: [(0, jsx_runtime_1.jsx)("span", __assign({ style: { fontWeight: 'bold' } }, { children: "Last modified:" })), ' ', (0, jsx_runtime_1.jsx)(react_moment_1.default, __assign({ fromNow: true }, { children: formData.lastModified }))] })), notification && ((0, jsx_runtime_1.jsx)("div", __assign({ className: "kogito-task-console__task-details-page" }, { children: (0, jsx_runtime_1.jsx)(FormNotification_1.FormNotification, { notification: notification }) })))] })), (0, jsx_runtime_1.jsx)(Page_1.PageSection, { children: (0, jsx_runtime_1.jsx)(Card_1.Card, __assign({ className: "Dev-ui__card-size" }, { children: (0, jsx_runtime_1.jsx)(FormDetailsContainer_1.default, { formData: formData, onSuccess: onSuccess, onError: onError }) })) })] }));
};
exports.default = FormDetailsPage;
//# sourceMappingURL=FormDetailsPage.js.map