"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (g && (g = 0, op[0] && (_ = 0)), _) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var OuiaUtils_1 = require("@kogito-apps/ouia-tools/dist/utils/OuiaUtils");
var WorkflowFormContext_1 = require("../../../channel/WorkflowForm/WorkflowFormContext");
var workflow_form_1 = require("@kogito-apps/workflow-form");
var DevUIAppContext_1 = require("../../contexts/DevUIAppContext");
var WorkflowFormContainer = function (_a) {
    var workflowDefinitionData = _a.workflowDefinitionData, onSubmitSuccess = _a.onSubmitSuccess, onSubmitError = _a.onSubmitError, onResetForm = _a.onResetForm, ouiaId = _a.ouiaId, ouiaSafe = _a.ouiaSafe;
    var gatewayApi = (0, WorkflowFormContext_1.useWorkflowFormGatewayApi)();
    var appContext = (0, DevUIAppContext_1.useDevUIAppContext)();
    return ((0, jsx_runtime_1.jsx)(workflow_form_1.EmbeddedWorkflowForm, __assign({}, (0, OuiaUtils_1.componentOuiaProps)(ouiaId, 'workflow-form-container', ouiaSafe), { driver: {
            getCustomWorkflowSchema: function () {
                return __awaiter(this, void 0, void 0, function () {
                    return __generator(this, function (_a) {
                        return [2, gatewayApi.getCustomWorkflowSchema(workflowDefinitionData.workflowName)];
                    });
                });
            },
            resetBusinessKey: function () {
                return __awaiter(this, void 0, void 0, function () {
                    return __generator(this, function (_a) {
                        onResetForm();
                        return [2];
                    });
                });
            },
            startWorkflow: function (endpoint, data) {
                return __awaiter(this, void 0, void 0, function () {
                    return __generator(this, function (_a) {
                        return [2, gatewayApi
                                .startWorkflow(endpoint, data)
                                .then(function (id) {
                                onSubmitSuccess("A workflow with id ".concat(id, " was triggered successfully."));
                            })
                                .catch(function (error) {
                                var _a, _b, _c, _d;
                                var message = ((_b = (_a = error === null || error === void 0 ? void 0 : error.response) === null || _a === void 0 ? void 0 : _a.data) === null || _b === void 0 ? void 0 : _b.message) +
                                    ' ' +
                                    ((_d = (_c = error === null || error === void 0 ? void 0 : error.response) === null || _c === void 0 ? void 0 : _c.data) === null || _d === void 0 ? void 0 : _d.cause) ||
                                    (error === null || error === void 0 ? void 0 : error.message) ||
                                    'Unknown error. More details in the developer tools console.';
                                onSubmitError(message);
                            })];
                    });
                });
            }
        }, targetOrigin: appContext.getDevUIUrl(), workflowDefinition: {
            workflowName: workflowDefinitionData.workflowName,
            endpoint: workflowDefinitionData.endpoint
        } })));
};
exports.default = WorkflowFormContainer;
//# sourceMappingURL=WorkflowFormContainer.js.map